<div x-data="{ showCronModal: false }">
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Dashboard')" :subtitle="__('Welcome back! Here\'s what\'s happening today.')">
        <x-slot:actions>
            <div class="flex flex-col sm:flex-row items-stretch sm:items-center gap-2 sm:gap-3 w-full sm:w-auto">
                {{-- Cron Setup Button --}}
                <button @click="showCronModal = true" class="inline-flex items-center justify-center gap-2 rounded-lg sm:rounded-xl border border-white/10 bg-white/5 px-3 sm:px-4 py-2.5 text-sm font-medium text-slate-300 transition-all hover:border-indigo-500/50 hover:bg-white/10 active:scale-95">
                    <i class="ph-duotone ph-clock-clockwise text-lg"></i>
                    <span class="hidden sm:inline">@lang('Cron Setup')</span>
                    <span class="sm:hidden">@lang('Cron')</span>
                </button>
                {{-- Date Range Filter --}}
                <select wire:model.live="dateRange" class="rounded-lg sm:rounded-xl border border-white/10 bg-white/5 px-3 sm:px-4 py-2.5 text-base sm:text-sm text-slate-300 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                    <option value="7">@lang('Last 7 days')</option>
                    <option value="30">@lang('Last 30 days')</option>
                    <option value="90">@lang('Last 90 days')</option>
                </select>
            </div>
        </x-slot:actions>
    </x-admin.page-header>

    {{-- Quick Actions - Horizontal scroll on mobile --}}
    <div class="mt-4 sm:mt-6 -mx-4 sm:mx-0 px-4 sm:px-0 overflow-x-auto scrollbar-none">
        <div class="flex sm:flex-wrap gap-2 sm:gap-3 min-w-max sm:min-w-0">
            <a href="{{ route('admin.users.create') }}" class="inline-flex items-center gap-2 rounded-lg sm:rounded-xl bg-gradient-to-r from-indigo-600 to-indigo-500 px-3 sm:px-4 py-2 sm:py-2.5 text-xs sm:text-sm font-medium text-white shadow-lg shadow-indigo-500/25 transition-all hover:from-indigo-500 hover:to-indigo-400 active:scale-95 whitespace-nowrap">
                <i class="ph-bold ph-user-plus"></i>
                @lang('Add Client')
            </a>
            <a href="{{ route('admin.invoices.index') }}" class="inline-flex items-center gap-2 rounded-lg sm:rounded-xl bg-gradient-to-r from-emerald-600 to-emerald-500 px-3 sm:px-4 py-2 sm:py-2.5 text-xs sm:text-sm font-medium text-white shadow-lg shadow-emerald-500/25 transition-all hover:from-emerald-500 hover:to-emerald-400 active:scale-95 whitespace-nowrap">
                <i class="ph-bold ph-file-plus"></i>
                @lang('Invoices')
            </a>
            <a href="{{ route('admin.orders.index') }}" class="inline-flex items-center gap-2 rounded-lg sm:rounded-xl bg-gradient-to-r from-amber-600 to-amber-500 px-3 sm:px-4 py-2 sm:py-2.5 text-xs sm:text-sm font-medium text-white shadow-lg shadow-amber-500/25 transition-all hover:from-amber-500 hover:to-amber-400 active:scale-95 whitespace-nowrap">
                <i class="ph-bold ph-shopping-cart-simple"></i>
                @lang('Orders')
            </a>
            <a href="{{ route('admin.ticket.index') }}" class="inline-flex items-center gap-2 rounded-lg sm:rounded-xl bg-gradient-to-r from-rose-600 to-rose-500 px-3 sm:px-4 py-2 sm:py-2.5 text-xs sm:text-sm font-medium text-white shadow-lg shadow-rose-500/25 transition-all hover:from-rose-500 hover:to-rose-400 active:scale-95 whitespace-nowrap">
                <i class="ph-bold ph-ticket"></i>
                @lang('Tickets')
            </a>
        </div>
    </div>

    {{-- ============================================ --}}
    {{-- SECTION 1: CLIENT STATISTICS --}}
    {{-- ============================================ --}}
    <div class="mt-6 sm:mt-8">
        <h3 class="mb-3 sm:mb-4 flex items-center gap-2 text-xs sm:text-sm font-semibold uppercase tracking-wider text-slate-400">
            <i class="ph-duotone ph-users-three text-base sm:text-lg text-indigo-400"></i>
            @lang('Clients Overview')
        </h3>
        <div class="grid grid-cols-2 gap-3 sm:gap-4 lg:grid-cols-4">
            <a href="{{ route('admin.users.all') }}" class="group relative overflow-hidden rounded-xl sm:rounded-2xl border border-white/5 bg-[#12121a] p-3 sm:p-5 transition-all hover:border-indigo-500/30 hover:shadow-lg hover:shadow-indigo-500/5 active:scale-[0.98]">
                <div class="absolute -right-4 -top-4 h-16 sm:h-20 w-16 sm:w-20 rounded-full bg-indigo-500/10 blur-2xl transition-all group-hover:bg-indigo-500/20"></div>
                <div class="relative flex items-center justify-between gap-2">
                    <div class="min-w-0">
                        <p class="text-xs sm:text-sm text-slate-500 truncate">@lang('Total Clients')</p>
                        <p class="mt-0.5 sm:mt-1 text-xl sm:text-3xl font-bold text-white">{{ number_format($clientStats['total']) }}</p>
                    </div>
                    <div class="flex h-10 w-10 sm:h-12 sm:w-12 shrink-0 items-center justify-center rounded-lg sm:rounded-xl bg-indigo-500/10 text-indigo-400 ring-1 ring-indigo-500/20">
                        <i class="ph-duotone ph-users text-xl sm:text-2xl"></i>
                    </div>
                </div>
            </a>
            <a href="{{ route('admin.users.active') }}" class="group relative overflow-hidden rounded-xl sm:rounded-2xl border border-white/5 bg-[#12121a] p-3 sm:p-5 transition-all hover:border-emerald-500/30 hover:shadow-lg hover:shadow-emerald-500/5 active:scale-[0.98]">
                <div class="absolute -right-4 -top-4 h-16 sm:h-20 w-16 sm:w-20 rounded-full bg-emerald-500/10 blur-2xl transition-all group-hover:bg-emerald-500/20"></div>
                <div class="relative flex items-center justify-between gap-2">
                    <div class="min-w-0">
                        <p class="text-xs sm:text-sm text-slate-500 truncate">@lang('Active Clients')</p>
                        <p class="mt-0.5 sm:mt-1 text-xl sm:text-3xl font-bold text-emerald-400">{{ number_format($clientStats['active']) }}</p>
                    </div>
                    <div class="flex h-10 w-10 sm:h-12 sm:w-12 shrink-0 items-center justify-center rounded-lg sm:rounded-xl bg-emerald-500/10 text-emerald-400 ring-1 ring-emerald-500/20">
                        <i class="ph-duotone ph-user-check text-xl sm:text-2xl"></i>
                    </div>
                </div>
            </a>
            <a href="{{ route('admin.users.email.unverified') }}" class="group relative overflow-hidden rounded-xl sm:rounded-2xl border border-white/5 bg-[#12121a] p-3 sm:p-5 transition-all hover:border-amber-500/30 hover:shadow-lg hover:shadow-amber-500/5 active:scale-[0.98]">
                <div class="absolute -right-4 -top-4 h-16 sm:h-20 w-16 sm:w-20 rounded-full bg-amber-500/10 blur-2xl transition-all group-hover:bg-amber-500/20"></div>
                <div class="relative flex items-center justify-between gap-2">
                    <div class="min-w-0">
                        <p class="text-xs sm:text-sm text-slate-500 truncate">@lang('Email Unverified')</p>
                        <p class="mt-0.5 sm:mt-1 text-xl sm:text-3xl font-bold text-amber-400">{{ number_format($clientStats['email_unverified']) }}</p>
                    </div>
                    <div class="flex h-10 w-10 sm:h-12 sm:w-12 shrink-0 items-center justify-center rounded-lg sm:rounded-xl bg-amber-500/10 text-amber-400 ring-1 ring-amber-500/20">
                        <i class="ph-duotone ph-envelope-simple text-xl sm:text-2xl"></i>
                    </div>
                </div>
            </a>
            <a href="{{ route('admin.users.mobile.unverified') }}" class="group relative overflow-hidden rounded-xl sm:rounded-2xl border border-white/5 bg-[#12121a] p-3 sm:p-5 transition-all hover:border-rose-500/30 hover:shadow-lg hover:shadow-rose-500/5 active:scale-[0.98]">
                <div class="absolute -right-4 -top-4 h-16 sm:h-20 w-16 sm:w-20 rounded-full bg-rose-500/10 blur-2xl transition-all group-hover:bg-rose-500/20"></div>
                <div class="relative flex items-center justify-between gap-2">
                    <div class="min-w-0">
                        <p class="text-xs sm:text-sm text-slate-500 truncate">@lang('Mobile Unverified')</p>
                        <p class="mt-0.5 sm:mt-1 text-xl sm:text-3xl font-bold text-rose-400">{{ number_format($clientStats['mobile_unverified']) }}</p>
                    </div>
                    <div class="flex h-10 w-10 sm:h-12 sm:w-12 shrink-0 items-center justify-center rounded-lg sm:rounded-xl bg-rose-500/10 text-rose-400 ring-1 ring-rose-500/20">
                        <i class="ph-duotone ph-device-mobile text-xl sm:text-2xl"></i>
                    </div>
                </div>
            </a>
        </div>
    </div>

    {{-- ============================================ --}}
    {{-- SECTION 2: ORDERS STATISTICS --}}
    {{-- ============================================ --}}
    <div class="mt-6 sm:mt-8">
        <h3 class="mb-3 sm:mb-4 flex items-center gap-2 text-xs sm:text-sm font-semibold uppercase tracking-wider text-slate-400">
            <i class="ph-duotone ph-shopping-cart text-base sm:text-lg text-emerald-400"></i>
            @lang('Orders Overview')
        </h3>
        <div class="grid grid-cols-2 gap-3 sm:gap-4 lg:grid-cols-4">
            <a href="{{ route('admin.orders.index') }}" class="group relative overflow-hidden rounded-xl sm:rounded-2xl border border-white/5 bg-[#12121a] p-3 sm:p-5 transition-all hover:border-indigo-500/30 active:scale-[0.98]">
                <div class="flex items-center justify-between gap-2">
                    <div class="min-w-0">
                        <p class="text-xs sm:text-sm text-slate-500 truncate">@lang('Total Orders')</p>
                        <p class="mt-0.5 sm:mt-1 text-lg sm:text-2xl font-bold text-white">{{ number_format($orderStats['total_count']) }}</p>
                        <p class="mt-0.5 sm:mt-1 text-xs sm:text-sm font-medium text-indigo-400 truncate">{{ showAmount($orderStats['total_amount']) }}</p>
                    </div>
                    <div class="flex h-10 w-10 sm:h-12 sm:w-12 shrink-0 items-center justify-center rounded-lg sm:rounded-xl bg-indigo-500/10 text-indigo-400">
                        <i class="ph-duotone ph-package text-xl sm:text-2xl"></i>
                    </div>
                </div>
            </a>
            <a href="{{ route('admin.orders.active') }}" class="group relative overflow-hidden rounded-xl sm:rounded-2xl border border-white/5 bg-[#12121a] p-3 sm:p-5 transition-all hover:border-emerald-500/30 active:scale-[0.98]">
                <div class="flex items-center justify-between gap-2">
                    <div class="min-w-0">
                        <p class="text-xs sm:text-sm text-slate-500 truncate">@lang('Active Orders')</p>
                        <p class="mt-0.5 sm:mt-1 text-lg sm:text-2xl font-bold text-emerald-400">{{ number_format($orderStats['active_count']) }}</p>
                        <p class="mt-0.5 sm:mt-1 text-xs sm:text-sm font-medium text-emerald-400/70 truncate">{{ showAmount($orderStats['active_amount']) }}</p>
                    </div>
                    <div class="flex h-10 w-10 sm:h-12 sm:w-12 shrink-0 items-center justify-center rounded-lg sm:rounded-xl bg-emerald-500/10 text-emerald-400">
                        <i class="ph-duotone ph-check-circle text-xl sm:text-2xl"></i>
                    </div>
                </div>
            </a>
            <a href="{{ route('admin.orders.pending') }}" class="group relative overflow-hidden rounded-xl sm:rounded-2xl border border-white/5 bg-[#12121a] p-3 sm:p-5 transition-all hover:border-amber-500/30 active:scale-[0.98]">
                <div class="flex items-center justify-between gap-2">
                    <div class="min-w-0">
                        <p class="text-xs sm:text-sm text-slate-500 truncate">@lang('Pending Orders')</p>
                        <p class="mt-0.5 sm:mt-1 text-lg sm:text-2xl font-bold text-amber-400">{{ number_format($orderStats['pending_count']) }}</p>
                        <p class="mt-0.5 sm:mt-1 text-xs sm:text-sm font-medium text-amber-400/70 truncate">{{ showAmount($orderStats['pending_amount']) }}</p>
                    </div>
                    <div class="flex h-10 w-10 sm:h-12 sm:w-12 shrink-0 items-center justify-center rounded-lg sm:rounded-xl bg-amber-500/10 text-amber-400">
                        <i class="ph-duotone ph-clock text-xl sm:text-2xl"></i>
                    </div>
                </div>
            </a>
            <a href="{{ route('admin.orders.cancelled') }}" class="group relative overflow-hidden rounded-xl sm:rounded-2xl border border-white/5 bg-[#12121a] p-3 sm:p-5 transition-all hover:border-rose-500/30 active:scale-[0.98]">
                <div class="flex items-center justify-between gap-2">
                    <div class="min-w-0">
                        <p class="text-xs sm:text-sm text-slate-500 truncate">@lang('Cancelled Orders')</p>
                        <p class="mt-0.5 sm:mt-1 text-lg sm:text-2xl font-bold text-rose-400">{{ number_format($orderStats['cancelled_count']) }}</p>
                        <p class="mt-0.5 sm:mt-1 text-xs sm:text-sm font-medium text-rose-400/70 truncate">{{ showAmount($orderStats['cancelled_amount']) }}</p>
                    </div>
                    <div class="flex h-10 w-10 sm:h-12 sm:w-12 shrink-0 items-center justify-center rounded-lg sm:rounded-xl bg-rose-500/10 text-rose-400">
                        <i class="ph-duotone ph-x-circle text-xl sm:text-2xl"></i>
                    </div>
                </div>
            </a>
        </div>
    </div>

    {{-- ============================================ --}}
    {{-- SECTION 3: INVOICE STATISTICS --}}
    {{-- ============================================ --}}
    <div class="mt-6 sm:mt-8">
        <h3 class="mb-3 sm:mb-4 flex items-center gap-2 text-xs sm:text-sm font-semibold uppercase tracking-wider text-slate-400">
            <i class="ph-duotone ph-file-text text-base sm:text-lg text-sky-400"></i>
            @lang('Invoices Overview')
        </h3>
        <div class="grid grid-cols-2 gap-3 sm:gap-4 lg:grid-cols-4">
            <a href="{{ route('admin.invoices.paid') }}" class="group relative overflow-hidden rounded-xl sm:rounded-2xl border border-white/5 bg-[#12121a] p-3 sm:p-5 transition-all hover:border-emerald-500/30 active:scale-[0.98]">
                <div class="flex items-center justify-between gap-2">
                    <div class="min-w-0">
                        <p class="text-xs sm:text-sm text-slate-500 truncate">@lang('Paid Invoices')</p>
                        <p class="mt-0.5 sm:mt-1 text-lg sm:text-2xl font-bold text-emerald-400 truncate">{{ showAmount($invoiceStats['paid_amount']) }}</p>
                        <p class="mt-0.5 sm:mt-1 text-xs sm:text-sm text-slate-500">{{ number_format($invoiceStats['paid_count']) }} <span class="hidden sm:inline">@lang('invoices')</span></p>
                    </div>
                    <div class="flex h-10 w-10 sm:h-12 sm:w-12 shrink-0 items-center justify-center rounded-lg sm:rounded-xl bg-emerald-500/10 text-emerald-400">
                        <i class="ph-duotone ph-check-circle text-xl sm:text-2xl"></i>
                    </div>
                </div>
            </a>
            <a href="{{ route('admin.invoices.unpaid') }}" class="group relative overflow-hidden rounded-xl sm:rounded-2xl border border-white/5 bg-[#12121a] p-3 sm:p-5 transition-all hover:border-amber-500/30 active:scale-[0.98]">
                <div class="flex items-center justify-between gap-2">
                    <div class="min-w-0">
                        <p class="text-xs sm:text-sm text-slate-500 truncate">@lang('Unpaid Invoices')</p>
                        <p class="mt-0.5 sm:mt-1 text-lg sm:text-2xl font-bold text-amber-400 truncate">{{ showAmount($invoiceStats['unpaid_amount']) }}</p>
                        <p class="mt-0.5 sm:mt-1 text-xs sm:text-sm text-slate-500">{{ number_format($invoiceStats['unpaid_count']) }} <span class="hidden sm:inline">@lang('invoices')</span></p>
                    </div>
                    <div class="flex h-10 w-10 sm:h-12 sm:w-12 shrink-0 items-center justify-center rounded-lg sm:rounded-xl bg-amber-500/10 text-amber-400">
                        <i class="ph-duotone ph-warning-circle text-xl sm:text-2xl"></i>
                    </div>
                </div>
            </a>
            <a href="{{ route('admin.invoices.payment.pending') }}" class="group relative overflow-hidden rounded-xl sm:rounded-2xl border border-white/5 bg-[#12121a] p-3 sm:p-5 transition-all hover:border-sky-500/30 active:scale-[0.98]">
                <div class="flex items-center justify-between gap-2">
                    <div class="min-w-0">
                        <p class="text-xs sm:text-sm text-slate-500 truncate">@lang('Payment Pending')</p>
                        <p class="mt-0.5 sm:mt-1 text-lg sm:text-2xl font-bold text-sky-400 truncate">{{ showAmount($invoiceStats['pending_amount']) }}</p>
                        <p class="mt-0.5 sm:mt-1 text-xs sm:text-sm text-slate-500">{{ number_format($invoiceStats['pending_count']) }} <span class="hidden sm:inline">@lang('invoices')</span></p>
                    </div>
                    <div class="flex h-10 w-10 sm:h-12 sm:w-12 shrink-0 items-center justify-center rounded-lg sm:rounded-xl bg-sky-500/10 text-sky-400">
                        <i class="ph-duotone ph-hourglass text-xl sm:text-2xl"></i>
                    </div>
                </div>
            </a>
            <a href="{{ route('admin.invoices.refunded') }}" class="group relative overflow-hidden rounded-xl sm:rounded-2xl border border-white/5 bg-[#12121a] p-3 sm:p-5 transition-all hover:border-rose-500/30 active:scale-[0.98]">
                <div class="flex items-center justify-between gap-2">
                    <div class="min-w-0">
                        <p class="text-xs sm:text-sm text-slate-500 truncate">@lang('Refunded')</p>
                        <p class="mt-0.5 sm:mt-1 text-lg sm:text-2xl font-bold text-rose-400 truncate">{{ showAmount($invoiceStats['refunded_amount']) }}</p>
                        <p class="mt-0.5 sm:mt-1 text-xs sm:text-sm text-slate-500">{{ number_format($invoiceStats['refunded_count']) }} <span class="hidden sm:inline">@lang('invoices')</span></p>
                    </div>
                    <div class="flex h-10 w-10 sm:h-12 sm:w-12 shrink-0 items-center justify-center rounded-lg sm:rounded-xl bg-rose-500/10 text-rose-400">
                        <i class="ph-duotone ph-arrow-counter-clockwise text-xl sm:text-2xl"></i>
                    </div>
                </div>
            </a>
        </div>
    </div>

    {{-- ============================================ --}}
    {{-- SECTION 4: SERVICES & REVENUE STATS --}}
    {{-- ============================================ --}}
    <div class="mt-6 sm:mt-8 grid grid-cols-1 gap-4 sm:gap-6 lg:grid-cols-2">
        {{-- Services Overview --}}
        <div>
            <h3 class="mb-3 sm:mb-4 flex items-center gap-2 text-xs sm:text-sm font-semibold uppercase tracking-wider text-slate-400">
                <i class="ph-duotone ph-hard-drives text-base sm:text-lg text-purple-400"></i>
                @lang('Services Overview')
            </h3>
            <div class="grid grid-cols-2 gap-2 sm:gap-4 sm:grid-cols-3">
                <div class="rounded-xl sm:rounded-2xl border border-white/5 bg-[#12121a] p-3 sm:p-4 transition-all hover:border-white/10 active:scale-[0.98]">
                    <div class="flex items-center gap-2 sm:gap-3">
                        <div class="flex h-8 w-8 sm:h-10 sm:w-10 shrink-0 items-center justify-center rounded-lg bg-emerald-500/10 text-emerald-400">
                            <i class="ph-duotone ph-hard-drive text-lg sm:text-xl"></i>
                        </div>
                        <div class="min-w-0">
                            <p class="text-lg sm:text-2xl font-bold text-white">{{ number_format($serviceStats['active_hosting']) }}</p>
                            <p class="text-[10px] sm:text-xs text-slate-500 truncate">@lang('Active Hosting')</p>
                        </div>
                    </div>
                </div>
                <div class="rounded-xl sm:rounded-2xl border border-white/5 bg-[#12121a] p-3 sm:p-4 transition-all hover:border-white/10 active:scale-[0.98]">
                    <div class="flex items-center gap-2 sm:gap-3">
                        <div class="flex h-8 w-8 sm:h-10 sm:w-10 shrink-0 items-center justify-center rounded-lg bg-amber-500/10 text-amber-400">
                            <i class="ph-duotone ph-clock text-lg sm:text-xl"></i>
                        </div>
                        <div class="min-w-0">
                            <p class="text-lg sm:text-2xl font-bold text-white">{{ number_format($serviceStats['pending_hosting']) }}</p>
                            <p class="text-[10px] sm:text-xs text-slate-500 truncate">@lang('Pending Setup')</p>
                        </div>
                    </div>
                </div>
                <div class="rounded-xl sm:rounded-2xl border border-white/5 bg-[#12121a] p-3 sm:p-4 transition-all hover:border-white/10 active:scale-[0.98]">
                    <div class="flex items-center gap-2 sm:gap-3">
                        <div class="flex h-8 w-8 sm:h-10 sm:w-10 shrink-0 items-center justify-center rounded-lg bg-rose-500/10 text-rose-400">
                            <i class="ph-duotone ph-pause-circle text-lg sm:text-xl"></i>
                        </div>
                        <div class="min-w-0">
                            <p class="text-lg sm:text-2xl font-bold text-white">{{ number_format($serviceStats['suspended_hosting']) }}</p>
                            <p class="text-[10px] sm:text-xs text-slate-500 truncate">@lang('Suspended')</p>
                        </div>
                    </div>
                </div>
                <div class="rounded-xl sm:rounded-2xl border border-white/5 bg-[#12121a] p-3 sm:p-4 transition-all hover:border-white/10 active:scale-[0.98]">
                    <div class="flex items-center gap-2 sm:gap-3">
                        <div class="flex h-8 w-8 sm:h-10 sm:w-10 shrink-0 items-center justify-center rounded-lg bg-indigo-500/10 text-indigo-400">
                            <i class="ph-duotone ph-globe text-lg sm:text-xl"></i>
                        </div>
                        <div class="min-w-0">
                            <p class="text-lg sm:text-2xl font-bold text-white">{{ number_format($serviceStats['active_domains']) }}</p>
                            <p class="text-[10px] sm:text-xs text-slate-500 truncate">@lang('Active Domains')</p>
                        </div>
                    </div>
                </div>
                <div class="rounded-xl sm:rounded-2xl border border-white/5 bg-[#12121a] p-3 sm:p-4 transition-all hover:border-white/10 active:scale-[0.98]">
                    <div class="flex items-center gap-2 sm:gap-3">
                        <div class="flex h-8 w-8 sm:h-10 sm:w-10 shrink-0 items-center justify-center rounded-lg bg-sky-500/10 text-sky-400">
                            <i class="ph-duotone ph-globe-simple text-lg sm:text-xl"></i>
                        </div>
                        <div class="min-w-0">
                            <p class="text-lg sm:text-2xl font-bold text-white">{{ number_format($serviceStats['pending_domains']) }}</p>
                            <p class="text-[10px] sm:text-xs text-slate-500 truncate">@lang('Pending Domains')</p>
                        </div>
                    </div>
                </div>
                <div class="rounded-xl sm:rounded-2xl border border-white/5 bg-[#12121a] p-3 sm:p-4 transition-all hover:border-white/10 active:scale-[0.98]">
                    <div class="flex items-center gap-2 sm:gap-3">
                        <div class="flex h-8 w-8 sm:h-10 sm:w-10 shrink-0 items-center justify-center rounded-lg bg-slate-500/10 text-slate-400">
                            <i class="ph-duotone ph-globe-x text-lg sm:text-xl"></i>
                        </div>
                        <div class="min-w-0">
                            <p class="text-lg sm:text-2xl font-bold text-white">{{ number_format($serviceStats['suspended_domains']) }}</p>
                            <p class="text-[10px] sm:text-xs text-slate-500 truncate">@lang('Suspended Domains')</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Revenue Overview --}}
        <div>
            <h3 class="mb-3 sm:mb-4 flex items-center gap-2 text-xs sm:text-sm font-semibold uppercase tracking-wider text-slate-400">
                <i class="ph-duotone ph-currency-dollar text-base sm:text-lg text-emerald-400"></i>
                @lang('Revenue Overview')
            </h3>
            <div class="grid grid-cols-2 gap-2 sm:gap-4">
                <div class="rounded-xl sm:rounded-2xl border border-white/5 bg-[#12121a] p-3 sm:p-5 transition-all hover:border-white/10 active:scale-[0.98]">
                    <div class="flex items-center justify-between gap-2">
                        <div class="min-w-0">
                            <p class="text-xs sm:text-sm text-slate-500 truncate">@lang('Today\'s Revenue')</p>
                            <p class="mt-0.5 sm:mt-1 text-lg sm:text-2xl font-bold text-emerald-400 truncate">{{ showAmount($revenueStats['today']) }}</p>
                        </div>
                        <div class="flex h-8 w-8 sm:h-10 sm:w-10 shrink-0 items-center justify-center rounded-lg bg-emerald-500/10 text-emerald-400">
                            <i class="ph-duotone ph-calendar-check text-lg sm:text-xl"></i>
                        </div>
                    </div>
                </div>
                <div class="rounded-xl sm:rounded-2xl border border-white/5 bg-[#12121a] p-3 sm:p-5 transition-all hover:border-white/10 active:scale-[0.98]">
                    <div class="flex items-center justify-between gap-2">
                        <div class="min-w-0">
                            <p class="text-xs sm:text-sm text-slate-500 truncate">@lang('This Month')</p>
                            <p class="mt-0.5 sm:mt-1 text-lg sm:text-2xl font-bold text-indigo-400 truncate">{{ showAmount($revenueStats['month']) }}</p>
                            @if($revenueStats['trend'] != 0)
                                <p class="mt-0.5 sm:mt-1 flex items-center gap-1 text-[10px] sm:text-xs {{ $revenueStats['trend'] > 0 ? 'text-emerald-400' : 'text-rose-400' }}">
                                    <i class="ph-bold {{ $revenueStats['trend'] > 0 ? 'ph-arrow-up' : 'ph-arrow-down' }}"></i>
                                    {{ abs($revenueStats['trend']) }}%
                                </p>
                            @endif
                        </div>
                        <div class="flex h-8 w-8 sm:h-10 sm:w-10 shrink-0 items-center justify-center rounded-lg bg-indigo-500/10 text-indigo-400">
                            <i class="ph-duotone ph-calendar text-lg sm:text-xl"></i>
                        </div>
                    </div>
                </div>
                <div class="rounded-xl sm:rounded-2xl border border-white/5 bg-[#12121a] p-3 sm:p-5 transition-all hover:border-white/10 active:scale-[0.98]">
                    <div class="flex items-center justify-between gap-2">
                        <div class="min-w-0">
                            <p class="text-xs sm:text-sm text-slate-500 truncate">@lang('Total Revenue')</p>
                            <p class="mt-0.5 sm:mt-1 text-lg sm:text-2xl font-bold text-white truncate">{{ showAmount($revenueStats['total']) }}</p>
                        </div>
                        <div class="flex h-8 w-8 sm:h-10 sm:w-10 shrink-0 items-center justify-center rounded-lg bg-white/5 text-slate-400">
                            <i class="ph-duotone ph-chart-line-up text-lg sm:text-xl"></i>
                        </div>
                    </div>
                </div>
                <div class="rounded-xl sm:rounded-2xl border border-white/5 bg-[#12121a] p-3 sm:p-5 transition-all hover:border-white/10 active:scale-[0.98]">
                    <div class="flex items-center justify-between gap-2">
                        <div class="min-w-0">
                            <p class="text-xs sm:text-sm text-slate-500 truncate">@lang('Pending Payments')</p>
                            <p class="mt-0.5 sm:mt-1 text-lg sm:text-2xl font-bold text-amber-400 truncate">{{ showAmount($revenueStats['pending']) }}</p>
                        </div>
                        <div class="flex h-8 w-8 sm:h-10 sm:w-10 shrink-0 items-center justify-center rounded-lg bg-amber-500/10 text-amber-400">
                            <i class="ph-duotone ph-hourglass text-lg sm:text-xl"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>



    {{-- ============================================ --}}
    {{-- SECTION 5: CHARTS --}}
    {{-- ============================================ --}}
    <div class="mt-6 sm:mt-8 grid grid-cols-1 gap-4 sm:gap-6 lg:grid-cols-2">
        <x-admin.card :title="__('Revenue Trend')">
            <x-slot:actions>
                <select wire:model.live="dateRange" class="rounded-lg border border-white/10 bg-white/5 px-2 sm:px-3 py-1.5 text-xs text-slate-300 focus:border-indigo-500/50 focus:outline-none">
                    <option value="7">@lang('7 Days')</option>
                    <option value="30">@lang('30 Days')</option>
                    <option value="90">@lang('90 Days')</option>
                </select>
            </x-slot:actions>
            <x-admin.chart
                type="line"
                :labels="$chartData['labels']"
                :datasets="[['label' => __('Revenue'), 'data' => $chartData['revenue'], 'borderColor' => '#6366f1', 'fill' => true, 'backgroundColor' => 'rgba(99, 102, 241, 0.1)']]"
                height="280"
                mobileHeight="200"
            />
        </x-admin.card>

        <x-admin.card :title="__('Orders Statistics')">
            <x-slot:actions>
                <div class="flex items-center gap-2">
                    <select wire:model.live="orderChartStatus" class="rounded-lg border border-white/10 bg-white/5 px-2 sm:px-3 py-1.5 text-xs text-slate-300 focus:border-indigo-500/50 focus:outline-none">
                        <option value="">@lang('All Status')</option>
                        <option value="1">@lang('Active')</option>
                        <option value="0">@lang('Pending')</option>
                        <option value="2">@lang('Cancelled')</option>
                    </select>
                </div>
            </x-slot:actions>
            <x-admin.chart
                type="bar"
                :labels="$chartData['labels']"
                :datasets="[['label' => __('Orders'), 'data' => $chartData['orders'], 'backgroundColor' => '#10b981']]"
                height="280"
                mobileHeight="200"
            />
        </x-admin.card>
    </div>

    {{-- ============================================ --}}
    {{-- SECTION 6: RECENT ACTIVITY --}}
    {{-- ============================================ --}}
    <div class="mt-6 sm:mt-8 grid grid-cols-1 gap-4 sm:gap-6 md:grid-cols-2 xl:grid-cols-4">
        {{-- Recent Orders --}}
        <x-admin.card :title="__('Recent Orders')" :padding="false">
            <x-slot:actions>
                <a href="{{ route('admin.orders.index') }}" class="text-xs font-medium text-indigo-400 hover:text-indigo-300">@lang('View All')</a>
            </x-slot:actions>
            <div class="divide-y divide-white/5">
                @forelse($recentOrders as $order)
                    <div class="flex items-center justify-between px-3 sm:px-5 py-2.5 sm:py-3 transition-all hover:bg-white/5 active:bg-white/10">
                        <div class="min-w-0">
                            <p class="text-sm font-medium text-white">#{{ $order['id'] }}</p>
                            <p class="text-xs text-slate-500 truncate">{{ $order['user']['username'] ?? 'N/A' }}</p>
                        </div>
                        <x-admin.badge :type="$order['status'] == 1 ? 'success' : ($order['status'] == 0 ? 'warning' : 'danger')" size="sm">
                            {{ $order['status'] == 1 ? __('Active') : ($order['status'] == 0 ? __('Pending') : __('Cancelled')) }}
                        </x-admin.badge>
                    </div>
                @empty
                    <div class="px-4 sm:px-5 py-6 sm:py-8 text-center text-sm text-slate-500">@lang('No recent orders')</div>
                @endforelse
            </div>
        </x-admin.card>

        {{-- Recent Invoices --}}
        <x-admin.card :title="__('Recent Invoices')" :padding="false">
            <x-slot:actions>
                <a href="{{ route('admin.invoices.index') }}" class="text-xs font-medium text-indigo-400 hover:text-indigo-300">@lang('View All')</a>
            </x-slot:actions>
            <div class="divide-y divide-white/5">
                @forelse($recentInvoices as $invoice)
                    <a href="{{ route('admin.invoices.details', $invoice['id']) }}" class="flex items-center justify-between px-3 sm:px-5 py-2.5 sm:py-3 transition-all hover:bg-white/5 active:bg-white/10">
                        <div class="min-w-0">
                            <p class="text-sm font-medium text-white">{{ $invoice['invoice_number'] ?? '#'.$invoice['id'] }}</p>
                            <p class="text-xs text-slate-500">{{ showAmount($invoice['amount']) }}</p>
                        </div>
                        @php
                            $invStatus = match($invoice['status']) {
                                1 => ['success', __('Paid')],
                                2 => ['warning', __('Unpaid')],
                                3 => ['info', __('Pending')],
                                5 => ['danger', __('Refunded')],
                                default => ['secondary', __('Unknown')]
                            };
                        @endphp
                        <x-admin.badge :type="$invStatus[0]" size="sm">{{ $invStatus[1] }}</x-admin.badge>
                    </a>
                @empty
                    <div class="px-4 sm:px-5 py-6 sm:py-8 text-center text-sm text-slate-500">@lang('No recent invoices')</div>
                @endforelse
            </div>
        </x-admin.card>

        {{-- Pending Tickets --}}
        <x-admin.card :title="__('Pending Tickets')" :padding="false">
            <x-slot:actions>
                <a href="{{ route('admin.ticket.index') }}" class="text-xs font-medium text-indigo-400 hover:text-indigo-300">@lang('View All')</a>
            </x-slot:actions>
            <div class="divide-y divide-white/5">
                @forelse($recentTickets as $ticket)
                    <a href="{{ route('admin.ticket.view', $ticket['id']) }}" class="flex items-center justify-between px-3 sm:px-5 py-2.5 sm:py-3 transition-all hover:bg-white/5 active:bg-white/10">
                        <div class="min-w-0 flex-1">
                            <p class="truncate text-sm font-medium text-white">{{ Str::limit($ticket['subject'], 25) }}</p>
                            <p class="text-xs text-slate-500">{{ $ticket['user']['username'] ?? 'N/A' }}</p>
                        </div>
                        <x-admin.badge type="warning" size="sm">@lang('Open')</x-admin.badge>
                    </a>
                @empty
                    <div class="px-4 sm:px-5 py-6 sm:py-8 text-center text-sm text-slate-500">@lang('No pending tickets')</div>
                @endforelse
            </div>
        </x-admin.card>

        {{-- New Clients --}}
        <x-admin.card :title="__('New Clients')" :padding="false">
            <x-slot:actions>
                <a href="{{ route('admin.users.all') }}" class="text-xs font-medium text-indigo-400 hover:text-indigo-300">@lang('View All')</a>
            </x-slot:actions>
            <div class="divide-y divide-white/5">
                @forelse($recentUsers as $user)
                    @if(!empty($user['username']))
                        <a href="{{ route('admin.users.detail', $user['username']) }}" class="flex items-center gap-2 sm:gap-3 px-3 sm:px-5 py-2.5 sm:py-3 transition-all hover:bg-white/5 active:bg-white/10">
                    @else
                        <div class="flex items-center gap-2 sm:gap-3 px-3 sm:px-5 py-2.5 sm:py-3 transition-all hover:bg-white/5">
                    @endif
                        <div class="flex h-8 w-8 shrink-0 items-center justify-center rounded-lg bg-gradient-to-br from-indigo-500/20 to-purple-500/20 text-xs font-semibold text-indigo-400">
                            {{ strtoupper(substr($user['firstname'] ?? 'U', 0, 1)) }}
                        </div>
                        <div class="min-w-0 flex-1">
                            <p class="truncate text-sm font-medium text-white">{{ $user['firstname'] }} {{ $user['lastname'] }}</p>
                            <p class="truncate text-xs text-slate-500">{{ $user['email'] }}</p>
                        </div>
                    @if(!empty($user['username']))
                        </a>
                    @else
                        </div>
                    @endif
                @empty
                    <div class="px-4 sm:px-5 py-6 sm:py-8 text-center text-sm text-slate-500">@lang('No recent clients')</div>
                @endforelse
            </div>
        </x-admin.card>
    </div>

    {{-- ============================================ --}}
    {{-- SECTION 7: SYSTEM STATUS --}}
    {{-- ============================================ --}}
    <div class="mt-6 sm:mt-8">
        <h3 class="mb-3 sm:mb-4 flex items-center gap-2 text-xs sm:text-sm font-semibold uppercase tracking-wider text-slate-400">
            <i class="ph-duotone ph-gear text-base sm:text-lg text-slate-400"></i>
            @lang('System Status')
        </h3>
        <div class="grid grid-cols-2 gap-2 sm:gap-4 sm:grid-cols-4">
            <div class="rounded-xl sm:rounded-2xl border border-white/5 bg-[#12121a] p-3 sm:p-4 active:scale-[0.98]">
                <div class="flex items-center gap-2 sm:gap-3">
                    <div class="flex h-8 w-8 sm:h-10 sm:w-10 shrink-0 items-center justify-center rounded-lg {{ $lastCronRun ? 'bg-emerald-500/10 text-emerald-400' : 'bg-rose-500/10 text-rose-400' }}">
                        <i class="ph-duotone ph-clock-clockwise text-lg sm:text-xl"></i>
                    </div>
                    <div class="min-w-0">
                        <p class="text-[10px] sm:text-xs text-slate-500 truncate">@lang('Last Cron Run')</p>
                        <p class="text-xs sm:text-sm font-medium {{ $lastCronRun ? 'text-emerald-400' : 'text-rose-400' }} truncate">
                            {{ $lastCronRun ?? __('Never') }}
                        </p>
                    </div>
                </div>
            </div>
            <div class="rounded-xl sm:rounded-2xl border border-white/5 bg-[#12121a] p-3 sm:p-4 active:scale-[0.98]">
                <div class="flex items-center gap-2 sm:gap-3">
                    <div class="flex h-8 w-8 sm:h-10 sm:w-10 shrink-0 items-center justify-center rounded-lg bg-emerald-500/10 text-emerald-400">
                        <i class="ph-duotone ph-check-circle text-lg sm:text-xl"></i>
                    </div>
                    <div class="min-w-0">
                        <p class="text-[10px] sm:text-xs text-slate-500 truncate">@lang('System Status')</p>
                        <p class="text-xs sm:text-sm font-medium text-emerald-400">@lang('Operational')</p>
                    </div>
                </div>
            </div>
            <div class="rounded-xl sm:rounded-2xl border border-white/5 bg-[#12121a] p-3 sm:p-4 active:scale-[0.98]">
                <div class="flex items-center gap-2 sm:gap-3">
                    <div class="flex h-8 w-8 sm:h-10 sm:w-10 shrink-0 items-center justify-center rounded-lg bg-amber-500/10 text-amber-400">
                        <i class="ph-duotone ph-warning text-lg sm:text-xl"></i>
                    </div>
                    <div class="min-w-0">
                        <p class="text-[10px] sm:text-xs text-slate-500 truncate">@lang('Overdue Invoices')</p>
                        <p class="text-xs sm:text-sm font-medium text-amber-400">{{ number_format($invoiceStats['unpaid_count']) }}</p>
                    </div>
                </div>
            </div>
            <div class="rounded-xl sm:rounded-2xl border border-white/5 bg-[#12121a] p-3 sm:p-4 active:scale-[0.98]">
                <div class="flex items-center gap-2 sm:gap-3">
                    <div class="flex h-8 w-8 sm:h-10 sm:w-10 shrink-0 items-center justify-center rounded-lg bg-rose-500/10 text-rose-400">
                        <i class="ph-duotone ph-ticket text-lg sm:text-xl"></i>
                    </div>
                    <div class="min-w-0">
                        <p class="text-[10px] sm:text-xs text-slate-500 truncate">@lang('Open Tickets')</p>
                        <p class="text-xs sm:text-sm font-medium text-rose-400">{{ number_format($stats['pending_tickets']) }}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- ============================================ --}}
    {{-- CRON SETUP MODAL (Mobile-optimized) --}}
    {{-- ============================================ --}}
    <div x-show="showCronModal" x-cloak
        class="fixed inset-0 z-50 flex items-end sm:items-center justify-center overflow-y-auto"
        x-transition:enter="transition ease-out duration-300"
        x-transition:enter-start="opacity-0"
        x-transition:enter-end="opacity-100"
        x-transition:leave="transition ease-in duration-200"
        x-transition:leave-start="opacity-100"
        x-transition:leave-end="opacity-0"
        @keydown.escape.window="showCronModal = false">
        <div class="fixed inset-0 bg-black/60 backdrop-blur-sm" @click="showCronModal = false"></div>
        <div class="relative w-full sm:max-w-lg rounded-t-2xl sm:rounded-2xl border border-white/10 bg-[#12121a] p-4 sm:p-6 shadow-2xl max-h-[90vh] overflow-y-auto"
            x-transition:enter="transition ease-out duration-300"
            x-transition:enter-start="opacity-0 translate-y-full sm:translate-y-0 sm:scale-95"
            x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
            x-transition:leave="transition ease-in duration-200"
            x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
            x-transition:leave-end="opacity-0 translate-y-full sm:translate-y-0 sm:scale-95">
            {{-- Mobile drag handle --}}
            <div class="sm:hidden flex justify-center mb-3">
                <div class="w-10 h-1 rounded-full bg-white/20"></div>
            </div>
            <div class="flex items-center justify-between">
                <h3 class="text-base sm:text-lg font-semibold text-white">@lang('Cron Job Setup')</h3>
                <button @click="showCronModal = false" class="rounded-lg p-2 min-h-[44px] min-w-[44px] flex items-center justify-center text-slate-400 transition-colors hover:bg-white/5 hover:text-white active:bg-white/10">
                    <i class="ph-bold ph-x text-lg"></i>
                </button>
            </div>
            <div class="mt-3 sm:mt-4">
                <p class="text-xs sm:text-sm text-slate-400">@lang('Add the following cron job to your server to automate billing tasks:')</p>
                <div class="mt-3 rounded-xl bg-black/30 p-3 sm:p-4 overflow-x-auto">
                    <code class="break-all text-xs sm:text-sm text-emerald-400">{{ $this->getCronCommand() }}</code>
                </div>
                <div class="mt-3 sm:mt-4 flex items-start gap-2 text-xs sm:text-sm">
                    <i class="ph-duotone ph-info text-indigo-400 shrink-0 mt-0.5"></i>
                    <span class="text-slate-400">@lang('This cron job runs every minute to process invoices, reminders, and auto-suspend services.')</span>
                </div>
                @if($lastCronRun)
                    <div class="mt-3 sm:mt-4 flex items-center gap-2 rounded-lg bg-emerald-500/10 px-3 sm:px-4 py-2.5 sm:py-3">
                        <i class="ph-duotone ph-check-circle text-emerald-400 shrink-0"></i>
                        <span class="text-xs sm:text-sm text-emerald-400">@lang('Last run:') {{ $lastCronRun }}</span>
                    </div>
                @else
                    <div class="mt-3 sm:mt-4 flex items-center gap-2 rounded-lg bg-amber-500/10 px-3 sm:px-4 py-2.5 sm:py-3">
                        <i class="ph-duotone ph-warning text-amber-400 shrink-0"></i>
                        <span class="text-xs sm:text-sm text-amber-400">@lang('Cron job has never been executed. Please set it up.')</span>
                    </div>
                @endif
            </div>
            <div class="mt-4 sm:mt-6 flex justify-end pb-safe">
                <button @click="showCronModal = false" class="w-full sm:w-auto rounded-xl bg-indigo-600 px-4 py-3 sm:py-2.5 text-sm font-medium text-white transition-colors hover:bg-indigo-500 active:bg-indigo-700 min-h-[44px]">
                    @lang('Close')
                </button>
            </div>
        </div>
    </div>
</div>
