<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Domain Categories')" :subtitle="__('Manage TLD groups and categories.')">
        <x-slot:actions>
            <x-admin.button wire:click="openModal" icon="ph-plus">
                @lang('Add Category')
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    @if (session('success'))
        <x-admin.alert type="success" class="mt-6">{{ session('success') }}</x-admin.alert>
    @endif
    @if (session('error'))
        <x-admin.alert type="danger" class="mt-6">{{ session('error') }}</x-admin.alert>
    @endif

    {{-- Search --}}
    <x-admin.card class="mt-6">
        <div class="relative w-full sm:w-80">
            <i class="ph-duotone ph-magnifying-glass absolute left-3 top-1/2 -translate-y-1/2 text-slate-500"></i>
            <input
                type="text"
                wire:model.live.debounce.300ms="search"
                placeholder="{{ __('Search categories...') }}"
                class="w-full rounded-xl border border-white/10 bg-white/5 py-2.5 pl-10 pr-4 text-sm text-white placeholder-slate-500 transition-all focus:border-primary-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-primary-500/20"
            />
        </div>
    </x-admin.card>

    {{-- Categories Table --}}
    <x-admin.card class="mt-6" :padding="false">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-white/5 bg-white/[0.02]">
                        <th class="px-6 py-4 text-left">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Category')</span>
                        </th>
                        <th class="px-6 py-4 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Slug')</span>
                        </th>
                        <th class="px-6 py-4 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('TLD Count')</span>
                        </th>
                        <th class="px-6 py-4 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Status')</span>
                        </th>
                        <th class="px-6 py-4 text-right">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Actions')</span>
                        </th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    @forelse($categories as $cat)
                        <tr class="group transition-all hover:bg-white/[0.02]" wire:key="cat-{{ $cat->id }}">
                            <td class="px-6 py-4">
                                <div class="flex items-center gap-3">
                                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-primary-500/20 to-indigo-500/20 text-primary-400">
                                        <i class="{{ $cat->icon ?: 'ph-duotone ph-bookmarks' }} text-lg"></i>
                                    </div>
                                    <span class="font-semibold text-white">{{ $cat->name }}</span>
                                </div>
                            </td>
                            <td class="px-6 py-4 text-center">
                                <span class="text-sm text-slate-400 font-mono">{{ $cat->slug }}</span>
                            </td>
                            <td class="px-6 py-4 text-center">
                                <span class="inline-flex items-center justify-center rounded-lg bg-white/5 px-3 py-1 text-sm font-medium text-white">
                                    {{ $cat->tlds_count ?? $cat->tlds()->count() }}
                                </span>
                            </td>
                            <td class="px-6 py-4 text-center">
                                <x-admin.toggle wire:click="toggleStatus({{ $cat->id }})" :checked="$cat->status" />
                            </td>
                            <td class="px-6 py-4 text-right">
                                <x-admin.action-menu>
                                    <x-admin.action-menu-item wire:click="openModal({{ $cat->id }})" icon="ph-pencil">
                                        @lang('Edit')
                                    </x-admin.action-menu-item>
                                    <x-admin.action-menu-item :divider="true" />
                                    <x-admin.action-menu-item wire:click="delete({{ $cat->id }})" wire:confirm="{{ __('Are you sure?') }}" icon="ph-trash" :danger="true">
                                        @lang('Delete')
                                    </x-admin.action-menu-item>
                                </x-admin.action-menu>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="px-6 py-16 text-center">
                                <div class="flex flex-col items-center text-slate-500">
                                    <i class="ph-duotone ph-bookmarks text-5xl opacity-20 mb-4"></i>
                                    <p>@lang('No categories found.')</p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        @if($categories->hasPages())
            <div class="border-t border-white/5 px-6 py-4">
                {{ $categories->links() }}
            </div>
        @endif
    </x-admin.card>

    {{-- Modal --}}
    <x-admin.modal wire:model="showModal" :title="$editingId ? __('Edit Category') : __('Add Category')">
        <form wire:submit="save">
            <div class="space-y-4">
                <x-admin.input :label="__('Name')" wire:model.live="name" required />
                <x-admin.input :label="__('Slug')" wire:model="slug" required />
                <x-admin.input :label="__('Icon Class')" wire:model="icon" placeholder="ph-duotone ph-star" />
                
                <div class="flex items-center justify-between rounded-xl bg-white/5 p-4">
                    <div>
                        <p class="text-sm font-medium text-white">@lang('Show on Frontend')</p>
                    </div>
                    <x-admin.toggle wire:model.live="status" />
                </div>
            </div>
            <div class="mt-6 flex justify-end gap-3">
                <x-admin.button type="button" variant="secondary" wire:click="$set('showModal', false)">@lang('Cancel')</x-admin.button>
                <x-admin.button type="submit">@lang('Save Category')</x-admin.button>
            </div>
        </form>
    </x-admin.modal>
</div>
