<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Domain Details')" :subtitle="$domain->domain ?? __('N/A')">
        <x-slot:actions>
            {{-- Desktop Actions --}}
            <div class="hidden sm:flex items-center gap-2">
                @if($domain->order_id)
                    <a href="{{ route('admin.orders.details', $domain->order_id) }}" class="inline-flex items-center gap-2 rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm font-medium text-white transition-all hover:bg-white/10 cursor-pointer">
                        <i class="ph-duotone ph-shopping-cart"></i>
                        @lang('View Order')
                    </a>
                @endif
            </div>
        </x-slot:actions>
    </x-admin.page-header>

    {{-- Mobile Actions --}}
    @if($domain->order_id)
        <div class="flex sm:hidden -mx-4 px-4 overflow-x-auto pb-2 mt-3">
            <div class="flex items-center gap-2 min-w-max">
                <a href="{{ route('admin.orders.details', $domain->order_id) }}" class="inline-flex items-center gap-1.5 rounded-xl border border-white/10 bg-white/5 px-3 py-2 text-xs font-medium text-white transition-all active:scale-[0.98] min-h-9">
                    <i class="ph-duotone ph-shopping-cart"></i>
                    @lang('Order')
                </a>
            </div>
        </div>
    @endif

    @if (session('success'))
        <x-admin.alert type="success" class="mt-4 sm:mt-6">{{ session('success') }}</x-admin.alert>
    @endif
    @if (session('error'))
        <x-admin.alert type="danger" class="mt-4 sm:mt-6">{{ session('error') }}</x-admin.alert>
    @endif

    {{-- Register Commands --}}
    @if($this->registrars->count() > 0)
        <x-admin.card class="mt-4 sm:mt-6" :title="__('Register Commands')" :subtitle="__('Execute domain registrar API commands')">
            <div class="grid grid-cols-3 sm:grid-cols-4 lg:grid-cols-7 gap-2 sm:gap-3">
                <button wire:click="openRegisterModal" type="button" class="flex flex-col items-center gap-1.5 sm:gap-2 rounded-xl border border-white/10 bg-white/5 p-2.5 sm:p-4 text-center transition-all hover:bg-white/10 active:scale-[0.98] cursor-pointer min-h-[70px] sm:min-h-0">
                    <i class="ph-duotone ph-globe text-xl sm:text-2xl text-primary-400"></i>
                    <span class="text-[10px] sm:text-sm font-medium text-white">@lang('Register')</span>
                </button>
                <button wire:click="openModuleModal(2, '{{ __('Change Nameservers') }}')" type="button" class="flex flex-col items-center gap-1.5 sm:gap-2 rounded-xl border border-white/10 bg-white/5 p-2.5 sm:p-4 text-center transition-all hover:bg-white/10 active:scale-[0.98] cursor-pointer min-h-[70px] sm:min-h-0">
                    <i class="ph-duotone ph-dns text-xl sm:text-2xl text-blue-400"></i>
                    <span class="text-[10px] sm:text-sm font-medium text-white leading-tight">@lang('Nameservers')</span>
                </button>
                <button wire:click="openModuleModal(3, '{{ __('Renew Domain') }}')" type="button" class="flex flex-col items-center gap-1.5 sm:gap-2 rounded-xl border border-white/10 bg-white/5 p-2.5 sm:p-4 text-center transition-all hover:bg-white/10 active:scale-[0.98] cursor-pointer min-h-[70px] sm:min-h-0">
                    <i class="ph-duotone ph-arrows-clockwise text-xl sm:text-2xl text-emerald-400"></i>
                    <span class="text-[10px] sm:text-sm font-medium text-white">@lang('Renew')</span>
                </button>
                <button wire:click="syncWithRegistrar" type="button" class="flex flex-col items-center gap-1.5 sm:gap-2 rounded-xl border border-white/10 bg-white/5 p-2.5 sm:p-4 text-center transition-all hover:bg-white/10 active:scale-[0.98] cursor-pointer min-h-[70px] sm:min-h-0" :disabled="isProcessing">
                    <i class="ph-duotone ph-arrows-counter-clockwise text-xl sm:text-2xl text-cyan-400" wire:loading.remove wire:target="syncWithRegistrar"></i>
                    <svg wire:loading wire:target="syncWithRegistrar" class="h-5 w-5 sm:h-6 sm:w-6 animate-spin text-cyan-400" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                    </svg>
                    <span class="text-[10px] sm:text-sm font-medium text-white">@lang('Sync')</span>
                </button>
                <button wire:click="openContactModal" type="button" class="flex flex-col items-center gap-1.5 sm:gap-2 rounded-xl border border-white/10 bg-white/5 p-2.5 sm:p-4 text-center transition-all hover:bg-white/10 active:scale-[0.98] cursor-pointer min-h-[70px] sm:min-h-0" :disabled="isProcessing">
                    <i class="ph-duotone ph-address-book text-xl sm:text-2xl text-amber-400" wire:loading.remove wire:target="openContactModal"></i>
                    <svg wire:loading wire:target="openContactModal" class="h-5 w-5 sm:h-6 sm:w-6 animate-spin text-amber-400" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                    </svg>
                    <span class="text-[10px] sm:text-sm font-medium text-white leading-tight">@lang('Contact')</span>
                </button>
                <button wire:click="openModuleModal(5, '{{ __('Enable ID Protection') }}')" type="button" class="flex flex-col items-center gap-1.5 sm:gap-2 rounded-xl border border-white/10 bg-white/5 p-2.5 sm:p-4 text-center transition-all hover:bg-white/10 active:scale-[0.98] cursor-pointer min-h-[70px] sm:min-h-0 {{ $id_protection ? 'opacity-50 cursor-not-allowed' : '' }}" {{ $id_protection ? 'disabled' : '' }}>
                    <i class="ph-duotone ph-shield-check text-xl sm:text-2xl text-violet-400"></i>
                    <span class="text-[10px] sm:text-sm font-medium text-white leading-tight">@lang('Enable ID')</span>
                </button>
                <button wire:click="openModuleModal(6, '{{ __('Disable ID Protection') }}')" type="button" class="flex flex-col items-center gap-1.5 sm:gap-2 rounded-xl border border-white/10 bg-white/5 p-2.5 sm:p-4 text-center transition-all hover:bg-white/10 active:scale-[0.98] cursor-pointer min-h-[70px] sm:min-h-0 {{ !$id_protection ? 'opacity-50 cursor-not-allowed' : '' }}" {{ !$id_protection ? 'disabled' : '' }}>
                    <i class="ph-duotone ph-shield-slash text-xl sm:text-2xl text-red-400"></i>
                    <span class="text-[10px] sm:text-sm font-medium text-white leading-tight">@lang('Disable ID')</span>
                </button>
                <button wire:click="$set('showTransferModal', true)" type="button" class="flex flex-col items-center gap-1.5 sm:gap-2 rounded-xl border border-white/10 bg-white/5 p-2.5 sm:p-4 text-center transition-all hover:bg-white/10 active:scale-[0.98] cursor-pointer min-h-[70px] sm:min-h-0">
                    <i class="ph-duotone ph-swap text-xl sm:text-2xl text-yellow-400"></i>
                    <span class="text-[10px] sm:text-sm font-medium text-white leading-tight">@lang('Transfer')</span>
                </button>
                <button wire:click="openModuleModal(7, '{{ __('Get EPP Code') }}')" type="button" class="flex flex-col items-center gap-1.5 sm:gap-2 rounded-xl border border-white/10 bg-white/5 p-2.5 sm:p-4 text-center transition-all hover:bg-white/10 active:scale-[0.98] cursor-pointer min-h-[70px] sm:min-h-0">
                    <i class="ph-duotone ph-key text-xl sm:text-2xl text-orange-400"></i>
                    <span class="text-[10px] sm:text-sm font-medium text-white leading-tight">@lang('Get EPP')</span>
                </button>
                <button wire:click="openModuleModal(8, '{{ __('Lock Domain') }}')" type="button" class="flex flex-col items-center gap-1.5 sm:gap-2 rounded-xl border border-white/10 bg-white/5 p-2.5 sm:p-4 text-center transition-all hover:bg-white/10 active:scale-[0.98] cursor-pointer min-h-[70px] sm:min-h-0">
                    <i class="ph-duotone ph-lock text-xl sm:text-2xl text-rose-400"></i>
                    <span class="text-[10px] sm:text-sm font-medium text-white leading-tight">@lang('Lock')</span>
                </button>
                <button wire:click="openModuleModal(9, '{{ __('Unlock Domain') }}')" type="button" class="flex flex-col items-center gap-1.5 sm:gap-2 rounded-xl border border-white/10 bg-white/5 p-2.5 sm:p-4 text-center transition-all hover:bg-white/10 active:scale-[0.98] cursor-pointer min-h-[70px] sm:min-h-0">
                    <i class="ph-duotone ph-lock-open text-xl sm:text-2xl text-lime-400"></i>
                    <span class="text-[10px] sm:text-sm font-medium text-white leading-tight">@lang('Unlock')</span>
                </button>
                <button wire:click="openModuleModal(10, '{{ __('Check Transfer Status') }}')" type="button" class="flex flex-col items-center gap-1.5 sm:gap-2 rounded-xl border border-white/10 bg-white/5 p-2.5 sm:p-4 text-center transition-all hover:bg-white/10 active:scale-[0.98] cursor-pointer min-h-[70px] sm:min-h-0">
                    <i class="ph-duotone ph-activity text-xl sm:text-2xl text-cyan-400"></i>
                    <span class="text-[10px] sm:text-sm font-medium text-white leading-tight">@lang('Status')</span>
                </button>
            </div>
        </x-admin.card>
    @endif

    {{-- Domain Form --}}
    <form wire:submit="save">
        <x-admin.card class="mt-4 sm:mt-6" :title="__('Domain Information')" :subtitle="__('Update domain details and settings')">
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 sm:gap-6">
                {{-- Registration Date --}}
                <x-admin.input type="date" :label="__('Registration Date')" wire:model="reg_date" />

                {{-- Expiry Date --}}
                <x-admin.input type="date" :label="__('Expiry Date')" wire:model="expiry_date" />

                {{-- Next Due Date --}}
                <x-admin.input type="date" :label="__('Next Due Date')" wire:model="next_due_date" />

                {{-- Next Invoice Date --}}
                <x-admin.input type="date" :label="__('Next Invoice Date')" wire:model="next_invoice_date" />

                {{-- Domain Name --}}
                <x-admin.input :label="__('Domain')" wire:model="domainName" required />

                {{-- Registrar --}}
                <div>
                    <label class="mb-1.5 sm:mb-2 block text-xs sm:text-sm font-medium text-slate-300">@lang('Registrar')</label>
                    <select wire:model="domain_register_id" class="w-full rounded-xl border border-white/10 bg-white/5 px-3 sm:px-4 py-2.5 text-base sm:text-sm text-white focus:border-primary-500/50 focus:outline-none focus:ring-2 focus:ring-primary-500/20 cursor-pointer">
                        <option value="" class="bg-[#12121a]">@lang('Select Registrar')</option>
                        @foreach($this->registrars as $registrar)
                            <option value="{{ $registrar->id }}" class="bg-[#12121a]">{{ $registrar->name }}</option>
                        @endforeach
                    </select>
                </div>

                {{-- Status --}}
                <div>
                    <label class="mb-1.5 sm:mb-2 block text-xs sm:text-sm font-medium text-slate-300">@lang('Status')</label>
                    <select wire:model="status" class="w-full rounded-xl border border-white/10 bg-white/5 px-3 sm:px-4 py-2.5 text-base sm:text-sm text-white focus:border-primary-500/50 focus:outline-none focus:ring-2 focus:ring-primary-500/20 cursor-pointer">
                        @foreach($this->statusOptions as $value => $label)
                            <option value="{{ $value }}" class="bg-[#12121a]">{{ __($label) }}</option>
                        @endforeach
                    </select>
                </div>

                {{-- Registration Period --}}
                <div>
                    <label class="mb-1.5 sm:mb-2 block text-xs sm:text-sm font-medium text-slate-300">@lang('Registration Period')</label>
                    <div class="flex">
                        <input type="number" wire:model="reg_period" min="1" max="10" class="w-full rounded-l-xl border border-white/10 bg-white/5 px-3 sm:px-4 py-2.5 text-base sm:text-sm text-white focus:border-primary-500/50 focus:outline-none focus:ring-2 focus:ring-primary-500/20">
                        <span class="inline-flex items-center rounded-r-xl border border-l-0 border-white/10 bg-white/10 px-3 sm:px-4 text-xs sm:text-sm text-slate-400">@lang('Years')</span>
                    </div>
                </div>

                {{-- First Payment Amount --}}
                <div>
                    <label class="mb-1.5 sm:mb-2 block text-xs sm:text-sm font-medium text-slate-300">@lang('First Payment')</label>
                    <div class="flex">
                        <span class="inline-flex items-center rounded-l-xl border border-r-0 border-white/10 bg-white/10 px-3 sm:px-4 text-xs sm:text-sm text-slate-400">$</span>
                        <input type="number" step="0.01" wire:model="first_payment_amount" class="w-full rounded-r-xl border border-white/10 bg-white/5 px-3 sm:px-4 py-2.5 text-base sm:text-sm text-white focus:border-primary-500/50 focus:outline-none focus:ring-2 focus:ring-primary-500/20">
                    </div>
                </div>

                {{-- Recurring Amount --}}
                <div>
                    <label class="mb-1.5 sm:mb-2 block text-xs sm:text-sm font-medium text-slate-300">@lang('Recurring Amount')</label>
                    <div class="flex">
                        <span class="inline-flex items-center rounded-l-xl border border-r-0 border-white/10 bg-white/10 px-3 sm:px-4 text-xs sm:text-sm text-slate-400">$</span>
                        <input type="number" step="0.01" wire:model="recurring_amount" class="w-full rounded-r-xl border border-white/10 bg-white/5 px-3 sm:px-4 py-2.5 text-base sm:text-sm text-white focus:border-primary-500/50 focus:outline-none focus:ring-2 focus:ring-primary-500/20">
                    </div>
                </div>
            </div>

            {{-- Nameservers --}}
            <div class="mt-4 sm:mt-6 border-t border-white/5 pt-4 sm:pt-6">
                <h4 class="mb-3 sm:mb-4 text-xs sm:text-sm font-semibold text-white flex items-center gap-2">
                    <i class="ph-duotone ph-dns text-primary-400"></i>
                    @lang('Nameservers')
                </h4>
                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-3 sm:gap-4">
                    <x-admin.input :label="__('Nameserver 1')" wire:model="ns1" placeholder="ns1.example.com" />
                    <x-admin.input :label="__('Nameserver 2')" wire:model="ns2" placeholder="ns2.example.com" />
                    <x-admin.input :label="__('Nameserver 3')" wire:model="ns3" placeholder="ns3.example.com" />
                    <x-admin.input :label="__('Nameserver 4')" wire:model="ns4" placeholder="ns4.example.com" />
                </div>
            </div>

            {{-- ID Protection & Notes --}}
            <div class="mt-4 sm:mt-6 grid grid-cols-1 gap-4 sm:gap-6 border-t border-white/5 pt-4 sm:pt-6 lg:grid-cols-2">
                <div class="flex items-center justify-between rounded-xl bg-white/5 p-3 sm:p-4">
                    <div>
                        <p class="text-xs sm:text-sm font-medium text-white">@lang('ID Protection')</p>
                        <p class="text-[10px] sm:text-xs text-slate-500">@lang('WHOIS privacy protection for this domain')</p>
                    </div>
                    <x-admin.toggle wire:model.live="id_protection" />
                </div>

                <div>
                    <label class="mb-1.5 sm:mb-2 block text-xs sm:text-sm font-medium text-slate-300">@lang('Admin Notes')</label>
                    <textarea wire:model="admin_notes" rows="3" class="w-full rounded-xl border border-white/10 bg-white/5 px-3 sm:px-4 py-2.5 text-base sm:text-sm text-white placeholder-slate-500 focus:border-primary-500/50 focus:outline-none focus:ring-2 focus:ring-primary-500/20" placeholder="{{ __('Internal notes about this domain...') }}"></textarea>
                </div>
            </div>

            {{-- Submit Button --}}
            <div class="mt-4 sm:mt-6 flex justify-end">
                <x-admin.button type="submit" icon="ph-floppy-disk" class="w-full sm:w-auto">
                    @lang('Save Changes')
                </x-admin.button>
            </div>
        </x-admin.card>
    </form>

    {{-- Client Info Card --}}
    @if($domain->user)
        <x-admin.card class="mt-4 sm:mt-6" :title="__('Client Information')">
            <div class="flex items-center gap-3 sm:gap-4">
                <div class="flex h-10 w-10 sm:h-14 sm:w-14 shrink-0 items-center justify-center rounded-xl sm:rounded-2xl bg-gradient-to-br from-blue-500/20 to-cyan-500/20 text-blue-400">
                    <span class="text-base sm:text-xl font-bold">{{ strtoupper(substr($domain->user->firstname ?? 'U', 0, 1)) }}</span>
                </div>
                <div class="min-w-0">
                    <p class="text-sm sm:text-lg font-semibold text-white truncate">{{ $domain->user->fullname }}</p>
                    <p class="text-xs sm:text-sm text-slate-400 truncate">{{ $domain->user->email }}</p>
                    <a href="{{ route('admin.users.detail', $domain->user->username) }}" class="mt-1 inline-flex items-center gap-1 text-xs sm:text-sm text-primary-400 hover:underline">
                        <i class="ph-bold ph-arrow-right text-xs"></i>
                        @lang('View Client Profile')
                    </a>
                </div>
            </div>
        </x-admin.card>
    @endif

    {{-- Register Domain Modal --}}
    <x-admin.modal wire:model="showRegisterModal" :title="__('Register Domain')" maxWidth="lg">
        <form wire:submit="runRegisterCommand">
            <div class="space-y-3 sm:space-y-4">
                <div class="rounded-xl bg-white/5 p-3 sm:p-4">
                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-2 sm:gap-4 text-xs sm:text-sm">
                        <div>
                            <span class="text-slate-500">@lang('Registrar'):</span>
                            <span class="ml-1 sm:ml-2 text-white">{{ $domain->domainRegister?->name ?? __('N/A') }}</span>
                        </div>
                        <div>
                            <span class="text-slate-500">@lang('Domain'):</span>
                            <span class="ml-1 sm:ml-2 text-white">{{ $domain->domain }}</span>
                        </div>
                        <div>
                            <span class="text-slate-500">@lang('Period'):</span>
                            <span class="ml-1 sm:ml-2 text-white">{{ $reg_period }} @lang('Year(s)')</span>
                        </div>
                    </div>
                </div>

                <x-admin.input :label="__('Nameserver 1')" wire:model="register_ns1" required />
                <x-admin.input :label="__('Nameserver 2')" wire:model="register_ns2" required />
                <x-admin.input :label="__('Nameserver 3')" wire:model="register_ns3" />
                <x-admin.input :label="__('Nameserver 4')" wire:model="register_ns4" />

                <div class="flex items-center gap-2">
                    <input type="checkbox" wire:model="send_email" id="send_email" class="h-4 w-4 sm:h-5 sm:w-5 rounded border-white/20 bg-white/5 text-primary-500 focus:ring-primary-500/20">
                    <label for="send_email" class="text-xs sm:text-sm text-slate-300 cursor-pointer">@lang('Send confirmation email to client')</label>
                </div>
            </div>

            <div class="mt-4 sm:mt-6 flex flex-col-reverse sm:flex-row justify-end gap-2 sm:gap-3">
                <x-admin.button type="button" variant="secondary" wire:click="$set('showRegisterModal', false)" :disabled="$isProcessing" class="w-full sm:w-auto min-h-11 sm:min-h-0">@lang('Cancel')</x-admin.button>
                <x-admin.button type="submit" :disabled="$isProcessing" class="w-full sm:w-auto min-h-11 sm:min-h-0">
                    <span wire:loading.remove wire:target="runRegisterCommand">@lang('Register Domain')</span>
                    <span wire:loading wire:target="runRegisterCommand" class="flex items-center gap-2">
                        <svg class="h-4 w-4 animate-spin" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                        </svg>
                        @lang('Processing...')
                    </span>
                </x-admin.button>
            </div>
        </form>
    </x-admin.modal>

    {{-- Module Command Modal --}}
    <x-admin.modal wire:model="showModuleModal" :title="__('Confirm Command')">
        <form wire:submit="runModuleCommand">
            <div class="text-center py-3 sm:py-4">
                <div class="mx-auto mb-3 sm:mb-4 flex h-12 w-12 sm:h-16 sm:w-16 items-center justify-center rounded-xl sm:rounded-2xl bg-amber-500/10">
                    <i class="ph-duotone ph-warning text-2xl sm:text-3xl text-amber-400"></i>
                </div>
                <p class="text-sm sm:text-base text-white">
                    @lang('Are you sure you want to run the') <span class="font-semibold text-primary-400">{{ $moduleName }}</span> @lang('command?')
                </p>
                <p class="mt-1.5 sm:mt-2 text-xs sm:text-sm text-slate-500">
                    @lang('This will send a request to') <span class="font-medium text-white">{{ $domain->domainRegister?->name ?? __('the registrar') }}</span>.
                </p>
            </div>

            <div class="mt-4 sm:mt-6 flex flex-col-reverse sm:flex-row justify-center gap-2 sm:gap-3">
                <x-admin.button type="button" variant="secondary" wire:click="$set('showModuleModal', false)" :disabled="$isProcessing" class="w-full sm:w-auto min-h-11 sm:min-h-0">@lang('Cancel')</x-admin.button>
                <x-admin.button type="submit" :disabled="$isProcessing" class="w-full sm:w-auto min-h-11 sm:min-h-0">
                    <span wire:loading.remove wire:target="runModuleCommand">@lang('Yes, Execute')</span>
                    <span wire:loading wire:target="runModuleCommand" class="flex items-center gap-2">
                        <svg class="h-4 w-4 animate-spin" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                        </svg>
                        @lang('Processing...')
                    </span>
                </x-admin.button>
            </div>
        </form>
    </x-admin.modal>

    {{-- Contact Details Modal --}}
    <x-admin.modal wire:model="showContactModal" :title="__('Domain Contact Details')" maxWidth="4xl">
        <div x-data="{ tab: 'Registrant' }">
            {{-- Tabs Navigation --}}
            <div class="flex border-b border-white/10 mb-6">
                @foreach(['Registrant', 'Admin', 'Tech', 'AuxBilling'] as $type)
                    <button @click="tab = '{{ $type }}'"
                            type="button"
                            :class="tab === '{{ $type }}' ? 'border-b-2 border-primary-500 text-primary-400' : 'text-slate-400 hover:text-white'"
                            class="px-6 py-3 text-sm font-semibold transition-all">
                        {{ __($type) }}
                    </button>
                @endforeach
            </div>

            <form wire:submit="saveContactInfo">
                @foreach(['Registrant', 'Admin', 'Tech', 'AuxBilling'] as $type)
                    <div x-show="tab === '{{ $type }}'" class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                        <x-admin.input :label="__('First Name')" wire:model="contactData.{{ $type }}.{{ $type }}FirstName" required />
                        <x-admin.input :label="__('Last Name')" wire:model="contactData.{{ $type }}.{{ $type }}LastName" required />
                        <x-admin.input :label="__('Email Address')" type="email" wire:model="contactData.{{ $type }}.{{ $type }}EmailAddress" required />
                        <x-admin.input :label="__('Phone Number')" wire:model="contactData.{{ $type }}.{{ $type }}Phone" required />
                        <div class="sm:col-span-2">
                            <x-admin.input :label="__('Address 1')" wire:model="contactData.{{ $type }}.{{ $type }}Address1" required />
                        </div>
                        <x-admin.input :label="__('City')" wire:model="contactData.{{ $type }}.{{ $type }}City" required />
                        <x-admin.input :label="__('State / Province')" wire:model="contactData.{{ $type }}.{{ $type }}StateProvince" required />
                        <x-admin.input :label="__('Postal Code')" wire:model="contactData.{{ $type }}.{{ $type }}PostalCode" required />
                        <x-admin.input :label="__('Country Code')" wire:model="contactData.{{ $type }}.{{ $type }}Country" required placeholder="e.g. US" />
                    </div>
                @endforeach

                <div class="mt-8 flex flex-col-reverse sm:flex-row justify-end gap-3 border-t border-white/5 pt-6">
                    <x-admin.button type="button" variant="secondary" wire:click="$set('showContactModal', false)" :disabled="$isProcessing">@lang('Cancel')</x-admin.button>
                    <x-admin.button type="submit" :disabled="$isProcessing" icon="ph-floppy-disk">
                        <span wire:loading.remove wire:target="saveContactInfo">@lang('Update Contacts')</span>
                        <span wire:loading wire:target="saveContactInfo" class="flex items-center gap-2">
                            <svg class="h-4 w-4 animate-spin" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                            </svg>
                            @lang('Saving...')
                        </span>
                    </x-admin.button>
                </div>
            </form>
        </div>
    </x-admin.modal>

    {{-- Transfer Domain Modal --}}
    <x-admin.modal wire:model="showTransferModal" :title="__('Transfer Domain')" maxWidth="lg">
        <form wire:submit="runTransferCommand">
            <div class="space-y-3 sm:space-y-4">
                <div class="rounded-xl bg-white/5 p-3 sm:p-4">
                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-2 sm:gap-4 text-xs sm:text-sm">
                        <div>
                            <span class="text-slate-500">@lang('Registrar'):</span>
                            <span class="ml-1 sm:ml-2 text-white">{{ $domain->domainRegister?->name ?? __('N/A') }}</span>
                        </div>
                        <div>
                            <span class="text-slate-500">@lang('Domain'):</span>
                            <span class="ml-1 sm:ml-2 text-white">{{ $domain->domain }}</span>
                        </div>
                    </div>
                </div>

                <x-admin.input :label="__('EPP / Auth Code')" wire:model="eppCode" required placeholder="{{ __('Enter transfer authorization code') }}" />
                
                <div class="flex items-center gap-2">
                    <input type="checkbox" wire:model="send_email" id="transfer_send_email" class="h-4 w-4 sm:h-5 sm:w-5 rounded border-white/20 bg-white/5 text-primary-500 focus:ring-primary-500/20">
                    <label for="transfer_send_email" class="text-xs sm:text-sm text-slate-300 cursor-pointer">@lang('Send confirmation email to client')</label>
                </div>
            </div>

            <div class="mt-4 sm:mt-6 flex flex-col-reverse sm:flex-row justify-end gap-2 sm:gap-3">
                <x-admin.button type="button" variant="secondary" wire:click="$set('showTransferModal', false)" :disabled="$isProcessing" class="w-full sm:w-auto min-h-11 sm:min-h-0">@lang('Cancel')</x-admin.button>
                <x-admin.button type="submit" :disabled="$isProcessing" class="w-full sm:w-auto min-h-11 sm:min-h-0">
                    <span wire:loading.remove wire:target="runTransferCommand">@lang('Transfer Domain')</span>
                    <span wire:loading wire:target="runTransferCommand" class="flex items-center gap-2">
                        <svg class="h-4 w-4 animate-spin" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                        </svg>
                        @lang('Processing...')
                    </span>
                </x-admin.button>
            </div>
        </form>
    </x-admin.modal>
</div>

