<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Client Domains')" :subtitle="__('View and manage all client domain registrations.')" />

    {{-- Filters --}}
    <x-admin.card class="mt-4 sm:mt-6">
        <div class="flex flex-col gap-3 sm:gap-4 sm:flex-row sm:items-center sm:justify-between">
            {{-- Search --}}
            <div class="relative w-full sm:w-80">
                <i class="ph-duotone ph-magnifying-glass absolute left-3 top-1/2 -translate-y-1/2 text-slate-500"></i>
                <input
                    type="text"
                    wire:model.live.debounce.300ms="search"
                    placeholder="{{ __('Search domains...') }}"
                    class="w-full rounded-xl border border-white/10 bg-white/5 py-3 sm:py-2.5 pl-10 pr-10 text-base sm:text-sm text-white placeholder-slate-500 transition-all focus:border-primary-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-primary-500/20"
                />
                @if($search)
                    <button wire:click="$set('search', '')" class="absolute right-3 top-1/2 -translate-y-1/2 text-slate-500 transition-colors hover:text-white cursor-pointer p-1 min-h-11 min-w-11 flex items-center justify-center -mr-2">
                        <i class="ph-bold ph-x text-sm"></i>
                    </button>
                @endif
            </div>

            {{-- Status Filter --}}
            <select
                wire:model.live="status"
                class="w-full sm:w-auto rounded-xl border border-white/10 bg-white/5 px-4 py-3 sm:py-2.5 text-base sm:text-sm text-white focus:border-primary-500/50 focus:outline-none focus:ring-2 focus:ring-primary-500/20 cursor-pointer"
            >
                @foreach($this->statusOptions as $value => $label)
                    <option value="{{ $value }}" class="bg-[#12121a]">{{ __($label) }}</option>
                @endforeach
            </select>
        </div>
    </x-admin.card>

    {{-- Domains Table (Desktop) / Cards (Mobile) --}}
    <x-admin.card class="mt-4 sm:mt-6" :padding="false">
        {{-- Desktop Table View --}}
        <div class="hidden md:block overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-white/5 bg-white/5">
                        <th class="px-4 lg:px-6 py-3 text-left">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Client')</span>
                        </th>
                        <th class="px-4 lg:px-6 py-3 text-left">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Domain')</span>
                        </th>
                        <th class="px-4 lg:px-6 py-3 text-center hidden lg:table-cell">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Registrar')</span>
                        </th>
                        <th class="px-4 lg:px-6 py-3 text-center hidden xl:table-cell">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Reg. Date')</span>
                        </th>
                        <th class="px-4 lg:px-6 py-3 text-center hidden lg:table-cell">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Next Due')</span>
                        </th>
                        <th class="px-4 lg:px-6 py-3 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Status')</span>
                        </th>
                        <th class="px-4 lg:px-6 py-3 text-right">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Actions')</span>
                        </th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    @forelse($domains as $domain)
                        <tr class="group transition-all hover:bg-white/5" wire:key="domain-{{ $domain->id }}">
                            <td class="px-4 lg:px-6 py-3">
                                <div class="flex items-center gap-3">
                                    <div class="flex h-9 w-9 shrink-0 items-center justify-center rounded-xl bg-gradient-to-br from-blue-500/20 to-cyan-500/20 text-blue-400">
                                        <span class="text-sm font-bold">{{ strtoupper(substr($domain->user?->firstname ?? 'U', 0, 1)) }}</span>
                                    </div>
                                    <div class="min-w-0">
                                        <p class="font-medium text-white truncate">{{ $domain->user?->fullname ?? __('Unknown') }}</p>
                                        @if($domain->user)
                                            <a href="{{ route('admin.users.detail', $domain->user->username) }}" class="text-xs text-primary-400 hover:underline truncate block">
                                                {{ '@' . $domain->user->username }}
                                            </a>
                                        @endif
                                    </div>
                                </div>
                            </td>
                            <td class="px-4 lg:px-6 py-3">
                                <a href="http://{{ $domain->domain }}" target="_blank" class="font-medium text-white hover:text-primary-400 transition-colors text-sm truncate block max-w-[200px]">
                                    {{ $domain->domain }}
                                    <i class="ph-bold ph-arrow-square-out text-xs ml-1"></i>
                                </a>
                            </td>
                            <td class="px-4 lg:px-6 py-3 text-center hidden lg:table-cell">
                                <span class="text-sm text-slate-400">{{ $domain->domainRegister?->name ?? '—' }}</span>
                            </td>
                            <td class="px-4 lg:px-6 py-3 text-center hidden xl:table-cell">
                                <span class="text-sm text-slate-400">
                                    {{ $domain->reg_date ? \Carbon\Carbon::parse($domain->reg_date)->format('d M Y') : '—' }}
                                </span>
                            </td>
                            <td class="px-4 lg:px-6 py-3 text-center hidden lg:table-cell">
                                @if($domain->next_due_date)
                                    @php
                                        $dueDate = \Carbon\Carbon::parse($domain->next_due_date);
                                        $isOverdue = $dueDate->isPast();
                                        $isDueSoon = $dueDate->isBetween(now(), now()->addDays(30));
                                    @endphp
                                    <span class="text-sm {{ $isOverdue ? 'text-red-400' : ($isDueSoon ? 'text-amber-400' : 'text-slate-400') }}">
                                        {{ $dueDate->format('d M Y') }}
                                    </span>
                                @else
                                    <span class="text-sm text-slate-600">—</span>
                                @endif
                            </td>
                            <td class="px-4 lg:px-6 py-3 text-center">
                                @php
                                    $statusColors = [
                                        \App\Models\Domain::STATUS_ACTIVE => 'bg-emerald-500/10 text-emerald-400',
                                        \App\Models\Domain::STATUS_PENDING => 'bg-amber-500/10 text-amber-400',
                                        \App\Models\Domain::STATUS_SUSPENDED => 'bg-orange-500/10 text-orange-400',
                                        \App\Models\Domain::STATUS_TERMINATED => 'bg-red-500/10 text-red-400',
                                        \App\Models\Domain::STATUS_CANCELLED => 'bg-slate-500/10 text-slate-400',
                                    ];
                                @endphp
                                <span class="inline-flex items-center gap-1.5 rounded-full px-2.5 py-1 text-xs font-medium {{ $statusColors[$domain->status] ?? 'bg-slate-500/10 text-slate-400' }}">
                                    <span class="h-1.5 w-1.5 rounded-full bg-current"></span>
                                    {{ __($domain->status_label) }}
                                </span>
                            </td>
                            <td class="px-4 lg:px-6 py-3 text-right">
                                <a href="{{ route('admin.order.domain.details', $domain->id) }}" class="inline-flex items-center gap-1.5 rounded-lg bg-white/5 px-3 py-1.5 text-sm font-medium text-white transition-colors hover:bg-white/10 cursor-pointer">
                                    <i class="ph-duotone ph-eye text-sm"></i>
                                    <span class="hidden lg:inline">@lang('Details')</span>
                                </a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="px-6 py-12 text-center">
                                <div class="flex flex-col items-center">
                                    <div class="flex h-14 w-14 items-center justify-center rounded-2xl bg-white/5">
                                        <i class="ph-duotone ph-globe text-2xl text-slate-500"></i>
                                    </div>
                                    <h3 class="mt-3 text-base font-medium text-white">@lang('No domains found')</h3>
                                    <p class="mt-1 text-sm text-slate-500">
                                        @if($search || $status)
                                            @lang('No domains match your filters.')
                                        @else
                                            @lang('Client domains will appear here once registered.')
                                        @endif
                                    </p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        {{-- Mobile Card View --}}
        <div class="md:hidden divide-y divide-white/5">
            @forelse($domains as $domain)
                @php
                    $statusColors = [
                        \App\Models\Domain::STATUS_ACTIVE => 'bg-emerald-500/10 text-emerald-400',
                        \App\Models\Domain::STATUS_PENDING => 'bg-amber-500/10 text-amber-400',
                        \App\Models\Domain::STATUS_SUSPENDED => 'bg-orange-500/10 text-orange-400',
                        \App\Models\Domain::STATUS_TERMINATED => 'bg-red-500/10 text-red-400',
                        \App\Models\Domain::STATUS_CANCELLED => 'bg-slate-500/10 text-slate-400',
                    ];
                    $dueDate = $domain->next_due_date ? \Carbon\Carbon::parse($domain->next_due_date) : null;
                    $isOverdue = $dueDate && $dueDate->isPast();
                @endphp
                <a href="{{ route('admin.order.domain.details', $domain->id) }}" class="block p-4 active:bg-white/5" wire:key="domain-mobile-{{ $domain->id }}">
                    <div class="flex items-start justify-between gap-3">
                        <div class="flex items-center gap-3 min-w-0 flex-1">
                            <div class="flex h-10 w-10 shrink-0 items-center justify-center rounded-xl bg-gradient-to-br from-blue-500/20 to-cyan-500/20 text-blue-400">
                                <span class="text-sm font-bold">{{ strtoupper(substr($domain->user?->firstname ?? 'U', 0, 1)) }}</span>
                            </div>
                            <div class="min-w-0 flex-1">
                                <p class="font-medium text-white truncate">{{ $domain->domain }}</p>
                                <p class="text-xs text-slate-500 truncate">{{ $domain->user?->fullname ?? __('Unknown') }}</p>
                            </div>
                        </div>
                        <span class="inline-flex items-center gap-1 rounded-full px-2 py-0.5 text-xs font-medium shrink-0 {{ $statusColors[$domain->status] ?? 'bg-slate-500/10 text-slate-400' }}">
                            <span class="h-1 w-1 rounded-full bg-current"></span>
                            {{ __($domain->status_label) }}
                        </span>
                    </div>
                    <div class="mt-2 flex items-center justify-between text-xs">
                        <span class="text-slate-500">{{ $domain->domainRegister?->name ?? __('No registrar') }}</span>
                        @if($dueDate)
                            <span class="{{ $isOverdue ? 'text-red-400' : 'text-slate-400' }}">
                                @lang('Due'): {{ $dueDate->format('d M Y') }}
                            </span>
                        @endif
                    </div>
                </a>
            @empty
                <div class="px-4 py-12 text-center">
                    <div class="flex flex-col items-center">
                        <div class="flex h-14 w-14 items-center justify-center rounded-2xl bg-white/5">
                            <i class="ph-duotone ph-globe text-2xl text-slate-500"></i>
                        </div>
                        <h3 class="mt-3 text-base font-medium text-white">@lang('No domains found')</h3>
                        <p class="mt-1 text-sm text-slate-500">
                            @if($search || $status)
                                @lang('No domains match your filters.')
                            @else
                                @lang('Client domains will appear here once registered.')
                            @endif
                        </p>
                    </div>
                </div>
            @endforelse
        </div>

        {{-- Pagination --}}
        @if($domains->hasPages())
            <div class="border-t border-white/5 px-4 sm:px-6 py-3 sm:py-4">
                {{ $domains->links() }}
            </div>
        @endif
    </x-admin.card>
</div>

