<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Domain Registrars')" :subtitle="__('Configure domain registrar API integrations.')" />

    @if (session('success'))
        <x-admin.alert type="success" class="mt-6">{{ session('success') }}</x-admin.alert>
    @endif

    {{-- Registrars Table --}}
    <x-admin.card class="mt-6" :padding="false">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-white/5 bg-white/[0.02]">
                        <th class="px-6 py-4 text-left">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Service Provider')</span>
                        </th>
                        <th class="px-6 py-4 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Domains')</span>
                        </th>
                        <th class="px-6 py-4 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Test Mode')</span>
                        </th>
                        <th class="px-6 py-4 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Status')</span>
                        </th>
                        <th class="px-6 py-4 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Default')</span>
                        </th>
                        <th class="px-6 py-4 text-right">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Actions')</span>
                        </th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    @forelse($registrars as $registrar)
                        <tr class="group transition-all hover:bg-white/[0.02]" wire:key="registrar-{{ $registrar->id }}">
                            {{-- Provider --}}
                            <td class="px-6 py-4">
                                <div class="flex items-center gap-3">
                                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-violet-500/20 to-purple-500/20 text-violet-400">
                                        <i class="ph-duotone ph-plugs-connected text-lg"></i>
                                    </div>
                                    <div>
                                        <p class="font-semibold text-white">{{ $registrar->name }}</p>
                                        <p class="text-xs text-slate-500">{{ $registrar->alias }}</p>
                                    </div>
                                </div>
                            </td>

                            {{-- Domains Count --}}
                            <td class="px-6 py-4 text-center">
                                <span class="inline-flex items-center justify-center rounded-lg bg-white/5 px-3 py-1 text-sm font-medium text-white">
                                    {{ $registrar->domains_count }}
                                </span>
                            </td>

                            {{-- Test Mode --}}
                            <td class="px-6 py-4 text-center">
                                @if($registrar->test_mode)
                                    <span class="inline-flex items-center gap-1.5 rounded-full bg-amber-500/10 px-3 py-1 text-xs font-medium text-amber-400">
                                        <span class="h-1.5 w-1.5 rounded-full bg-amber-400"></span>
                                        @lang('Test Mode')
                                    </span>
                                @else
                                    <span class="inline-flex items-center gap-1.5 rounded-full bg-emerald-500/10 px-3 py-1 text-xs font-medium text-emerald-400">
                                        <span class="h-1.5 w-1.5 rounded-full bg-emerald-400"></span>
                                        @lang('Live')
                                    </span>
                                @endif
                            </td>

                            {{-- Status --}}
                            <td class="px-6 py-4 text-center">
                                <x-admin.toggle wire:click="toggleStatus({{ $registrar->id }})" :checked="$registrar->status" />
                            </td>

                            {{-- Default --}}
                            <td class="px-6 py-4 text-center">
                                @if($registrar->default)
                                    <span class="inline-flex items-center gap-1.5 rounded-full bg-primary-500/10 px-3 py-1 text-xs font-medium text-primary-400">
                                        <i class="ph-fill ph-star text-xs"></i>
                                        @lang('Default')
                                    </span>
                                @else
                                    <button wire:click="setDefault({{ $registrar->id }})" class="text-xs text-slate-500 hover:text-white transition-colors cursor-pointer">
                                        @lang('Set Default')
                                    </button>
                                @endif
                            </td>

                            {{-- Actions --}}
                            <td class="px-6 py-4 text-right">
                                <x-admin.button wire:click="openConfigModal({{ $registrar->id }})" size="sm" variant="secondary" icon="ph-gear">
                                    @lang('Configure')
                                </x-admin.button>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="px-6 py-16 text-center">
                                <div class="flex flex-col items-center">
                                    <div class="flex h-16 w-16 items-center justify-center rounded-2xl bg-white/5">
                                        <i class="ph-duotone ph-plugs-connected text-3xl text-slate-500"></i>
                                    </div>
                                    <h3 class="mt-4 text-lg font-medium text-white">@lang('No registrars found')</h3>
                                    <p class="mt-1 text-sm text-slate-500">@lang('Domain registrars will appear here once configured.')</p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        {{-- Pagination --}}
        @if($registrars->hasPages())
            <div class="border-t border-white/5 px-6 py-4">
                {{ $registrars->links() }}
            </div>
        @endif
    </x-admin.card>

    {{-- Configuration Modal --}}
    @php $modalTitle = __('Configure') . ' ' . $registrarName; @endphp
    <x-admin.modal wire:model="showConfigModal" :title="$modalTitle" maxWidth="2xl">
        <form wire:submit="saveConfig">
            <div class="space-y-6">
                {{-- API Configuration --}}
                @if(count($this->configFields) > 0)
                    <div class="space-y-4">
                        <h4 class="text-sm font-semibold text-white flex items-center gap-2">
                            <i class="ph-duotone ph-key text-primary-400"></i>
                            @lang('API Credentials')
                        </h4>
                        <div class="grid grid-cols-1 gap-4">
                            @foreach($this->configFields as $key => $config)
                                <x-admin.input
                                    :label="$config['title']"
                                    :type="$config['type']"
                                    wire:model="params.{{ $key }}"
                                    :placeholder="$config['title']"
                                />
                            @endforeach
                        </div>
                    </div>
                @endif

                {{-- Test Mode --}}
                <div class="flex items-center justify-between rounded-xl bg-white/5 p-4">
                    <div>
                        <p class="text-sm font-medium text-white">@lang('Test Mode')</p>
                        <p class="text-xs text-slate-500">@lang('Use sandbox/test API endpoints')</p>
                    </div>
                    <x-admin.toggle wire:model.live="test_mode" />
                </div>

                {{-- Nameservers --}}
                <div class="space-y-4">
                    <h4 class="text-sm font-semibold text-white flex items-center gap-2">
                        <i class="ph-duotone ph-dns text-primary-400"></i>
                        @lang('Default Nameservers')
                    </h4>
                    <div class="grid grid-cols-2 gap-4">
                        <x-admin.input :label="__('Nameserver 1')" wire:model="ns1" placeholder="ns1.example.com" required />
                        <x-admin.input :label="__('Nameserver 2')" wire:model="ns2" placeholder="ns2.example.com" required />
                        <x-admin.input :label="__('Nameserver 3')" wire:model="ns3" :placeholder="__('ns3.example.com (optional)')" />
                        <x-admin.input :label="__('Nameserver 4')" wire:model="ns4" :placeholder="__('ns4.example.com (optional)')" />
                    </div>
                </div>

                {{-- Default Registrar --}}
                <div class="flex items-center justify-between rounded-xl bg-white/5 p-4">
                    <div>
                        <p class="text-sm font-medium text-white">@lang('Default Registrar')</p>
                        <p class="text-xs text-slate-500">@lang('Use this registrar for new domain registrations')</p>
                    </div>
                    <x-admin.toggle wire:model.live="is_default" />
                </div>
            </div>

            <div class="mt-6 flex justify-end gap-3">
                <x-admin.button type="button" variant="secondary" wire:click="$set('showConfigModal', false)">@lang('Cancel')</x-admin.button>
                <x-admin.button type="submit">@lang('Save Configuration')</x-admin.button>
            </div>
        </form>
    </x-admin.modal>
</div>

