<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('TLD / Extensions')" :subtitle="__('Manage domain extensions and pricing.')">
        <x-slot:actions>
            <x-admin.button wire:click="openTldModal" icon="ph-plus">
                @lang('Add TLD')
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    @if (session('success'))
        <x-admin.alert type="success" class="mt-6">{{ session('success') }}</x-admin.alert>
    @endif
    @if (session('error'))
        <x-admin.alert type="danger" class="mt-6">{{ session('error') }}</x-admin.alert>
    @endif

    {{-- Search --}}
    <x-admin.card class="mt-6">
        <div class="relative w-full sm:w-80">
            <i class="ph-duotone ph-magnifying-glass absolute left-3 top-1/2 -translate-y-1/2 text-slate-500"></i>
            <input
                type="text"
                wire:model.live.debounce.300ms="search"
                placeholder="{{ __('Search extensions...') }}"
                class="w-full rounded-xl border border-white/10 bg-white/5 py-2.5 pl-10 pr-4 text-sm text-white placeholder-slate-500 transition-all focus:border-primary-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-primary-500/20"
            />
            @if($search)
                <button wire:click="$set('search', '')" class="absolute right-3 top-1/2 -translate-y-1/2 text-slate-500 transition-colors hover:text-white cursor-pointer">
                    <i class="ph-bold ph-x text-sm"></i>
                </button>
            @endif
        </div>
    </x-admin.card>

    {{-- TLDs Table --}}
    <x-admin.card class="mt-6" :padding="false">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-white/5 bg-white/[0.02]">
                        <th class="px-6 py-4 text-left">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Extension')</span>
                        </th>
                        <th class="px-6 py-4 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Category')</span>
                        </th>
                        <th class="px-6 py-4 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('1 Year Price')</span>
                        </th>
                        <th class="px-6 py-4 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Renewal')</span>
                        </th>
                        <th class="px-6 py-4 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('ID Protection')</span>
                        </th>
                        <th class="px-6 py-4 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Domains')</span>
                        </th>
                        <th class="px-6 py-4 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Status')</span>
                        </th>
                        <th class="px-6 py-4 text-right">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Actions')</span>
                        </th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    @forelse($tlds as $tld)
                        <tr class="group transition-all hover:bg-white/[0.02]" wire:key="tld-{{ $tld->id }}">
                            {{-- Extension --}}
                            <td class="px-6 py-4">
                                <div class="flex items-center gap-3">
                                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-blue-500/20 to-cyan-500/20 text-blue-400">
                                        <i class="ph-duotone ph-globe text-lg"></i>
                                    </div>
                                    <div>
                                        <p class="font-semibold text-white">{{ $tld->extension }}</p>
                                        @if($tld->id_protection)
                                            <span class="text-xs text-emerald-400">@lang('ID Protection Available')</span>
                                        @endif
                                    </div>
                                </div>
                            </td>

                            {{-- Category --}}
                            <td class="px-6 py-4 text-center">
                                @if($tld->category)
                                    <span class="inline-flex items-center gap-1.5 rounded-lg bg-indigo-500/10 px-2.5 py-1 text-xs font-medium text-indigo-400">
                                        <i class="{{ $tld->category->icon ?: 'ph-duotone ph-tag' }}"></i>
                                        {{ $tld->category->name }}
                                    </span>
                                @else
                                    <span class="text-xs text-slate-600">@lang('Uncategorized')</span>
                                @endif
                            </td>

                            {{-- 1 Year Price --}}
                            <td class="px-6 py-4 text-center">
                                <span class="font-medium text-white">${{ number_format($tld->pricing?->one_year_price ?? 0, 2) }}</span>
                            </td>

                            {{-- Renewal --}}
                            <td class="px-6 py-4 text-center">
                                <span class="text-slate-400">${{ number_format($tld->pricing?->one_year_renew ?? 0, 2) }}</span>
                            </td>

                            {{-- ID Protection --}}
                            <td class="px-6 py-4 text-center">
                                @if($tld->id_protection)
                                    <span class="text-slate-400">${{ number_format($tld->pricing?->one_year_id_protection ?? 0, 2) }}</span>
                                @else
                                    <span class="text-slate-600">—</span>
                                @endif
                            </td>

                            {{-- Domains Count --}}
                            <td class="px-6 py-4 text-center">
                                <span class="inline-flex items-center justify-center rounded-lg bg-white/5 px-3 py-1 text-sm font-medium text-white">
                                    {{ $tld->domains_count }}
                                </span>
                            </td>

                            {{-- Status --}}
                            <td class="px-6 py-4 text-center">
                                <x-admin.toggle wire:click="toggleStatus({{ $tld->id }})" :checked="$tld->status" />
                            </td>

                            {{-- Actions --}}
                            <td class="px-6 py-4 text-right">
                                <x-admin.action-menu>
                                    <x-admin.action-menu-item wire:click="openPricingModal({{ $tld->id }})" icon="ph-currency-dollar">
                                        @lang('Pricing')
                                    </x-admin.action-menu-item>
                                    <x-admin.action-menu-item wire:click="openTldModal({{ $tld->id }})" icon="ph-pencil">
                                        @lang('Edit TLD')
                                    </x-admin.action-menu-item>
                                    <x-admin.action-menu-item :divider="true" />
                                    <x-admin.action-menu-item wire:click="deleteTld({{ $tld->id }})" wire:confirm="{{ __('Are you sure you want to delete this TLD?') }}" icon="ph-trash" :danger="true">
                                        @lang('Delete TLD')
                                    </x-admin.action-menu-item>
                                </x-admin.action-menu>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="px-6 py-16 text-center">
                                <div class="flex flex-col items-center">
                                    <div class="flex h-16 w-16 items-center justify-center rounded-2xl bg-white/5">
                                        <i class="ph-duotone ph-globe text-3xl text-slate-500"></i>
                                    </div>
                                    <h3 class="mt-4 text-lg font-medium text-white">@lang('No TLDs found')</h3>
                                    <p class="mt-1 text-sm text-slate-500">
                                        @if($search)
                                            @lang('No TLDs match your search.')
                                        @else
                                            @lang('Get started by adding your first domain extension.')
                                        @endif
                                    </p>
                                    @if(!$search)
                                        <x-admin.button wire:click="openTldModal" icon="ph-plus" class="mt-4">
                                            @lang('Add TLD')
                                        </x-admin.button>
                                    @endif
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        {{-- Pagination --}}
        @if($tlds->hasPages())
            <div class="border-t border-white/5 px-6 py-4">
                {{ $tlds->links() }}
            </div>
        @endif
    </x-admin.card>

    {{-- Add/Edit TLD Modal --}}
    <x-admin.modal wire:model="showTldModal" :title="$editingTldId ? __('Edit TLD') : __('Add TLD')">
        <form wire:submit="saveTld">
            <div class="space-y-4">
                <x-admin.input
                    :label="__('Extension')"
                    wire:model="extension"
                    placeholder=".com"
                    required
                />
                
                <div class="space-y-1">
                    <label class="text-sm font-medium text-white">@lang('Category')</label>
                    <select wire:model="category_id" class="w-full rounded-xl border border-white/10 bg-white/5 py-2.5 px-4 text-sm text-white placeholder-slate-500 transition-all focus:border-primary-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-primary-500/20">
                        <option value="0" class="bg-[#1a1a24]">@lang('Select Category')</option>
                        @foreach($categories as $cat)
                            <option value="{{ $cat->id }}" class="bg-[#1a1a24]">{{ $cat->name }}</option>
                        @endforeach
                    </select>
                </div>

                <p class="text-xs text-slate-500 -mt-2">@lang('Enter the domain extension (e.g., .com, .net, .org)')</p>

                <div class="flex items-center justify-between rounded-xl bg-white/5 p-4">
                    <div>
                        <p class="text-sm font-medium text-white">@lang('ID Protection')</p>
                        <p class="text-xs text-slate-500">@lang('Enable WHOIS privacy protection')</p>
                    </div>
                    <x-admin.toggle wire:model.live="id_protection" />
                </div>

                <div class="flex items-center justify-between rounded-xl bg-white/5 p-4">
                    <div>
                        <p class="text-sm font-medium text-white">@lang('Active Status')</p>
                        <p class="text-xs text-slate-500">@lang('Show this TLD on frontend')</p>
                    </div>
                    <x-admin.toggle wire:model.live="tld_status" />
                </div>
            </div>
            <div class="mt-6 flex justify-end gap-3">
                <x-admin.button type="button" variant="secondary" wire:click="$set('showTldModal', false)">@lang('Cancel')</x-admin.button>
                <x-admin.button type="submit">{{ $editingTldId ? __('Update') : __('Add') }} @lang('TLD')</x-admin.button>
            </div>
        </form>
    </x-admin.modal>

    {{-- Pricing Modal --}}
    @php $pricingModalTitle = __('Pricing for') . ' ' . $pricingExtension; @endphp
    <x-admin.modal wire:model="showPricingModal" :title="$pricingModalTitle" maxWidth="4xl">
        <form wire:submit="savePricing">
            <div class="space-y-4">
                {{-- Pricing Table --}}
                <div class="overflow-x-auto rounded-xl border border-white/10">
                    <table class="w-full">
                        <thead>
                            <tr class="border-b border-white/5 bg-white/[0.02]">
                                <th class="px-4 py-3 text-left text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Period')</th>
                                <th class="px-4 py-3 text-center text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Registration')</th>
                                <th class="px-4 py-3 text-center text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Renewal')</th>
                                <th class="px-4 py-3 text-center text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('ID Protection')</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-white/5">
                            @foreach(['one_year' => __('1 Year'), 'two_year' => __('2 Years'), 'three_year' => __('3 Years'), 'four_year' => __('4 Years'), 'five_year' => __('5 Years'), 'six_year' => __('6 Years')] as $key => $label)
                                <tr class="hover:bg-white/[0.02]">
                                    <td class="px-4 py-3">
                                        <span class="font-medium text-white">{{ $label }}</span>
                                    </td>
                                    <td class="px-4 py-3">
                                        <input type="number" step="0.01" min="0"
                                            wire:model="pricing.{{ $key }}.price"
                                            class="w-full rounded-lg border border-white/10 bg-white/5 px-3 py-2 text-center text-sm text-white placeholder-slate-500 focus:border-primary-500 focus:outline-none focus:ring-1 focus:ring-primary-500"
                                            placeholder="0.00">
                                    </td>
                                    <td class="px-4 py-3">
                                        <input type="number" step="0.01" min="0"
                                            wire:model="pricing.{{ $key }}.renew"
                                            class="w-full rounded-lg border border-white/10 bg-white/5 px-3 py-2 text-center text-sm text-white placeholder-slate-500 focus:border-primary-500 focus:outline-none focus:ring-1 focus:ring-primary-500"
                                            placeholder="0.00">
                                    </td>
                                    <td class="px-4 py-3">
                                        <input type="number" step="0.01" min="0"
                                            wire:model="pricing.{{ $key }}.id_protection"
                                            class="w-full rounded-lg border border-white/10 bg-white/5 px-3 py-2 text-center text-sm text-white placeholder-slate-500 focus:border-primary-500 focus:outline-none focus:ring-1 focus:ring-primary-500"
                                            placeholder="0.00">
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <p class="text-xs text-slate-500">@lang('Set pricing to 0.00 to disable a specific registration period.')</p>
            </div>
            <div class="mt-6 flex justify-end gap-3">
                <x-admin.button type="button" variant="secondary" wire:click="$set('showPricingModal', false)">@lang('Cancel')</x-admin.button>
                <x-admin.button type="submit">@lang('Save Pricing')</x-admin.button>
            </div>
        </form>
    </x-admin.modal>
</div>

