<div>
    <x-admin.page-header :title="($id ? __('Edit') : __('Add')) . ' ' . ($section->name ?? __('Element'))" :subtitle="($id ? __('Update') : __('Create a new')) . ' ' . strtolower($section->name ?? __('element')) . ' ' . __('item') . '.'">
        <x-slot:actions>
            <x-admin.button href="{{ route('admin.frontend.sections', $key) }}" variant="secondary" icon="ph-arrow-left">
                @lang('Back')
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    <x-admin.card class="mt-6">
        <form wire:submit="save">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                @foreach($section->element as $field => $type)
                    @if(!in_array($field, ['modal', 'seo']))
                        @if($field === 'images')
                            @foreach($type as $imgKey => $imgConfig)
                                <div class="col-span-full lg:col-span-1">
                                    <label class="block text-sm font-medium text-slate-300 mb-2">{{ keyToTitle($imgKey) }}</label>
                                    <div class="relative">
                                        @php
                                            $existingImage = $element?->data_values?->{$imgKey} ?? null;
                                            $imageUrl = $existingImage ? asset(getFilePath('frontend') . '/' . $existingImage) : null;
                                        @endphp
                                        <div class="w-full aspect-video rounded-xl border-2 border-dashed border-white/10 bg-white/5 flex items-center justify-center overflow-hidden transition-all hover:border-indigo-500/30 hover:bg-white/10">
                                            @if(isset($images[$imgKey]) && $images[$imgKey])
                                                <img src="{{ $images[$imgKey]->temporaryUrl() }}" class="w-full h-full object-cover">
                                            @elseif($imageUrl)
                                                <img src="{{ $imageUrl }}" class="w-full h-full object-cover">
                                            @else
                                                <div class="text-center p-4">
                                                    <i class="ph-duotone ph-image text-4xl text-slate-500 mb-2"></i>
                                                    <p class="text-sm text-slate-400">{{ $imgConfig->size ?? __('Upload Image') }}</p>
                                                </div>
                                            @endif
                                        </div>
                                        <input type="file" wire:model="images.{{ $imgKey }}" accept="image/*" class="absolute inset-0 w-full h-full opacity-0 cursor-pointer">
                                    </div>
                                    @if($imgConfig->size ?? null)
                                        <p class="text-xs text-slate-500 mt-1">@lang('Recommended size:')</span> {{ $imgConfig->size }}</p>
                                    @endif
                                </div>
                            @endforeach
                        @elseif($type === 'textarea')
                            <div class="col-span-full">
                                <label class="block text-sm font-medium text-slate-300 mb-2">{{ keyToTitle($field) }}</label>
                                <textarea wire:model="form.{{ $field }}" rows="5" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"></textarea>
                            </div>
                        @elseif($type === 'textarea-nic')
                            <div class="col-span-full">
                                <label class="block text-sm font-medium text-slate-300 mb-2">{{ keyToTitle($field) }}</label>
                                <textarea wire:model="form.{{ $field }}" rows="10" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" placeholder="{{ __('HTML content supported...') }}"></textarea>
                                <p class="text-xs text-slate-500 mt-1">@lang('HTML formatting is supported.')</p>
                            </div>
                        @elseif($type === 'icon')
                            <div>
                                <label class="block text-sm font-medium text-slate-300 mb-2">{{ keyToTitle($field) }}</label>
                                <input type="text" wire:model="form.{{ $field }}" placeholder="{{ __('e.g., ph-house or las la-home') }}" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                                <p class="text-xs text-slate-500 mt-1">@lang('Enter icon class (Phosphor or FontAwesome)')</p>
                            </div>
                        @elseif($type === 'title')
                            <div>
                                <label class="block text-sm font-medium text-slate-300 mb-2">{{ keyToTitle($field) }}</label>
                                <input type="text" wire:model="form.{{ $field }}" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                                <p class="text-xs text-slate-500 mt-1">@lang('This will be used to generate the URL slug.')</p>
                            </div>
                        @else
                            <div>
                                <label class="block text-sm font-medium text-slate-300 mb-2">{{ keyToTitle($field) }}</label>
                                <input type="text" wire:model="form.{{ $field }}" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                            </div>
                        @endif
                    @endif
                @endforeach
            </div>

            <div class="mt-8 flex items-center gap-4">
                <x-admin.button type="submit" icon="ph-floppy-disk">
                    <span wire:loading.remove wire:target="save">{{ $id ? __('Update Element') : __('Create Element') }}</span>
                    <span wire:loading wire:target="save">
                        <i class="ph-bold ph-spinner animate-spin"></i>
                        @lang('Saving...')
                    </span>
                </x-admin.button>
                <x-admin.button href="{{ route('admin.frontend.sections', $key) }}" variant="secondary">
                    @lang('Cancel')
                </x-admin.button>
            </div>
        </form>
    </x-admin.card>
</div>

