<div>
    <x-admin.page-header :title="__('Frontend Manager')" :subtitle="__('Manage your website sections, pages, and themes from one place.')">
        <x-slot:actions>
            <x-admin.button href="{{ route('admin.frontend.create.section') }}" icon="ph-plus" variant="primary">
                @lang('Create New Section')
            </x-admin.button>
            <x-admin.button href="{{ route('admin.frontend.templates') }}" icon="ph-palette" variant="secondary">
                @lang('Manage Themes')
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    <x-admin.card class="mt-6">
        {{-- Search Header --}}
        <div class="flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between mb-6">
            <h3 class="text-lg font-semibold text-white">@lang('Content Management Options')</h3>
            <div class="relative w-full sm:w-80">
                <i class="ph-duotone ph-magnifying-glass absolute left-3 top-1/2 -translate-y-1/2 text-slate-500"></i>
                <input type="text" wire:model.live.debounce.300ms="search" placeholder="{{ __('Search sections...') }}"
                    class="w-full rounded-xl border border-white/10 bg-white/5 py-2.5 pl-10 pr-4 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
                @if($search)
                    <button wire:click="$set('search', '')"
                        class="absolute right-3 top-1/2 -translate-y-1/2 text-slate-500 transition-colors hover:text-white">
                        <i class="ph-bold ph-x text-sm"></i>
                    </button>
                @endif
            </div>
        </div>

        {{-- Sections Grid --}}
        @if($sections->count() > 0)
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-4">
                @foreach($sections as $key => $section)
                    <a href="{{ route('admin.frontend.sections', $key) }}"
                        class="group flex items-center justify-between gap-3 rounded-xl border border-white/10 bg-white/5 p-4 transition-all duration-200 hover:border-indigo-500/50 hover:bg-white/10">
                        <div class="flex items-center gap-3">
                            <div
                                class="flex h-10 w-10 items-center justify-center rounded-lg bg-indigo-500/10 transition-colors group-hover:bg-indigo-500/20">
                                <i class="ph-duotone ph-stack text-lg text-indigo-400"></i>
                            </div>
                            <div>
                                <h4 class="text-sm font-medium text-white transition-colors group-hover:text-indigo-400">
                                    {{ $section['name'] }}</h4>
                                <p class="text-xs text-slate-500">
                                    @if(isset($section['content']) && isset($section['element']))
                                        @lang('Content + Elements')
                                    @elseif(isset($section['content']))
                                        @lang('Content Only')
                                    @elseif(isset($section['element']))
                                        @lang('Elements Only')
                                    @else
                                        @lang('Section')
                                    @endif
                                </p>
                            </div>
                        </div>
                        <i class="ph-bold ph-caret-right text-slate-500 transition-colors group-hover:text-indigo-400"></i>
                    </a>
                @endforeach
            </div>
        @else
            <div class="py-12 text-center">
                <div class="mx-auto mb-4 flex h-16 w-16 items-center justify-center rounded-full bg-slate-800">
                    <i class="ph-duotone ph-magnifying-glass text-3xl text-slate-500"></i>
                </div>
                <h3 class="mb-2 text-lg font-medium text-white">@lang('No Sections Found')</h3>
                <p class="text-sm text-slate-400">
                    @if($search)
                        @lang('No sections match your search') "{{ $search }}".
                    @else
                        @lang('No frontend sections are configured for this template.')
                    @endif
                </p>
            </div>
        @endif
    </x-admin.card>
</div>