<div>
    <x-admin.page-header :title="__('Pages')" :subtitle="__('Manage website pages and their sections.')">
        <x-slot:actions>
            <x-admin.button wire:click="openAddModal" icon="ph-plus">
                @lang('Add New Page')
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    <x-admin.card class="mt-6">
        {{-- Search --}}
        <div class="flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between mb-6">
            <h3 class="text-lg font-semibold text-white">@lang('All Pages')</h3>
            <div class="relative w-full sm:w-80">
                <i class="ph-duotone ph-magnifying-glass absolute left-3 top-1/2 -translate-y-1/2 text-slate-500"></i>
                <input
                    type="text"
                    wire:model.live.debounce.300ms="search"
                    placeholder="{{ __('Search pages...') }}"
                    class="w-full rounded-xl border border-white/10 bg-white/5 py-2.5 pl-10 pr-4 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                />
                @if($search)
                    <button wire:click="$set('search', '')" class="absolute right-3 top-1/2 -translate-y-1/2 text-slate-500 transition-colors hover:text-white">
                        <i class="ph-bold ph-x text-sm"></i>
                    </button>
                @endif
            </div>
        </div>

        @if($pages->count() > 0)
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead>
                        <tr class="border-b border-white/10">
                            <th class="text-left text-xs font-medium text-slate-400 uppercase tracking-wider py-3 px-4">@lang('Name')</th>
                            <th class="text-left text-xs font-medium text-slate-400 uppercase tracking-wider py-3 px-4">@lang('Slug')</th>
                            <th class="text-left text-xs font-medium text-slate-400 uppercase tracking-wider py-3 px-4">@lang('Type')</th>
                            <th class="text-right text-xs font-medium text-slate-400 uppercase tracking-wider py-3 px-4">@lang('Actions')</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-white/5">
                        @foreach($pages as $page)
                            <tr class="hover:bg-white/5 transition-colors">
                                <td class="py-4 px-4">
                                    <div class="flex items-center gap-3">
                                        <div class="w-10 h-10 rounded-lg bg-primary-500/10 flex items-center justify-center">
                                            <i class="ph-duotone ph-file-text text-lg text-primary-400"></i>
                                        </div>
                                        <span class="text-sm font-medium text-white">{{ $page->name }}</span>
                                    </div>
                                </td>
                                <td class="py-4 px-4">
                                    <code class="text-sm text-slate-400 bg-white/5 px-2 py-1 rounded">/{{ $page->slug }}</code>
                                </td>
                                <td class="py-4 px-4">
                                    @if($page->is_default)
                                        <span class="inline-flex items-center gap-1 px-2 py-1 bg-blue-500/10 text-blue-400 text-xs font-medium rounded-full">
                                            <i class="ph-bold ph-house text-xs"></i>
                                            @lang('Default')
                                        </span>
                                    @elseif($page->auto_created)
                                        <span class="inline-flex items-center gap-1 px-2 py-1 bg-amber-500/10 text-amber-400 text-xs font-medium rounded-full">
                                            <i class="ph-bold ph-tag text-xs"></i>
                                            @lang('Category')
                                        </span>
                                    @else
                                        <span class="inline-flex items-center gap-1 px-2 py-1 bg-slate-500/10 text-slate-400 text-xs font-medium rounded-full">
                                            <i class="ph-bold ph-file text-xs"></i>
                                            @lang('Custom')
                                        </span>
                                    @endif
                                </td>
                                <td class="py-4 px-4">
                                    <div class="flex items-center justify-end gap-2">
                                        <a href="{{ route('admin.frontend.manage.section', $page->id) }}" class="p-2 text-slate-400 hover:text-primary-400 hover:bg-primary-500/10 rounded-lg transition-colors" title="{{ __('Manage Sections') }}">
                                            <i class="ph-bold ph-squares-four text-lg"></i>
                                        </a>
                                        <a href="{{ route('admin.frontend.manage.pages.seo', $page->id) }}" class="p-2 text-slate-400 hover:text-green-400 hover:bg-green-500/10 rounded-lg transition-colors" title="{{ __('SEO Settings') }}">
                                            <i class="ph-bold ph-magnifying-glass text-lg"></i>
                                        </a>
                                        @if(!$page->auto_created)
                                            <button type="button" wire:click="editPage({{ $page->id }})" class="p-2 text-slate-400 hover:text-blue-400 hover:bg-blue-500/10 rounded-lg transition-colors" title="{{ __('Edit') }}">
                                                <i class="ph-bold ph-pencil text-lg"></i>
                                            </button>
                                        @else
                                            <button type="button" disabled class="p-2 text-slate-600 cursor-not-allowed opacity-50 rounded-lg" title="{{ __('Category pages cannot be edited here') }}">
                                                <i class="ph-bold ph-lock text-lg"></i>
                                            </button>
                                        @endif
                                        @if(!$page->is_default && !$page->auto_created)
                                            <button type="button" wire:click="deletePage({{ $page->id }})" wire:confirm="{{ __('Are you sure you want to delete this page?') }}" class="p-2 text-slate-400 hover:text-red-400 hover:bg-red-500/10 rounded-lg transition-colors" title="{{ __('Delete') }}">
                                                <i class="ph-bold ph-trash text-lg"></i>
                                            </button>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @else
            <div class="py-12 text-center">
                <div class="w-16 h-16 mx-auto mb-4 rounded-full bg-slate-800 flex items-center justify-center">
                    <i class="ph-duotone ph-file-text text-3xl text-slate-500"></i>
                </div>
                <h3 class="text-lg font-medium text-white mb-2">@lang('No Pages Found')</h3>
                <p class="text-slate-400 text-sm mb-4">
                    @if($search)
                        @lang('No pages match your search.')
                    @else
                        @lang('Start by creating your first page.')
                    @endif
                </p>
            </div>
        @endif
    </x-admin.card>

    {{-- Add/Edit Modal --}}
    <x-admin.modal wire:model="showModal" :title="$editingId ? __('Edit Page') : __('Add New Page')" maxWidth="md">
        <form wire:submit="save" class="space-y-5">
            <div>
                <div class="flex items-center justify-between mb-2">
                    <label class="block text-sm font-medium text-slate-300">@lang('Page Name')</label>
                    <button type="button" wire:click="generateSlug" class="text-xs text-indigo-400 hover:text-indigo-300 transition-colors">
                        <i class="ph-bold ph-link text-xs"></i> @lang('Make Slug')
                    </button>
                </div>
                <input type="text" wire:model="name" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" placeholder="{{ __('Enter page name') }}" required>
            </div>
            <div>
                <div class="flex items-center justify-between mb-2">
                    <label class="block text-sm font-medium text-slate-300">@lang('Slug')</label>
                    @if($slug)
                        @if($slugAvailable)
                            <span class="text-xs text-emerald-400"><i class="ph-bold ph-check"></i> @lang('Available')</span>
                        @else
                            <span class="text-xs text-rose-400"><i class="ph-bold ph-x"></i> @lang('Already exists')</span>
                        @endif
                    @endif
                </div>
                <input type="text" wire:model.live.debounce.500ms="slug" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" placeholder="{{ __('page-slug') }}" required>
            </div>

            <div class="flex justify-end gap-3 pt-4 border-t border-white/5">
                <x-admin.button type="button" variant="secondary" wire:click="closeModal">
                    @lang('Cancel')
                </x-admin.button>
                <x-admin.button type="submit" :disabled="!$slugAvailable">
                    <span wire:loading.remove wire:target="save">
                        {{ $editingId ? __('Update Page') : __('Create Page') }}
                    </span>
                    <span wire:loading wire:target="save">
                        <i class="ph-bold ph-spinner animate-spin"></i>
                        @lang('Saving...')
                    </span>
                </x-admin.button>
            </div>
        </form>
    </x-admin.modal>
</div>

