<div>
    <x-admin.page-header :title="$page->name . ' ' . __('Page')" :subtitle="__('Manage sections for this page.')">
        <x-slot:actions>
            <x-admin.button href="{{ route('admin.frontend.manage.pages.seo', $page->id) }}" variant="secondary"
                icon="ph-magnifying-glass">
                @lang('SEO Settings')
            </x-admin.button>
            <x-admin.button href="{{ route('admin.frontend.manage.pages') }}" variant="secondary" icon="ph-arrow-left">
                @lang('Back to Pages')
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    {{-- Page Info Form (for non-default pages) --}}
    @if(!$page->is_default)
        <x-admin.card class="mt-6 mb-6">
            @if($page->auto_created)
                {{-- Auto-Created Page Warning --}}
                <div class="mb-4 p-4 bg-amber-500/10 border border-amber-500/30 rounded-xl flex items-start gap-3">
                    <i class="ph-bold ph-lock text-amber-400 text-xl mt-0.5"></i>
                    <div class="flex-1">
                        <h4 class="text-sm font-semibold text-amber-400 mb-1">@lang('Auto-Managed Page')</h4>
                        <p class="text-xs text-amber-300/80">
                            @lang('This page is automatically managed by the system and cannot be renamed or have its URL changed. You can only manage the sections below.')
                        </p>
                    </div>
                </div>
            @endif

            <form wire:submit="updatePageInfo">
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4 items-end">
                    <div>
                        <div class="flex items-center justify-between mb-2">
                            <label class="block text-sm font-medium text-slate-300">@lang('Page Name')</label>
                            @if(!$page->auto_created)
                                <button type="button" wire:click="generateSlug"
                                    class="text-xs text-indigo-400 hover:text-indigo-300 transition-colors">
                                    <i class="ph-bold ph-link text-xs"></i> @lang('Make Slug')
                                </button>
                            @endif
                        </div>
                        <input type="text" wire:model="name" {{ $page->auto_created ? 'disabled' : '' }}
                            class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20 disabled:opacity-50 disabled:cursor-not-allowed">
                    </div>
                    <div>
                        <div class="flex items-center justify-between mb-2">
                            <label class="block text-sm font-medium text-slate-300">@lang('Slug')</label>
                            @if($slug && !$page->auto_created)
                                @if($slugAvailable)
                                    <span class="text-xs text-emerald-400"><i class="ph-bold ph-check"></i>
                                        @lang('Available')</span>
                                @else
                                    <span class="text-xs text-rose-400"><i class="ph-bold ph-x"></i> @lang('Already exists')</span>
                                @endif
                            @endif
                        </div>
                        <input type="text" wire:model.live.debounce.500ms="slug" {{ $page->auto_created ? 'disabled' : '' }}
                            class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20 disabled:opacity-50 disabled:cursor-not-allowed">
                    </div>
                    <div>
                        <x-admin.button type="submit" :disabled="!$slugAvailable || $page->auto_created" class="w-full">
                            @lang('Update Info')
                        </x-admin.button>
                    </div>
                </div>
            </form>
        </x-admin.card>
    @endif

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6" x-data="pageSectionsManager(@entangle('pageSections'))">
        {{-- Page Sections (Left Side) --}}
        <div class="lg:col-span-2">
            <x-admin.card>
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-semibold text-white">@lang('Page Sections')</h3>
                    <span class="text-xs text-slate-400">@lang('Drag to reorder')</span>
                </div>

                {{-- Sortable List --}}
                {{-- Sortable List with Manual Controls --}}
                <div x-ref="sortableList" class="space-y-3 min-h-[200px]"
                    :class="{ 'border-2 border-dashed border-primary-500/50 rounded-lg p-4': sections.length === 0 }">
                    <template x-if="sections.length === 0">
                        <div class="flex items-center justify-center h-32 text-slate-400">
                            <div class="text-center">
                                <i class="ph-duotone ph-squares-four text-4xl mb-2"></i>
                                <p class="text-sm">@lang('Drag sections from the right panel')</p>
                            </div>
                        </div>
                    </template>
                    <template x-for="(section, index) in sections" :key="index">
                        <div class="group flex items-center gap-3 p-3 bg-white/5 border border-white/10 rounded-xl hover:bg-white/[0.07] transition-all hover:shadow-lg hover:border-white/20"
                            :data-index="index">
                            {{-- Drag Handle --}}
                            <div
                                class="cursor-move p-2 text-slate-500 hover:text-white transition-colors ph-dots-six-vertical">
                            </div>

                            {{-- Section Name --}}
                            <div class="flex-1">
                                <div class="flex items-center gap-2">
                                    <span class="block text-sm font-medium text-white"
                                        x-text="getSectionName(section)"></span>
                                    <template x-if="isMandatory(section)">
                                        <span class="px-2 py-0.5 bg-amber-500/20 border border-amber-500/30 rounded text-[10px] font-bold text-amber-400 flex items-center gap-1">
                                            <i class="ph-bold ph-lock text-xs"></i>
                                            @lang('Required')
                                        </span>
                                    </template>
                                </div>
                                <span class="text-[10px] text-slate-500 font-mono" x-text="section"></span>
                            </div>

                            {{-- Manual Reorder Controls --}}
                            <div class="flex items-center gap-1 bg-black/20 rounded-lg p-1">
                                <button type="button" @click="$wire.moveUp(index)"
                                    class="p-1.5 rounded-md text-slate-400 hover:text-white hover:bg-white/10 transition-colors disabled:opacity-30 disabled:cursor-not-allowed"
                                    :disabled="index === 0" title="@lang('Move Up')">
                                    <i class="ph-bold ph-caret-up"></i>
                                </button>
                                <button type="button" @click="$wire.moveDown(index)"
                                    class="p-1.5 rounded-md text-slate-400 hover:text-white hover:bg-white/10 transition-colors disabled:opacity-30 disabled:cursor-not-allowed"
                                    :disabled="index === sections.length - 1" title="@lang('Move Down')">
                                    <i class="ph-bold ph-caret-down"></i>
                                </button>
                            </div>

                            {{-- Actions --}}
                            <div class="flex items-center gap-2 pl-3 border-l border-white/10">
                                <a :href="'{{ route('admin.frontend.sections', '') }}/' + section" target="_blank"
                                    class="p-2 text-slate-400 hover:text-primary-400 hover:bg-primary-500/10 rounded-lg transition-colors"
                                    title="{{ __('Manage Content') }}">
                                    <i class="ph-bold ph-gear"></i>
                                </a>
                                <button type="button" @click="removeSection(index)"
                                    class="p-2 text-slate-400 hover:text-red-400 hover:bg-red-500/10 rounded-lg transition-colors disabled:opacity-30 disabled:cursor-not-allowed"
                                    :disabled="isMandatory(section)"
                                    :title="isMandatory(section) ? '{{ __('This section is required') }}' : '{{ __('Remove') }}'">
                                    <i class="ph-bold" :class="isMandatory(section) ? 'ph-lock' : 'ph-trash'"></i>
                                </button>
                            </div>
                        </div>
                    </template>
                </div>

                <div class="mt-6">
                    <x-admin.button wire:click="saveSections" icon="ph-floppy-disk" class="w-full">
                        <span wire:loading.remove wire:target="saveSections">@lang('Update Sections')</span>
                        <span wire:loading wire:target="saveSections">
                            <i class="ph-bold ph-spinner animate-spin"></i>
                            @lang('Saving...')
                        </span>
                    </x-admin.button>
                </div>
            </x-admin.card>
        </div>

        {{-- Available Sections (Right Side) --}}
        <div>
            <x-admin.card>
                <div class="mb-4">
                    <h3 class="text-lg font-semibold text-white">@lang('Available Sections')</h3>
                    <p class="text-xs text-slate-400 mt-1">@lang('Click to add to page')</p>
                </div>

                <div class="space-y-2 max-h-[500px] overflow-y-auto">
                    @foreach($availableSections as $key => $section)
                        <div class="flex items-center gap-3 p-3 bg-white/5 border border-white/10 rounded-lg hover:bg-white/10 transition-colors cursor-pointer"
                            @click="addSection('{{ $key }}')">
                            <i class="ph-bold ph-plus-circle text-primary-400"></i>
                            <span class="flex-1 text-sm text-white">{{ $section['name'] }}</span>
                            @if($section['builder'] ?? false)
                                <a href="{{ route('admin.frontend.sections', $key) }}" target="_blank"
                                    class="p-1 text-slate-400 hover:text-primary-400 transition-colors"
                                    title="{{ __('Manage Content') }}" @click.stop>
                                    <i class="ph-bold ph-gear text-sm"></i>
                                </a>
                            @endif
                        </div>
                    @endforeach
                </div>
            </x-admin.card>
        </div>
    </div>
</div>

@script
<script>
    Alpine.data('pageSectionsManager', (initialSections) => ({
        sections: initialSections,
        sectionNames: @json($allSections),

        init() {
            this.$watch('sections', (value) => {
                this.$wire.updateSectionOrder(value);
            });

            // Initialize Sortable
            if (typeof Sortable !== 'undefined') {
                new Sortable(this.$refs.sortableList, {
                    animation: 150,
                    handle: '.ph-dots-six-vertical',
                    ghostClass: 'opacity-50',
                    onEnd: (evt) => {
                        const newOrder = [...this.sections];
                        const [removed] = newOrder.splice(evt.oldIndex, 1);
                        newOrder.splice(evt.newIndex, 0, removed);
                        this.sections = newOrder;
                    }
                });
            }
        },

        getSectionName(key) {
            return this.sectionNames[key]?.name || key;
        },

        addSection(key) {
            this.sections.push(key);
            this.$wire.addSection(key);
        },

        removeSection(index) {
            this.sections.splice(index, 1);
            this.$wire.removeSection(index);
        },

        isMandatory(key) {
            const section = this.sectionNames[key];
            return section && (section.mandatory_for_categories === true);
        }
    }));
</script>
@endscript