<div>
    <x-admin.page-header :title="__('SEO Settings') . ' - ' . $page->name" :subtitle="__('Configure SEO settings for this page.')">
        <x-slot:actions>
            <x-admin.button href="{{ route('admin.frontend.manage.section', $page->id) }}" variant="secondary" icon="ph-arrow-left">
                @lang('Back to Page')
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    {{-- Info Banner --}}
    <x-admin.alert type="warning" class="mt-6 mb-6">
        @lang('The SEO setting is optional for this page. If you don\'t configure SEO here, the global SEO contents will work for this page, which you can configure from')
        <a href="{{ route('admin.seo') }}" class="text-amber-400 hover:text-amber-300 underline">@lang('Global SEO Settings')</a>.
    </x-admin.alert>

    <x-admin.card>
        <form wire:submit="save">
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                {{-- SEO Image --}}
                <div>
                    <label class="block text-sm font-medium text-slate-300 mb-2">@lang('SEO Image')</label>
                    <div class="relative">
                        @php
                            $existingImage = $page->seo_content->image ?? null;
                            $imageUrl = $existingImage ? asset(getFilePath('seo') . '/' . $existingImage) : null;
                        @endphp
                        <div class="w-full aspect-video rounded-xl border-2 border-dashed border-white/10 bg-white/5 flex items-center justify-center overflow-hidden transition-all hover:border-indigo-500/30 hover:bg-white/10">
                            @if($image)
                                <img src="{{ $image->temporaryUrl() }}" class="w-full h-full object-cover">
                            @elseif($imageUrl)
                                <img src="{{ $imageUrl }}" class="w-full h-full object-cover">
                            @else
                                <div class="text-center p-4">
                                    <i class="ph-duotone ph-image text-4xl text-slate-500 mb-2"></i>
                                    <p class="text-sm text-slate-400">1200x630 px</p>
                                </div>
                            @endif
                        </div>
                        <input type="file" wire:model="image" accept="image/*" class="absolute inset-0 w-full h-full opacity-0 cursor-pointer">
                    </div>
                    <p class="text-xs text-slate-500 mt-2">@lang('Recommended size: 1200x630 pixels for social sharing')</p>
                </div>

                {{-- SEO Fields --}}
                <div class="lg:col-span-2 space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-slate-300 mb-2">@lang('Meta Title') <span class="text-slate-500">(@lang('optional — overrides auto-generated title'))</span></label>
                        <input type="text" wire:model="metaTitle" placeholder="{{ __('Custom page title for search engines') }}" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-slate-300 mb-2">@lang('Meta Keywords')</label>
                        <input type="text" wire:model="keywords" placeholder="{{ __('keyword1, keyword2, keyword3') }}" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                        <p class="text-xs text-slate-500 mt-1">@lang('Separate multiple keywords with commas')</p>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-slate-300 mb-2">@lang('Meta Robots') <span class="text-slate-500">(@lang('optional'))</span></label>
                        <input type="text" wire:model="metaRobots" placeholder="{{ __('e.g. noindex, follow') }}" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-slate-300 mb-2">@lang('Meta Description')</label>
                        <textarea wire:model="description" rows="3" placeholder="{{ __('Brief description of this page for search engines...') }}" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"></textarea>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-slate-300 mb-2">@lang('Social Title')</label>
                        <input type="text" wire:model="socialTitle" placeholder="{{ __('Title for social media sharing') }}" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-slate-300 mb-2">@lang('Social Description')</label>
                        <textarea wire:model="socialDescription" rows="3" placeholder="{{ __('Description for social media sharing...') }}" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"></textarea>
                    </div>

                    <div class="pt-4">
                        <x-admin.button type="submit" icon="ph-floppy-disk" class="w-full">
                            <span wire:loading.remove wire:target="save">@lang('Save SEO Settings')</span>
                            <span wire:loading wire:target="save">
                                <i class="ph-bold ph-spinner animate-spin"></i>
                                @lang('Saving...')
                            </span>
                        </x-admin.button>
                    </div>
                </div>
            </div>
        </form>
    </x-admin.card>
</div>

