<div>
    <x-admin.page-header :title="__('Create New Section')" :subtitle="__('Define the structure and fields for a new website section.')">
        <x-slot:actions>
            <x-admin.button href="{{ route('admin.frontend.index') }}" variant="secondary" icon="ph-arrow-left">
                @lang('Back')
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    <div class="max-w-4xl mx-auto">
        <form wire:submit="createSection">
            <x-admin.card>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
                    <div>
                        <label class="block text-sm font-medium text-slate-300 mb-2">@lang('Section Name')</label>
                        <input type="text" wire:model="name" placeholder="e.g., Features Section"
                            class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                        @error('name') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                    </div>
                    <div>
                        <label
                            class="block text-sm font-medium text-slate-300 mb-2">@lang('Section Key (Unique ID)')</label>
                        <input type="text" wire:model="key" placeholder="e.g., features_section"
                            class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                        @error('key') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                        <p class="text-slate-500 text-[10px] mt-1 uppercase tracking-wider">
                            @lang('Alpha-dash only. Used as file name and JSON key.')
                        </p>
                    </div>
                </div>

                {{-- AI Generation Toggle --}}
                <div class="mb-8 p-4 rounded-xl bg-indigo-500/10 border border-indigo-500/20">
                    <div class="flex items-center justify-between">
                        <div>
                            <h3 class="text-indigo-400 font-semibold flex items-center gap-2">
                                <i class="ph-bold ph-sparkle"></i> @lang('AI Section Generation')
                            </h3>
                            <p class="text-xs text-indigo-300/80 mt-1">
                                @lang('Describe your section and let AI structure it for you.')</p>
                        </div>
                        <x-admin.button type="button" wire:click="toggleAiMode" size="sm"
                            variant="{{ $isAiMode ? 'primary' : 'secondary' }}">
                            {{ $isAiMode ? __('Disable AI') : __('Enable AI') }}
                        </x-admin.button>
                    </div>

                    @if($isAiMode)
                        <div class="mt-4 space-y-4">
                            <div>
                                <label
                                    class="block text-sm font-medium text-slate-300 mb-2">@lang('Describe the section')</label>
                                <textarea wire:model="aiPrompt" rows="3"
                                    placeholder="e.g., A pricing section with 3 cards, each having a title, price, and features list."
                                    class="w-full rounded-xl border border-white/10 bg-slate-900 px-4 py-3 text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"></textarea>
                                @error('aiPrompt') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                            </div>
                            <!-- Optional API Key Input for future real integration -->
                            <!-- 
                                <div>
                                    <label class="block text-sm font-medium text-slate-300 mb-2">@lang('OpenAI API Key (Optional)')</label>
                                    <input type="password" wire:model="aiApiKey" placeholder="sk-..."
                                        class="w-full rounded-xl border border-white/10 bg-slate-900 px-4 py-3 text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                                </div> 
                                -->
                            <div class="flex justify-end">
                                <x-admin.button type="button" wire:click="generateWithAi" icon="ph-magic-wand">
                                    <span wire:loading.remove
                                        wire:target="generateWithAi">@lang('Generate Configuration')</span>
                                    <span wire:loading wire:target="generateWithAi">
                                        <i class="ph-bold ph-spinner animate-spin"></i> @lang('Generating...')
                                    </span>
                                </x-admin.button>
                            </div>
                        </div>
                    @endif
                </div>

                <div class="space-y-4">
                    <div class="flex items-center justify-between border-b border-white/5 pb-4">
                        <h3 class="text-md font-semibold text-white">@lang('Section Fields')</h3>
                        <x-admin.button type="button" wire:click="addField" size="sm" variant="secondary"
                            icon="ph-plus">
                            @lang('Add Field')
                        </x-admin.button>
                    </div>

                    @foreach($fields as $index => $field)
                        <div
                            class="group relative grid grid-cols-1 md:grid-cols-3 gap-4 p-4 rounded-xl bg-white/5 border border-white/5 transition-all hover:bg-white/[0.07]">
                            <div>
                                <label
                                    class="block text-[10px] font-bold text-slate-500 uppercase mb-1">@lang('Field Label')</label>
                                <input type="text" wire:model="fields.{{ $index }}.label" placeholder="e.g., Main Heading"
                                    class="w-full rounded-lg border border-white/10 bg-white/5 px-3 py-2 text-sm text-white focus:outline-none focus:border-indigo-500/50">
                            </div>
                            <div>
                                <label
                                    class="block text-[10px] font-bold text-slate-500 uppercase mb-1">@lang('Unique Key')</label>
                                <input type="text" wire:model="fields.{{ $index }}.key" placeholder="e.g., heading"
                                    class="w-full rounded-lg border border-white/10 bg-white/5 px-3 py-2 text-sm text-white focus:outline-none focus:border-indigo-500/50">
                            </div>
                            <div class="flex items-end gap-3">
                                <div class="flex-1">
                                    <label
                                        class="block text-[10px] font-bold text-slate-500 uppercase mb-1">@lang('Type')</label>
                                    <select wire:model="fields.{{ $index }}.type"
                                        class="w-full rounded-lg border border-white/10 bg-white/5 px-3 py-2 text-sm text-white focus:outline-none focus:border-indigo-500/50">
                                        @foreach($fieldTypes as $typeKey => $typeName)
                                            <option value="{{ $typeKey }}">{{ $typeName }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <button type="button" wire:click="removeField({{ $index }})"
                                    class="p-2 text-red-400 hover:bg-red-500/10 rounded-lg transition-colors">
                                    <i class="ph-bold ph-trash"></i>
                                </button>
                            </div>
                        </div>
                    @endforeach
                    @error('fields.*') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                </div>

                <div class="mt-10 pt-6 border-t border-white/5 flex justify-end">
                    <x-admin.button type="submit" size="lg" icon="ph-rocket-launch">
                        @lang('Fire Away! Create Section')
                    </x-admin.button>
                </div>
            </x-admin.card>
        </form>
    </div>
</div>