<div>
    <x-admin.page-header :title="$section->name ?? __('Section')" :subtitle="__('Manage content and elements for this section.')">
        <x-slot:actions>
            @if(isset($section->element))
                @if($section->element->modal ?? true)
                    <x-admin.button wire:click="openAddElementModal" icon="ph-plus">
                        @lang('Add New Item')
                    </x-admin.button>
                @endif
            @endif
            <x-admin.button wire:click="openCloneModal" variant="outline" icon="ph-copy">
                @lang('Clone Section')
            </x-admin.button>
            <x-admin.button href="{{ route('admin.frontend.index') }}" variant="secondary" icon="ph-arrow-left">
                @lang('Back')
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    {{-- Advanced Code Toggle --}}
    <div class="mb-8 flex items-center justify-end">
        <button wire:click="toggleCodeView" 
            class="flex items-center gap-2 px-6 py-2.5 rounded-xl text-sm font-bold transition-all duration-300 {{ $viewCode ? 'bg-indigo-600 text-white shadow-lg shadow-indigo-500/25' : 'bg-slate-900/50 text-slate-400 hover:text-white hover:bg-white/5 border border-white/5' }}">
            <i class="ph-bold ph-code"></i>
            @lang('Advanced Code')
        </button>
    </div>

    @if($viewCode)
        <x-admin.card class="mb-6 border-indigo-500/30">
            <div class="flex items-center justify-between mb-6">
                <div class="flex flex-col">
                    <h3 class="text-lg font-semibold text-white">@lang('Advanced Code Lab')</h3>
                    <span class="text-[10px] text-slate-500 font-mono">resources/views/templates/{{ activeTemplateName() }}/sections/{{ $key }}.blade.php</span>
                </div>
                <div class="flex items-center gap-2">
                    <span class="px-3 py-1 rounded-full bg-red-500/10 text-red-400 text-[10px] font-bold uppercase tracking-widest border border-red-500/20">
                        <i class="ph-bold ph-warning-circle mr-1"></i>
                        @lang('Developer Only')
                    </span>
                </div>
            </div>
            <form wire:submit="saveBladeCode">
                <div class="relative group">
                    <textarea wire:model="bladeCode" rows="24"
                        class="w-full rounded-2xl border border-white/5 bg-slate-950/80 px-6 py-6 text-sm text-indigo-300 font-mono transition-all focus:border-indigo-500/50 focus:outline-none focus:ring-4 focus:ring-indigo-500/5"
                        spellcheck="false"></textarea>
                    <div class="absolute bottom-4 right-4 flex items-center gap-2">
                         <span class="text-[10px] font-bold text-slate-600 uppercase tracking-widest">@lang('PHP / Blade / HTML')</span>
                    </div>
                </div>
                <div class="mt-6 flex justify-end">
                    <x-admin.button type="submit" icon="ph-floppy-disk">
                        @lang('Overwrite Template')
                    </x-admin.button>
                </div>
            </form>
        </x-admin.card>
    @endif



    {{-- Fields Section (Standard Editor) --}}
    

    {{-- Content Section --}}
    @if(isset($section->content))
        <x-admin.card class="mb-6">
            <h3 class="text-lg font-semibold text-white mb-6">@lang('Section Content')</h3>
            <form wire:submit="saveContent">
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                    @php $imgCount = 0; @endphp
                    @foreach($section->content as $field => $type)
                        @if($field === 'images')
                            @php $imgCount = count((array) $type); @endphp
                            @foreach($type as $imgKey => $imgConfig)
                                        <div class="@if($imgCount > 1) col-span-1 @else col-span-full @endif">
                                            <label class="block text-sm font-medium text-slate-300 mb-2">{{ keyToTitle($imgKey) }}</label>
                                            <div class="relative">
                                                @php
                                                    $existingImage = $content?->data_values?->{$imgKey} ?? null;
                                                    $imageUrl = $existingImage ? asset(getFilePath('frontend') . '/' . $existingImage) : null;
                                                @endphp
                                <div
                                                    class="w-full aspect-video bg-slate-800 rounded-lg border-2 border-dashed border-white/10 flex items-center justify-center overflow-hidden">
                                                    @if(isset($contentImages[$imgKey]) && $contentImages[$imgKey])
                                                        <img src="{{ $contentImages[$imgKey]->temporaryUrl() }}" class="w-full h-full object-cover">
                                                    @elseif($imageUrl)
                                                        <img src="{{ $imageUrl }}" class="w-full h-full object-cover">
                                                    @else
                                                        <div class="text-center p-4">
                                                            <i class="ph-duotone ph-image text-4xl text-slate-500 mb-2"></i>
                                                            <p class="text-sm text-slate-400">{{ $imgConfig->size ?? __('Upload Image') }}</p>
                                                        </div>
                                                    @endif
                                                </div>
                                                <input type="file" wire:model="contentImages.{{ $imgKey }}" accept="image/*"
                                                    class="absolute inset-0 w-full h-full opacity-0 cursor-pointer">
                                            </div>
                                        </div>
                            @endforeach
                        @elseif($type === 'textarea' || $type === 'textarea-nic')
                            <div class="col-span-full">
                                <label class="block text-sm font-medium text-slate-300 mb-2">{{ keyToTitle($field) }}</label>
                                <textarea wire:model="contentForm.{{ $field }}" rows="5"
                                    class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"></textarea>
                            </div>
                        @elseif($type === 'icon')
                            <div>
                                <label class="block text-sm font-medium text-slate-300 mb-2">{{ keyToTitle($field) }}</label>
                                <input type="text" wire:model="contentForm.{{ $field }}" placeholder="{{ __('e.g., ph-house') }}"
                                    class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                            </div>
                        @else
                            <div>
                                <label class="block text-sm font-medium text-slate-300 mb-2">{{ keyToTitle($field) }}</label>
                                <input type="text" wire:model="contentForm.{{ $field }}"
                                    class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                            </div>
                        @endif
                    @endforeach
                </div>
                <div class="mt-6">
                    <x-admin.button type="submit" icon="ph-floppy-disk">
                        <span wire:loading.remove wire:target="saveContent">@lang('Save Content')</span>
                        <span wire:loading wire:target="saveContent">
                            <i class="ph-bold ph-spinner animate-spin"></i>
                            @lang('Saving...')
                        </span>
                    </x-admin.button>
                </div>
            </form>
        </x-admin.card>
    @endif

    {{-- CRUD Schema Manager --}}
    @if(isset($section->crud) && $section->crud === true)
        <x-admin.card class="mb-6 border-purple-500/20">
            <div class="flex items-center justify-between mb-8">
                <div class="flex flex-col">
                    <h3 class="text-lg font-semibold text-white">@lang('CRUD Schema Manager')</h3>
                    <p class="text-slate-500 text-sm">@lang('Define the input fields for this section\'s repeatable items.')</p>
                </div>
            </div>

            <div class="space-y-6">
                {{-- Current CRUD Inputs --}}
                @if(isset($section->element) && count((array)$section->element) > 0)
                    <div class="bg-white/[0.02] rounded-2xl border border-white/10 p-6">
                        <h4 class="text-xs font-black uppercase tracking-[0.2em] text-slate-400 mb-6">
                            @lang('Current CRUD Inputs')
                        </h4>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            @foreach($section->element as $inputKey => $inputType)
                                @if($inputKey !== 'modal' && $inputKey !== 'seo' && $inputKey !== 'images')
                                    <div class="flex items-center justify-between p-4 bg-white/[0.02] border border-white/5 rounded-xl hover:border-white/10 transition-colors">
                                        <div class="flex items-center gap-3">
                                            @if($inputType === 'textarea' || $inputType === 'textarea-nic')
                                                <span class="px-2 py-0.5 rounded bg-amber-500/10 text-amber-500 text-[8px] font-black uppercase tracking-tighter">@lang('Textarea')</span>
                                            @elseif($inputType === 'icon')
                                                <span class="px-2 py-0.5 rounded bg-purple-500/10 text-purple-500 text-[8px] font-black uppercase tracking-tighter">@lang('Icon')</span>
                                            @elseif($inputType === 'image')
                                                <span class="px-2 py-0.5 rounded bg-green-500/10 text-green-500 text-[8px] font-black uppercase tracking-tighter">@lang('Image')</span>
                                            @else
                                                <span class="px-2 py-0.5 rounded bg-blue-500/10 text-blue-500 text-[8px] font-black uppercase tracking-tighter">@lang('Text')</span>
                                            @endif
                                            <span class="text-white text-sm font-medium">{{ keyToTitle($inputKey) }}</span>
                                            <span class="text-[10px] font-mono text-slate-600">{{ $inputKey }}</span>
                                        </div>
                                        <button wire:click="removeCrudInput('{{ $inputKey }}')" 
                                            wire:confirm="{{ __('Are you sure you want to remove this input?') }}"
                                            class="p-2 text-slate-400 hover:text-red-400 hover:bg-red-500/10 rounded-lg transition-colors">
                                            <i class="ph-bold ph-trash text-lg"></i>
                                        </button>
                                    </div>
                                @endif
                            @endforeach
                        </div>
                    </div>
                @endif

                {{-- Add New CRUD Input --}}
                <div class="bg-purple-600/5 rounded-2xl border border-purple-500/10 p-6">
                    <h4 class="text-xs font-black uppercase tracking-[0.2em] text-purple-400 mb-6 flex items-center gap-2">
                        <i class="ph-bold ph-plus-circle"></i>
                        @lang('Add New CRUD Input')
                    </h4>
                    <form wire:submit="addCrudInput" class="grid grid-cols-1 md:grid-cols-3 gap-4">
                        <div>
                            <label class="block text-[10px] font-bold text-slate-500 uppercase mb-1">@lang('Input Key')</label>
                            <input type="text" wire:model="newCrudInputKey" placeholder="e.g. question"
                                class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2 text-sm text-white focus:border-purple-500/50 focus:ring-0">
                        </div>
                        <div>
                            <label class="block text-[10px] font-bold text-slate-500 uppercase mb-1">@lang('Input Type')</label>
                            <select wire:model="newCrudInputType"
                                class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2 text-sm text-white focus:border-purple-500/50 focus:ring-0">
                                <option value="text">@lang('Text')</option>
                                <option value="textarea">@lang('Textarea')</option>
                                <option value="icon">@lang('Icon')</option>
                                <option value="image">@lang('Image')</option>
                            </select>
                        </div>
                        <div class="flex items-end">
                            <button type="submit" 
                                class="w-full flex items-center justify-center gap-2 px-4 py-2.5 bg-purple-600 hover:bg-purple-500 text-white rounded-xl text-xs font-bold transition-all">
                                <i class="ph-bold ph-plus"></i>
                                @lang('Add Input')
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </x-admin.card>
    @endif

    {{-- Elements Section --}}

    @if(isset($section->element))
        <x-admin.card>
            <div class="flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between mb-6">
                <h3 class="text-lg font-semibold text-white">{{ $section->name }} @lang('Items')</h3>
                <div class="relative w-full sm:w-64">
                    <i class="ph-duotone ph-magnifying-glass absolute left-3 top-1/2 -translate-y-1/2 text-slate-500"></i>
                    <input type="text" wire:model.live.debounce.300ms="search" placeholder="{{ __('Search...') }}"
                        class="w-full rounded-xl border border-white/10 bg-white/5 py-2.5 pl-10 pr-4 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" />
                    @if($search)
                        <button wire:click="$set('search', '')"
                            class="absolute right-3 top-1/2 -translate-y-1/2 text-slate-500 transition-colors hover:text-white">
                            <i class="ph-bold ph-x text-sm"></i>
                        </button>
                    @endif
                </div>
            </div>

            @if($elements->count() > 0)
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead>
                            <tr class="border-b border-white/10">
                                <th class="text-left text-xs font-medium text-slate-400 uppercase tracking-wider py-3 px-4">#
                                </th>
                                @if(isset($section->element->images))
                                    <th class="text-left text-xs font-medium text-slate-400 uppercase tracking-wider py-3 px-4">
                                        @lang('Image')</th>
                                @endif
                                @foreach($section->element as $field => $type)
                                    @if(!in_array($field, ['modal', 'seo', 'images']))
                                        @if($type === 'text' || $type === 'icon' || $type === 'title')
                                            <th class="text-left text-xs font-medium text-slate-400 uppercase tracking-wider py-3 px-4">
                                                {{ keyToTitle($field) }}</th>
                                        @endif
                                    @endif
                                @endforeach
                                <th class="text-right text-xs font-medium text-slate-400 uppercase tracking-wider py-3 px-4">
                                    @lang('Actions')</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-white/5">
                            @foreach($elements as $element)
                                <tr class="hover:bg-white/5 transition-colors">
                                    <td class="py-4 px-4 text-sm text-slate-300">{{ $loop->iteration }}</td>
                                    @if(isset($section->element->images))
                                        @php $firstImgKey = array_key_first((array) $section->element->images); @endphp
                                        <td class="py-4 px-4">
                                            <div class="w-12 h-12 rounded-lg overflow-hidden bg-slate-800">
                                                @if(isset($element->data_values->{$firstImgKey}))
                                                    <img src="{{ asset(getFilePath('frontend') . '/' . $element->data_values->{$firstImgKey}) }}"
                                                        class="w-full h-full object-cover">
                                                @else
                                                    <div class="w-full h-full flex items-center justify-center">
                                                        <i class="ph-duotone ph-image text-slate-500"></i>
                                                    </div>
                                                @endif
                                            </div>
                                        </td>
                                    @endif
                                    @foreach($section->element as $field => $type)
                                        @if(!in_array($field, ['modal', 'seo', 'images']))
                                            @if($type === 'text' || $type === 'title')
                                                <td class="py-4 px-4 text-sm text-white">
                                                    {{ Str::limit($element->data_values->{$field} ?? '', 50) }}</td>
                                            @elseif($type === 'icon')
                                                <td class="py-4 px-4 text-sm text-white">{!! $element->data_values->{$field} ?? '' !!}</td>
                                            @endif
                                        @endif
                                    @endforeach
                                    <td class="py-4 px-4">
                                        <div class="flex items-center justify-end gap-2">
                                            @if($section->element->seo ?? false)
                                                <a href="{{ route('admin.frontend.sections.element.seo', [$key, $element->id]) }}"
                                                    class="p-2 text-slate-400 hover:text-blue-400 hover:bg-blue-500/10 rounded-lg transition-colors"
                                                    title="{{ __('SEO Settings') }}">
                                                    <i class="ph-bold ph-gear text-lg"></i>
                                                </a>
                                            @endif
                                            @if($section->element->modal ?? true)
                                                <button type="button" wire:click="openEditElementModal({{ $element->id }})"
                                                    class="p-2 text-slate-400 hover:text-primary-400 hover:bg-primary-500/10 rounded-lg transition-colors"
                                                    title="{{ __('Edit') }}">
                                                    <i class="ph-bold ph-pencil text-lg"></i>
                                                </button>
                                            @else
                                                <a href="{{ route('admin.frontend.sections.element', [$key, $element->id]) }}"
                                                    class="p-2 text-slate-400 hover:text-primary-400 hover:bg-primary-500/10 rounded-lg transition-colors"
                                                    title="{{ __('Edit') }}">
                                                    <i class="ph-bold ph-pencil text-lg"></i>
                                                </a>
                                            @endif
                                            <button type="button" wire:click="deleteElement({{ $element->id }})"
                                                wire:confirm="{{ __('Are you sure you want to remove this item?') }}"
                                                class="p-2 text-slate-400 hover:text-red-400 hover:bg-red-500/10 rounded-lg transition-colors"
                                                title="{{ __('Delete') }}">
                                                <i class="ph-bold ph-trash text-lg"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="py-12 text-center">
                    <div class="w-16 h-16 mx-auto mb-4 rounded-full bg-slate-800 flex items-center justify-center">
                        <i class="ph-duotone ph-stack text-3xl text-slate-500"></i>
                    </div>
                    <h3 class="text-lg font-medium text-white mb-2">@lang('No Items Found')</h3>
                    <p class="text-slate-400 text-sm mb-4">
                        @if($search)
                            @lang('No items match your search.')
                        @else
                            @lang('Start by adding your first item.')
                        @endif
                    </p>
                </div>
            @endif
        </x-admin.card>
    @endif

    {{-- Element Modal --}}
    @if(isset($section->element) && ($section->element->modal ?? true))
        <x-admin.modal wire:model="showElementModal" :title="($editingElementId ? __('Update') : __('Add New')) . ' ' . keyToTitle($key) . ' ' . __('Item')" maxWidth="lg">
            <form wire:submit="saveElement" class="space-y-5 max-h-[60vh] overflow-y-auto">
                @foreach($section->element as $field => $type)
                    @if(!in_array($field, ['modal', 'seo']))
                        @if($field === 'images')
                            @foreach($type as $imgKey => $imgConfig)
                                <div>
                                    <label class="block text-sm font-medium text-slate-300 mb-2">{{ keyToTitle($imgKey) }}</label>
                                    <div
                                        class="relative w-full aspect-video rounded-xl border-2 border-dashed border-white/10 bg-white/5 flex items-center justify-center overflow-hidden transition-all hover:border-indigo-500/30 hover:bg-white/10">
                                        @if(isset($elementImages[$imgKey]) && $elementImages[$imgKey])
                                            <img src="{{ $elementImages[$imgKey]->temporaryUrl() }}" class="w-full h-full object-cover">
                                        @else
                                            <div class="text-center p-4">
                                                <i class="ph-duotone ph-image text-4xl text-slate-500 mb-2"></i>
                                                <p class="text-sm text-slate-400">{{ $imgConfig->size ?? __('Upload Image') }}</p>
                                            </div>
                                        @endif
                                        <input type="file" wire:model="elementImages.{{ $imgKey }}" accept="image/*"
                                            class="absolute inset-0 w-full h-full opacity-0 cursor-pointer">
                                    </div>
                                    @error("elementImages.$imgKey") <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                                </div>
                            @endforeach
                        @elseif($type === 'textarea' || $type === 'textarea-nic')
                            <div>
                                <label class="block text-sm font-medium text-slate-300 mb-2">{{ keyToTitle($field) }}</label>
                                <textarea wire:model="elementForm.{{ $field }}" rows="4"
                                    class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"></textarea>
                                @error("elementForm.$field") <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                            </div>
                        @elseif($type === 'icon')
                            <div>
                                <label class="block text-sm font-medium text-slate-300 mb-2">{{ keyToTitle($field) }}</label>
                                <input type="text" wire:model="elementForm.{{ $field }}" placeholder="{{ __('e.g., ph-house') }}"
                                    class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                                @error("elementForm.$field") <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                            </div>
                        @elseif($type === 'select-pages')
                            <div>
                                <label class="block text-sm font-medium text-slate-300 mb-2">{{ keyToTitle($field) }}</label>
                                <div class="grid grid-cols-1 gap-2 p-4 rounded-xl border border-white/10 bg-white/5 max-h-48 overflow-y-auto">
                                    <label class="flex items-center gap-3 p-2 rounded-lg hover:bg-white/5 transition-colors cursor-pointer group">
                                        <input type="checkbox" wire:model="elementForm.{{ $field }}" value="all" class="w-4 h-4 rounded border-white/10 bg-slate-800 text-indigo-600 focus:ring-indigo-500">
                                        <div class="flex flex-col">
                                            <span class="text-sm font-bold text-white group-hover:text-indigo-400 transition-colors">@lang('All Pages')</span>
                                            <span class="text-[10px] text-slate-500 uppercase tracking-widest">@lang('Global FAQ')</span>
                                        </div>
                                    </label>
                                    <div class="h-px bg-white/5 my-1"></div>
                                    @foreach($this->getAvailablePages() as $p)
                                        <label class="flex items-center gap-3 p-2 rounded-lg hover:bg-white/5 transition-colors cursor-pointer group">
                                            <input type="checkbox" wire:model="elementForm.{{ $field }}" value="{{ $p['slug'] }}" class="w-4 h-4 rounded border-white/10 bg-slate-800 text-indigo-600 focus:ring-indigo-500">
                                            <div class="flex flex-col">
                                                <span class="text-sm font-medium text-slate-300 group-hover:text-white transition-colors">{{ $p['name'] }}</span>
                                                <span class="text-[10px] text-slate-500 font-mono">{{ $p['slug'] }}</span>
                                            </div>
                                        </label>
                                    @endforeach
                                </div>
                                @error("elementForm.$field") <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                            </div>
                        @else
                            <div>
                                <label class="block text-sm font-medium text-slate-300 mb-2">{{ keyToTitle($field) }}</label>
                                <input type="text" wire:model="elementForm.{{ $field }}"
                                    class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                                @error("elementForm.$field") <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                            </div>
                        @endif
                    @endif
                @endforeach

                <div class="flex justify-end gap-3 pt-4 border-t border-white/5">
                    <x-admin.button type="button" variant="secondary" wire:click="closeElementModal">
                        @lang('Cancel')
                    </x-admin.button>
                    <x-admin.button type="submit">
                        <span wire:loading.remove wire:target="saveElement">
                            {{ $editingElementId ? __('Update Item') : __('Add Item') }}
                        </span>
                        <span wire:loading wire:target="saveElement">
                            <i class="ph-bold ph-spinner animate-spin"></i>
                            @lang('Saving...')
                        </span>
                    </x-admin.button>
                </div>
            </form>
        </x-admin.modal>
    @endif

    {{-- Clone Modal --}}
    <x-admin.modal wire:model="showCloneModal" :title="__('Clone Section')" maxWidth="md">
        <form wire:submit="cloneSection" class="space-y-6">
            <div>
                <p class="text-sm text-slate-400 mb-6">
                    @lang('This will create a complete duplicate of the current section, including its Design (Blade), Configuration (JSON), and all existing Data/Images.')
                </p>
                <div class="space-y-4">
                    <div>
                        <label class="block text-xs font-black uppercase tracking-widest text-slate-500 mb-2">@lang('New Section Name')</label>
                        <input type="text" wire:model="cloneName" placeholder="@lang('e.g. Special Features')"
                            class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-white focus:border-indigo-500/50 focus:ring-0">
                        @error('cloneName') <span class="text-red-500 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>
                    <div>
                        <label class="block text-xs font-black uppercase tracking-widest text-slate-500 mb-2">@lang('New Section Key')</label>
                        <input type="text" wire:model="cloneKey" placeholder="@lang('e.g. special_features')"
                            class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-white font-mono focus:border-indigo-500/50 focus:ring-0">
                        @error('cloneKey') <span class="text-red-500 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>
                </div>
            </div>

            <div class="flex justify-end gap-3 pt-6 border-t border-white/5">
                <x-admin.button type="button" variant="secondary" wire:click="$set('showCloneModal', false)">
                    @lang('Cancel')
                </x-admin.button>
                <x-admin.button type="submit">
                    <span wire:loading.remove wire:target="cloneSection">@lang('Create Clone')</span>
                    <span wire:loading wire:target="cloneSection">
                        <i class="ph-bold ph-spinner animate-spin"></i>
                        @lang('Cloning...')
                    </span>
                </x-admin.button>
            </div>
        </form>
    </x-admin.modal>
</div>