<div>
    <x-admin.page-header :title="__('Templates')" :subtitle="__('Manage and activate frontend templates for your website.')">
        <x-slot name="actions">
            <x-admin.button wire:click="openUploadModal" variant="primary">
                <i class="ph-duotone ph-upload-simple"></i>
                @lang('Upload Theme')
            </x-admin.button>
        </x-slot>
    </x-admin.page-header>

    @if(count($templates) > 0)
        <div class="mt-6 grid grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-6">
            @foreach($templates as $template)
                <div
                    class="group rounded-2xl border border-white/10 bg-white/5 transition-all duration-300 hover:border-indigo-500/50 {{ $activeTemplate === $template['name'] ? 'ring-2 ring-indigo-500' : '' }}">
                    {{-- Template Preview Image --}}
                    <div class="relative aspect-video overflow-hidden rounded-t-2xl bg-slate-800">
                        <img src="{{ $template['preview'] }}" alt="{{ $template['display_name'] }}"
                            class="h-full w-full object-cover transition-transform duration-500 group-hover:scale-105">

                        @if($activeTemplate === $template['name'])
                            <div class="absolute right-3 top-3">
                                <span
                                    class="inline-flex items-center gap-1.5 rounded-full bg-gradient-to-r from-indigo-500 to-purple-500 px-3 py-1.5 text-xs font-semibold text-white shadow-lg shadow-indigo-500/25">
                                    <i class="ph-bold ph-check-circle text-sm"></i>
                                    @lang('Active')
                                </span>
                            </div>
                        @endif

                        @if(!$template['is_valid'])
                            <div class="absolute left-3 top-3">
                                <span
                                    class="inline-flex items-center gap-1.5 rounded-full bg-red-500/90 px-3 py-1.5 text-xs font-semibold text-white">
                                    <i class="ph-bold ph-warning text-sm"></i>
                                    @lang('Invalid')
                                </span>
                            </div>
                        @endif
                    </div>

                    {{-- Template Info --}}
                    <div class="p-5">
                        <div class="mb-3">
                            <h3 class="text-lg font-semibold text-white">{{ $template['display_name'] }}</h3>
                            <p class="mt-0.5 text-sm text-slate-400">{{ $template['description'] }}</p>
                        </div>

                        {{-- Metadata --}}
                        <div class="mb-4 flex flex-wrap gap-2 text-xs">
                            <span class="inline-flex items-center gap-1 rounded-full bg-slate-800 px-2.5 py-1 text-slate-300">
                                <i class="ph-duotone ph-tag text-indigo-400"></i>
                                v{{ $template['version'] }}
                            </span>
                            @if($template['author'] !== 'Unknown')
                                <span class="inline-flex items-center gap-1 rounded-full bg-slate-800 px-2.5 py-1 text-slate-300">
                                    <i class="ph-duotone ph-user text-indigo-400"></i>
                                    {{ $template['author'] }}
                                </span>
                            @endif
                        </div>

                        {{-- Actions --}}
                        <div class="flex items-center justify-between gap-2">
                            @if($activeTemplate === $template['name'])
                                <x-admin.button variant="secondary" disabled class="flex-1">
                                    <i class="ph-duotone ph-check"></i>
                                    @lang('Active')
                                </x-admin.button>
                            @else
                                <x-admin.button wire:click="activateTemplate('{{ $template['name'] }}')"
                                    wire:loading.attr="disabled" wire:target="activateTemplate('{{ $template['name'] }}')"
                                    class="flex-1">
                                    <span wire:loading.remove wire:target="activateTemplate('{{ $template['name'] }}')">
                                        <i class="ph-duotone ph-check-circle"></i>
                                        @lang('Activate')
                                    </span>
                                    <span wire:loading wire:target="activateTemplate('{{ $template['name'] }}')">
                                        <i class="ph-bold ph-spinner animate-spin"></i>
                                        @lang('Activating...')
                                    </span>
                                </x-admin.button>
                            @endif

                            {{-- Dropdown Menu --}}
                            <div x-data="{ open: false }" class="relative">
                                <button @click="open = !open"
                                    class="rounded-lg p-2 text-slate-400 transition-colors hover:bg-white/5 hover:text-white">
                                    <i class="ph-bold ph-dots-three-vertical text-lg"></i>
                                </button>

                                <div x-show="open" @click.away="open = false" x-transition
                                    class="absolute right-0 bottom-full z-50 mb-2 w-48 origin-bottom-right rounded-xl border border-white/10 bg-slate-900 py-1 shadow-xl">
                                    <a href="{{ route('admin.frontend.templates.download', $template['name']) }}"
                                        @click="open = false"
                                        class="flex w-full items-center gap-2 px-4 py-2 text-sm text-slate-300 transition-colors hover:bg-white/5 hover:text-white">
                                        <i class="ph-duotone ph-download-simple"></i>
                                        @lang('Export')
                                    </a>
                                    @if($template['name'] !== 'basic' && $activeTemplate !== $template['name'])
                                        <button wire:click="confirmDelete('{{ $template['name'] }}')" @click="open = false"
                                            class="flex w-full items-center gap-2 px-4 py-2 text-sm text-red-400 transition-colors hover:bg-red-500/10 hover:text-red-300">
                                            <i class="ph-duotone ph-trash"></i>
                                            @lang('Delete')
                                        </button>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    @else
        <x-admin.card class="mt-6">
            <div class="p-12 text-center">
                <div class="mx-auto mb-4 flex h-16 w-16 items-center justify-center rounded-full bg-slate-800">
                    <i class="ph-duotone ph-palette text-3xl text-slate-500"></i>
                </div>
                <h3 class="mb-2 text-lg font-medium text-white">@lang('No Templates Found')</h3>
                <p class="mx-auto max-w-md text-sm text-slate-400">
                    @lang('No templates are available. Upload a theme or create a template folder in') <code
                        class="text-indigo-400">resources/views/templates/</code>
                </p>
                <div class="mt-6">
                    <x-admin.button wire:click="openUploadModal" variant="primary">
                        <i class="ph-duotone ph-upload-simple"></i>
                        @lang('Upload Theme')
                    </x-admin.button>
                </div>
            </div>
        </x-admin.card>
    @endif

    {{-- Upload Modal --}}
    @if($showUploadModal)
        <div class="fixed inset-0 z-50 flex items-center justify-center overflow-y-auto" aria-labelledby="modal-title"
            role="dialog" aria-modal="true">
            <div class="fixed inset-0 bg-black/60 backdrop-blur-sm transition-opacity" wire:click="closeUploadModal"></div>

            <div
                class="relative z-10 w-full max-w-lg transform overflow-hidden rounded-2xl border border-white/10 bg-slate-900 p-6 shadow-2xl transition-all">
                <div class="mb-6">
                    <h3 class="text-xl font-semibold text-white" id="modal-title">@lang('Upload Theme')</h3>
                    <p class="mt-1 text-sm text-slate-400">@lang('Upload a ZIP file containing your theme.')</p>
                </div>

                <form wire:submit="uploadTheme">
                    <div class="mb-6">
                        <label class="mb-2 block text-sm font-medium text-slate-300">@lang('Theme File')</label>
                        <div class="relative">
                            <input type="file" wire:model="themeFile" accept=".zip"
                                class="block w-full cursor-pointer rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-sm text-slate-300 file:mr-4 file:rounded-lg file:border-0 file:bg-indigo-500 file:px-4 file:py-2 file:text-sm file:font-medium file:text-white hover:file:bg-indigo-600">

                            @error('themeFile')
                                <p class="mt-2 text-sm text-red-400">{{ $message }}</p>
                            @enderror

                            <div wire:loading wire:target="themeFile"
                                class="mt-2 flex items-center gap-2 text-sm text-slate-400">
                                <i class="ph-bold ph-spinner animate-spin"></i>
                                @lang('Uploading file...')
                            </div>
                        </div>

                        <div class="mt-4 rounded-xl border border-white/5 bg-white/5 p-4">
                            <h4 class="mb-2 text-sm font-medium text-slate-300">@lang('Theme Requirements')</h4>
                            <ul class="space-y-1 text-xs text-slate-400">
                                <li class="flex items-center gap-2">
                                    <i class="ph-bold ph-check text-emerald-400"></i>
                                    @lang('ZIP file format')
                                </li>
                                <li class="flex items-center gap-2">
                                    <i class="ph-bold ph-check text-emerald-400"></i>
                                    @lang('Contains layouts/app.blade.php')
                                </li>
                                <li class="flex items-center gap-2">
                                    <i class="ph-bold ph-check text-emerald-400"></i>
                                    @lang('Contains sections.json')
                                </li>
                                <li class="flex items-center gap-2">
                                    <i class="ph-bold ph-info text-slate-500"></i>
                                    @lang('Optional: theme.json for metadata')
                                </li>
                                <li class="flex items-center gap-2">
                                    <i class="ph-bold ph-info text-slate-500"></i>
                                    @lang('Optional: preview.jpg or preview.png')
                                </li>
                            </ul>
                        </div>
                    </div>

                    <div class="flex justify-end gap-3">
                        <x-admin.button type="button" variant="secondary" wire:click="closeUploadModal">
                            @lang('Cancel')
                        </x-admin.button>
                        <x-admin.button type="submit" wire:loading.attr="disabled" wire:target="uploadTheme">
                            <span wire:loading.remove wire:target="uploadTheme">
                                <i class="ph-duotone ph-upload-simple"></i>
                                @lang('Install Theme')
                            </span>
                            <span wire:loading wire:target="uploadTheme">
                                <i class="ph-bold ph-spinner animate-spin"></i>
                                @lang('Installing...')
                            </span>
                        </x-admin.button>
                    </div>
                </form>
            </div>
        </div>
    @endif

    {{-- Delete Confirmation Modal --}}
    @if($showDeleteModal && $themeToDelete)
        <div class="fixed inset-0 z-50 flex items-center justify-center overflow-y-auto"
            aria-labelledby="delete-modal-title" role="dialog" aria-modal="true">
            <div class="fixed inset-0 bg-black/60 backdrop-blur-sm transition-opacity" wire:click="cancelDelete"></div>

            <div
                class="relative z-10 w-full max-w-md transform overflow-hidden rounded-2xl border border-white/10 bg-slate-900 p-6 shadow-2xl transition-all">
                <div class="mb-6 text-center">
                    <div class="mx-auto mb-4 flex h-14 w-14 items-center justify-center rounded-full bg-red-500/10">
                        <i class="ph-duotone ph-trash text-3xl text-red-400"></i>
                    </div>
                    <h3 class="text-xl font-semibold text-white" id="delete-modal-title">@lang('Delete Theme')</h3>
                    <p class="mt-2 text-sm text-slate-400">
                        @lang('Are you sure you want to delete') <span
                            class="font-medium text-white">{{ $themeToDelete }}</span>?
                        @lang('This action cannot be undone.')
                    </p>
                </div>

                <div class="flex justify-center gap-3">
                    <x-admin.button type="button" variant="secondary" wire:click="cancelDelete">
                        @lang('Cancel')
                    </x-admin.button>
                    <x-admin.button type="button" variant="danger" wire:click="deleteTheme" wire:loading.attr="disabled">
                        <span wire:loading.remove wire:target="deleteTheme">
                            <i class="ph-duotone ph-trash"></i>
                            @lang('Delete')
                        </span>
                        <span wire:loading wire:target="deleteTheme">
                            <i class="ph-bold ph-spinner animate-spin"></i>
                            @lang('Deleting...')
                        </span>
                    </x-admin.button>
                </div>
            </div>
        </div>
    @endif
</div>