<div>
    {{-- Page Header --}}
    <div class="flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between">
        <x-admin.page-header :title="$gateway->name" :subtitle="__('Configure payment gateway settings and currencies.')" />
        <a href="{{ route('admin.gateway.automatic.index') }}" class="inline-flex items-center gap-2 rounded-xl border border-white/10 bg-white/5 px-4 py-2 text-sm font-medium text-white transition-all hover:bg-white/10">
            <i class="ph-duotone ph-arrow-left"></i>
            @lang('Back to Gateways')
        </a>
    </div>

    <div class="mt-6 grid grid-cols-1 gap-6 lg:grid-cols-3">
        {{-- Left Column: API Config + Gateway Info --}}
        <div class="lg:col-span-1 space-y-4">
            {{-- Global Parameters (API Configuration) --}}
            @if(count($this->globalParamsList) > 0)
            <x-admin.card>
                <div class="flex items-center gap-3 border-b border-white/5 pb-4">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-purple-500/10">
                        <i class="ph-duotone ph-key text-xl text-purple-400"></i>
                    </div>
                    <div>
                        <h3 class="text-sm font-semibold text-white">@lang('API Configuration')</h3>
                        <p class="text-xs text-slate-400">@lang('Global credentials (shared across all currencies)')</p>
                    </div>
                </div>

                <div class="mt-4 space-y-4">
                    @foreach($this->globalParamsList as $key => $param)
                        <div wire:key="global-param-{{ $key }}">
                            <label class="mb-1.5 block text-xs font-medium text-slate-300">{{ $param['title'] ?? ucfirst(str_replace('_', ' ', $key)) }}</label>
                            @if(isset($param['options']))
                                <select
                                    wire:model="globalParams.{{ $key }}"
                                    class="w-full rounded-xl border border-white/10 bg-slate-900 px-4 py-2.5 text-sm text-white outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20 cursor-pointer"
                                >
                                    @foreach($param['options'] as $v => $l)
                                        <option value="{{ $v }}">{{ __($l) }}</option>
                                    @endforeach
                                </select>
                            @else
                                <input
                                    type="{{ str_contains(strtolower($key), 'secret') || str_contains(strtolower($key), 'password') || str_contains(strtolower($key), 'key') ? 'password' : 'text' }}"
                                    wire:model="globalParams.{{ $key }}"
                                    class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20"
                                    placeholder="{{ __('Enter') }} {{ $param['title'] ?? $key }}"
                                />
                            @endif
                        </div>
                    @endforeach
                </div>

                <div class="mt-6 flex flex-col gap-2 border-t border-white/5 pt-4">
                    <button wire:click="testConnection" wire:loading.attr="disabled" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm font-medium text-white transition-all hover:bg-white/10 cursor-pointer flex items-center justify-center gap-2">
                        <i class="ph-duotone ph-plugs-connected" wire:loading.remove wire:target="testConnection"></i>
                        <i class="ph-duotone ph-spinner animate-spin" wire:loading wire:target="testConnection"></i>
                        <span wire:loading.remove wire:target="testConnection">@lang('Test Connection')</span>
                        <span wire:loading wire:target="testConnection">@lang('Testing...')</span>
                    </button>
                    <button wire:click="saveGlobalParams" class="w-full rounded-xl bg-gradient-to-r from-purple-500 to-purple-600 px-4 py-2.5 text-sm font-medium text-white shadow-lg shadow-purple-500/25 transition-all hover:shadow-purple-500/40 cursor-pointer">
                        <i class="ph-duotone ph-floppy-disk mr-1"></i>
                        @lang('Save Configuration')
                    </button>
                </div>
            </x-admin.card>
            @endif

            {{-- Gateway Info --}}
            <x-admin.card>
                <div class="flex items-center gap-3 border-b border-white/5 pb-4">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-blue-500/10">
                        <i class="ph-duotone ph-info text-xl text-blue-400"></i>
                    </div>
                    <h3 class="text-sm font-semibold text-white">@lang('Gateway Information')</h3>
                </div>
                
                <div class="mt-4 flex flex-col items-center">
                    <div class="relative group">
                        <div class="flex h-24 w-32 items-center justify-center rounded-2xl bg-gradient-to-br from-white/5 to-white/10 p-4 border border-white/10 overflow-hidden shadow-xl">
                            @if($image)
                                <img src="{{ $image->temporaryUrl() }}" class="h-full w-full object-contain">
                            @else
                                <img src="{{ $gateway->imageUrl() }}" alt="{{ $gateway->name }}" class="h-full w-full object-contain">
                            @endif
                            
                            {{-- Upload Overlay --}}
                            <label class="absolute inset-0 flex cursor-pointer items-center justify-center bg-black/60 opacity-0 transition-opacity group-hover:opacity-100">
                                <input type="file" wire:model="image" class="hidden">
                                <div class="text-center">
                                    <i class="ph-duotone ph-camera text-2xl text-white"></i>
                                    <p class="text-[10px] text-white">@lang('Change')</p>
                                </div>
                            </label>
                        </div>
                        
                        {{-- Loading Spinner --}}
                        <div wire:loading wire:target="image" class="absolute inset-0 flex items-center justify-center rounded-2xl bg-black/50 backdrop-blur-sm">
                            <i class="ph-duotone ph-spinner animate-spin text-2xl text-purple-400"></i>
                        </div>
                    </div>

                    @if($image)
                        <div class="mt-4 flex gap-2">
                            <button wire:click="updateImage" class="rounded-lg bg-emerald-500/20 px-3 py-1.5 text-xs font-semibold text-emerald-400 hover:bg-emerald-500/30">
                                @lang('Save Logo')
                            </button>
                            <button wire:click="$set('image', null)" class="rounded-lg bg-rose-500/20 px-3 py-1.5 text-xs font-semibold text-rose-400 hover:bg-rose-500/30">
                                @lang('Cancel')
                            </button>
                        </div>
                    @else
                        <p class="mt-3 text-[10px] text-slate-500">@lang('Recommended size'): 200x200px</p>
                    @endif
                </div>

                <div class="mt-6 space-y-3 text-sm">
                    <div class="flex items-center justify-between">
                        <span class="text-slate-400">@lang('Gateway Code')</span>
                        <span class="font-mono text-white">{{ $gateway->code }}</span>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-slate-400">@lang('Alias')</span>
                        <span class="text-white">{{ $gateway->alias }}</span>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-slate-400">@lang('Status')</span>
                        @if($gateway->status)
                            <span class="inline-flex items-center gap-1 text-emerald-400">
                                <i class="ph-duotone ph-check-circle"></i> @lang('Active')
                            </span>
                        @else
                            <span class="inline-flex items-center gap-1 text-slate-400">
                                <i class="ph-duotone ph-x-circle"></i> @lang('Inactive')
                            </span>
                        @endif
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-slate-400">@lang('Type')</span>
                        @if($gateway->crypto)
                            <span class="inline-flex items-center gap-1 rounded-lg bg-amber-500/10 px-2 py-0.5 text-xs font-medium text-amber-400">
                                <i class="ph-duotone ph-currency-btc"></i> @lang('Crypto')
                            </span>
                        @else
                            <span class="inline-flex items-center gap-1 rounded-lg bg-emerald-500/10 px-2 py-0.5 text-xs font-medium text-emerald-400">
                                <i class="ph-duotone ph-bank"></i> @lang('Fiat')
                            </span>
                        @endif
                    </div>
                </div>
            </x-admin.card>

            {{-- Extra Configuration (Webhook URLs, etc.) --}}
            @if(count($this->extraConfig) > 0)
            <x-admin.card>
                <div class="flex items-center gap-3 border-b border-white/5 pb-4">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-amber-500/10">
                        <i class="ph-duotone ph-link text-xl text-amber-400"></i>
                    </div>
                    <div>
                        <h3 class="text-sm font-semibold text-white">@lang('Webhook URLs')</h3>
                        <p class="text-xs text-slate-400">@lang('Configure these in your gateway dashboard')</p>
                    </div>
                </div>
                <div class="mt-4 space-y-3">
                    @foreach($this->extraConfig as $key => $config)
                        <div>
                            <label class="mb-1.5 block text-xs font-medium text-slate-400">{{ $config->title ?? ucfirst($key) }}</label>
                            <div class="group relative">
                                <input
                                    type="text"
                                    value="{{ url('ipn/' . $gateway->alias) }}"
                                    readonly
                                    class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 pr-10 text-xs text-slate-300 outline-none"
                                />
                                <button
                                    onclick="navigator.clipboard.writeText('{{ url('ipn/' . $gateway->alias) }}'); this.querySelector('i').classList.replace('ph-copy', 'ph-check'); setTimeout(() => this.querySelector('i').classList.replace('ph-check', 'ph-copy'), 2000)"
                                    class="absolute right-2 top-1/2 -translate-y-1/2 rounded-lg p-1.5 text-slate-400 transition-colors hover:bg-white/5 hover:text-white cursor-pointer"
                                    title="{{ __('Copy URL') }}"
                                >
                                    <i class="ph-duotone ph-copy text-sm"></i>
                                </button>
                            </div>
                        </div>
                    @endforeach
                </div>
            </x-admin.card>
            @endif

            {{-- Per-Currency Parameters Info --}}
            @if(count($this->currencyParamsList) > 0)
            <x-admin.card>
                <div class="flex items-center gap-3 border-b border-white/5 pb-4">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-rose-500/10">
                        <i class="ph-duotone ph-wallet text-xl text-rose-400"></i>
                    </div>
                    <div>
                        <h3 class="text-sm font-semibold text-white">@lang('Per-Currency Settings')</h3>
                        <p class="text-xs text-slate-400">@lang('Required for each currency')</p>
                    </div>
                </div>
                <div class="mt-4 space-y-2">
                    @foreach($this->currencyParamsList as $key => $param)
                        <div class="flex items-center gap-2 text-sm">
                            <i class="ph-duotone ph-dot text-rose-400"></i>
                            <span class="text-slate-300">{{ $param['title'] ?? ucfirst(str_replace('_', ' ', $key)) }}</span>
                        </div>
                    @endforeach
                    <p class="mt-2 text-xs text-slate-500">@lang('These values must be set individually for each currency when adding/editing currencies.')</p>
                </div>
            </x-admin.card>
            @endif
        </div>

        {{-- Currencies --}}
        <div class="lg:col-span-2">
            <x-admin.card>
                <div class="flex items-center justify-between border-b border-white/5 pb-4">
                    <div class="flex items-center gap-3">
                        <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-emerald-500/10">
                            <i class="ph-duotone ph-money text-xl text-emerald-400"></i>
                        </div>
                        <div>
                            <h3 class="text-sm font-semibold text-white">@lang('Enabled Currencies')</h3>
                            <p class="text-xs text-slate-400">{{ __(':count of :total currencies configured', ['count' => $currencies->count(), 'total' => count($this->supportedCurrencies)]) }}</p>
                        </div>
                    </div>
                    <button wire:click="openAddCurrencyModal" class="inline-flex items-center gap-2 rounded-xl bg-gradient-to-r from-emerald-500 to-emerald-600 px-4 py-2 text-sm font-medium text-white shadow-lg shadow-emerald-500/25 transition-all hover:shadow-emerald-500/40 cursor-pointer">
                        <i class="ph-duotone ph-plus"></i>
                        @lang('Add Currency')
                    </button>
                </div>

                {{-- Currencies Table --}}
                <div class="mt-4 overflow-x-auto">
                    <table class="w-full">
                        <thead>
                            <tr class="border-b border-white/5 text-left">
                                <th class="px-3 py-2 text-xs font-medium uppercase tracking-wider text-slate-400">@lang('Currency')</th>
                                <th class="px-3 py-2 text-xs font-medium uppercase tracking-wider text-slate-400">@lang('Min/Max')</th>
                                <th class="px-3 py-2 text-xs font-medium uppercase tracking-wider text-slate-400">@lang('Charges')</th>
                                <th class="px-3 py-2 text-xs font-medium uppercase tracking-wider text-slate-400">@lang('Rate')</th>
                                <th class="px-3 py-2 text-xs font-medium uppercase tracking-wider text-slate-400 text-right">@lang('Actions')</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-white/5">
                            @forelse($currencies as $currency)
                                <tr class="transition-colors hover:bg-white/[0.02]">
                                    <td class="whitespace-nowrap px-3 py-3">
                                        <div class="flex items-center gap-2">
                                            <span class="flex h-8 w-8 items-center justify-center rounded-lg bg-purple-500/10 text-xs font-bold text-purple-400">{{ $currency->symbol }}</span>
                                            <span class="font-medium text-white">{{ $currency->currency }}</span>
                                        </div>
                                    </td>
                                    <td class="whitespace-nowrap px-3 py-3 text-sm text-slate-300">
                                        {{ $currency->symbol }}{{ number_format($currency->min_amount, 2) }} - {{ $currency->symbol }}{{ number_format($currency->max_amount, 2) }}
                                    </td>
                                    <td class="whitespace-nowrap px-3 py-3 text-sm text-slate-300">
                                        {{ $currency->symbol }}{{ number_format($currency->fixed_charge, 2) }} + {{ $currency->percent_charge }}%
                                    </td>
                                    <td class="whitespace-nowrap px-3 py-3 text-sm text-slate-300">
                                        1 {{ gs('cur_text') ?? 'USD' }} = {{ number_format($currency->rate, 4) }} {{ $currency->currency }}
                                    </td>
                                    <td class="whitespace-nowrap px-3 py-3 text-right">
                                        <div class="flex items-center justify-end gap-1">
                                            <button wire:click="editCurrency({{ $currency->id }})" class="rounded-lg p-2 text-slate-400 transition-colors hover:bg-white/5 hover:text-white cursor-pointer" title="{{ __('Edit') }}">
                                                <i class="ph-duotone ph-pencil text-lg"></i>
                                            </button>
                                            <button wire:click="deleteCurrency({{ $currency->id }})" wire:confirm="{{ __('Are you sure you want to remove this currency?') }}" class="rounded-lg p-2 text-rose-400 transition-colors hover:bg-rose-500/10 cursor-pointer" title="{{ __('Delete') }}">
                                                <i class="ph-duotone ph-trash text-lg"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="px-3 py-8 text-center">
                                        <i class="ph-duotone ph-money text-4xl text-slate-600"></i>
                                        <p class="mt-2 text-sm text-white">@lang('No currencies configured')</p>
                                        <p class="mt-1 text-xs text-slate-400">@lang('Add a currency to enable this gateway.')</p>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                {{-- Supported Currencies --}}
                <div class="mt-6 border-t border-white/5 pt-4">
                    <p class="mb-2 text-xs font-medium text-slate-400">@lang('Supported Currencies'):</p>
                    <div class="flex flex-wrap gap-2">
                        @foreach($this->supportedCurrencies as $code => $name)
                            <span class="rounded-lg border border-white/10 bg-white/5 px-2 py-1 text-xs text-slate-300">{{ $code }}</span>
                        @endforeach
                    </div>
                </div>
            </x-admin.card>
        </div>
    </div>

    {{-- Currency Modal --}}
    @php $modalTitle = $editingCurrencyId ? __('Edit Currency') : __('Add Currency'); @endphp
    <x-admin.modal wire:model="showCurrencyModal" :title="$modalTitle" maxWidth="xl">
        <div class="max-h-[70vh] overflow-y-auto p-6">
            {{-- Currency Selection --}}
            <div class="mb-6">
                <h4 class="mb-3 flex items-center gap-2 text-sm font-medium text-white">
                    <i class="ph-duotone ph-currency-circle-dollar text-purple-400"></i>
                    @lang('Currency Details')
                </h4>
                <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                    <div>
                        <label class="mb-1.5 block text-xs font-medium text-slate-300">@lang('Currency Code') <span class="text-rose-400">*</span></label>
                        <input type="text" wire:model.live="currencyCode" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20 uppercase" placeholder="@lang('e.g., USD, KES, BDT')" maxlength="10" {{ $editingCurrencyId ? 'disabled' : '' }} />
                        <p class="mt-1 text-[10px] text-slate-500">@lang('Enter any currency code (e.g., USD, EUR, NGN, KES, BDT)')</p>
                        @error('currencyCode') <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                    </div>
                    <div>
                        <label class="mb-1.5 block text-xs font-medium text-slate-300">@lang('Symbol')</label>
                        <input type="text" wire:model="currencySymbol" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20" placeholder="{{ $currencyCode ?: '$' }}" />
                        @error('currencySymbol') <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                    </div>
                </div>
            </div>

            {{-- Per-Currency Parameters (if any) --}}
            @if(count($this->currencyParamsList) > 0)
            <div class="mb-6 rounded-xl border border-rose-500/20 bg-rose-500/5 p-4">
                <h4 class="mb-3 flex items-center gap-2 text-sm font-medium text-rose-400">
                    <i class="ph-duotone ph-wallet"></i>
                    @lang('Currency-Specific Settings')
                </h4>
                <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                    @foreach($this->currencyParamsList as $key => $param)
                        <div wire:key="currency-param-{{ $key }}" class="{{ count($this->currencyParamsList) == 1 ? 'sm:col-span-2' : '' }}">
                            <label class="mb-1.5 block text-xs font-medium text-slate-300">{{ $param['title'] ?? ucfirst(str_replace('_', ' ', $key)) }} <span class="text-rose-400">*</span></label>
                            @if(isset($param['options']))
                                <select
                                    wire:model="currencyParams.{{ $key }}"
                                    class="w-full rounded-xl border border-white/10 bg-slate-900 px-4 py-2.5 text-sm text-white outline-none transition-all focus:border-rose-500/50 focus:ring-2 focus:ring-rose-500/20 cursor-pointer"
                                >
                                    @foreach($param['options'] as $v => $l)
                                        <option value="{{ $v }}">{{ __($l) }}</option>
                                    @endforeach
                                </select>
                            @else
                                <input
                                    type="text"
                                    wire:model="currencyParams.{{ $key }}"
                                    class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-rose-500/50 focus:ring-2 focus:ring-rose-500/20"
                                    placeholder="{{ __('Enter') }} {{ $param['title'] ?? $key }} {{ __('for') }} {{ $currencyCode ?: __('this currency') }}"
                                />
                            @endif
                            @error("currencyParams.{$key}") <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                        </div>
                    @endforeach
                </div>
            </div>
            @endif

            {{-- Limits & Charges --}}
            <div class="mb-6">
                <h4 class="mb-3 flex items-center gap-2 text-sm font-medium text-white">
                    <i class="ph-duotone ph-scales text-emerald-400"></i>
                    @lang('Limits & Charges')
                </h4>
                <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                    <div>
                        <label class="mb-1.5 block text-xs font-medium text-slate-300">@lang('Minimum Amount') <span class="text-rose-400">*</span></label>
                        <input type="number" step="0.01" wire:model="minAmount" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20" />
                        @error('minAmount') <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                    </div>
                    <div>
                        <label class="mb-1.5 block text-xs font-medium text-slate-300">@lang('Maximum Amount') <span class="text-rose-400">*</span></label>
                        <input type="number" step="0.01" wire:model="maxAmount" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20" />
                        @error('maxAmount') <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                    </div>
                    <div>
                        <label class="mb-1.5 block text-xs font-medium text-slate-300">@lang('Fixed Charge')</label>
                        <div class="relative">
                            <input type="number" step="0.01" wire:model="fixedCharge" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 pr-16 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20" />
                            <span class="absolute right-3 top-1/2 -translate-y-1/2 text-xs text-slate-400">{{ $currencyCode ?: 'USD' }}</span>
                        </div>
                        @error('fixedCharge') <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                    </div>
                    <div>
                        <label class="mb-1.5 block text-xs font-medium text-slate-300">@lang('Percent Charge')</label>
                        <div class="relative">
                            <input type="number" step="0.01" wire:model="percentCharge" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 pr-8 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20" />
                            <span class="absolute right-3 top-1/2 -translate-y-1/2 text-xs text-slate-400">%</span>
                        </div>
                        @error('percentCharge') <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                    </div>
                </div>
            </div>

            {{-- Exchange Rate --}}
            <div>
                <h4 class="mb-3 flex items-center gap-2 text-sm font-medium text-white">
                    <i class="ph-duotone ph-arrows-left-right text-blue-400"></i>
                    @lang('Exchange Rate')
                </h4>
                <div class="rounded-xl border border-white/10 bg-white/5 p-4">
                    <label class="mb-1.5 block text-xs font-medium text-slate-300">@lang('Rate') <span class="text-rose-400">*</span></label>
                    <div class="flex items-center gap-3">
                        <span class="whitespace-nowrap text-sm text-slate-400">1 {{ gs('cur_text') ?? 'USD' }} =</span>
                        <input type="number" step="0.000001" wire:model="rate" class="flex-1 rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20" />
                        <span class="whitespace-nowrap text-sm font-medium text-white">{{ $currencyCode ?: 'XXX' }}</span>
                    </div>
                    @error('rate') <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                    <p class="mt-2 text-xs text-slate-500">
                        @if($currencyCode && $rate > 0)
                            @lang('Example'): {{ gs('cur_sym') ?? '$' }}100 {{ gs('cur_text') ?? 'USD' }} = {{ number_format(100 * $rate, 2) }} {{ $currencyCode }}
                        @else
                            @lang('Set the exchange rate from your base currency to this currency.')
                        @endif
                    </p>
                </div>
            </div>
        </div>
        <div class="flex justify-end gap-3 border-t border-white/10 p-4">
            <button wire:click="$set('showCurrencyModal', false)" class="rounded-xl border border-white/10 bg-white/5 px-4 py-2 text-sm font-medium text-white transition-all hover:bg-white/10 cursor-pointer">
                @lang('Cancel')
            </button>
            <button wire:click="saveCurrency" class="inline-flex items-center gap-2 rounded-xl bg-gradient-to-r from-purple-500 to-purple-600 px-4 py-2 text-sm font-medium text-white shadow-lg shadow-purple-500/25 transition-all hover:shadow-purple-500/40 cursor-pointer">
                <i class="ph-duotone ph-floppy-disk"></i>
                {{ $editingCurrencyId ? __('Update Currency') : __('Add Currency') }}
            </button>
        </div>
    </x-admin.modal>
</div>

