<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Automatic Gateways')" :subtitle="__('Configure automatic payment processors like PayPal, Stripe, and more.')" />

    {{-- Stats Cards --}}
    <div class="mt-6 grid grid-cols-1 gap-4 sm:grid-cols-3">
        <x-admin.stat-card
            :title="__('Total Gateways')"
            :value="$this->totalCount"
            icon="ph-duotone ph-credit-card"
            color="purple"
        />
        <x-admin.stat-card
            :title="__('Active')"
            :value="$this->activeCount"
            icon="ph-duotone ph-check-circle"
            color="emerald"
        />
        <x-admin.stat-card
            :title="__('Inactive')"
            :value="$this->inactiveCount"
            icon="ph-duotone ph-x-circle"
            color="slate"
        />
    </div>

    {{-- Filters --}}
    <x-admin.card class="mt-6">
        <div class="flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between">
            <div class="relative flex-1">
                <i class="ph-duotone ph-magnifying-glass absolute left-3 top-1/2 -translate-y-1/2 text-slate-400"></i>
                <input
                    type="text"
                    wire:model.live.debounce.300ms="search"
                    placeholder="{{ __('Search gateways...') }}"
                    class="w-full rounded-xl border border-white/10 bg-white/5 py-2.5 pl-10 pr-4 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20"
                />
            </div>
            <div class="flex items-center gap-3">
                <select
                    wire:model.live="status"
                    class="rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20"
                >
                    <option value="" class="bg-[#12121a]">@lang('All Gateways')</option>
                    <option value="active" class="bg-[#12121a]">@lang('Active Only')</option>
                    <option value="inactive" class="bg-[#12121a]">@lang('Inactive Only')</option>
                </select>
            </div>
        </div>
    </x-admin.card>

    {{-- Gateways Grid --}}
    <div class="mt-6 grid grid-cols-1 gap-4 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4">
        @forelse($gateways as $gateway)
            <div class="group relative overflow-hidden rounded-2xl border border-white/10 bg-gradient-to-br from-[#12121a] to-[#0f0f15] p-5 transition-all hover:border-purple-500/30 hover:shadow-lg hover:shadow-purple-500/5">
                {{-- Status Badge --}}
                <div class="absolute right-3 top-3">
                    @if($gateway->status)
                        <span class="inline-flex items-center gap-1.5 rounded-lg border border-emerald-500/20 bg-emerald-500/10 px-2 py-0.5 text-xs font-medium text-emerald-400">
                            <span class="h-1.5 w-1.5 rounded-full bg-emerald-400 animate-pulse"></span>
                            @lang('Active')
                        </span>
                    @else
                        <span class="inline-flex items-center gap-1.5 rounded-lg border border-slate-500/20 bg-slate-500/10 px-2 py-0.5 text-xs font-medium text-slate-400">
                            @lang('Inactive')
                        </span>
                    @endif
                </div>

                {{-- Gateway Icon --}}
                <div class="mb-4 flex h-16 w-full items-center justify-center rounded-xl bg-gradient-to-br from-white/5 to-white/10 p-4">
                    @if($gateway->imageUrl() !== asset('assets/images/default.png'))
                        <img src="{{ $gateway->imageUrl() }}" alt="{{ $gateway->name }}" class="h-10 w-auto object-contain">
                    @else
                        <div class="flex h-10 w-10 items-center justify-center rounded-lg bg-purple-500/20 text-purple-400">
                            <i class="ph-duotone ph-credit-card text-2xl"></i>
                        </div>
                    @endif
                </div>

                {{-- Gateway Info --}}
                <h3 class="mb-1 text-base font-semibold text-white">{{ $gateway->name }}</h3>
                <p class="mb-3 text-xs text-slate-400">@lang('Code'): {{ $gateway->code }}</p>

                {{-- Currencies Info --}}
                <div class="mb-4 flex items-center gap-4 text-xs text-slate-400">
                    <div class="flex items-center gap-1">
                        <i class="ph-duotone ph-globe"></i>
                        <span>{{ collect($gateway->supported_currencies)->count() }} @lang('supported')</span>
                    </div>
                    <div class="flex items-center gap-1">
                        <i class="ph-duotone ph-check"></i>
                        <span>{{ $gateway->currencies->count() }} @lang('enabled')</span>
                    </div>
                </div>

                {{-- Actions --}}
                <div class="flex items-center gap-2 border-t border-white/5 pt-4">
                    <a href="{{ route('admin.gateway.automatic.edit', $gateway->alias) }}" class="flex-1 rounded-xl border border-white/10 bg-white/5 px-3 py-2 text-center text-xs font-medium text-white transition-all hover:bg-white/10">
                        <i class="ph-duotone ph-gear mr-1"></i>
                        @lang('Configure')
                    </a>
                    <button
                        wire:click="toggleStatus({{ $gateway->id }})"
                        class="rounded-xl px-3 py-2 text-xs font-medium transition-all cursor-pointer {{ $gateway->status ? 'border border-rose-500/20 bg-rose-500/10 text-rose-400 hover:bg-rose-500/20' : 'border border-emerald-500/20 bg-emerald-500/10 text-emerald-400 hover:bg-emerald-500/20' }}"
                    >
                        {{ $gateway->status ? __('Disable') : __('Enable') }}
                    </button>
                </div>
            </div>
        @empty
            <div class="col-span-full">
                <x-admin.card>
                    <div class="py-12 text-center">
                        <i class="ph-duotone ph-credit-card text-5xl text-slate-600"></i>
                        <p class="mt-4 text-sm font-medium text-white">@lang('No gateways found')</p>
                        <p class="mt-1 text-xs text-slate-400">@lang('Run the gateway seeder to add default payment gateways.')</p>
                    </div>
                </x-admin.card>
            </div>
        @endforelse
    </div>
</div>

