<div>
    {{-- Page Header --}}
    @php $pageTitle = $isEditing ? __('Edit') . ' ' . $name : __('Add Manual Gateway'); @endphp
    <div class="flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between">
        <x-admin.page-header :title="$pageTitle" :subtitle="__('Configure manual payment method settings and currencies.')" />
        <a href="{{ route('admin.gateway.manual.index') }}" class="inline-flex items-center gap-2 rounded-xl border border-white/10 bg-white/5 px-4 py-2 text-sm font-medium text-white transition-all hover:bg-white/10">
            <i class="ph-duotone ph-arrow-left"></i>
            @lang('Back to Gateways')
        </a>
    </div>

    <div class="mt-6 grid grid-cols-1 gap-6 lg:grid-cols-3">
        {{-- Gateway Settings --}}
        <div class="lg:col-span-1">
            <x-admin.card>
                <div class="flex items-center gap-3 border-b border-white/5 pb-4">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-purple-500/10">
                        <i class="ph-duotone ph-bank text-xl text-purple-400"></i>
                    </div>
                    <div>
                        <h3 class="text-sm font-semibold text-white">@lang('Gateway Settings')</h3>
                        <p class="text-xs text-slate-400">@lang('Basic configuration')</p>
                    </div>
                </div>

                <div class="mt-4 space-y-4">
                    {{-- Name --}}
                    <div>
                        <label class="mb-1.5 block text-xs font-medium text-slate-300">@lang('Gateway Name')</label>
                        <input type="text" wire:model="name" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20" placeholder="{{ __('e.g., Bank Transfer') }}" />
                        @error('name') <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                    </div>

                    {{-- Status --}}
                    <div>
                        <label class="mb-1.5 block text-xs font-medium text-slate-300">@lang('Status')</label>
                        <label class="relative inline-flex cursor-pointer items-center">
                            <input type="checkbox" wire:model="status" class="peer sr-only" />
                            <div class="h-6 w-11 rounded-full bg-slate-700 after:absolute after:left-[2px] after:top-[2px] after:h-5 after:w-5 after:rounded-full after:border after:border-slate-600 after:bg-white after:transition-all after:content-[''] peer-checked:bg-purple-500 peer-checked:after:translate-x-full peer-checked:after:border-white peer-focus:ring-4 peer-focus:ring-purple-500/20"></div>
                            <span class="ml-3 text-sm text-slate-300">{{ $status ? __('Active') : __('Inactive') }}</span>
                        </label>
                    </div>

                    {{-- Image --}}
                    <div>
                        <label class="mb-1.5 block text-xs font-medium text-slate-300">@lang('Gateway Image')</label>
                        <div class="flex items-center gap-4">
                            @if($existingImage || $image)
                                <div class="h-16 w-16 overflow-hidden rounded-xl border border-white/10 bg-white/5">
                                    @if($image)
                                        <img src="{{ $image->temporaryUrl() }}" class="h-full w-full object-cover" />
                                    @else
                                        <img src="{{ asset('storage/' . $existingImage) }}" class="h-full w-full object-cover" />
                                    @endif
                                </div>
                            @endif
                            <input type="file" wire:model="image" accept="image/*" class="flex-1 rounded-xl border border-white/10 bg-white/5 px-3 py-2 text-sm text-slate-400 file:mr-3 file:rounded-lg file:border-0 file:bg-purple-500/20 file:px-3 file:py-1 file:text-xs file:font-medium file:text-purple-400" />
                        </div>
                        @error('image') <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                    </div>

                    {{-- Deposit Instructions --}}
                    <div>
                        <label class="mb-1.5 block text-xs font-medium text-slate-300">@lang('Deposit Instructions')</label>
                        <textarea
                            wire:model="description"
                            rows="4"
                            class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20"
                            placeholder="{{ __('Enter payment instructions for users (e.g., bank account details, payment steps, etc.)') }}"
                        ></textarea>
                        <p class="mt-1 text-xs text-slate-500">@lang('This will be shown to users when they select this payment method.')</p>
                    </div>
                </div>

                <div class="mt-6 border-t border-white/5 pt-4">
                    <button wire:click="save" class="w-full rounded-xl bg-gradient-to-r from-purple-500 to-purple-600 px-4 py-2.5 text-sm font-medium text-white shadow-lg shadow-purple-500/25 transition-all hover:shadow-purple-500/40 cursor-pointer">
                        <i class="ph-duotone ph-floppy-disk mr-1"></i>
                        {{ $isEditing ? __('Update Gateway') : __('Create Gateway') }}
                    </button>
                </div>
            </x-admin.card>

            {{-- User Data Fields --}}
            <x-admin.card class="mt-4">
                <div class="flex items-center justify-between border-b border-white/5 pb-4">
                    <div>
                        <h3 class="text-sm font-semibold text-white">@lang('User Data Fields')</h3>
                        <p class="text-xs text-slate-400">@lang('Fields to collect from user')</p>
                    </div>
                    <button wire:click="addUserDataField" class="rounded-lg bg-purple-500/10 p-2 text-purple-400 transition-colors hover:bg-purple-500/20 cursor-pointer">
                        <i class="ph-duotone ph-plus"></i>
                    </button>
                </div>

                <div class="mt-4 space-y-3">
                    @forelse($userDataFields as $index => $field)
                        <div class="flex items-start gap-2 rounded-xl border border-white/5 bg-white/[0.02] p-3">
                            <div class="flex-1 space-y-2">
                                <input type="text" wire:model="userDataFields.{{ $index }}.field_name" class="w-full rounded-lg border border-white/10 bg-white/5 px-3 py-2 text-xs text-white placeholder-slate-400 outline-none focus:border-purple-500/50" placeholder="{{ __('Field Name') }}" />
                                <select wire:model="userDataFields.{{ $index }}.field_type" class="w-full rounded-lg border border-white/10 bg-white/5 px-3 py-2 text-xs text-white outline-none focus:border-purple-500/50">
                                    <option value="text" class="bg-[#12121a]">@lang('Text')</option>
                                    <option value="textarea" class="bg-[#12121a]">@lang('Textarea')</option>
                                    <option value="file" class="bg-[#12121a]">@lang('File Upload')</option>
                                </select>
                            </div>
                            <button wire:click="removeUserDataField({{ $index }})" class="rounded-lg p-2 text-rose-400 transition-colors hover:bg-rose-500/10 cursor-pointer">
                                <i class="ph-duotone ph-trash"></i>
                            </button>
                        </div>
                    @empty
                        <div class="py-4 text-center text-xs text-slate-400">
                            @lang('No fields added. Click + to add a field.')
                        </div>
                    @endforelse
                </div>
            </x-admin.card>
        </div>

        {{-- Currencies --}}
        <div class="lg:col-span-2">
            <x-admin.card>
                <div class="flex items-center justify-between border-b border-white/5 pb-4">
                    <div class="flex items-center gap-3">
                        <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-emerald-500/10">
                            <i class="ph-duotone ph-money text-xl text-emerald-400"></i>
                        </div>
                        <div>
                            <h3 class="text-sm font-semibold text-white">@lang('Enabled Currencies')</h3>
                            <p class="text-xs text-slate-400">{{ __(':count currencies configured', ['count' => $currencies->count()]) }}</p>
                        </div>
                    </div>
                    @if($isEditing)
                        <button wire:click="openAddCurrencyModal" class="inline-flex items-center gap-2 rounded-xl bg-gradient-to-r from-emerald-500 to-emerald-600 px-4 py-2 text-sm font-medium text-white shadow-lg shadow-emerald-500/25 transition-all hover:shadow-emerald-500/40 cursor-pointer">
                            <i class="ph-duotone ph-plus"></i>
                            @lang('Add Currency')
                        </button>
                    @endif
                </div>

                @if(!$isEditing)
                    <div class="py-12 text-center">
                        <i class="ph-duotone ph-info text-4xl text-amber-400"></i>
                        <p class="mt-2 text-sm text-white">@lang('Save the gateway first')</p>
                        <p class="mt-1 text-xs text-slate-400">@lang('You can add currencies after creating the gateway.')</p>
                    </div>
                @else
                    {{-- Currencies Table --}}
                    <div class="mt-4 overflow-x-auto">
                        <table class="w-full">
                            <thead>
                                <tr class="border-b border-white/5 text-left">
                                    <th class="px-3 py-2 text-xs font-medium uppercase tracking-wider text-slate-400">@lang('Currency')</th>
                                    <th class="px-3 py-2 text-xs font-medium uppercase tracking-wider text-slate-400">@lang('Min/Max')</th>
                                    <th class="px-3 py-2 text-xs font-medium uppercase tracking-wider text-slate-400">@lang('Charges')</th>
                                    <th class="px-3 py-2 text-xs font-medium uppercase tracking-wider text-slate-400">@lang('Rate')</th>
                                    <th class="px-3 py-2 text-xs font-medium uppercase tracking-wider text-slate-400 text-right">@lang('Actions')</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-white/5">
                                @forelse($currencies as $currency)
                                    <tr class="transition-colors hover:bg-white/[0.02]">
                                        <td class="whitespace-nowrap px-3 py-3">
                                            <div class="flex items-center gap-2">
                                                <span class="flex h-8 w-8 items-center justify-center rounded-lg bg-purple-500/10 text-xs font-bold text-purple-400">{{ $currency->symbol }}</span>
                                                <span class="font-medium text-white">{{ $currency->currency }}</span>
                                            </div>
                                        </td>
                                        <td class="whitespace-nowrap px-3 py-3 text-sm text-slate-300">
                                            {{ $currency->symbol }}{{ number_format($currency->min_amount, 2) }} - {{ $currency->symbol }}{{ number_format($currency->max_amount, 2) }}
                                        </td>
                                        <td class="whitespace-nowrap px-3 py-3 text-sm text-slate-300">
                                            {{ $currency->symbol }}{{ number_format($currency->fixed_charge, 2) }} + {{ $currency->percent_charge }}%
                                        </td>
                                        <td class="whitespace-nowrap px-3 py-3 text-sm text-slate-300">
                                            1 {{ gs('cur_text') ?? 'USD' }} = {{ number_format($currency->rate, 4) }} {{ $currency->currency }}
                                        </td>
                                        <td class="whitespace-nowrap px-3 py-3 text-right">
                                            <div class="flex items-center justify-end gap-1">
                                                <button wire:click="editCurrency({{ $currency->id }})" class="rounded-lg p-2 text-slate-400 transition-colors hover:bg-white/5 hover:text-white cursor-pointer" title="{{ __('Edit') }}">
                                                    <i class="ph-duotone ph-pencil text-lg"></i>
                                                </button>
                                                <button wire:click="deleteCurrency({{ $currency->id }})" wire:confirm="{{ __('Remove this currency?') }}" class="rounded-lg p-2 text-rose-400 transition-colors hover:bg-rose-500/10 cursor-pointer" title="{{ __('Delete') }}">
                                                    <i class="ph-duotone ph-trash text-lg"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="5" class="px-3 py-8 text-center">
                                            <i class="ph-duotone ph-money text-4xl text-slate-600"></i>
                                            <p class="mt-2 text-sm text-white">@lang('No currencies configured')</p>
                                            <p class="mt-1 text-xs text-slate-400">@lang('Add a currency to enable this gateway.')</p>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                @endif
            </x-admin.card>
        </div>
    </div>

    {{-- Currency Modal --}}
    @php $currencyModalTitle = $editingCurrencyId ? __('Edit Currency') : __('Add Currency'); @endphp
    <x-admin.modal wire:model="showCurrencyModal" :title="$currencyModalTitle" maxWidth="xl">
        <div class="max-h-[70vh] overflow-y-auto p-6">
            {{-- Currency Details --}}
            <div class="mb-6">
                <h4 class="mb-3 flex items-center gap-2 text-sm font-medium text-white">
                    <i class="ph-duotone ph-currency-circle-dollar text-purple-400"></i>
                    @lang('Currency Details')
                </h4>
                <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                    <div>
                        <label class="mb-1.5 block text-xs font-medium text-slate-300">@lang('Currency Code') <span class="text-rose-400">*</span></label>
                        <input type="text" wire:model.live="currencyCode" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20 uppercase" placeholder="@lang('e.g., USD, EUR, KES, TZS')" maxlength="10" />
                        <p class="mt-1 text-xs text-slate-500">@lang('Enter any currency code (e.g., USD, EUR, KES, TZS, NGN)')</p>
                        @error('currencyCode') <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                    </div>
                    <div>
                        <label class="mb-1.5 block text-xs font-medium text-slate-300">@lang('Symbol') <span class="text-rose-400">*</span></label>
                        <input type="text" wire:model="currencySymbol" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20" placeholder="@lang('e.g., $, €, KSh')" maxlength="10" />
                        @error('currencySymbol') <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                    </div>
                </div>
            </div>

            {{-- Limits & Charges --}}
            <div class="mb-6">
                <h4 class="mb-3 flex items-center gap-2 text-sm font-medium text-white">
                    <i class="ph-duotone ph-scales text-emerald-400"></i>
                    @lang('Limits & Charges')
                </h4>
                <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                    <div>
                        <label class="mb-1.5 block text-xs font-medium text-slate-300">@lang('Minimum Amount') <span class="text-rose-400">*</span></label>
                        <div class="relative">
                            <input type="number" step="0.01" wire:model="minAmount" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 pr-16 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20" />
                            <span class="absolute right-3 top-1/2 -translate-y-1/2 text-xs text-slate-400">{{ gs('cur_text') ?? 'USD' }}</span>
                        </div>
                        @error('minAmount') <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                    </div>
                    <div>
                        <label class="mb-1.5 block text-xs font-medium text-slate-300">@lang('Maximum Amount') <span class="text-rose-400">*</span></label>
                        <div class="relative">
                            <input type="number" step="0.01" wire:model="maxAmount" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 pr-16 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20" />
                            <span class="absolute right-3 top-1/2 -translate-y-1/2 text-xs text-slate-400">{{ gs('cur_text') ?? 'USD' }}</span>
                        </div>
                        @error('maxAmount') <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                    </div>
                    <div>
                        <label class="mb-1.5 block text-xs font-medium text-slate-300">@lang('Fixed Charge')</label>
                        <div class="relative">
                            <input type="number" step="0.01" wire:model="fixedCharge" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 pr-16 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20" />
                            <span class="absolute right-3 top-1/2 -translate-y-1/2 text-xs text-slate-400">{{ gs('cur_text') ?? 'USD' }}</span>
                        </div>
                        @error('fixedCharge') <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                    </div>
                    <div>
                        <label class="mb-1.5 block text-xs font-medium text-slate-300">@lang('Percent Charge')</label>
                        <div class="relative">
                            <input type="number" step="0.01" wire:model="percentCharge" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 pr-8 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20" />
                            <span class="absolute right-3 top-1/2 -translate-y-1/2 text-xs text-slate-400">%</span>
                        </div>
                        @error('percentCharge') <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                    </div>
                </div>
            </div>

            {{-- Exchange Rate --}}
            <div>
                <h4 class="mb-3 flex items-center gap-2 text-sm font-medium text-white">
                    <i class="ph-duotone ph-arrows-left-right text-blue-400"></i>
                    @lang('Exchange Rate')
                </h4>
                <div class="rounded-xl border border-white/10 bg-white/5 p-4">
                    <label class="mb-1.5 block text-xs font-medium text-slate-300">@lang('Rate') <span class="text-rose-400">*</span></label>
                    <div class="flex items-center gap-3">
                        <span class="whitespace-nowrap text-sm text-slate-400">1 {{ gs('cur_text') ?? 'USD' }} =</span>
                        <input type="number" step="0.000001" wire:model="rate" class="flex-1 rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20" />
                        <span class="whitespace-nowrap text-sm font-medium text-white">{{ $currencyCode ?: 'XXX' }}</span>
                    </div>
                    @error('rate') <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                    <p class="mt-2 text-xs text-slate-500">
                        @if($currencyCode && $rate > 0)
                            @lang('Example'): {{ gs('cur_sym') ?? '$' }}100 {{ gs('cur_text') ?? 'USD' }} = {{ number_format(100 * $rate, 2) }} {{ $currencyCode }}
                        @else
                            @lang('Set the exchange rate from your base currency to this currency.')
                        @endif
                    </p>
                </div>
            </div>
        </div>
        <div class="flex justify-end gap-3 border-t border-white/10 p-4">
            <button wire:click="$set('showCurrencyModal', false)" class="rounded-xl border border-white/10 bg-white/5 px-4 py-2 text-sm font-medium text-white transition-all hover:bg-white/10 cursor-pointer">
                @lang('Cancel')
            </button>
            <button wire:click="saveCurrency" class="inline-flex items-center gap-2 rounded-xl bg-gradient-to-r from-purple-500 to-purple-600 px-4 py-2 text-sm font-medium text-white shadow-lg shadow-purple-500/25 transition-all hover:shadow-purple-500/40 cursor-pointer">
                <i class="ph-duotone ph-floppy-disk"></i>
                {{ $editingCurrencyId ? __('Update Currency') : __('Add Currency') }}
            </button>
        </div>
    </x-admin.modal>
</div>

