<div>
    {{-- Page Header --}}
    <div class="flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between">
        <x-admin.page-header :title="__('Manual Gateways')" :subtitle="__('Manage manual payment methods like bank transfer, crypto wallets, etc.')" />
        <a href="{{ route('admin.gateway.manual.create') }}" class="inline-flex items-center gap-2 rounded-xl bg-gradient-to-r from-purple-500 to-purple-600 px-4 py-2.5 text-sm font-medium text-white shadow-lg shadow-purple-500/25 transition-all hover:shadow-purple-500/40">
            <i class="ph-duotone ph-plus"></i>
            @lang('Add Gateway')
        </a>
    </div>

    {{-- Stats Cards --}}
    <div class="mt-6 grid grid-cols-1 gap-4 sm:grid-cols-3">
        <x-admin.stat-card
            :title="__('Total Gateways')"
            :value="$this->totalCount"
            icon="ph-duotone ph-bank"
            color="purple"
        />
        <x-admin.stat-card
            :title="__('Active')"
            :value="$this->activeCount"
            icon="ph-duotone ph-check-circle"
            color="emerald"
        />
        <x-admin.stat-card
            :title="__('Inactive')"
            :value="$this->inactiveCount"
            icon="ph-duotone ph-x-circle"
            color="slate"
        />
    </div>

    {{-- Filters --}}
    <x-admin.card class="mt-6">
        <div class="flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between">
            <div class="relative flex-1">
                <i class="ph-duotone ph-magnifying-glass absolute left-3 top-1/2 -translate-y-1/2 text-slate-400"></i>
                <input
                    type="text"
                    wire:model.live.debounce.300ms="search"
                    placeholder="{{ __('Search gateways...') }}"
                    class="w-full rounded-xl border border-white/10 bg-white/5 py-2.5 pl-10 pr-4 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20"
                />
            </div>
            <div class="flex items-center gap-3">
                <select
                    wire:model.live="status"
                    class="rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20"
                >
                    <option value="" class="bg-[#12121a]">@lang('All Gateways')</option>
                    <option value="active" class="bg-[#12121a]">@lang('Active Only')</option>
                    <option value="inactive" class="bg-[#12121a]">@lang('Inactive Only')</option>
                </select>
            </div>
        </div>
    </x-admin.card>

    {{-- Gateways Table --}}
    <x-admin.card class="mt-6">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-white/5 text-left">
                        <th class="px-4 py-3 text-xs font-medium uppercase tracking-wider text-slate-400">@lang('Gateway')</th>
                        <th class="px-4 py-3 text-xs font-medium uppercase tracking-wider text-slate-400">@lang('Currencies')</th>
                        <th class="px-4 py-3 text-xs font-medium uppercase tracking-wider text-slate-400">@lang('Status')</th>
                        <th class="px-4 py-3 text-xs font-medium uppercase tracking-wider text-slate-400 text-right">@lang('Actions')</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    @forelse($gateways as $gateway)
                        <tr class="transition-colors hover:bg-white/[0.02]">
                            <td class="whitespace-nowrap px-4 py-4">
                                <div class="flex items-center gap-3">
                                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-white/5 to-white/10 p-1.5 overflow-hidden">
                                        @if($gateway->imageUrl() !== asset('assets/images/default.png'))
                                            <img src="{{ $gateway->imageUrl() }}" alt="{{ $gateway->name }}" class="h-full w-full object-contain">
                                        @else
                                            <i class="ph-duotone ph-bank text-xl text-purple-400"></i>
                                        @endif
                                    </div>
                                    <div>
                                        <p class="font-medium text-white">{{ $gateway->name }}</p>
                                        <p class="text-xs text-slate-400">@lang('Code'): {{ $gateway->code }}</p>
                                    </div>
                                </div>
                            </td>
                            <td class="whitespace-nowrap px-4 py-4">
                                <span class="text-sm text-slate-300">{{ __(':count enabled', ['count' => $gateway->currencies->count()]) }}</span>
                            </td>
                            <td class="whitespace-nowrap px-4 py-4">
                                @if($gateway->status)
                                    <span class="inline-flex items-center gap-1.5 rounded-lg border border-emerald-500/20 bg-emerald-500/10 px-2.5 py-1 text-xs font-medium text-emerald-400">
                                        <span class="h-1.5 w-1.5 rounded-full bg-emerald-400 animate-pulse"></span>
                                        @lang('Active')
                                    </span>
                                @else
                                    <span class="inline-flex items-center gap-1.5 rounded-lg border border-slate-500/20 bg-slate-500/10 px-2.5 py-1 text-xs font-medium text-slate-400">
                                        @lang('Inactive')
                                    </span>
                                @endif
                            </td>
                            <td class="whitespace-nowrap px-4 py-4 text-right">
                                <div class="flex items-center justify-end gap-1">
                                    <a href="{{ route('admin.gateway.manual.edit', $gateway->alias) }}" class="rounded-lg p-2 text-slate-400 transition-colors hover:bg-white/5 hover:text-white" title="{{ __('Edit') }}">
                                        <i class="ph-duotone ph-pencil text-lg"></i>
                                    </a>
                                    <button
                                        wire:click="toggleStatus({{ $gateway->id }})"
                                        class="rounded-lg p-2 transition-colors cursor-pointer {{ $gateway->status ? 'text-amber-400 hover:bg-amber-500/10' : 'text-emerald-400 hover:bg-emerald-500/10' }}"
                                        title="{{ $gateway->status ? __('Disable') : __('Enable') }}"
                                    >
                                        <i class="ph-duotone {{ $gateway->status ? 'ph-toggle-right' : 'ph-toggle-left' }} text-lg"></i>
                                    </button>
                                    <button
                                        wire:click="confirmDelete({{ $gateway->id }})"
                                        class="rounded-lg p-2 text-rose-400 transition-colors hover:bg-rose-500/10 cursor-pointer"
                                        title="{{ __('Delete') }}"
                                    >
                                        <i class="ph-duotone ph-trash text-lg"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="px-4 py-12 text-center">
                                <i class="ph-duotone ph-bank text-5xl text-slate-600"></i>
                                <p class="mt-4 text-sm font-medium text-white">@lang('No manual gateways found')</p>
                                <p class="mt-1 text-xs text-slate-400">@lang('Create a manual gateway to accept offline payments.')</p>
                                <a href="{{ route('admin.gateway.manual.create') }}" class="mt-4 inline-flex items-center gap-2 rounded-xl bg-gradient-to-r from-purple-500 to-purple-600 px-4 py-2 text-sm font-medium text-white shadow-lg shadow-purple-500/25 transition-all hover:shadow-purple-500/40">
                                    <i class="ph-duotone ph-plus"></i>
                                    @lang('Add Gateway')
                                </a>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </x-admin.card>

    {{-- Delete Confirmation Modal --}}
    <x-admin.modal wire:model="showDeleteModal" :title="__('Delete Gateway')" maxWidth="sm">
        <div class="p-6 text-center">
            <div class="mx-auto mb-4 flex h-14 w-14 items-center justify-center rounded-full bg-rose-500/10">
                <i class="ph-duotone ph-warning text-3xl text-rose-400"></i>
            </div>
            <h3 class="mb-2 text-lg font-semibold text-white">{{ __('Delete :name?', ['name' => $deletingGatewayName]) }}</h3>
            <p class="text-sm text-slate-400">@lang('This action cannot be undone. All associated currency configurations will also be deleted.')</p>
        </div>
        <div class="flex justify-end gap-3 border-t border-white/10 p-4">
            <button wire:click="$set('showDeleteModal', false)" class="rounded-xl border border-white/10 bg-white/5 px-4 py-2 text-sm font-medium text-white transition-all hover:bg-white/10 cursor-pointer">
                @lang('Cancel')
            </button>
            <button wire:click="deleteGateway" class="inline-flex items-center gap-2 rounded-xl bg-gradient-to-r from-rose-500 to-rose-600 px-4 py-2 text-sm font-medium text-white shadow-lg shadow-rose-500/25 transition-all hover:shadow-rose-500/40 cursor-pointer">
                <i class="ph-duotone ph-trash"></i>
                @lang('Delete Gateway')
            </button>
        </div>
    </x-admin.modal>
</div>

