<div class="space-y-6">
    <!-- Page Header -->
    <x-admin.page-header
        :title="__('Domain Invoices')"
        :subtitle="$domain->domain"
    >
        <x-slot:actions>
            <a href="{{ route('admin.domains.detail', $domain->id) }}" class="inline-flex items-center gap-2 rounded-xl bg-white/5 px-4 py-2.5 text-sm font-medium text-slate-300 transition-all hover:bg-white/10 hover:text-white">
                <i class="ph-bold ph-arrow-left text-base"></i>
                @lang('Back to Domain')
            </a>
        </x-slot:actions>
    </x-admin.page-header>

    <!-- Domain Summary -->
    <x-admin.card>
        <div class="grid gap-6 sm:grid-cols-4">
            <div>
                <div class="text-sm text-slate-400">@lang('Domain')</div>
                <div class="mt-1 text-lg font-semibold text-white">{{ $domain->domain }}</div>
            </div>
            <div>
                <div class="text-sm text-slate-400">@lang('Client')</div>
                <div class="mt-1 text-lg font-semibold text-white">{{ $domain->user->fullname }}</div>
            </div>
            <div>
                <div class="text-sm text-slate-400">@lang('Registrar')</div>
                <div class="mt-1 text-lg font-semibold text-white">{{ $domain->registrar ?? __('N/A') }}</div>
            </div>
            <div>
                <div class="text-sm text-slate-400">@lang('Status')</div>
                <div class="mt-1">
                    <span class="inline-flex items-center rounded-full px-2.5 py-1 text-xs font-medium {{ $domain->status == 'active' ? 'bg-emerald-500/10 text-emerald-400' : 'bg-amber-500/10 text-amber-400' }}">
                        {{ __($domain->status_label ?? ucfirst($domain->status)) }}
                    </span>
                </div>
            </div>
        </div>
    </x-admin.card>

    <!-- Invoices Table -->
    <x-admin.card :title="__('Invoices')">
        @if($invoices->count() > 0)
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead>
                        <tr class="border-b border-white/5 text-left text-xs font-medium uppercase tracking-wider text-slate-400">
                            <th class="px-4 py-3">@lang('Invoice #')</th>
                            <th class="px-4 py-3">@lang('Amount')</th>
                            <th class="px-4 py-3">@lang('Status')</th>
                            <th class="px-4 py-3">@lang('Due Date')</th>
                            <th class="px-4 py-3">@lang('Date Paid')</th>
                            <th class="px-4 py-3">@lang('Actions')</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-white/5">
                        @foreach($invoices as $invoice)
                            <tr class="transition-colors hover:bg-white/[0.02]">
                                <td class="px-4 py-4">
                                    <a href="{{ route('admin.invoices.details', $invoice->id) }}" class="font-mono text-sm text-indigo-400 hover:text-indigo-300">
                                        #{{ $invoice->invoice_number }}
                                    </a>
                                </td>
                                <td class="px-4 py-4 text-sm text-white">{{ showAmount($invoice->amount) }}</td>
                                <td class="px-4 py-4">
                                    <span class="inline-flex items-center rounded-full px-2.5 py-1 text-xs font-medium {{ $invoice->status == 1 ? 'bg-emerald-500/10 text-emerald-400' : 'bg-amber-500/10 text-amber-400' }}">
                                        {{ __($invoice->status_label) }}
                                    </span>
                                </td>
                                <td class="px-4 py-4 text-sm text-slate-400">{{ $invoice->due_date ? \Carbon\Carbon::parse($invoice->due_date)->format('M d, Y') : __('N/A') }}</td>
                                <td class="px-4 py-4 text-sm text-slate-400">{{ $invoice->date_paid ? \Carbon\Carbon::parse($invoice->date_paid)->format('M d, Y') : '-' }}</td>
                                <td class="px-4 py-4">
                                    <a href="{{ route('admin.invoices.details', $invoice->id) }}" class="inline-flex items-center gap-1 text-sm text-indigo-400 hover:text-indigo-300">
                                        <i class="ph-bold ph-eye text-base"></i>
                                        @lang('View')
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="mt-4">
                {{ $invoices->links() }}
            </div>
        @else
            <div class="py-12 text-center">
                <i class="ph-duotone ph-file-text text-5xl text-slate-600"></i>
                <p class="mt-4 text-slate-400">@lang('No invoices found for this domain.')</p>
            </div>
        @endif
    </x-admin.card>
</div>

