<div>
    {{-- Page Header with Actions --}}
    @php $pageTitle = __('Invoice') . ' #' . ($invoice->invoice_number ?? $invoice->id); @endphp
    <div class="flex flex-col gap-3 sm:gap-4 sm:flex-row sm:items-center sm:justify-between">
        <x-admin.page-header :title="$pageTitle" :subtitle="__('View and manage invoice details.')" />

        {{-- Desktop Actions --}}
        <div class="hidden sm:flex flex-wrap items-center gap-2">
            @if($invoice->status === \App\Models\Invoice::STATUS_UNPAID)
                <button wire:click="$set('showMarkPaidModal', true)" class="inline-flex items-center gap-2 rounded-xl bg-gradient-to-r from-emerald-500 to-emerald-600 px-4 py-2 text-sm font-medium text-white shadow-lg shadow-emerald-500/25 transition-all hover:shadow-emerald-500/40 cursor-pointer">
                    <i class="ph-duotone ph-check-circle"></i>
                    @lang('Mark as Paid')
                </button>
            @endif

            @if($invoice->status === \App\Models\Invoice::STATUS_PAID)
                <button wire:click="$set('showRefundModal', true)" class="inline-flex items-center gap-2 rounded-xl border border-purple-500/30 bg-purple-500/10 px-4 py-2 text-sm font-medium text-purple-400 transition-all hover:bg-purple-500/20 cursor-pointer">
                    <i class="ph-duotone ph-arrow-counter-clockwise"></i>
                    @lang('Refund')
                </button>
            @endif

            @if($invoice->status !== \App\Models\Invoice::STATUS_CANCELLED)
                <button wire:click="$set('showCancelModal', true)" class="inline-flex items-center gap-2 rounded-xl border border-red-500/30 bg-red-500/10 px-4 py-2 text-sm font-medium text-red-400 transition-all hover:bg-red-500/20 cursor-pointer">
                    <i class="ph-duotone ph-x-circle"></i>
                    @lang('Cancel')
                </button>
            @endif

            @if($invoice->order)
                <a href="{{ route('admin.orders.details', $invoice->order->id) }}" class="inline-flex items-center gap-2 rounded-xl border border-white/10 bg-white/5 px-4 py-2 text-sm font-medium text-white transition-all hover:bg-white/10">
                    <i class="ph-duotone ph-shopping-cart"></i>
                    @lang('View Order')
                </a>
            @endif

            <button wire:click="$set('showNotesModal', true)" class="inline-flex items-center gap-2 rounded-xl border border-white/10 bg-white/5 px-4 py-2 text-sm font-medium text-white transition-all hover:bg-white/10 cursor-pointer">
                <i class="ph-duotone ph-note-pencil"></i>
                @lang('Admin Notes')
            </button>
        </div>

        {{-- Mobile Actions - Horizontal Scroll --}}
        <div class="flex sm:hidden -mx-4 px-4 overflow-x-auto pb-2">
            <div class="flex items-center gap-2 min-w-max">
                @if($invoice->status === \App\Models\Invoice::STATUS_UNPAID)
                    <button wire:click="$set('showMarkPaidModal', true)" class="inline-flex items-center gap-1.5 rounded-xl bg-gradient-to-r from-emerald-500 to-emerald-600 px-3 py-2 text-xs font-medium text-white shadow-lg shadow-emerald-500/25 transition-all active:scale-[0.98] cursor-pointer min-h-9">
                        <i class="ph-duotone ph-check-circle"></i>
                        @lang('Paid')
                    </button>
                @endif

                @if($invoice->status === \App\Models\Invoice::STATUS_PAID)
                    <button wire:click="$set('showRefundModal', true)" class="inline-flex items-center gap-1.5 rounded-xl border border-purple-500/30 bg-purple-500/10 px-3 py-2 text-xs font-medium text-purple-400 transition-all active:scale-[0.98] cursor-pointer min-h-9">
                        <i class="ph-duotone ph-arrow-counter-clockwise"></i>
                        @lang('Refund')
                    </button>
                @endif

                @if($invoice->status !== \App\Models\Invoice::STATUS_CANCELLED)
                    <button wire:click="$set('showCancelModal', true)" class="inline-flex items-center gap-1.5 rounded-xl border border-red-500/30 bg-red-500/10 px-3 py-2 text-xs font-medium text-red-400 transition-all active:scale-[0.98] cursor-pointer min-h-9">
                        <i class="ph-duotone ph-x-circle"></i>
                        @lang('Cancel')
                    </button>
                @endif

                @if($invoice->order)
                    <a href="{{ route('admin.orders.details', $invoice->order->id) }}" class="inline-flex items-center gap-1.5 rounded-xl border border-white/10 bg-white/5 px-3 py-2 text-xs font-medium text-white transition-all active:scale-[0.98] min-h-9">
                        <i class="ph-duotone ph-shopping-cart"></i>
                        @lang('Order')
                    </a>
                @endif

                <button wire:click="$set('showNotesModal', true)" class="inline-flex items-center gap-1.5 rounded-xl border border-white/10 bg-white/5 px-3 py-2 text-xs font-medium text-white transition-all active:scale-[0.98] cursor-pointer min-h-9">
                    <i class="ph-duotone ph-note-pencil"></i>
                    @lang('Notes')
                </button>
            </div>
        </div>
    </div>

    {{-- Invoice Info Cards --}}
    <div class="mt-4 sm:mt-6 grid grid-cols-1 gap-4 sm:gap-6 lg:grid-cols-2">
        {{-- Invoice Status Card --}}
        <x-admin.card>
            <h3 class="mb-3 sm:mb-4 text-base sm:text-lg font-semibold text-white">@lang('Invoice Information')</h3>
            <div class="space-y-2.5 sm:space-y-3">
                <div class="flex items-center justify-between border-b border-white/5 pb-2.5 sm:pb-3">
                    <span class="text-xs sm:text-sm text-slate-400">@lang('Invoice Status')</span>
                    @php
                        $statusColors = [
                            \App\Models\Invoice::STATUS_UNPAID => 'bg-amber-500/10 text-amber-400',
                            \App\Models\Invoice::STATUS_PAID => 'bg-emerald-500/10 text-emerald-400',
                            \App\Models\Invoice::STATUS_CANCELLED => 'bg-slate-500/10 text-slate-400',
                            \App\Models\Invoice::STATUS_REFUNDED => 'bg-purple-500/10 text-purple-400',
                        ];
                    @endphp
                    <span class="inline-flex items-center gap-1 sm:gap-1.5 rounded-full px-2 sm:px-3 py-0.5 sm:py-1 text-[10px] sm:text-xs font-medium {{ $statusColors[$invoice->status] ?? 'bg-slate-500/10 text-slate-400' }}">
                        <span class="h-1 w-1 sm:h-1.5 sm:w-1.5 rounded-full bg-current"></span>
                        {{ __($invoice->status_label) }}
                    </span>
                </div>
                <div class="flex items-center justify-between border-b border-white/5 pb-2.5 sm:pb-3">
                    <span class="text-xs sm:text-sm text-slate-400">@lang('Invoice #')</span>
                    <span class="font-mono text-xs sm:text-sm font-semibold text-white">#{{ $invoice->invoice_number ?? $invoice->id }}</span>
                </div>
                <div class="flex items-center justify-between border-b border-white/5 pb-2.5 sm:pb-3">
                    <span class="text-xs sm:text-sm text-slate-400">@lang('Created Date')</span>
                    <span class="text-xs sm:text-sm text-white">{{ $invoice->created_at->format('d/m/Y H:i') }}</span>
                </div>
                <div class="flex items-center justify-between border-b border-white/5 pb-2.5 sm:pb-3">
                    <span class="text-xs sm:text-sm text-slate-400">@lang('Due Date')</span>
                    @if($invoice->due_date)
                        @php
                            $dueDate = \Carbon\Carbon::parse($invoice->due_date);
                            $isOverdue = $dueDate->isPast() && $invoice->status === \App\Models\Invoice::STATUS_UNPAID;
                        @endphp
                        <span class="text-xs sm:text-sm {{ $isOverdue ? 'text-red-400' : 'text-white' }}">
                            {{ $dueDate->format('d/m/Y') }}
                            @if($isOverdue)
                                <span class="ml-1 text-[10px] sm:text-xs">(@lang('Overdue'))</span>
                            @endif
                        </span>
                    @else
                        <span class="text-xs sm:text-sm text-slate-500">@lang('N/A')</span>
                    @endif
                </div>
                <div class="flex items-center justify-between">
                    <span class="text-xs sm:text-sm text-slate-400">@lang('Paid Date')</span>
                    @if($invoice->date_paid)
                        <span class="text-xs sm:text-sm text-emerald-400">{{ \Carbon\Carbon::parse($invoice->date_paid)->format('d/m/Y H:i') }}</span>
                    @else
                        <span class="text-xs sm:text-sm text-slate-500">@lang('Not paid')</span>
                    @endif
                </div>
            </div>
        </x-admin.card>

        {{-- Client Info Card --}}
        <x-admin.card>
            <h3 class="mb-3 sm:mb-4 text-base sm:text-lg font-semibold text-white">@lang('Client Information')</h3>
            @if($invoice->user)
                <div class="flex items-start gap-3 sm:gap-4">
                    <div class="flex h-10 w-10 sm:h-14 sm:w-14 shrink-0 items-center justify-center rounded-xl sm:rounded-2xl bg-gradient-to-br from-blue-500/20 to-cyan-500/20 text-blue-400">
                        <span class="text-base sm:text-xl font-bold">{{ strtoupper(substr($invoice->user->firstname ?? 'U', 0, 1)) }}</span>
                    </div>
                    <div class="flex-1 min-w-0 space-y-1.5 sm:space-y-2">
                        <div>
                            <p class="font-semibold text-sm sm:text-base text-white truncate">{{ $invoice->user->fullname }}</p>
                            <a href="{{ route('admin.users.detail', $invoice->user->username) }}" class="text-xs sm:text-sm text-primary-400 hover:underline">
                                {{ '@' . $invoice->user->username }}
                            </a>
                        </div>
                        <div class="space-y-1 text-xs sm:text-sm text-slate-400">
                            <p class="flex items-center gap-1.5 truncate"><i class="ph-duotone ph-envelope shrink-0"></i><span class="truncate">{{ $invoice->user->email }}</span></p>
                            @if($invoice->user->mobile)
                                <p class="flex items-center gap-1.5"><i class="ph-duotone ph-phone shrink-0"></i>{{ $invoice->user->mobile }}</p>
                            @endif
                            @if($invoice->user->address)
                                <p class="flex items-center gap-1.5 truncate"><i class="ph-duotone ph-map-pin shrink-0"></i><span class="truncate">{{ $invoice->user->address }}</span></p>
                            @endif
                        </div>
                    </div>
                </div>
            @else
                <p class="text-xs sm:text-sm text-slate-500">@lang('Client information not available.')</p>
            @endif
        </x-admin.card>
    </div>

    {{-- Invoice Items Table --}}
    <x-admin.card class="mt-4 sm:mt-6" :padding="false">
        <div class="border-b border-white/5 px-4 sm:px-6 py-3 sm:py-4">
            <h3 class="text-base sm:text-lg font-semibold text-white">@lang('Invoice Items')</h3>
        </div>
        <div class="overflow-x-auto">
            <table class="w-full min-w-[320px]">
                <thead>
                    <tr class="border-b border-white/5 bg-white/[0.02]">
                        <th class="px-4 sm:px-6 py-3 sm:py-4 text-left">
                            <span class="text-[10px] sm:text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Description')</span>
                        </th>
                        <th class="px-4 sm:px-6 py-3 sm:py-4 text-right">
                            <span class="text-[10px] sm:text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Amount')</span>
                        </th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                <tbody class="divide-y divide-white/5">
                    {{-- Hosting Items (Grouped) --}}
                    @foreach($groupedItems['hosting'] as $hostingId => $items)
                        @php $hosting = $items->first()->hosting; @endphp
                        <tr class="bg-white/5">
                            <td colspan="2" class="px-4 sm:px-6 py-2">
                                <div class="flex items-center gap-2">
                                    <i class="ph-duotone ph-cube text-primary-400"></i>
                                    <span class="text-[10px] sm:text-xs font-semibold uppercase tracking-wider text-slate-400">
                                        {{ $hosting?->product?->name ?? __('Hosting Service') }}
                                        @if($hosting?->domain)
                                            - {{ $hosting->domain }}
                                        @endif
                                    </span>
                                </div>
                            </td>
                        </tr>
                        @foreach($items as $item)
                            <tr class="transition-all hover:bg-white/[0.02]">
                                <td class="px-4 sm:px-6 py-3 sm:py-4 pl-8 sm:pl-10">
                                    <span class="text-xs sm:text-sm text-white">{{ $item->description }}</span>
                                </td>
                                <td class="px-4 sm:px-6 py-3 sm:py-4 text-right">
                                    <span class="text-xs sm:text-sm font-semibold text-white">{{ showAmount($item->amount) }}</span>
                                </td>
                            </tr>
                        @endforeach
                    @endforeach

                    {{-- Domain Items (Grouped) --}}
                    @foreach($groupedItems['domain'] as $domainId => $items)
                        @php $domain = $items->first()->domain; @endphp
                        <tr class="bg-white/5">
                            <td colspan="2" class="px-4 sm:px-6 py-2">
                                <div class="flex items-center gap-2">
                                    <i class="ph-duotone ph-globe text-primary-400"></i>
                                    <span class="text-[10px] sm:text-xs font-semibold uppercase tracking-wider text-slate-400">
                                        @lang('Domain') - {{ $domain?->domain ?? __('Domain') }}
                                    </span>
                                </div>
                            </td>
                        </tr>
                        @foreach($items as $item)
                            <tr class="transition-all hover:bg-white/[0.02]">
                                <td class="px-4 sm:px-6 py-3 sm:py-4 pl-8 sm:pl-10">
                                    <span class="text-xs sm:text-sm text-white">{{ $item->description }}</span>
                                </td>
                                <td class="px-4 sm:px-6 py-3 sm:py-4 text-right">
                                    <span class="text-xs sm:text-sm font-semibold text-white">{{ showAmount($item->amount) }}</span>
                                </td>
                            </tr>
                        @endforeach
                    @endforeach

                    {{-- Other Items --}}
                    @foreach($groupedItems['other'] as $item)
                        <tr class="transition-all hover:bg-white/[0.02]">
                            <td class="px-4 sm:px-6 py-3 sm:py-4">
                                <span class="text-xs sm:text-sm text-white">{{ $item->description }}</span>
                            </td>
                            <td class="px-4 sm:px-6 py-3 sm:py-4 text-right">
                                <span class="text-xs sm:text-sm font-semibold text-white">{{ showAmount($item->amount) }}</span>
                            </td>
                        </tr>
                    @endforeach

                    @if($invoice->items->isEmpty())
                        <tr>
                            <td colspan="2" class="px-4 sm:px-6 py-6 sm:py-8 text-center text-sm text-slate-500">
                                @lang('No items found')
                            </td>
                        </tr>
                    @endif
                </tbody>
                <tfoot class="border-t border-white/10 bg-white/[0.02]">
                    <tr>
                        <td class="px-4 sm:px-6 py-3 sm:py-4 text-right">
                            <span class="text-xs sm:text-sm font-semibold text-slate-400">@lang('Subtotal')</span>
                        </td>
                        <td class="px-4 sm:px-6 py-3 sm:py-4 text-right">
                            <span class="text-xs sm:text-sm font-semibold text-white">{{ showAmount($invoice->amount) }}</span>
                        </td>
                    </tr>
                    @if($invoice->tax > 0)
                        <tr>
                            <td class="px-4 sm:px-6 py-3 sm:py-4 text-right">
                                <span class="text-xs sm:text-sm font-semibold text-slate-400">@lang('Tax')</span>
                            </td>
                            <td class="px-4 sm:px-6 py-3 sm:py-4 text-right">
                                <span class="text-xs sm:text-sm font-semibold text-white">{{ showAmount($invoice->tax) }}</span>
                            </td>
                        </tr>
                    @endif
                    @if($invoice->discount > 0)
                        <tr>
                            <td class="px-4 sm:px-6 py-3 sm:py-4 text-right">
                                <span class="text-xs sm:text-sm font-semibold text-slate-400">@lang('Discount')</span>
                            </td>
                            <td class="px-4 sm:px-6 py-3 sm:py-4 text-right">
                                <span class="text-xs sm:text-sm font-semibold text-emerald-400">-{{ showAmount($invoice->discount) }}</span>
                            </td>
                        </tr>
                    @endif
                    <tr class="border-t border-white/10">
                        <td class="px-4 sm:px-6 py-3 sm:py-4 text-right">
                            <span class="text-sm sm:text-base font-bold text-white">@lang('Total')</span>
                        </td>
                        <td class="px-4 sm:px-6 py-3 sm:py-4 text-right">
                            <span class="text-base sm:text-lg font-bold text-primary-400">{{ showAmount($invoice->total) }}</span>
                        </td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </x-admin.card>

    {{-- Payment History --}}
    @if($invoice->deposits->count() > 0)
        <x-admin.card class="mt-4 sm:mt-6" :padding="false">
            <div class="border-b border-white/5 px-4 sm:px-6 py-3 sm:py-4">
                <h3 class="text-base sm:text-lg font-semibold text-white">@lang('Payment History')</h3>
            </div>
            {{-- Desktop Table --}}
            <div class="hidden sm:block overflow-x-auto">
                <table class="w-full">
                    <thead>
                        <tr class="border-b border-white/5 bg-white/[0.02]">
                            <th class="px-6 py-4 text-left">
                                <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Transaction')</span>
                            </th>
                            <th class="px-6 py-4 text-left">
                                <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Gateway')</span>
                            </th>
                            <th class="px-6 py-4 text-center">
                                <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Amount')</span>
                            </th>
                            <th class="px-6 py-4 text-center">
                                <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Date')</span>
                            </th>
                            <th class="px-6 py-4 text-center">
                                <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Status')</span>
                            </th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-white/5">
                        @foreach($invoice->deposits as $deposit)
                            <tr class="transition-all hover:bg-white/[0.02]">
                                <td class="px-6 py-4">
                                    <span class="font-mono text-sm text-white">{{ $deposit->trx }}</span>
                                </td>
                                <td class="px-6 py-4">
                                    <span class="text-sm text-slate-400">{{ $deposit->gateway?->name ?? __('Manual') }}</span>
                                </td>
                                <td class="px-6 py-4 text-center">
                                    <span class="text-sm font-semibold {{ $deposit->amount < 0 ? 'text-red-400' : 'text-emerald-400' }}">
                                        {{ $deposit->amount < 0 ? '-' : '+' }}${{ number_format(abs($deposit->amount), 2) }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 text-center">
                                    <span class="text-sm text-slate-400">{{ $deposit->created_at->format('d M Y H:i') }}</span>
                                </td>
                                <td class="px-6 py-4 text-center">
                                    @php
                                        $depositStatusColors = [
                                            0 => 'bg-amber-500/10 text-amber-400',
                                            1 => 'bg-emerald-500/10 text-emerald-400',
                                            2 => 'bg-red-500/10 text-red-400',
                                        ];
                                        $depositStatusLabels = [
                                            0 => __('Pending'),
                                            1 => __('Completed'),
                                            2 => __('Failed'),
                                        ];
                                    @endphp
                                    <span class="inline-flex items-center gap-1.5 rounded-full px-3 py-1 text-xs font-medium {{ $depositStatusColors[$deposit->status] ?? 'bg-slate-500/10 text-slate-400' }}">
                                        {{ $depositStatusLabels[$deposit->status] ?? __('Unknown') }}
                                    </span>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            {{-- Mobile Card View --}}
            <div class="sm:hidden divide-y divide-white/5">
                @foreach($invoice->deposits as $deposit)
                    @php
                        $depositStatusColors = [
                            0 => 'bg-amber-500/10 text-amber-400',
                            1 => 'bg-emerald-500/10 text-emerald-400',
                            2 => 'bg-red-500/10 text-red-400',
                        ];
                        $depositStatusLabels = [
                            0 => __('Pending'),
                            1 => __('Completed'),
                            2 => __('Failed'),
                        ];
                    @endphp
                    <div class="px-4 py-3 space-y-2">
                        <div class="flex items-center justify-between">
                            <span class="font-mono text-xs text-white truncate max-w-[140px]">{{ $deposit->trx }}</span>
                            <span class="inline-flex items-center gap-1 rounded-full px-2 py-0.5 text-[10px] font-medium {{ $depositStatusColors[$deposit->status] ?? 'bg-slate-500/10 text-slate-400' }}">
                                {{ $depositStatusLabels[$deposit->status] ?? __('Unknown') }}
                            </span>
                        </div>
                        <div class="flex items-center justify-between text-xs">
                            <span class="text-slate-400">{{ $deposit->gateway?->name ?? __('Manual') }}</span>
                            <span class="font-semibold {{ $deposit->amount < 0 ? 'text-red-400' : 'text-emerald-400' }}">
                                {{ $deposit->amount < 0 ? '-' : '+' }}${{ number_format(abs($deposit->amount), 2) }}
                            </span>
                        </div>
                        <div class="text-[10px] text-slate-500">{{ $deposit->created_at->format('d M Y H:i') }}</div>
                    </div>
                @endforeach
            </div>
        </x-admin.card>
    @endif

    {{-- Admin Notes Modal --}}
    <x-admin.modal wire:model="showNotesModal" :title="__('Admin Notes')" maxWidth="lg">
        <div class="space-y-3 sm:space-y-4">
            <p class="text-xs sm:text-sm text-slate-400">@lang('Add internal notes for this invoice. These notes are only visible to administrators.')</p>
            <textarea
                wire:model="adminNotes"
                rows="5"
                class="w-full rounded-xl border border-white/10 bg-white/5 px-3 sm:px-4 py-2.5 sm:py-3 text-base sm:text-sm text-white placeholder-slate-500 transition-all focus:border-primary-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-primary-500/20"
                placeholder="{{ __('Enter admin notes...') }}"
            ></textarea>
        </div>
        <x-slot name="footer">
            <div class="flex flex-col-reverse sm:flex-row gap-2 sm:gap-3 w-full sm:w-auto sm:justify-end">
                <button wire:click="$set('showNotesModal', false)" class="w-full sm:w-auto rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 sm:py-2 text-sm font-medium text-white transition-all hover:bg-white/10 active:scale-[0.98] cursor-pointer min-h-11 sm:min-h-0">
                    @lang('Cancel')
                </button>
                <button wire:click="saveNotes" wire:loading.attr="disabled" wire:loading.class="opacity-50" class="w-full sm:w-auto rounded-xl bg-gradient-to-r from-primary-500 to-primary-600 px-4 py-2.5 sm:py-2 text-sm font-medium text-white shadow-lg shadow-primary-500/25 transition-all hover:shadow-primary-500/40 active:scale-[0.98] cursor-pointer min-h-11 sm:min-h-0">
                    <span wire:loading.remove wire:target="saveNotes">@lang('Save Notes')</span>
                    <span wire:loading wire:target="saveNotes">@lang('Saving...')</span>
                </button>
            </div>
        </x-slot>
    </x-admin.modal>

    {{-- Mark as Paid Modal --}}
    <x-admin.modal wire:model="showMarkPaidModal" :title="__('Mark as Paid')" maxWidth="md">
        <div class="text-center">
            <div class="mx-auto flex h-12 w-12 sm:h-16 sm:w-16 items-center justify-center rounded-xl sm:rounded-2xl bg-emerald-500/10">
                <i class="ph-duotone ph-check-circle text-2xl sm:text-3xl text-emerald-400"></i>
            </div>
            <h3 class="mt-3 sm:mt-4 text-base sm:text-lg font-semibold text-white">@lang('Mark this invoice as paid?')</h3>
            @php $paymentAmount = '$' . number_format($invoice->total, 2); @endphp
            <p class="mt-1.5 sm:mt-2 text-xs sm:text-sm text-slate-400">{{ __('This will record a manual payment of :amount for this invoice.', ['amount' => $paymentAmount]) }}</p>
        </div>
        <x-slot name="footer">
            <div class="flex flex-col-reverse sm:flex-row gap-2 sm:gap-3 w-full sm:w-auto sm:justify-end">
                <button wire:click="$set('showMarkPaidModal', false)" class="w-full sm:w-auto rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 sm:py-2 text-sm font-medium text-white transition-all hover:bg-white/10 active:scale-[0.98] cursor-pointer min-h-11 sm:min-h-0">
                    @lang('No, Cancel')
                </button>
                <button wire:click="markAsPaid" wire:loading.attr="disabled" wire:loading.class="opacity-50" class="w-full sm:w-auto rounded-xl bg-gradient-to-r from-emerald-500 to-emerald-600 px-4 py-2.5 sm:py-2 text-sm font-medium text-white shadow-lg shadow-emerald-500/25 transition-all hover:shadow-emerald-500/40 active:scale-[0.98] cursor-pointer min-h-11 sm:min-h-0">
                    <span wire:loading.remove wire:target="markAsPaid">@lang('Yes, Mark as Paid')</span>
                    <span wire:loading wire:target="markAsPaid">@lang('Processing...')</span>
                </button>
            </div>
        </x-slot>
    </x-admin.modal>

    {{-- Cancel Invoice Modal --}}
    <x-admin.modal wire:model="showCancelModal" :title="__('Cancel Invoice')" maxWidth="md">
        <div class="text-center">
            <div class="mx-auto flex h-12 w-12 sm:h-16 sm:w-16 items-center justify-center rounded-xl sm:rounded-2xl bg-red-500/10">
                <i class="ph-duotone ph-x-circle text-2xl sm:text-3xl text-red-400"></i>
            </div>
            <h3 class="mt-3 sm:mt-4 text-base sm:text-lg font-semibold text-white">@lang('Cancel this invoice?')</h3>
            <p class="mt-1.5 sm:mt-2 text-xs sm:text-sm text-slate-400">@lang('This action cannot be undone. The invoice will be marked as cancelled.')</p>
        </div>
        <x-slot name="footer">
            <div class="flex flex-col-reverse sm:flex-row gap-2 sm:gap-3 w-full sm:w-auto sm:justify-end">
                <button wire:click="$set('showCancelModal', false)" class="w-full sm:w-auto rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 sm:py-2 text-sm font-medium text-white transition-all hover:bg-white/10 active:scale-[0.98] cursor-pointer min-h-11 sm:min-h-0">
                    @lang('No, Keep Invoice')
                </button>
                <button wire:click="cancelInvoice" wire:loading.attr="disabled" wire:loading.class="opacity-50" class="w-full sm:w-auto rounded-xl bg-gradient-to-r from-red-500 to-red-600 px-4 py-2.5 sm:py-2 text-sm font-medium text-white shadow-lg shadow-red-500/25 transition-all hover:shadow-red-500/40 active:scale-[0.98] cursor-pointer min-h-11 sm:min-h-0">
                    <span wire:loading.remove wire:target="cancelInvoice">@lang('Yes, Cancel Invoice')</span>
                    <span wire:loading wire:target="cancelInvoice">@lang('Cancelling...')</span>
                </button>
            </div>
        </x-slot>
    </x-admin.modal>

    {{-- Refund Modal --}}
    <x-admin.modal wire:model="showRefundModal" :title="__('Refund Invoice')" maxWidth="md">
        <div class="space-y-3 sm:space-y-4">
            <div class="text-center">
                <div class="mx-auto flex h-12 w-12 sm:h-16 sm:w-16 items-center justify-center rounded-xl sm:rounded-2xl bg-purple-500/10">
                    <i class="ph-duotone ph-arrow-counter-clockwise text-2xl sm:text-3xl text-purple-400"></i>
                </div>
                <h3 class="mt-3 sm:mt-4 text-base sm:text-lg font-semibold text-white">@lang('Refund this invoice?')</h3>
            </div>

            <div>
                <label class="mb-1.5 sm:mb-2 block text-xs sm:text-sm font-medium text-slate-400">@lang('Refund Amount')</label>
                <div class="relative">
                    <span class="absolute left-3 sm:left-4 top-1/2 -translate-y-1/2 text-slate-500">$</span>
                    <input
                        type="number"
                        wire:model="refundAmount"
                        step="0.01"
                        min="0"
                        max="{{ $invoice->total }}"
                        class="w-full rounded-xl border border-white/10 bg-white/5 py-2.5 pl-7 sm:pl-8 pr-3 sm:pr-4 text-base sm:text-sm text-white placeholder-slate-500 transition-all focus:border-primary-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-primary-500/20"
                    />
                </div>
                <p class="mt-1 text-[10px] sm:text-xs text-slate-500">@lang('Maximum'): ${{ number_format($invoice->total, 2) }}</p>
            </div>

            <div>
                <label class="mb-1.5 sm:mb-2 block text-xs sm:text-sm font-medium text-slate-400">@lang('Reason (Optional)')</label>
                <textarea
                    wire:model="refundReason"
                    rows="3"
                    class="w-full rounded-xl border border-white/10 bg-white/5 px-3 sm:px-4 py-2.5 sm:py-3 text-base sm:text-sm text-white placeholder-slate-500 transition-all focus:border-primary-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-primary-500/20"
                    placeholder="{{ __('Enter refund reason...') }}"
                ></textarea>
            </div>
        </div>
        <x-slot name="footer">
            <div class="flex flex-col-reverse sm:flex-row gap-2 sm:gap-3 w-full sm:w-auto sm:justify-end">
                <button wire:click="$set('showRefundModal', false)" class="w-full sm:w-auto rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 sm:py-2 text-sm font-medium text-white transition-all hover:bg-white/10 active:scale-[0.98] cursor-pointer min-h-11 sm:min-h-0">
                    @lang('Cancel')
                </button>
                <button wire:click="refundInvoice" wire:loading.attr="disabled" wire:loading.class="opacity-50" class="w-full sm:w-auto rounded-xl bg-gradient-to-r from-purple-500 to-purple-600 px-4 py-2.5 sm:py-2 text-sm font-medium text-white shadow-lg shadow-purple-500/25 transition-all hover:shadow-purple-500/40 active:scale-[0.98] cursor-pointer min-h-11 sm:min-h-0">
                    <span wire:loading.remove wire:target="refundInvoice">@lang('Process Refund')</span>
                    <span wire:loading wire:target="refundInvoice">@lang('Processing...')</span>
                </button>
            </div>
        </x-slot>
    </x-admin.modal>
</div>

