<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Invoices')" :subtitle="__('View and manage all client invoices.')" />

    {{-- Stats Cards --}}
    <div class="mt-4 sm:mt-6 grid grid-cols-2 gap-2 sm:gap-4 lg:grid-cols-5">
        {{-- Total Invoices --}}
        <div class="group relative overflow-hidden rounded-xl sm:rounded-2xl border border-white/5 bg-gradient-to-br from-white/5 to-transparent p-3 sm:p-5 transition-all hover:border-white/10 active:scale-[0.98]">
            <div class="flex items-center justify-between gap-2">
                <div class="min-w-0">
                    <p class="text-xs sm:text-sm font-medium text-slate-400 truncate">@lang('Total')</p>
                    <p class="mt-0.5 sm:mt-1 text-lg sm:text-2xl font-bold text-white">{{ number_format($stats['total']) }}</p>
                </div>
                <div class="flex h-10 w-10 sm:h-12 sm:w-12 shrink-0 items-center justify-center rounded-lg sm:rounded-xl bg-gradient-to-br from-blue-500/20 to-cyan-500/20 text-blue-400">
                    <i class="ph-duotone ph-file-text text-lg sm:text-xl"></i>
                </div>
            </div>
        </div>

        {{-- Unpaid --}}
        <div class="group relative overflow-hidden rounded-xl sm:rounded-2xl border border-white/5 bg-gradient-to-br from-white/5 to-transparent p-3 sm:p-5 transition-all hover:border-white/10 active:scale-[0.98]">
            <div class="flex items-center justify-between gap-2">
                <div class="min-w-0">
                    <p class="text-xs sm:text-sm font-medium text-slate-400 truncate">@lang('Unpaid')</p>
                    <p class="mt-0.5 sm:mt-1 text-lg sm:text-2xl font-bold text-amber-400">{{ number_format($stats['unpaid']) }}</p>
                </div>
                <div class="flex h-10 w-10 sm:h-12 sm:w-12 shrink-0 items-center justify-center rounded-lg sm:rounded-xl bg-gradient-to-br from-amber-500/20 to-orange-500/20 text-amber-400">
                    <i class="ph-duotone ph-hourglass text-lg sm:text-xl"></i>
                </div>
            </div>
        </div>

        {{-- Paid --}}
        <div class="group relative overflow-hidden rounded-xl sm:rounded-2xl border border-white/5 bg-gradient-to-br from-white/5 to-transparent p-3 sm:p-5 transition-all hover:border-white/10 active:scale-[0.98]">
            <div class="flex items-center justify-between gap-2">
                <div class="min-w-0">
                    <p class="text-xs sm:text-sm font-medium text-slate-400 truncate">@lang('Paid')</p>
                    <p class="mt-0.5 sm:mt-1 text-lg sm:text-2xl font-bold text-emerald-400">{{ number_format($stats['paid']) }}</p>
                </div>
                <div class="flex h-10 w-10 sm:h-12 sm:w-12 shrink-0 items-center justify-center rounded-lg sm:rounded-xl bg-gradient-to-br from-emerald-500/20 to-green-500/20 text-emerald-400">
                    <i class="ph-duotone ph-check-circle text-lg sm:text-xl"></i>
                </div>
            </div>
        </div>

        {{-- Cancelled --}}
        <div class="group relative overflow-hidden rounded-xl sm:rounded-2xl border border-white/5 bg-gradient-to-br from-white/5 to-transparent p-3 sm:p-5 transition-all hover:border-white/10 active:scale-[0.98]">
            <div class="flex items-center justify-between gap-2">
                <div class="min-w-0">
                    <p class="text-xs sm:text-sm font-medium text-slate-400 truncate">@lang('Cancelled')</p>
                    <p class="mt-0.5 sm:mt-1 text-lg sm:text-2xl font-bold text-slate-400">{{ number_format($stats['cancelled']) }}</p>
                </div>
                <div class="flex h-10 w-10 sm:h-12 sm:w-12 shrink-0 items-center justify-center rounded-lg sm:rounded-xl bg-gradient-to-br from-slate-500/20 to-slate-600/20 text-slate-400">
                    <i class="ph-duotone ph-x-circle text-lg sm:text-xl"></i>
                </div>
            </div>
        </div>

        {{-- Total Revenue --}}
        <div class="col-span-2 lg:col-span-1 group relative overflow-hidden rounded-xl sm:rounded-2xl border border-white/5 bg-gradient-to-br from-white/5 to-transparent p-3 sm:p-5 transition-all hover:border-white/10 active:scale-[0.98]">
            <div class="flex items-center justify-between gap-2">
                <div class="min-w-0">
                    <p class="text-xs sm:text-sm font-medium text-slate-400 truncate">@lang('Revenue')</p>
                    <p class="mt-0.5 sm:mt-1 text-lg sm:text-2xl font-bold text-primary-400 truncate">${{ number_format($stats['total_amount'], 2) }}</p>
                </div>
                <div class="flex h-10 w-10 sm:h-12 sm:w-12 shrink-0 items-center justify-center rounded-lg sm:rounded-xl bg-gradient-to-br from-primary-500/20 to-primary-600/20 text-primary-400">
                    <i class="ph-duotone ph-currency-dollar text-lg sm:text-xl"></i>
                </div>
            </div>
        </div>
    </div>

    {{-- Filters --}}
    <x-admin.card class="mt-4 sm:mt-6">
        <div class="flex flex-col gap-3 sm:gap-4 sm:flex-row sm:items-center sm:justify-between">
            {{-- Search --}}
            <div class="relative w-full sm:w-80">
                <i class="ph-duotone ph-magnifying-glass absolute left-3 top-1/2 -translate-y-1/2 text-slate-500"></i>
                <input
                    type="text"
                    wire:model.live.debounce.300ms="search"
                    placeholder="{{ __('Search invoices...') }}"
                    class="w-full rounded-xl border border-white/10 bg-white/5 py-3 sm:py-2.5 pl-10 pr-10 text-base sm:text-sm text-white placeholder-slate-500 transition-all focus:border-primary-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-primary-500/20"
                />
                @if($search)
                    <button wire:click="$set('search', '')" class="absolute right-3 top-1/2 -translate-y-1/2 text-slate-500 transition-colors hover:text-white cursor-pointer p-1 min-h-11 min-w-11 flex items-center justify-center -mr-2">
                        <i class="ph-bold ph-x text-sm"></i>
                    </button>
                @endif
            </div>

            {{-- Status Filter --}}
            <select
                wire:model.live="status"
                class="w-full sm:w-auto rounded-xl border border-white/10 bg-white/5 px-4 py-3 sm:py-2.5 text-base sm:text-sm text-white focus:border-primary-500/50 focus:outline-none focus:ring-2 focus:ring-primary-500/20 cursor-pointer"
            >
                @foreach($this->statusOptions as $value => $label)
                    <option value="{{ $value }}" class="bg-[#12121a]">{{ __($label) }}</option>
                @endforeach
            </select>
        </div>
    </x-admin.card>

    {{-- Invoices Table (Desktop) / Cards (Mobile) --}}
    <x-admin.card class="mt-4 sm:mt-6" :padding="false">
        {{-- Desktop Table View --}}
        <div class="hidden md:block overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-white/5 bg-white/5">
                        <th class="px-4 lg:px-6 py-3 text-left">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Invoice #')</span>
                        </th>
                        <th class="px-4 lg:px-6 py-3 text-left">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Client')</span>
                        </th>
                        <th class="px-4 lg:px-6 py-3 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Amount')</span>
                        </th>
                        <th class="px-4 lg:px-6 py-3 text-center hidden lg:table-cell">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Due Date')</span>
                        </th>
                        <th class="px-4 lg:px-6 py-3 text-center hidden xl:table-cell">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Paid Date')</span>
                        </th>
                        <th class="px-4 lg:px-6 py-3 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Status')</span>
                        </th>
                        <th class="px-4 lg:px-6 py-3 text-right">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Actions')</span>
                        </th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    @forelse($invoices as $invoice)
                        <tr class="group transition-all hover:bg-white/5" wire:key="invoice-{{ $invoice->id }}">
                            <td class="px-4 lg:px-6 py-3">
                                <span class="font-medium text-white">#{{ $invoice->invoice_number ?? $invoice->id }}</span>
                            </td>
                            <td class="px-4 lg:px-6 py-3">
                                <div class="flex items-center gap-3">
                                    <div class="flex h-9 w-9 shrink-0 items-center justify-center rounded-xl bg-gradient-to-br from-blue-500/20 to-cyan-500/20 text-blue-400">
                                        <span class="text-sm font-bold">{{ strtoupper(substr($invoice->user?->firstname ?? 'U', 0, 1)) }}</span>
                                    </div>
                                    <div class="min-w-0">
                                        <p class="font-medium text-white truncate">{{ $invoice->user?->fullname ?? __('Unknown') }}</p>
                                        @if($invoice->user)
                                            <a href="{{ route('admin.users.detail', $invoice->user->username) }}" class="text-xs text-primary-400 hover:underline truncate block">
                                                {{ '@' . $invoice->user->username }}
                                            </a>
                                        @endif
                                    </div>
                                </div>
                            </td>
                            <td class="px-4 lg:px-6 py-3 text-center">
                                <span class="font-semibold text-white text-sm">${{ number_format($invoice->total, 2) }}</span>
                                @if($invoice->balance_due > 0 && $invoice->status === \App\Models\Invoice::STATUS_UNPAID)
                                    <p class="text-xs text-amber-400">@lang('Due'): ${{ number_format($invoice->balance_due, 2) }}</p>
                                @endif
                            </td>
                            <td class="px-4 lg:px-6 py-3 text-center hidden lg:table-cell">
                                @if($invoice->due_date)
                                    @php
                                        $dueDate = \Carbon\Carbon::parse($invoice->due_date);
                                        $isOverdue = $dueDate->isPast() && $invoice->status === \App\Models\Invoice::STATUS_UNPAID;
                                    @endphp
                                    <span class="text-sm {{ $isOverdue ? 'text-red-400' : 'text-slate-400' }}">{{ $dueDate->format('d M Y') }}</span>
                                    @if($isOverdue)
                                        <p class="text-xs text-red-400">@lang('Overdue')</p>
                                    @endif
                                @else
                                    <span class="text-sm text-slate-600">—</span>
                                @endif
                            </td>
                            <td class="px-4 lg:px-6 py-3 text-center hidden xl:table-cell">
                                @if($invoice->date_paid)
                                    <span class="text-sm text-emerald-400">{{ \Carbon\Carbon::parse($invoice->date_paid)->format('d M Y') }}</span>
                                @else
                                    <span class="text-sm text-slate-600">—</span>
                                @endif
                            </td>
                            <td class="px-4 lg:px-6 py-3 text-center">
                                @php
                                    $statusColors = [
                                        \App\Models\Invoice::STATUS_UNPAID => 'bg-amber-500/10 text-amber-400',
                                        \App\Models\Invoice::STATUS_PAID => 'bg-emerald-500/10 text-emerald-400',
                                        \App\Models\Invoice::STATUS_CANCELLED => 'bg-slate-500/10 text-slate-400',
                                        \App\Models\Invoice::STATUS_REFUNDED => 'bg-purple-500/10 text-purple-400',
                                    ];
                                @endphp
                                <span class="inline-flex items-center gap-1.5 rounded-full px-2.5 py-1 text-xs font-medium {{ $statusColors[$invoice->status] ?? 'bg-slate-500/10 text-slate-400' }}">
                                    <span class="h-1.5 w-1.5 rounded-full bg-current"></span>
                                    {{ __($invoice->status_label) }}
                                </span>
                            </td>
                            <td class="px-4 lg:px-6 py-3 text-right">
                                <a href="{{ route('admin.invoices.details', $invoice->id) }}" class="inline-flex items-center gap-1.5 rounded-lg bg-white/5 px-3 py-1.5 text-sm font-medium text-white transition-colors hover:bg-white/10 cursor-pointer">
                                    <i class="ph-duotone ph-eye text-sm"></i>
                                    <span class="hidden lg:inline">@lang('Details')</span>
                                </a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="px-6 py-12 text-center">
                                <div class="flex flex-col items-center">
                                    <div class="flex h-14 w-14 items-center justify-center rounded-2xl bg-white/5">
                                        <i class="ph-duotone ph-file-text text-2xl text-slate-500"></i>
                                    </div>
                                    <h3 class="mt-3 text-base font-medium text-white">@lang('No invoices found')</h3>
                                    <p class="mt-1 text-sm text-slate-500">
                                        @if($search || $status)
                                            @lang('No invoices match your filters.')
                                        @else
                                            @lang('Invoices will appear here once generated.')
                                        @endif
                                    </p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        {{-- Mobile Card View --}}
        <div class="md:hidden divide-y divide-white/5">
            @forelse($invoices as $invoice)
                @php
                    $statusColors = [
                        \App\Models\Invoice::STATUS_UNPAID => 'bg-amber-500/10 text-amber-400',
                        \App\Models\Invoice::STATUS_PAID => 'bg-emerald-500/10 text-emerald-400',
                        \App\Models\Invoice::STATUS_CANCELLED => 'bg-slate-500/10 text-slate-400',
                        \App\Models\Invoice::STATUS_REFUNDED => 'bg-purple-500/10 text-purple-400',
                    ];
                    $dueDate = $invoice->due_date ? \Carbon\Carbon::parse($invoice->due_date) : null;
                    $isOverdue = $dueDate && $dueDate->isPast() && $invoice->status === \App\Models\Invoice::STATUS_UNPAID;
                @endphp
                <a href="{{ route('admin.invoices.details', $invoice->id) }}" class="block p-4 active:bg-white/5" wire:key="invoice-mobile-{{ $invoice->id }}">
                    <div class="flex items-start justify-between gap-3">
                        <div class="flex items-center gap-3 min-w-0 flex-1">
                            <div class="flex h-10 w-10 shrink-0 items-center justify-center rounded-xl bg-gradient-to-br from-blue-500/20 to-cyan-500/20 text-blue-400">
                                <span class="text-sm font-bold">{{ strtoupper(substr($invoice->user?->firstname ?? 'U', 0, 1)) }}</span>
                            </div>
                            <div class="min-w-0 flex-1">
                                <p class="font-medium text-white truncate">{{ $invoice->user?->fullname ?? __('Unknown') }}</p>
                                <p class="text-xs text-slate-500">#{{ $invoice->invoice_number ?? $invoice->id }}</p>
                            </div>
                        </div>
                        <div class="text-right shrink-0">
                            <p class="font-semibold text-white">${{ number_format($invoice->total, 2) }}</p>
                            <span class="inline-flex items-center gap-1 rounded-full px-2 py-0.5 text-xs font-medium {{ $statusColors[$invoice->status] ?? 'bg-slate-500/10 text-slate-400' }}">
                                <span class="h-1 w-1 rounded-full bg-current"></span>
                                {{ __($invoice->status_label) }}
                            </span>
                        </div>
                    </div>
                    @if($dueDate)
                        <div class="mt-2 flex items-center justify-between text-xs">
                            <span class="text-slate-500">@lang('Due'): {{ $dueDate->format('d M Y') }}</span>
                            @if($isOverdue)
                                <span class="text-red-400 font-medium">@lang('Overdue')</span>
                            @elseif($invoice->date_paid)
                                <span class="text-emerald-400">@lang('Paid'): {{ \Carbon\Carbon::parse($invoice->date_paid)->format('d M Y') }}</span>
                            @endif
                        </div>
                    @endif
                </a>
            @empty
                <div class="px-4 py-12 text-center">
                    <div class="flex flex-col items-center">
                        <div class="flex h-14 w-14 items-center justify-center rounded-2xl bg-white/5">
                            <i class="ph-duotone ph-file-text text-2xl text-slate-500"></i>
                        </div>
                        <h3 class="mt-3 text-base font-medium text-white">@lang('No invoices found')</h3>
                        <p class="mt-1 text-sm text-slate-500">
                            @if($search || $status)
                                @lang('No invoices match your filters.')
                            @else
                                @lang('Invoices will appear here once generated.')
                            @endif
                        </p>
                    </div>
                </div>
            @endforelse
        </div>

        {{-- Pagination --}}
        @if($invoices->hasPages())
            <div class="border-t border-white/5 px-4 sm:px-6 py-3 sm:py-4">
                {{ $invoices->links() }}
            </div>
        @endif
    </x-admin.card>
</div>

