<div class="space-y-6">
    <!-- Page Header -->
    @php $pageSubtitle = __('Invoice') . ' #' . $invoice->invoice_number; @endphp
    <x-admin.page-header
        :title="__('Payment Transactions')"
        :subtitle="$pageSubtitle"
    >
        <x-slot:actions>
            <a href="{{ route('admin.invoices.details', $invoice->id) }}" class="inline-flex items-center gap-2 rounded-xl bg-white/5 px-4 py-2.5 text-sm font-medium text-slate-300 transition-all hover:bg-white/10 hover:text-white">
                <i class="ph-bold ph-arrow-left text-base"></i>
                @lang('Back to Invoice')
            </a>
        </x-slot:actions>
    </x-admin.page-header>

    <!-- Invoice Summary -->
    <x-admin.card>
        <div class="grid gap-6 sm:grid-cols-4">
            <div>
                <div class="text-sm text-slate-400">@lang('Invoice Number')</div>
                <div class="mt-1 text-lg font-semibold text-white">#{{ $invoice->invoice_number }}</div>
            </div>
            <div>
                <div class="text-sm text-slate-400">@lang('Client')</div>
                <div class="mt-1 text-lg font-semibold text-white">{{ $invoice->user->fullname }}</div>
            </div>
            <div>
                <div class="text-sm text-slate-400">@lang('Amount')</div>
                <div class="mt-1 text-lg font-semibold text-white">{{ showAmount($invoice->amount) }}</div>
            </div>
            <div>
                <div class="text-sm text-slate-400">@lang('Status')</div>
                <div class="mt-1">
                    <span class="inline-flex items-center rounded-full px-2.5 py-1 text-xs font-medium {{ $invoice->status == 1 ? 'bg-emerald-500/10 text-emerald-400' : 'bg-amber-500/10 text-amber-400' }}">
                        {{ __($invoice->status_label) }}
                    </span>
                </div>
            </div>
        </div>
    </x-admin.card>

    <!-- Transactions Table -->
    <x-admin.card :title="__('Payment Transactions')">
        @if($transactions->count() > 0)
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead>
                        <tr class="border-b border-white/5 text-left text-xs font-medium uppercase tracking-wider text-slate-400">
                            <th class="px-4 py-3">@lang('Transaction ID')</th>
                            <th class="px-4 py-3">@lang('Type')</th>
                            <th class="px-4 py-3">@lang('Amount')</th>
                            <th class="px-4 py-3">@lang('Charge')</th>
                            <th class="px-4 py-3">@lang('Post Balance')</th>
                            <th class="px-4 py-3">@lang('Date')</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-white/5">
                        @foreach($transactions as $transaction)
                            <tr class="transition-colors hover:bg-white/[0.02]">
                                <td class="px-4 py-4">
                                    <span class="font-mono text-sm text-white">{{ $transaction->trx }}</span>
                                </td>
                                <td class="px-4 py-4">
                                    <span class="inline-flex items-center rounded-full px-2.5 py-1 text-xs font-medium {{ $transaction->trx_type == '+' ? 'bg-emerald-500/10 text-emerald-400' : 'bg-rose-500/10 text-rose-400' }}">
                                        {{ $transaction->trx_type == '+' ? __('Credit') : __('Debit') }}
                                    </span>
                                </td>
                                <td class="px-4 py-4 text-sm text-white">{{ showAmount($transaction->amount) }}</td>
                                <td class="px-4 py-4 text-sm text-slate-400">{{ showAmount($transaction->charge) }}</td>
                                <td class="px-4 py-4 text-sm text-white">{{ showAmount($transaction->post_balance) }}</td>
                                <td class="px-4 py-4 text-sm text-slate-400">{{ $transaction->created_at->format('M d, Y H:i') }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="mt-4">
                {{ $transactions->links() }}
            </div>
        @else
            <div class="py-12 text-center">
                <i class="ph-duotone ph-receipt text-5xl text-slate-600"></i>
                <p class="mt-4 text-slate-400">@lang('No payment transactions found for this invoice.')</p>
            </div>
        @endif
    </x-admin.card>
</div>

