<div x-data="articleEditor()">
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Edit Article')" :subtitle="$article->title">
        <x-slot:actions>
            <x-admin.button href="{{ route('admin.kb.articles') }}" variant="secondary" icon="ph-arrow-left">
                @lang('Back to Articles')
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    <div class="mt-6">
        <form wire:submit="save" class="grid grid-cols-1 gap-6 xl:grid-cols-3">
            {{-- Main Content --}}
            <div class="space-y-6 xl:col-span-2">
                <x-admin.card :title="__('Article Content')" :subtitle="__('Edit article title and main content.')">
                    <div class="space-y-4">
                        <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                            <x-admin.input wire:model.live="title" :label="__('Article Title')" required />
                            <x-admin.input wire:model="slug" :label="__('Slug')" required />
                        </div>

                        <div wire:ignore>
                            <label class="mb-2 block text-sm font-medium text-slate-300">@lang('Content')</label>
                            <textarea id="kb-editor" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-white focus:border-indigo-500/50 focus:outline-none min-h-[500px]"></textarea>
                        </div>
                        @error('content') <span class="text-xs text-rose-400 mt-1">{{ $message }}</span> @enderror
                    </div>
                </x-admin.card>

                <x-admin.card :title="__('SEO Settings')" :subtitle="__('Optimize your article for search engines.')">
                    <div class="space-y-4">
                        <x-admin.input wire:model="meta_title" :label="__('Meta Title')" />
                        <x-admin.textarea wire:model="meta_description" :label="__('Meta Description')" rows="3" />
                    </div>
                </x-admin.card>
            </div>

            {{-- Sidebar Settings --}}
            <div class="space-y-6">
                <x-admin.card :title="__('Publishing')">
                    <div class="space-y-4">
                        <x-admin.select wire:model="category_id" :label="__('Category')" required>
                            <option value="">@lang('Select Category')</option>
                            @foreach($categories as $category)
                                <option value="{{ $category->id }}">{{ $category->name }}</option>
                            @endforeach
                        </x-admin.select>

                        <div class="flex items-center justify-between rounded-xl bg-white/5 p-4">
                            <div>
                                <p class="text-sm font-medium text-white">@lang('Published')</p>
                                <p class="text-xs text-slate-500">@lang('Available on frontend')</p>
                            </div>
                            <x-admin.toggle wire:model="status" />
                        </div>

                        <div class="flex items-center justify-between rounded-xl bg-white/5 p-4">
                            <div>
                                <p class="text-sm font-medium text-white">@lang('Mark as Popular')</p>
                                <p class="text-xs text-slate-500">@lang('Feature on KB home')</p>
                            </div>
                            <x-admin.toggle wire:model="is_popular" />
                        </div>

                        <div class="rounded-xl border border-white/10 bg-white/5 p-4">
                            <div class="flex items-center gap-3">
                                <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-indigo-500/10 text-indigo-400">
                                    <i class="ph-duotone ph-eye text-xl"></i>
                                </div>
                                <div>
                                    <p class="text-xs text-slate-500">@lang('Total Views')</p>
                                    <p class="text-lg font-mono font-semibold text-white">{{ number_format($article->views) }}</p>
                                </div>
                            </div>
                        </div>

                        <div class="flex flex-col gap-3 pt-2">
                            <x-admin.button type="submit" class="w-full" size="lg" icon="ph-floppy-disk">
                                @lang('Save Changes')
                            </x-admin.button>
                            <x-admin.button href="{{ route('admin.kb.articles') }}" variant="secondary" class="w-full">
                                @lang('Cancel')
                            </x-admin.button>
                        </div>
                    </div>
                </x-admin.card>
            </div>
        </form>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/tinymce/6.8.2/tinymce.min.js"></script>
    <script>
        function articleEditor() {
            return {
                init() {
                    let self = this;
                    tinymce.init({
                        selector: '#kb-editor',
                        height: 600,
                        skin: 'oxide-dark',
                        content_css: 'dark',
                        plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
                        toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
                        setup: function (ed) {
                            ed.on('init', function () {
                                ed.setContent(@js($content));
                            });
                            ed.on('change keyup', function () {
                                self.$wire.set('content', ed.getContent());
                            });
                        }
                    });
                }
            }
        }
    </script>
</div>