<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Knowledgebase Articles')" :subtitle="__('Manage your help documentation and customer guides.')">
        <x-slot:actions>
            <x-admin.button href="{{ route('admin.kb.articles.create') }}" icon="ph-plus">
                @lang('Add Article')
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    {{-- Statistics Cards --}}
    <div class="mt-6 grid grid-cols-1 gap-4 sm:grid-cols-2 lg:grid-cols-4">
        <x-admin.stat-card icon="ph-article" iconColor="primary" :label="__('Total Articles')" :value="$totalArticles" />
        <x-admin.stat-card icon="ph-check-circle" iconColor="success" :label="__('Published')" :value="$publishedArticles" />
        <x-admin.stat-card icon="ph-notebook" iconColor="warning" :label="__('Drafts')" :value="$draftArticles" />
        <x-admin.stat-card icon="ph-star" iconColor="info" :label="__('Popular')" :value="$popularArticles" />
    </div>

    {{-- Filters Card --}}
    <x-admin.card class="mt-6">
        <div class="flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between">
            {{-- Search --}}
            <div class="relative w-full sm:w-80">
                <i class="ph-duotone ph-magnifying-glass absolute left-3 top-1/2 -translate-y-1/2 text-slate-500"></i>
                <input
                    type="text"
                    wire:model.live.debounce.300ms="search"
                    placeholder="{{ __('Search articles...') }}"
                    class="w-full rounded-xl border border-white/10 bg-white/5 py-2.5 pl-10 pr-4 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                />
                @if($search)
                    <button wire:click="$set('search', '')" class="absolute right-3 top-1/2 -translate-y-1/2 text-slate-500 transition-colors hover:text-white">
                        <i class="ph-bold ph-x text-sm"></i>
                    </button>
                @endif
            </div>

            {{-- Filters --}}
            <div class="flex flex-wrap gap-2">
                <select
                    wire:model.live="category_id"
                    class="rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                >
                    <option value="" class="bg-[#1a1a24]">@lang('All Categories')</option>
                    @foreach($categories as $category)
                        <option value="{{ $category->id }}" class="bg-[#1a1a24]">{{ $category->name }}</option>
                    @endforeach
                </select>
            </div>
        </div>
    </x-admin.card>

    {{-- Articles Table --}}
    <x-admin.card class="mt-6" :padding="false">
        <div class="overflow-x-auto">
            <table class="w-full text-left">
                <thead>
                    <tr class="border-b border-white/5 bg-white/[0.02]">
                        <th class="px-6 py-4">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Article')</span>
                        </th>
                        <th class="px-6 py-4">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Category')</span>
                        </th>
                        <th class="px-6 py-4 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Views')</span>
                        </th>
                        <th class="px-6 py-4 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Status')</span>
                        </th>
                        <th class="px-6 py-4 text-right">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Actions')</span>
                        </th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    @forelse($articles as $article)
                        <tr class="group transition-all hover:bg-white/[0.02]" wire:key="article-{{ $article->id }}">
                            <td class="px-6 py-4">
                                <div class="flex items-center gap-3">
                                    <button wire:click="togglePopular({{ $article->id }})"
                                        class="flex h-8 w-8 items-center justify-center rounded-lg transition-all {{ $article->is_popular ? 'bg-amber-500/10 text-amber-500' : 'bg-white/5 text-slate-500 hover:text-white' }}"
                                        title="@lang('Toggle Popular Status')">
                                        <i class="ph {{ $article->is_popular ? 'ph-fill ph-star' : 'ph-star' }} text-base"></i>
                                    </button>
                                    <div>
                                        <p class="font-medium text-white line-clamp-1">{{ $article->title }}</p>
                                        <p class="text-xs text-slate-500">{{ $article->slug }}</p>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4">
                                <div class="flex items-center gap-2 text-sm text-slate-300">
                                    <i class="ph-duotone {{ $article->category->icon ?? 'ph-folder' }} text-indigo-400"></i>
                                    {{ $article->category->name }}
                                </div>
                            </td>
                            <td class="px-6 py-4 text-center">
                                <span class="rounded-full bg-white/5 px-2.5 py-1 font-mono text-xs text-slate-300">
                                    {{ number_format($article->views) }}
                                </span>
                            </td>
                            <td class="px-6 py-4 text-center">
                                <x-admin.badge :type="$article->status ? 'success' : 'secondary'" size="sm">
                                    {{ $article->status ? __('Published') : __('Draft') }}
                                </x-admin.badge>
                            </td>
                            <td class="px-6 py-4 text-right">
                                <x-admin.action-menu>
                                    <x-admin.action-menu-item href="{{ route('admin.kb.articles.edit', $article->id) }}" icon="ph-pencil">
                                        @lang('Edit Article')
                                    </x-admin.action-menu-item>
                                    <x-admin.action-menu-item wire:click="delete({{ $article->id }})" wire:confirm="{{ __('Are you sure you want to delete this article?') }}" icon="ph-trash" :danger="true">
                                        @lang('Delete Article')
                                    </x-admin.action-menu-item>
                                </x-admin.action-menu>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="px-6 py-16 text-center">
                                <div class="flex flex-col items-center">
                                    <div class="flex h-16 w-16 items-center justify-center rounded-2xl bg-white/5">
                                        <i class="ph-duotone ph-article text-3xl text-slate-500"></i>
                                    </div>
                                    <h3 class="mt-4 text-lg font-medium text-white">@lang('No articles found')</h3>
                                    <p class="mt-1 text-sm text-slate-500">
                                        @if($search || $category_id)
                                            @lang('No articles match your search criteria.')
                                        @else
                                            @lang('Start by writing your first help article.')
                                        @endif
                                    </p>
                                    @if(!$search && !$category_id)
                                        <x-admin.button href="{{ route('admin.kb.articles.create') }}" icon="ph-plus" class="mt-4">
                                            @lang('Add Article')
                                        </x-admin.button>
                                    @endif
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        {{-- Pagination --}}
        @if($articles->hasPages())
            <div class="border-t border-white/5 px-6 py-4">
                {{ $articles->links() }}
            </div>
        @endif
    </x-admin.card>
</div>