<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Knowledgebase Categories')" :subtitle="__('Manage categories to organize your help documentation.')">
        <x-slot:actions>
            <x-admin.button href="{{ route('admin.kb.articles') }}" variant="secondary" icon="ph-article">
                @lang('View Articles')
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    {{-- Statistics Cards --}}
    <div class="mt-6 grid grid-cols-1 gap-4 sm:grid-cols-3">
        <x-admin.stat-card icon="ph-folders" iconColor="primary" :label="__('Total Categories')" :value="$totalCategories" />
        <x-admin.stat-card icon="ph-check-circle" iconColor="success" :label="__('Active Categories')" :value="$activeCategories" />
        <x-admin.stat-card icon="ph-x-circle" iconColor="danger" :label="__('Inactive Categories')" :value="$inactiveCategories" />
    </div>

    <div class="mt-6 grid grid-cols-1 gap-6 xl:grid-cols-3">
        {{-- Categories Table --}}
        <div class="xl:col-span-2">
            <x-admin.card :padding="false">
                {{-- Search/Filters --}}
                <div class="border-b border-white/5 p-4 sm:p-6">
                    <div class="relative w-full sm:w-80">
                        <i class="ph-duotone ph-magnifying-glass absolute left-3 top-1/2 -translate-y-1/2 text-slate-500"></i>
                        <input
                            type="text"
                            wire:model.live.debounce.300ms="search"
                            placeholder="{{ __('Search categories...') }}"
                            class="w-full rounded-xl border border-white/10 bg-white/5 py-2.5 pl-10 pr-4 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                        />
                    </div>
                </div>

                <div class="overflow-x-auto">
                    <table class="w-full text-left">
                        <thead>
                            <tr class="border-b border-white/5 bg-white/[0.02]">
                                <th class="px-6 py-4">
                                    <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Category')</span>
                                </th>
                                <th class="px-6 py-4 text-center">
                                    <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Articles')</span>
                                </th>
                                <th class="px-6 py-4 text-center">
                                    <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Order')</span>
                                </th>
                                <th class="px-6 py-4 text-center">
                                    <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Status')</span>
                                </th>
                                <th class="px-6 py-4 text-right">
                                    <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Actions')</span>
                                </th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-white/5">
                            @forelse($categories as $category)
                                <tr class="group transition-all hover:bg-white/[0.02]" wire:key="category-{{ $category->id }}">
                                    <td class="px-6 py-4">
                                        <div class="flex items-center gap-3">
                                            <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20 text-indigo-400">
                                                <i class="{{ $category->icon ?: 'ph ph-folder' }} text-lg"></i>
                                            </div>
                                            <div>
                                                <p class="font-medium text-white">{{ $category->name }}</p>
                                                <p class="text-xs text-slate-500 line-clamp-1 truncate block max-w-xs">{{ $category->slug }}</p>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="px-6 py-4 text-center">
                                        <span class="rounded-full bg-white/5 px-2.5 py-1 font-mono text-xs text-slate-300">
                                            {{ $category->articles_count ?? $category->articles()->count() }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4 text-center">
                                        <span class="text-sm font-medium text-white">{{ $category->order }}</span>
                                    </td>
                                    <td class="px-6 py-4 text-center">
                                        <x-admin.badge :type="$category->status ? 'success' : 'secondary'" size="sm">
                                            {{ $category->status ? __('Active') : __('Inactive') }}
                                        </x-admin.badge>
                                    </td>
                                    <td class="px-6 py-4 text-right">
                                        <x-admin.action-menu>
                                            <x-admin.action-menu-item wire:click="edit({{ $category->id }})" icon="ph-pencil">
                                                @lang('Edit Category')
                                            </x-admin.action-menu-item>
                                            <x-admin.action-menu-item wire:click="delete({{ $category->id }})" wire:confirm="{{ __('Are you sure? All articles in this category will also be deleted.') }}" icon="ph-trash" :danger="true">
                                                @lang('Delete Category')
                                            </x-admin.action-menu-item>
                                        </x-admin.action-menu>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="px-6 py-16 text-center">
                                        <div class="flex flex-col items-center">
                                            <div class="flex h-16 w-16 items-center justify-center rounded-2xl bg-white/5">
                                                <i class="ph-duotone ph-folder-open text-3xl text-slate-500"></i>
                                            </div>
                                            <h3 class="mt-4 text-lg font-medium text-white">@lang('No categories found')</h3>
                                            <p class="mt-1 text-sm text-slate-500">@lang('Manage your articles by creating your first category.')</p>
                                        </div>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                {{-- Pagination --}}
                @if($categories->hasPages())
                    <div class="border-t border-white/5 px-6 py-4">
                        {{ $categories->links() }}
                    </div>
                @endif
            </x-admin.card>
        </div>

        {{-- Create/Edit Form --}}
        <div class="space-y-6">
            <x-admin.card :title="$is_editing ? __('Edit Category') : __('Create Category')" :subtitle="$is_editing ? __('Update category details.') : __('Add a new knowledgebase category.')">
                <form wire:submit="save" class="space-y-4">
                    <x-admin.input wire:model.live="name" :label="__('Category Name')" :placeholder="__('e.g. Domain Names')" required />
                    <x-admin.input wire:model="slug" :label="__('Slug')" :placeholder="__('e.g. domain-names')" required />
                    
                    <x-admin.textarea wire:model="description" :label="__('Description')" :placeholder="__('Briefly describe this category...')" rows="3" />

                    <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                        <x-admin.input wire:model="icon" :label="__('Icon Class')" :placeholder="__('ph ph-globe')" />
                        <x-admin.input type="number" wire:model="order" :label="__('Display Order')" />
                    </div>

                    <div class="flex items-center justify-between rounded-xl bg-white/5 p-4">
                        <div>
                            <p class="text-sm font-medium text-white">@lang('Active Status')</p>
                            <p class="text-xs text-slate-500">@lang('Show on frontend')</p>
                        </div>
                        <x-admin.toggle wire:model="status" />
                    </div>

                    <div class="flex flex-col gap-3 pt-2">
                        <x-admin.button type="submit" class="w-full" icon="{{ $is_editing ? 'ph-check' : 'ph-plus' }}">
                            {{ $is_editing ? __('Update Category') : __('Create Category') }}
                        </x-admin.button>
                        
                        @if($is_editing)
                            <x-admin.button type="button" variant="secondary" wire:click="resetFields" class="w-full">
                                @lang('Cancel')
                            </x-admin.button>
                        @endif
                    </div>
                </form>
            </x-admin.card>
        </div>
    </div>
</div>