<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('KYC Management')" :subtitle="__('Review and manage user identity verification requests')">
        <x-slot:actions>
            <a href="{{ route('admin.kyc.setting') }}" class="inline-flex items-center gap-2 rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm font-medium text-slate-300 transition-all hover:bg-white/10 hover:text-white">
                <i class="ph-duotone ph-gear"></i>
                @lang('KYC Settings')
            </a>
            @if(count($selectedUsers) > 0 && $status === 'pending')
                <x-admin.button wire:click="bulkApprove" wire:confirm="{{ __('Are you sure you want to approve :count selected KYC requests?', ['count' => count($selectedUsers)]) }}" icon="ph-check-circle" variant="success">
                    @lang('Approve Selected') ({{ count($selectedUsers) }})
                </x-admin.button>
            @endif
        </x-slot:actions>
    </x-admin.page-header>

    {{-- Statistics Cards --}}
    <div class="mt-6 grid grid-cols-1 gap-4 sm:grid-cols-4">
        <x-admin.stat-card
            icon="ph-hourglass"
            iconColor="warning"
            :label="__('Pending Review')"
            :value="$this->stats['pending']"
            :href="'?status=pending'"
            :active="$status === 'pending'"
        />
        <x-admin.stat-card
            icon="ph-seal-check"
            iconColor="success"
            :label="__('Verified')"
            :value="$this->stats['verified']"
            :href="'?status=verified'"
            :active="$status === 'verified'"
        />
        <x-admin.stat-card
            icon="ph-x-circle"
            iconColor="danger"
            :label="__('Rejected')"
            :value="$this->stats['rejected']"
            :href="'?status=rejected'"
            :active="$status === 'rejected'"
        />
        <x-admin.stat-card
            icon="ph-files"
            iconColor="info"
            :label="__('Total Submissions')"
            :value="$this->stats['total']"
        />
    </div>

    {{-- Filters & Search --}}
    <x-admin.card class="mt-6">
        <div class="flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between">
            {{-- Status Tabs --}}
            <div class="flex flex-wrap gap-2">
                @foreach(['pending' => 'Pending', 'verified' => 'Verified', 'rejected' => 'Rejected', 'unverified' => 'Not Submitted'] as $key => $label)
                    <button wire:click="$set('status', '{{ $key }}')"
                        class="rounded-xl px-4 py-2 text-sm font-medium transition-all {{ $status === $key ? 'bg-indigo-500/20 text-indigo-400' : 'bg-white/5 text-slate-400 hover:bg-white/10 hover:text-white' }}">
                        {{ __($label) }}
                        @if($key === 'pending' && $this->stats['pending'] > 0)
                            <span class="ml-1.5 inline-flex h-5 min-w-5 items-center justify-center rounded-full bg-amber-500/20 px-1.5 text-xs text-amber-400">{{ $this->stats['pending'] }}</span>
                        @endif
                    </button>
                @endforeach
            </div>

            {{-- Search --}}
            <div class="relative">
                <i class="ph-duotone ph-magnifying-glass absolute left-3 top-1/2 -translate-y-1/2 text-slate-500"></i>
                <input type="text" wire:model.live.debounce.300ms="search" placeholder="{{ __('Search users...') }}"
                    class="w-full rounded-xl border border-white/10 bg-white/5 py-2.5 pl-10 pr-4 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20 sm:w-64" />
            </div>
        </div>
    </x-admin.card>

    {{-- Users Table --}}
    <x-admin.card class="mt-6 overflow-hidden !p-0">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-white/5 bg-white/5">
                        @if($status === 'pending')
                            <th class="px-4 py-3 text-left">
                                <input type="checkbox" wire:model.live="selectAll" class="rounded border-white/20 bg-white/10 text-indigo-500 focus:ring-indigo-500/20 focus:ring-offset-0" />
                            </th>
                        @endif
                        <th class="px-4 py-3 text-left text-xs font-semibold uppercase tracking-wider text-slate-400">@lang('User')</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold uppercase tracking-wider text-slate-400">@lang('Document Type')</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold uppercase tracking-wider text-slate-400">@lang('Submitted')</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold uppercase tracking-wider text-slate-400">@lang('Status')</th>
                        <th class="px-4 py-3 text-right text-xs font-semibold uppercase tracking-wider text-slate-400">@lang('Actions')</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    @forelse($users as $user)
                        @php
                            $kycData = is_string($user->kyc_data) ? json_decode($user->kyc_data, true) : (array) ($user->kyc_data ?? []);
                            $docType = $kycData['document_type'] ?? 'N/A';
                        @endphp
                        <tr class="transition-colors hover:bg-white/5">
                            @if($status === 'pending')
                                <td class="px-4 py-4">
                                    <input type="checkbox" wire:model.live="selectedUsers" value="{{ $user->id }}" class="rounded border-white/20 bg-white/10 text-indigo-500 focus:ring-indigo-500/20 focus:ring-offset-0" />
                                </td>
                            @endif
                            <td class="px-4 py-4">
                                <div class="flex items-center gap-3">
                                    <div class="flex h-10 w-10 items-center justify-center rounded-full bg-gradient-to-br from-indigo-500/20 to-purple-500/20 text-sm font-semibold text-indigo-400">
                                        {{ strtoupper(substr($user->firstname ?? $user->username, 0, 1)) }}{{ strtoupper(substr($user->lastname ?? '', 0, 1)) }}
                                    </div>
                                    <div>
                                        <p class="font-medium text-white">{{ $user->fullname ?? $user->username }}</p>
                                        <p class="text-sm text-slate-500">{{ $user->email }}</p>
                                    </div>
                                </div>
                            </td>
                            <td class="px-4 py-4">
                                <span class="inline-flex items-center gap-1.5 rounded-lg bg-white/5 px-2.5 py-1 text-sm text-slate-300">
                                    <i class="ph-duotone ph-identification-card"></i>
                                    {{ ucwords(str_replace('_', ' ', $docType)) }}
                                </span>
                            </td>
                            <td class="px-4 py-4 text-sm text-slate-400">
                                @if($user->kyc_submitted_at)
                                    {{ $user->kyc_submitted_at->diffForHumans() }}
                                @elseif(isset($kycData['submitted_at']))
                                    {{ \Carbon\Carbon::parse($kycData['submitted_at'])->diffForHumans() }}
                                @else
                                    <span class="text-slate-600">—</span>
                                @endif
                            </td>
                            <td class="px-4 py-4">
                                @switch($user->kv)
                                    @case(1)
                                        <span class="inline-flex items-center gap-1.5 rounded-full bg-emerald-500/10 px-3 py-1 text-xs font-medium text-emerald-400">
                                            <i class="ph-fill ph-check-circle"></i> @lang('Verified')
                                        </span>
                                        @break
                                    @case(2)
                                        <span class="inline-flex items-center gap-1.5 rounded-full bg-amber-500/10 px-3 py-1 text-xs font-medium text-amber-400">
                                            <i class="ph-fill ph-hourglass"></i> @lang('Pending')
                                        </span>
                                        @break
                                    @case(3)
                                        <span class="inline-flex items-center gap-1.5 rounded-full bg-rose-500/10 px-3 py-1 text-xs font-medium text-rose-400">
                                            <i class="ph-fill ph-x-circle"></i> @lang('Rejected')
                                        </span>
                                        @break
                                    @default
                                        <span class="inline-flex items-center gap-1.5 rounded-full bg-slate-500/10 px-3 py-1 text-xs font-medium text-slate-400">
                                            <i class="ph-fill ph-minus-circle"></i> @lang('Not Submitted')
                                        </span>
                                @endswitch
                            </td>
                            <td class="px-4 py-4">
                                <div class="flex items-center justify-end gap-2">
                                    @if($user->kyc_data)
                                        <x-admin.button variant="ghost" size="sm" wire:click="viewDocuments({{ $user->id }})" icon="ph-eye" title="{{ __('View Documents') }}" />
                                    @endif
                                    @if($user->kv === 2)
                                        <x-admin.button variant="ghost" size="sm" wire:click="approveKyc({{ $user->id }})" icon="ph-check" class="text-emerald-400 hover:text-emerald-300" title="{{ __('Approve') }}" />
                                        <x-admin.button variant="ghost" size="sm" wire:click="openRejectModal({{ $user->id }})" icon="ph-x" class="text-rose-400 hover:text-rose-300" title="{{ __('Reject') }}" />
                                    @endif
                                    <a href="{{ route('admin.users.detail', $user->username) }}" class="rounded-lg p-2 text-slate-400 transition-colors hover:bg-white/10 hover:text-white">
                                        <i class="ph-duotone ph-arrow-square-out"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="{{ $status === 'pending' ? 6 : 5 }}" class="px-4 py-12 text-center">
                                <div class="flex flex-col items-center gap-3">
                                    <div class="flex h-16 w-16 items-center justify-center rounded-full bg-white/5">
                                        <i class="ph-duotone ph-identification-card text-3xl text-slate-600"></i>
                                    </div>
                                    <p class="text-slate-500">@lang('No KYC requests found.')</p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        {{-- Pagination --}}
        @if($users->hasPages())
            <div class="border-t border-white/5 px-4 py-4">
                {{ $users->links() }}
            </div>
        @endif
    </x-admin.card>

    {{-- Document Preview Modal --}}
    @if($showDocumentModal && $previewUserId)
        @php $previewUser = \App\Models\User::find($previewUserId); @endphp
        <div class="fixed inset-0 z-50 flex items-center justify-center bg-black/70 backdrop-blur-sm" wire:click.self="closeDocumentModal">
            <div class="relative max-h-[90vh] w-full max-w-4xl overflow-hidden rounded-2xl border border-white/10 bg-[#1a1a24] shadow-2xl">
                {{-- Modal Header --}}
                <div class="flex items-center justify-between border-b border-white/5 px-6 py-4">
                    <div class="flex items-center gap-4">
                        <div class="flex h-12 w-12 items-center justify-center rounded-full bg-gradient-to-br from-indigo-500/20 to-purple-500/20 text-lg font-semibold text-indigo-400">
                            {{ strtoupper(substr($previewUser->firstname ?? $previewUser->username, 0, 1)) }}{{ strtoupper(substr($previewUser->lastname ?? '', 0, 1)) }}
                        </div>
                        <div>
                            <h3 class="text-lg font-semibold text-white">{{ $previewUser->fullname ?? $previewUser->username }}</h3>
                            <p class="text-sm text-slate-500">{{ $previewUser->email }}</p>
                        </div>
                    </div>
                    <button wire:click="closeDocumentModal" class="rounded-lg p-2 text-slate-400 transition-colors hover:bg-white/10 hover:text-white">
                        <i class="ph-bold ph-x text-xl"></i>
                    </button>
                </div>

                {{-- Modal Body --}}
                <div class="max-h-[60vh] overflow-y-auto p-6">
                    <div class="grid gap-6 md:grid-cols-2">
                        @foreach($previewDocuments as $doc)
                            <div class="rounded-xl border border-white/10 bg-white/5 p-4">
                                <p class="mb-3 text-xs font-semibold uppercase tracking-wider text-slate-500">{{ $doc['name'] }}</p>
                                @if(isset($doc['is_text']) && $doc['is_text'])
                                    <p class="text-white">{{ $doc['value'] }}</p>
                                @elseif(isset($doc['is_image']) && $doc['is_image'])
                                    <a href="{{ $doc['url'] }}" target="_blank" class="block">
                                        <img src="{{ $doc['url'] }}" alt="{{ $doc['name'] }}" class="w-full rounded-lg object-cover transition-transform hover:scale-105" />
                                    </a>
                                @else
                                    <a href="{{ $doc['url'] }}" target="_blank" class="flex items-center gap-3 rounded-lg bg-white/5 p-4 transition-colors hover:bg-white/10">
                                        <i class="ph-duotone ph-file-{{ strtolower($doc['extension']) === 'pdf' ? 'pdf' : 'doc' }} text-3xl text-indigo-400"></i>
                                        <div>
                                            <p class="font-medium text-white">{{ $doc['extension'] }} @lang('Document')</p>
                                            <p class="text-sm text-slate-500">@lang('Click to view')</p>
                                        </div>
                                    </a>
                                @endif
                            </div>
                        @endforeach
                    </div>

                    @if($previewUser->kyc_rejection_reason && $previewUser->kv === 3)
                        <div class="mt-6 rounded-xl border border-rose-500/20 bg-rose-500/10 p-4">
                            <p class="text-xs font-semibold uppercase tracking-wider text-rose-400">@lang('Rejection Reason')</p>
                            <p class="mt-2 text-white">{{ $previewUser->kyc_rejection_reason }}</p>
                        </div>
                    @endif
                </div>

                {{-- Modal Footer --}}
                @if($previewUser->kv === 2)
                    <div class="flex items-center justify-end gap-3 border-t border-white/5 px-6 py-4">
                        <x-admin.button variant="danger" wire:click="openRejectModal({{ $previewUserId }})" icon="ph-x-circle">
                            @lang('Reject')
                        </x-admin.button>
                        <x-admin.button wire:click="approveKyc({{ $previewUserId }})" icon="ph-check-circle">
                            @lang('Approve KYC')
                        </x-admin.button>
                    </div>
                @endif
            </div>
        </div>
    @endif

    {{-- Reject Modal --}}
    @if($showRejectModal)
        <div class="fixed inset-0 z-50 flex items-center justify-center bg-black/70 backdrop-blur-sm" wire:click.self="closeRejectModal">
            <div class="w-full max-w-md rounded-2xl border border-white/10 bg-[#1a1a24] p-6 shadow-2xl">
                <div class="flex items-center gap-4 mb-6">
                    <div class="flex h-12 w-12 items-center justify-center rounded-full bg-rose-500/20">
                        <i class="ph-duotone ph-x-circle text-2xl text-rose-400"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-white">@lang('Reject KYC')</h3>
                        <p class="text-sm text-slate-500">@lang('Provide a reason for rejection')</p>
                    </div>
                </div>

                <div class="space-y-4">
                    <div>
                        <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-2">@lang('Rejection Reason') <span class="text-rose-400">*</span></label>
                        <textarea wire:model="rejectionReason" rows="4" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-3 text-sm text-white placeholder-slate-500 transition-all focus:border-rose-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-rose-500/20" placeholder="{{ __('Explain why the KYC submission was rejected...') }}"></textarea>
                        @error('rejectionReason') <p class="mt-1 text-sm text-rose-400">{{ $message }}</p> @enderror
                    </div>
                </div>

                <div class="mt-6 flex items-center justify-end gap-3">
                    <x-admin.button variant="secondary" wire:click="closeRejectModal">
                        @lang('Cancel')
                    </x-admin.button>
                    <x-admin.button variant="danger" wire:click="confirmReject" icon="ph-x-circle">
                        @lang('Confirm Rejection')
                    </x-admin.button>
                </div>
            </div>
        </div>
    @endif
</div>

