{{-- WordPress-style expandable menu item --}}
@php
    $isExpanded = in_array($item->id, $expandedItems);
    $typeIcons = [
        'link' => 'ph-link',
        'page' => 'ph-file-text',
        'page_link' => 'ph-app-window',
        'route' => 'ph-signpost',
        'divider' => 'ph-minus',
        'dropdown' => 'ph-caret-down',
        'heading' => 'ph-text-h',
    ];
    $typeColors = [
        'link' => 'text-purple-400 bg-purple-500/10',
        'page' => 'text-cyan-400 bg-cyan-500/10',
        'page_link' => 'text-indigo-400 bg-indigo-500/10',
        'route' => 'text-amber-400 bg-amber-500/10',
        'divider' => 'text-slate-400 bg-slate-500/10',
        'dropdown' => 'text-emerald-400 bg-emerald-500/10',
        'heading' => 'text-rose-400 bg-rose-500/10',
    ];
    $typeLabels = [
        'link' => __('Custom Link'),
        'page' => __('CMS Page'),
        'page_link' => __('Client Page'),
        'route' => __('Route'),
        'divider' => __('Divider'),
        'dropdown' => __('Dropdown'),
        'heading' => __('Heading'),
    ];
@endphp

<div class="menu-item-wrapper" wire:key="menu-item-{{ $item->id }}" data-id="{{ $item->id }}" style="margin-left: {{ $depth * 16 }}px;" x-data x-bind:style="window.innerWidth >= 640 ? 'margin-left: {{ $depth * 24 }}px' : 'margin-left: {{ $depth * 12 }}px'">
    {{-- Item Header (Collapsed View) --}}
    <div class="group flex items-center gap-2 p-3 rounded-xl border transition-all {{ $isExpanded ? 'bg-white/5 border-white/10' : 'bg-white/[0.02] border-transparent hover:border-white/5 hover:bg-white/[0.03]' }}">
        {{-- Drag Handle --}}
        <div class="cursor-grab text-slate-500 hover:text-slate-400 mr-2">
            <i class="ph ph-dots-six-vertical text-lg"></i>
        </div>

        {{-- Manual Controls --}}
        <div class="flex items-center gap-0.5 mr-2">
            <button wire:click="moveUp({{ $item->id }})" class="p-1 hover:bg-white/10 rounded text-slate-500 hover:text-white transition-colors" title="@lang('Move Up')">
                <i class="ph ph-caret-up"></i>
            </button>
            <button wire:click="moveDown({{ $item->id }})" class="p-1 hover:bg-white/10 rounded text-slate-500 hover:text-white transition-colors" title="@lang('Move Down')">
                <i class="ph ph-caret-down"></i>
            </button>
            <button wire:click="outdentItem({{ $item->id }})" class="p-1 hover:bg-white/10 rounded text-slate-500 hover:text-white transition-colors {{ !$item->parent_id ? 'opacity-30 cursor-not-allowed' : '' }}" title="@lang('Outdent')" {{ !$item->parent_id ? 'disabled' : '' }}>
                <i class="ph ph-arrow-fat-left"></i>
            </button>
            <button wire:click="indentItem({{ $item->id }})" class="p-1 hover:bg-white/10 rounded text-slate-500 hover:text-white transition-colors" title="@lang('Indent')">
                <i class="ph ph-arrow-fat-right"></i>
            </button>
        </div>

        {{-- Type Icon --}}
        <div class="flex h-7 w-7 shrink-0 items-center justify-center rounded-lg {{ $typeColors[$item->type] ?? 'text-slate-400 bg-slate-500/10' }}">
            <i class="ph-duotone {{ $typeIcons[$item->type] ?? 'ph-link' }} text-sm"></i>
        </div>

        {{-- Label --}}
        <div class="flex-1 min-w-0">
            <div class="flex items-center gap-2">
                @if($item->icon)
                    <i class="ph-duotone {{ $item->icon }} text-slate-400 text-sm"></i>
                @endif
                <span class="text-sm font-medium text-white truncate">{{ $item->label }}</span>
            </div>
            <span class="text-xs text-slate-500">{{ $typeLabels[$item->type] ?? ucfirst($item->type) }}</span>
        </div>

        {{-- Item Badge Preview --}}
        @if($item->badge_source || $item->badge_text)
            @php
                $badgeColorPreview = [
                    'rose' => 'bg-rose-500/20 text-rose-400',
                    'amber' => 'bg-amber-500/20 text-amber-400',
                    'emerald' => 'bg-emerald-500/20 text-emerald-400',
                    'sky' => 'bg-sky-500/20 text-sky-400',
                    'indigo' => 'bg-indigo-500/20 text-indigo-400',
                    'purple' => 'bg-purple-500/20 text-purple-400',
                    'orange' => 'bg-orange-500/20 text-orange-400',
                    'pink' => 'bg-pink-500/20 text-pink-400',
                    'slate' => 'bg-slate-500/20 text-slate-400',
                ];
            @endphp
            <span class="px-2 py-0.5 text-[10px] font-semibold rounded-full {{ $badgeColorPreview[$item->badge_color] ?? $badgeColorPreview['slate'] }}" title="@lang('Badge configured')">
                @if($item->badge_source && $item->badge_source !== 'static')
                    <i class="ph ph-pulse text-[10px]"></i>
                @else
                    {{ $item->badge_text ?: '...' }}
                @endif
            </span>
        @endif

        {{-- Status Badge --}}
        @if(!$item->is_active)
            <span class="px-2 py-0.5 text-xs font-medium text-slate-400 bg-slate-500/10 rounded-full">@lang('Inactive')</span>
        @endif

        {{-- Actions - Always visible on mobile, hover on desktop --}}
        <div class="flex items-center gap-1 sm:opacity-0 sm:group-hover:opacity-100 transition-opacity">
            <button wire:click="toggleItemExpand({{ $item->id }})" class="p-1.5 text-slate-400 hover:text-white hover:bg-white/10 rounded-lg transition-colors touch-manipulation" title="@lang('Edit')">
                <i class="ph ph-pencil-simple text-sm"></i>
            </button>
            <button wire:click="toggleItemActive({{ $item->id }})" class="p-1.5 text-slate-400 hover:text-white hover:bg-white/10 rounded-lg transition-colors touch-manipulation" title="{{ $item->is_active ? __('Disable') : __('Enable') }}">
                <i class="ph ph-{{ $item->is_active ? 'eye' : 'eye-slash' }} text-sm"></i>
            </button>
            <button wire:click="confirmDeleteItem({{ $item->id }})" class="p-1.5 text-slate-400 hover:text-rose-400 hover:bg-rose-500/10 rounded-lg transition-colors touch-manipulation" title="@lang('Delete')">
                <i class="ph ph-trash text-sm"></i>
            </button>
        </div>

        {{-- Expand/Collapse Toggle --}}
        <button wire:click="toggleItemExpand({{ $item->id }})" class="p-1.5 text-slate-400 hover:text-white transition-colors">
            <i class="ph ph-caret-down text-sm transition-transform {{ $isExpanded ? 'rotate-180' : '' }}"></i>
        </button>
    </div>

    {{-- Expanded Edit Panel (WordPress-style) --}}
    @if($isExpanded)
        <div class="mt-1 ml-6 p-4 rounded-xl bg-white/[0.02] border border-white/5 space-y-4">
            {{-- Navigation Label --}}
            <div>
                <label class="block text-xs font-medium text-slate-500 mb-1.5">@lang('Navigation Label')</label>
                <input type="text"
                       value="{{ $item->label }}"
                       wire:change="updateItem({{ $item->id }}, 'label', $event.target.value)"
                       class="w-full rounded-xl border border-white/10 bg-white/5 px-3 py-2 text-sm text-white placeholder-slate-500 focus:border-indigo-500/50 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
            </div>

            {{-- Icon Class --}}
            <div>
                <label class="block text-xs font-medium text-slate-500 mb-1.5">@lang('Icon Class')</label>
                <input type="text"
                       value="{{ $item->icon }}"
                       wire:change="updateItem({{ $item->id }}, 'icon', $event.target.value)"
                       placeholder="ph-duotone ph-house"
                       class="w-full rounded-xl border border-white/10 bg-white/5 px-3 py-2 text-sm text-white placeholder-slate-500 focus:border-indigo-500/50 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
            </div>

            {{-- URL (for link type) --}}
            @if($item->type === 'link')
                <div>
                    <label class="block text-xs font-medium text-slate-500 mb-1.5">@lang('URL')</label>
                    <input type="text"
                           value="{{ $item->url }}"
                           wire:change="updateItem({{ $item->id }}, 'url', $event.target.value)"
                           class="w-full rounded-xl border border-white/10 bg-white/5 px-3 py-2 text-sm text-white placeholder-slate-500 focus:border-indigo-500/50 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                </div>
            @endif

            <div class="grid grid-cols-2 gap-3">
                {{-- Open In --}}
                <div>
                    <label class="block text-xs font-medium text-slate-500 mb-1.5">@lang('Open In')</label>
                    <select wire:change="updateItem({{ $item->id }}, 'target', $event.target.value)" class="w-full rounded-xl border border-white/10 bg-white/5 px-3 py-2 text-sm text-white focus:border-indigo-500/50 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                        <option value="_self" {{ $item->target === '_self' ? 'selected' : '' }} class="bg-[#1a1a24]">@lang('Same Tab')</option>
                        <option value="_blank" {{ $item->target === '_blank' ? 'selected' : '' }} class="bg-[#1a1a24]">@lang('New Tab')</option>
                    </select>
                </div>

                {{-- Visibility --}}
                <div>
                    <label class="block text-xs font-medium text-slate-500 mb-1.5">@lang('Visibility')</label>
                    <select wire:change="updateItem({{ $item->id }}, 'visibility', $event.target.value)" class="w-full rounded-xl border border-white/10 bg-white/5 px-3 py-2 text-sm text-white focus:border-indigo-500/50 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                        <option value="all" {{ $item->visibility === 'all' ? 'selected' : '' }} class="bg-[#1a1a24]">@lang('Everyone')</option>
                        <option value="guest" {{ $item->visibility === 'guest' ? 'selected' : '' }} class="bg-[#1a1a24]">@lang('Guests Only')</option>
                        <option value="auth" {{ $item->visibility === 'auth' ? 'selected' : '' }} class="bg-[#1a1a24]">@lang('Logged In Only')</option>
                    </select>
                </div>
            </div>

            {{-- Badge Configuration --}}
            <div class="p-3 rounded-xl bg-white/[0.02] border border-white/5">
                <div class="flex items-center gap-2 mb-3">
                    <i class="ph-duotone ph-number-circle-three text-slate-500"></i>
                    <span class="text-xs font-medium text-slate-400">@lang('Badge')</span>
                </div>
                <div class="grid grid-cols-2 gap-3">
                    {{-- Badge Source --}}
                    <div>
                        <label class="block text-xs font-medium text-slate-500 mb-1.5">@lang('Badge Source')</label>
                        <select wire:change="updateItem({{ $item->id }}, 'badge_source', $event.target.value)" class="w-full rounded-xl border border-white/10 bg-white/5 px-3 py-2 text-sm text-white focus:border-indigo-500/50 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                            @foreach(app(\App\Services\MenuBadgeService::class)->getAvailableSources() as $source => $label)
                                <option value="{{ $source }}" {{ $item->badge_source === $source ? 'selected' : '' }} class="bg-[#1a1a24]">{{ $label }}</option>
                            @endforeach
                        </select>
                    </div>
                    {{-- Badge Color --}}
                    <div>
                        <label class="block text-xs font-medium text-slate-500 mb-1.5">@lang('Badge Color')</label>
                        <select wire:change="updateItem({{ $item->id }}, 'badge_color', $event.target.value)" class="w-full rounded-xl border border-white/10 bg-white/5 px-3 py-2 text-sm text-white focus:border-indigo-500/50 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                            @foreach(app(\App\Services\MenuBadgeService::class)->getBadgeColors() as $color => $label)
                                <option value="{{ $color }}" {{ $item->badge_color === $color ? 'selected' : '' }} class="bg-[#1a1a24]">{{ $label }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                @if($item->badge_source === 'static' || empty($item->badge_source))
                    <div class="mt-3">
                        <label class="block text-xs font-medium text-slate-500 mb-1.5">@lang('Static Badge Text')</label>
                        <input type="text"
                               value="{{ $item->badge_text }}"
                               wire:change="updateItem({{ $item->id }}, 'badge_text', $event.target.value)"
                               placeholder="e.g. NEW, 5, Beta"
                               class="w-full rounded-xl border border-white/10 bg-white/5 px-3 py-2 text-sm text-white placeholder-slate-500 focus:border-indigo-500/50 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                    </div>
                @endif
            </div>

            {{-- Advanced Visibility Rules --}}
            @php
                $visibilityRulesService = app(\App\Services\MenuVisibilityRulesService::class);
                $availableRules = $visibilityRulesService->getAvailableRules();
                $currentRules = $item->visibility_rules ?? ['operator' => 'and', 'conditions' => []];
                $hasRules = !empty($currentRules['conditions']);
            @endphp
            <div class="p-3 rounded-xl bg-white/[0.02] border border-white/5" x-data="{ showRules: {{ $hasRules ? 'true' : 'false' }} }">
                <button type="button" @click="showRules = !showRules" class="w-full flex items-center justify-between">
                    <div class="flex items-center gap-2">
                        <i class="ph-duotone ph-funnel text-slate-500"></i>
                        <span class="text-xs font-medium text-slate-400">@lang('Advanced Visibility Rules')</span>
                        @if($hasRules)
                            <span class="px-1.5 py-0.5 text-[10px] font-semibold rounded-full bg-indigo-500/20 text-indigo-400">
                                {{ count($currentRules['conditions']) }} @lang('rules')
                            </span>
                        @endif
                    </div>
                    <i class="ph ph-caret-down text-xs text-slate-500 transition-transform" :class="showRules ? 'rotate-180' : ''"></i>
                </button>

                <div x-show="showRules" x-collapse class="mt-3 space-y-3">
                    <p class="text-[11px] text-slate-500">@lang('Show this menu item only when all/any conditions are met.')</p>

                    {{-- Quick Rules (simplified UI for common rules) --}}
                    <div class="space-y-2">
                        <label class="flex items-center gap-2.5 p-2 rounded-lg hover:bg-white/5 cursor-pointer">
                            <input type="checkbox"
                                   @change="$wire.toggleVisibilityRule({{ $item->id }}, 'has_services', $event.target.checked)"
                                   {{ collect($currentRules['conditions'] ?? [])->contains('type', 'has_services') ? 'checked' : '' }}
                                   class="w-3.5 h-3.5 rounded border-white/20 bg-white/5 text-indigo-500 focus:ring-indigo-500/20">
                            <span class="text-xs text-slate-300">@lang('User has active services')</span>
                        </label>
                        <label class="flex items-center gap-2.5 p-2 rounded-lg hover:bg-white/5 cursor-pointer">
                            <input type="checkbox"
                                   @change="$wire.toggleVisibilityRule({{ $item->id }}, 'kyc_verified', $event.target.checked)"
                                   {{ collect($currentRules['conditions'] ?? [])->contains('type', 'kyc_verified') ? 'checked' : '' }}
                                   class="w-3.5 h-3.5 rounded border-white/20 bg-white/5 text-indigo-500 focus:ring-indigo-500/20">
                            <span class="text-xs text-slate-300">@lang('KYC is verified')</span>
                        </label>
                        <label class="flex items-center gap-2.5 p-2 rounded-lg hover:bg-white/5 cursor-pointer">
                            <input type="checkbox"
                                   @change="$wire.toggleVisibilityRule({{ $item->id }}, 'has_positive_balance', $event.target.checked)"
                                   {{ collect($currentRules['conditions'] ?? [])->contains('type', 'has_positive_balance') ? 'checked' : '' }}
                                   class="w-3.5 h-3.5 rounded border-white/20 bg-white/5 text-indigo-500 focus:ring-indigo-500/20">
                            <span class="text-xs text-slate-300">@lang('Has positive account balance')</span>
                        </label>
                        <label class="flex items-center gap-2.5 p-2 rounded-lg hover:bg-white/5 cursor-pointer">
                            <input type="checkbox"
                                   @change="$wire.toggleVisibilityRule({{ $item->id }}, 'has_unpaid_invoices', $event.target.checked)"
                                   {{ collect($currentRules['conditions'] ?? [])->contains('type', 'has_unpaid_invoices') ? 'checked' : '' }}
                                   class="w-3.5 h-3.5 rounded border-white/20 bg-white/5 text-indigo-500 focus:ring-indigo-500/20">
                            <span class="text-xs text-slate-300">@lang('Has unpaid invoices')</span>
                        </label>
                    </div>

                    @if($hasRules)
                        <button type="button"
                                wire:click="clearVisibilityRules({{ $item->id }})"
                                class="text-xs text-rose-400 hover:text-rose-300 transition-colors">
                            <i class="ph ph-x-circle mr-1"></i>
                            @lang('Clear all rules')
                        </button>
                    @endif
                </div>
            </div>

            {{-- CSS Classes --}}
            <div>
                <label class="block text-xs font-medium text-slate-500 mb-1.5">@lang('CSS Classes') <span class="text-slate-600">(@lang('optional'))</span></label>
                <input type="text"
                       value="{{ $item->css_class }}"
                       wire:change="updateItem({{ $item->id }}, 'css_class', $event.target.value)"
                       class="w-full rounded-xl border border-white/10 bg-white/5 px-3 py-2 text-sm text-white placeholder-slate-500 focus:border-indigo-500/50 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
            </div>

            {{-- Remove Link --}}
            <div class="pt-2 border-t border-white/5">
                <button wire:click="confirmDeleteItem({{ $item->id }})" class="text-xs text-rose-400 hover:text-rose-300 transition-colors">
                    @lang('Remove')
                </button>
            </div>
        </div>
    @endif

    {{-- Nested Children Container --}}
    <div class="mt-1 space-y-1 min-h-[10px] pl-2 border-l border-white/5"
         data-parent-id="{{ $item->id }}"
         x-data="menuSortable()"
         x-init="initSortable()"
         wire:ignore.self>
        @if($item->children)
            @foreach($item->children as $child)
                @include('livewire.admin.menus.menu-builder-item', ['item' => $child, 'depth' => $depth + 1, 'key' => 'menu-item-'.$child->id])
            @endforeach
        @endif
    </div>
</div>

