<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="$menu->name" :subtitle="$this->location?->label() ?? $menu->location">
        <x-slot:actions>
            <div class="flex flex-wrap items-center gap-2">
                {{-- Mobile: Show only icons, Desktop: Show icons + text --}}
                <button wire:click="openDuplicateModal" class="inline-flex items-center justify-center gap-2 px-3 sm:px-4 py-2.5 text-sm font-medium text-slate-300 bg-white/5 border border-white/10 rounded-xl hover:bg-white/10 transition-colors" title="@lang('Duplicate')">
                    <i class="ph ph-copy text-lg"></i>
                    <span class="hidden sm:inline">@lang('Duplicate')</span>
                </button>
                <button wire:click="openVersionsModal" class="inline-flex items-center justify-center gap-2 px-3 sm:px-4 py-2.5 text-sm font-medium text-slate-300 bg-white/5 border border-white/10 rounded-xl hover:bg-white/10 transition-colors" title="@lang('History')">
                    <i class="ph ph-clock-counter-clockwise text-lg"></i>
                    <span class="hidden sm:inline">@lang('History')</span>
                </button>
                <button wire:click="openImportModal" class="inline-flex items-center justify-center gap-2 px-3 sm:px-4 py-2.5 text-sm font-medium text-slate-300 bg-white/5 border border-white/10 rounded-xl hover:bg-white/10 transition-colors" title="@lang('Import')">
                    <i class="ph ph-upload-simple text-lg"></i>
                    <span class="hidden sm:inline">@lang('Import')</span>
                </button>
                <button wire:click="exportMenu" class="inline-flex items-center justify-center gap-2 px-3 sm:px-4 py-2.5 text-sm font-medium text-slate-300 bg-white/5 border border-white/10 rounded-xl hover:bg-white/10 transition-colors disabled:opacity-50" wire:loading.attr="disabled" wire:target="exportMenu" title="@lang('Export')">
                    <i class="ph ph-download-simple text-lg" wire:loading.remove wire:target="exportMenu"></i>
                    <i class="ph ph-spinner animate-spin text-lg" wire:loading wire:target="exportMenu"></i>
                    <span class="hidden sm:inline">@lang('Export')</span>
                </button>
                <button wire:click="confirmReset" class="inline-flex items-center justify-center gap-2 px-3 sm:px-4 py-2.5 text-sm font-medium text-amber-400 bg-amber-500/10 border border-amber-500/20 rounded-xl hover:bg-amber-500/20 transition-colors" title="@lang('Reset')">
                    <i class="ph ph-arrow-counter-clockwise text-lg"></i>
                    <span class="hidden sm:inline">@lang('Reset')</span>
                </button>
                <a href="{{ route('admin.menus.index') }}" wire:navigate class="inline-flex items-center justify-center gap-2 px-3 sm:px-4 py-2.5 text-sm font-medium text-slate-300 bg-white/5 border border-white/10 rounded-xl hover:bg-white/10 transition-colors" title="@lang('Back')">
                    <i class="ph ph-arrow-left text-lg"></i>
                    <span class="hidden sm:inline">@lang('Back')</span>
                </a>
            </div>
        </x-slot:actions>
    </x-admin.page-header>

    {{-- WordPress-style Two Column Layout --}}
    <div class="mt-4 sm:mt-6 grid grid-cols-1 md:grid-cols-12 gap-4 sm:gap-6">

        {{-- Left Column: Add Items Panel (WordPress-style) --}}
        <div class="md:col-span-4 space-y-3">

            {{-- Search Pages --}}
            <div class="relative">
                <i class="ph ph-magnifying-glass absolute left-3 top-1/2 -translate-y-1/2 text-slate-500"></i>
                <input type="text" wire:model.live.debounce.300ms="pageSearch" placeholder="@lang('Search pages...')" class="w-full pl-10 pr-4 py-2.5 rounded-xl border border-white/10 bg-white/5 text-sm text-white placeholder-slate-500 focus:border-indigo-500/50 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
            </div>

            {{-- Client Area Pages by Category --}}
            @foreach($availablePages as $category => $pages)
                @php
                    $isOpen = in_array($category, $openSections);
                    $categoryColors = [
                        'main' => ['bg' => 'bg-indigo-500/10', 'text' => 'text-indigo-400', 'icon' => 'ph-house'],
                        'account' => ['bg' => 'bg-emerald-500/10', 'text' => 'text-emerald-400', 'icon' => 'ph-user-circle'],
                        'quick_actions' => ['bg' => 'bg-amber-500/10', 'text' => 'text-amber-400', 'icon' => 'ph-lightning'],
                        'system' => ['bg' => 'bg-rose-500/10', 'text' => 'text-rose-400', 'icon' => 'ph-gear'],
                    ];
                    $colors = $categoryColors[$category] ?? ['bg' => 'bg-slate-500/10', 'text' => 'text-slate-400', 'icon' => 'ph-folder'];
                @endphp
                <x-admin.card class="overflow-hidden !p-0">
                    <button wire:click="toggleSection('{{ $category }}')" class="w-full flex items-center justify-between p-4 hover:bg-white/[0.02] transition-colors">
                        <div class="flex items-center gap-3">
                            <div class="flex h-8 w-8 shrink-0 items-center justify-center rounded-lg {{ $colors['bg'] }}">
                                <i class="ph-duotone {{ $colors['icon'] }} {{ $colors['text'] }}"></i>
                            </div>
                            <div class="text-left">
                                <span class="font-medium text-white text-sm">{{ $categoryLabels[$category] ?? ucfirst($category) }}</span>
                                <span class="ml-2 text-xs text-slate-500">({{ count($pages) }})</span>
                            </div>
                        </div>
                        <i class="ph ph-caret-down text-slate-400 transition-transform duration-200 {{ $isOpen ? 'rotate-180' : '' }}"></i>
                    </button>

                    @if($isOpen)
                        <div class="px-4 pb-4 border-t border-white/5" wire:key="section-{{ $category }}">
                            <div class="mt-3 max-h-64 overflow-y-auto space-y-1 scrollbar-thin scrollbar-thumb-white/10 scrollbar-track-transparent">
                                @foreach($pages as $page)
                                    <div class="group flex items-center justify-between p-2 rounded-lg hover:bg-white/5 transition-colors">
                                        <label class="flex items-center gap-3 flex-1 cursor-pointer">
                                            <input type="checkbox" wire:model.live="selectedPages" value="{{ $page['key'] }}" class="w-4 h-4 rounded border-white/20 bg-white/5 text-indigo-500 focus:ring-indigo-500/20">
                                            <div class="flex items-center gap-2">
                                                @if(!empty($page['icon']))
                                                    <i class="ph-duotone {{ $page['icon'] }} text-slate-500 text-sm"></i>
                                                @endif
                                                <span class="text-sm text-slate-300">{{ $page['label'] }}</span>
                                            </div>
                                        </label>
                                        <button wire:click="addPage('{{ $page['key'] }}')" wire:loading.attr="disabled" wire:target="addPage('{{ $page['key'] }}')" class="opacity-0 group-hover:opacity-100 p-1.5 text-slate-500 hover:text-indigo-400 hover:bg-indigo-500/10 rounded-lg transition-all disabled:opacity-50" title="@lang('Add to menu')">
                                            <i class="ph ph-plus text-sm" wire:loading.remove wire:target="addPage('{{ $page['key'] }}')"></i>
                                            <i class="ph ph-spinner animate-spin text-sm" wire:loading wire:target="addPage('{{ $page['key'] }}')"></i>
                                        </button>
                                    </div>
                                @endforeach
                            </div>
                            @if(count($pages) > 0)
                                <button wire:click="addSelectedPages" wire:loading.attr="disabled" wire:target="addSelectedPages" class="mt-3 w-full px-3 py-2 text-sm font-medium text-white bg-indigo-500/10 hover:bg-indigo-500/20 border border-indigo-500/20 rounded-xl transition-colors disabled:opacity-50" @if(empty($selectedPages)) disabled @endif>
                                    <span wire:loading.remove wire:target="addSelectedPages">
                                        <i class="ph ph-plus-circle mr-1.5"></i>
                                        @lang('Add Selected')
                                    </span>
                                    <span wire:loading wire:target="addSelectedPages" class="flex items-center justify-center gap-2">
                                        <i class="ph ph-spinner animate-spin"></i>
                                        @lang('Adding...')
                                    </span>
                                </button>
                            @endif
                        </div>
                    @endif
                </x-admin.card>
            @endforeach

            {{-- Custom Links Section --}}
            <x-admin.card class="overflow-hidden !p-0">
                <button wire:click="toggleSection('custom_links')" class="w-full flex items-center justify-between p-4 hover:bg-white/[0.02] transition-colors">
                    <div class="flex items-center gap-3">
                        <div class="flex h-8 w-8 shrink-0 items-center justify-center rounded-lg bg-purple-500/10">
                            <i class="ph-duotone ph-link text-purple-400"></i>
                        </div>
                        <span class="font-medium text-white text-sm">@lang('Custom Links')</span>
                    </div>
                    <i class="ph ph-caret-down text-slate-400 transition-transform duration-200 {{ in_array('custom_links', $openSections) ? 'rotate-180' : '' }}"></i>
                </button>

                @if(in_array('custom_links', $openSections))
                    <div class="px-4 pb-4 border-t border-white/5">
                        <div class="mt-3 space-y-3">
                            <div>
                                <label class="block text-xs font-medium text-slate-500 mb-1.5">@lang('URL')</label>
                                <input type="text" wire:model="customLinkUrl" placeholder="https://" class="w-full rounded-xl border border-white/10 bg-white/5 px-3 py-2 text-sm text-white placeholder-slate-500 focus:border-indigo-500/50 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                            </div>
                            <div>
                                <label class="block text-xs font-medium text-slate-500 mb-1.5">@lang('Link Text')</label>
                                <input type="text" wire:model="customLinkLabel" placeholder="@lang('Menu item label')" class="w-full rounded-xl border border-white/10 bg-white/5 px-3 py-2 text-sm text-white placeholder-slate-500 focus:border-indigo-500/50 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                            </div>
                            <div>
                                <label class="block text-xs font-medium text-slate-500 mb-1.5">@lang('Icon') <span class="text-slate-600">(@lang('optional'))</span></label>
                                <input type="text" wire:model="customLinkIcon" placeholder="ph-star" class="w-full rounded-xl border border-white/10 bg-white/5 px-3 py-2 text-sm text-white placeholder-slate-500 focus:border-indigo-500/50 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                            </div>
                        </div>
                        <button wire:click="addCustomLink" wire:loading.attr="disabled" wire:target="addCustomLink" class="mt-3 w-full px-3 py-2 text-sm font-medium text-white bg-purple-500/10 hover:bg-purple-500/20 border border-purple-500/20 rounded-xl transition-colors disabled:opacity-50">
                            <span wire:loading.remove wire:target="addCustomLink">
                                <i class="ph ph-plus-circle mr-1.5"></i>
                                @lang('Add Custom Link')
                            </span>
                            <span wire:loading wire:target="addCustomLink" class="flex items-center justify-center gap-2">
                                <i class="ph ph-spinner animate-spin"></i>
                                @lang('Adding...')
                            </span>
                        </button>
                    </div>
                @endif
            </x-admin.card>

            {{-- Quick Add --}}
            <x-admin.card class="!p-4">
                <div class="flex items-center gap-3 pb-3 mb-3 border-b border-white/5">
                    <div class="flex h-8 w-8 shrink-0 items-center justify-center rounded-lg bg-slate-500/10">
                        <i class="ph-duotone ph-dots-three text-slate-400"></i>
                    </div>
                    <span class="font-medium text-white text-sm">@lang('Quick Add')</span>
                </div>
                <button wire:click="addDivider" wire:loading.attr="disabled" wire:target="addDivider" class="w-full px-3 py-2 text-sm font-medium text-slate-300 bg-white/5 hover:bg-white/10 border border-white/10 rounded-xl transition-colors disabled:opacity-50">
                    <span wire:loading.remove wire:target="addDivider">
                        <i class="ph ph-minus mr-2"></i> @lang('Add Divider')
                    </span>
                    <span wire:loading wire:target="addDivider" class="flex items-center justify-center gap-2">
                        <i class="ph ph-spinner animate-spin"></i>
                        @lang('Adding...')
                    </span>
                </button>
            </x-admin.card>
        </div>

        {{-- Right Column: Menu Structure --}}
        <div class="md:col-span-8">
            <x-admin.card>
                <div class="flex items-center gap-3 pb-3 sm:pb-4 mb-4 border-b border-white/5">
                    <div class="flex h-9 w-9 sm:h-10 sm:w-10 shrink-0 items-center justify-center rounded-xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20">
                        <i class="ph-duotone ph-tree-structure text-lg sm:text-xl text-indigo-400"></i>
                    </div>
                    <div class="min-w-0 flex-1">
                        <h3 class="font-semibold text-white text-sm sm:text-base">@lang('Menu Structure')</h3>
                        <p class="text-xs text-slate-500">@lang('Drag items to reorder. Click to expand and edit.')</p>
                    </div>
                    <div class="flex items-center gap-2">
                        <span class="px-2.5 py-1 text-xs font-medium text-slate-400 bg-white/5 rounded-lg">
                            {{ $items->count() }} @lang('items')
                        </span>
                        {{-- Help Tooltip --}}
                        <div x-data="{ open: false }" class="relative">
                            <button @click="open = !open" @click.outside="open = false" class="p-1.5 text-slate-500 hover:text-slate-300 hover:bg-white/5 rounded-lg transition-colors" title="@lang('Keyboard Shortcuts')">
                                <i class="ph ph-keyboard text-lg"></i>
                            </button>
                            <div x-show="open" x-transition:enter="transition ease-out duration-150" x-transition:enter-start="opacity-0 scale-95" x-transition:enter-end="opacity-100 scale-100" x-transition:leave="transition ease-in duration-100" x-transition:leave-start="opacity-100 scale-100" x-transition:leave-end="opacity-0 scale-95" class="absolute right-0 top-full mt-2 w-64 p-4 bg-[#12121a] border border-white/10 rounded-xl shadow-2xl z-50">
                                <h4 class="text-sm font-semibold text-white mb-3">@lang('Keyboard Shortcuts')</h4>
                                <div class="space-y-2 text-xs">
                                    <div class="flex items-center justify-between">
                                        <span class="text-slate-400">@lang('Export Menu')</span>
                                        <kbd class="px-1.5 py-0.5 bg-white/5 border border-white/10 rounded text-slate-300">Ctrl+E</kbd>
                                    </div>
                                    <div class="flex items-center justify-between">
                                        <span class="text-slate-400">@lang('Import Menu')</span>
                                        <kbd class="px-1.5 py-0.5 bg-white/5 border border-white/10 rounded text-slate-300">Ctrl+I</kbd>
                                    </div>
                                    <div class="flex items-center justify-between">
                                        <span class="text-slate-400">@lang('Duplicate')</span>
                                        <kbd class="px-1.5 py-0.5 bg-white/5 border border-white/10 rounded text-slate-300">Ctrl+D</kbd>
                                    </div>
                                    <div class="flex items-center justify-between">
                                        <span class="text-slate-400">@lang('History')</span>
                                        <kbd class="px-1.5 py-0.5 bg-white/5 border border-white/10 rounded text-slate-300">Ctrl+H</kbd>
                                    </div>
                                    <div class="flex items-center justify-between">
                                        <span class="text-slate-400">@lang('Close Modal')</span>
                                        <kbd class="px-1.5 py-0.5 bg-white/5 border border-white/10 rounded text-slate-300">Esc</kbd>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Loading Skeleton --}}
                <div wire:loading.delay.longer wire:target="addSelectedPages, addPage, addCustomLink, addDivider, deleteItem, resetToDefault, restoreVersion, importMenu" class="space-y-2">
                    @for($i = 0; $i < 5; $i++)
                        <div class="animate-pulse flex items-center gap-3 p-3 rounded-xl bg-white/5">
                            <div class="w-5 h-5 rounded bg-white/10"></div>
                            <div class="w-8 h-8 rounded-lg bg-white/10"></div>
                            <div class="flex-1 space-y-2">
                                <div class="h-4 bg-white/10 rounded w-1/3"></div>
                                <div class="h-3 bg-white/5 rounded w-1/4"></div>
                            </div>
                        </div>
                    @endfor
                </div>

                {{-- Menu Items --}}
                <div wire:loading.remove.delay.longer wire:target="addSelectedPages, addPage, addCustomLink, addDivider, deleteItem, resetToDefault, restoreVersion, importMenu">
                    @if($items->count() > 0)
                        <div class="space-y-2"
                             x-data="menuSortable()"
                             x-init="initSortable()"
                             wire:ignore.self>
                            @foreach($items as $item)
                                @include('livewire.admin.menus.menu-builder-item', ['item' => $item, 'depth' => 0, 'key' => 'menu-item-'.$item->id])
                            @endforeach
                        </div>
                    @else
                        <div class="text-center py-12">
                            <div class="w-16 h-16 mx-auto mb-4 flex items-center justify-center rounded-2xl bg-white/5 text-slate-500">
                                <i class="ph-duotone ph-list-dashes text-3xl"></i>
                            </div>
                            <h3 class="text-base font-medium text-white mb-1">@lang('No menu items yet')</h3>
                            <p class="text-sm text-slate-500 mb-4">@lang('Add items from the left panel to build your menu.')</p>
                        </div>
                    @endif
                </div>
            </x-admin.card>
        </div>
    </div>

    {{-- Delete Confirmation Modal --}}
    @if($showDeleteModal)
        <div class="fixed inset-0 z-50 overflow-y-auto" aria-modal="true">
            <div class="flex min-h-screen items-center justify-center p-4">
                <div class="fixed inset-0 bg-black/70 backdrop-blur-sm" wire:click="$set('showDeleteModal', false)"></div>

                <div class="relative w-full max-w-sm bg-[#12121a] rounded-2xl shadow-2xl border border-white/10 p-6 text-center">
                    <div class="w-14 h-14 mx-auto mb-4 flex items-center justify-center rounded-full bg-rose-500/10">
                        <i class="ph-duotone ph-trash text-2xl text-rose-400"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-white mb-2">@lang('Delete Item?')</h3>
                    <p class="text-sm text-slate-400 mb-6">@lang('This will also delete all nested items. This action cannot be undone.')</p>

                    <div class="flex justify-center gap-3">
                        <button wire:click="$set('showDeleteModal', false)" class="px-4 py-2.5 text-sm font-medium text-slate-300 bg-white/5 border border-white/10 rounded-xl hover:bg-white/10 transition-colors">@lang('Cancel')</button>
                        <button wire:click="deleteItem" class="px-4 py-2.5 text-sm font-medium text-white bg-rose-600 rounded-xl hover:bg-rose-700 transition-colors">@lang('Delete')</button>
                    </div>
                </div>
            </div>
        </div>
    @endif

    {{-- Reset to Default Confirmation Modal --}}
    @if($showResetModal)
        <div class="fixed inset-0 z-50 overflow-y-auto" aria-modal="true">
            <div class="flex min-h-screen items-center justify-center p-4">
                <div class="fixed inset-0 bg-black/70 backdrop-blur-sm" wire:click="$set('showResetModal', false)"></div>

                <div class="relative w-full max-w-md bg-[#12121a] rounded-2xl shadow-2xl border border-white/10 p-6 text-center">
                    <div class="w-14 h-14 mx-auto mb-4 flex items-center justify-center rounded-full bg-amber-500/10">
                        <i class="ph-duotone ph-arrow-counter-clockwise text-2xl text-amber-400"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-white mb-2">@lang('Reset Menu to Default?')</h3>
                    <p class="text-sm text-slate-400 mb-4">@lang('This will remove all current menu items and restore the default configuration for this location.')</p>
                    <p class="text-xs text-amber-400/80 mb-6">
                        <i class="ph ph-warning mr-1"></i>
                        @lang('This action cannot be undone. Consider exporting your current menu first.')
                    </p>

                    <div class="flex justify-center gap-3">
                        <button wire:click="$set('showResetModal', false)" class="px-4 py-2.5 text-sm font-medium text-slate-300 bg-white/5 border border-white/10 rounded-xl hover:bg-white/10 transition-colors">@lang('Cancel')</button>
                        <button wire:click="resetToDefault" class="px-4 py-2.5 text-sm font-medium text-white bg-amber-600 rounded-xl hover:bg-amber-700 transition-colors">
                            <i class="ph ph-arrow-counter-clockwise mr-1.5"></i>
                            @lang('Reset to Default')
                        </button>
                    </div>
                </div>
            </div>
        </div>
    @endif

    {{-- Import Menu Modal --}}
    @if($showImportModal)
        <div class="fixed inset-0 z-50 overflow-y-auto" aria-modal="true">
            <div class="flex min-h-screen items-center justify-center p-4">
                <div class="fixed inset-0 bg-black/70 backdrop-blur-sm" wire:click="closeImportModal"></div>

                <div class="relative w-full max-w-md bg-[#12121a] rounded-2xl shadow-2xl border border-white/10 p-6">
                    <div class="flex items-center gap-3 mb-5">
                        <div class="w-10 h-10 flex items-center justify-center rounded-xl bg-indigo-500/10">
                            <i class="ph-duotone ph-upload-simple text-xl text-indigo-400"></i>
                        </div>
                        <div>
                            <h3 class="text-lg font-semibold text-white">@lang('Import Menu')</h3>
                            <p class="text-xs text-slate-500">@lang('Upload a JSON file to import menu items')</p>
                        </div>
                    </div>

                    <form wire:submit="importMenu" class="space-y-4">
                        {{-- File Upload --}}
                        <div>
                            <label class="block text-sm font-medium text-slate-300 mb-2">@lang('JSON File')</label>
                            <div class="relative">
                                <input type="file" wire:model="importFile" accept=".json,.txt" class="w-full text-sm text-slate-400 file:mr-4 file:py-2 file:px-4 file:rounded-xl file:border-0 file:text-sm file:font-medium file:bg-indigo-500/10 file:text-indigo-400 hover:file:bg-indigo-500/20 cursor-pointer">
                            </div>
                            @error('importFile') <span class="text-xs text-rose-400 mt-1">{{ $message }}</span> @enderror
                        </div>

                        {{-- Import Mode --}}
                        <div>
                            <label class="block text-sm font-medium text-slate-300 mb-2">@lang('Import Mode')</label>
                            <div class="space-y-2">
                                <label class="flex items-center gap-3 p-3 rounded-xl border border-white/10 hover:bg-white/5 cursor-pointer transition-colors {{ $importMode === 'merge' ? 'bg-indigo-500/10 border-indigo-500/30' : '' }}">
                                    <input type="radio" wire:model="importMode" value="merge" class="w-4 h-4 text-indigo-500 bg-white/5 border-white/20 focus:ring-indigo-500/20">
                                    <div>
                                        <span class="text-sm font-medium text-white">@lang('Merge')</span>
                                        <p class="text-xs text-slate-500">@lang('Add imported items to existing menu')</p>
                                    </div>
                                </label>
                                <label class="flex items-center gap-3 p-3 rounded-xl border border-white/10 hover:bg-white/5 cursor-pointer transition-colors {{ $importMode === 'replace' ? 'bg-rose-500/10 border-rose-500/30' : '' }}">
                                    <input type="radio" wire:model="importMode" value="replace" class="w-4 h-4 text-rose-500 bg-white/5 border-white/20 focus:ring-rose-500/20">
                                    <div>
                                        <span class="text-sm font-medium text-white">@lang('Replace')</span>
                                        <p class="text-xs text-slate-500">@lang('Remove existing items and import new ones')</p>
                                    </div>
                                </label>
                            </div>
                        </div>

                        <div class="flex justify-end gap-3 pt-2">
                            <button type="button" wire:click="closeImportModal" class="px-4 py-2.5 text-sm font-medium text-slate-300 bg-white/5 border border-white/10 rounded-xl hover:bg-white/10 transition-colors">@lang('Cancel')</button>
                            <button type="submit" class="px-4 py-2.5 text-sm font-medium text-white bg-indigo-600 rounded-xl hover:bg-indigo-700 transition-colors" wire:loading.attr="disabled">
                                <span wire:loading.remove wire:target="importMenu">
                                    <i class="ph ph-upload-simple mr-1.5"></i>
                                    @lang('Import')
                                </span>
                                <span wire:loading wire:target="importMenu">
                                    <i class="ph ph-spinner animate-spin mr-1.5"></i>
                                    @lang('Importing...')
                                </span>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endif

    {{-- Version History Modal --}}
    @if($showVersionsModal)
        <div class="fixed inset-0 z-50 overflow-y-auto" aria-modal="true">
            <div class="flex min-h-screen items-center justify-center p-4">
                <div class="fixed inset-0 bg-black/70 backdrop-blur-sm" wire:click="closeVersionsModal"></div>

                <div class="relative w-full max-w-lg bg-[#12121a] rounded-2xl shadow-2xl border border-white/10 p-6">
                    <div class="flex items-center justify-between mb-5">
                        <div class="flex items-center gap-3">
                            <div class="w-10 h-10 flex items-center justify-center rounded-xl bg-violet-500/10">
                                <i class="ph-duotone ph-clock-counter-clockwise text-xl text-violet-400"></i>
                            </div>
                            <div>
                                <h3 class="text-lg font-semibold text-white">@lang('Version History')</h3>
                                <p class="text-xs text-slate-500">@lang('Restore to a previous version')</p>
                            </div>
                        </div>
                        <button wire:click="createVersionSnapshot" class="text-xs text-indigo-400 hover:text-indigo-300 transition-colors">
                            <i class="ph ph-plus mr-1"></i>@lang('Create Snapshot')
                        </button>
                    </div>

                    @if($restoreVersionNumber)
                        {{-- Restore Confirmation --}}
                        <div class="p-4 rounded-xl bg-amber-500/10 border border-amber-500/20 mb-4">
                            <div class="flex items-start gap-3">
                                <i class="ph-duotone ph-warning text-xl text-amber-400 mt-0.5"></i>
                                <div>
                                    <p class="text-sm font-medium text-amber-300">@lang('Restore to Version :version?', ['version' => $restoreVersionNumber])</p>
                                    <p class="text-xs text-amber-400/70 mt-1">@lang('A backup of the current menu will be created before restoring.')</p>
                                    <div class="flex gap-2 mt-3">
                                        <button wire:click="restoreVersion" class="px-3 py-1.5 text-xs font-medium text-white bg-amber-600 rounded-lg hover:bg-amber-700 transition-colors">
                                            @lang('Restore')
                                        </button>
                                        <button wire:click="$set('restoreVersionNumber', null)" class="px-3 py-1.5 text-xs font-medium text-slate-300 bg-white/5 rounded-lg hover:bg-white/10 transition-colors">
                                            @lang('Cancel')
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif

                    <div class="max-h-80 overflow-y-auto space-y-2">
                        @forelse($this->versions as $version)
                            <div class="flex items-center justify-between p-3 rounded-xl bg-white/5 hover:bg-white/[0.07] transition-colors group">
                                <div class="flex items-center gap-3">
                                    <div class="w-8 h-8 flex items-center justify-center rounded-lg bg-slate-500/10 text-xs font-bold text-slate-400">
                                        v{{ $version->version_number }}
                                    </div>
                                    <div>
                                        <p class="text-sm text-white">{{ $version->change_summary ?? __('Menu update') }}</p>
                                        <p class="text-xs text-slate-500">
                                            {{ $version->time_ago }} · {{ $version->changed_by }} · {{ $version->item_count }} @lang('items')
                                        </p>
                                    </div>
                                </div>
                                <button wire:click="confirmRestoreVersion({{ $version->version_number }})" class="px-2.5 py-1.5 text-xs font-medium text-indigo-400 bg-indigo-500/10 rounded-lg opacity-0 group-hover:opacity-100 hover:bg-indigo-500/20 transition-all">
                                    @lang('Restore')
                                </button>
                            </div>
                        @empty
                            <div class="text-center py-8">
                                <i class="ph-duotone ph-clock-counter-clockwise text-4xl text-slate-600 mb-3"></i>
                                <p class="text-sm text-slate-500">@lang('No version history yet.')</p>
                                <p class="text-xs text-slate-600 mt-1">@lang('Versions are created when you make changes.')</p>
                            </div>
                        @endforelse
                    </div>

                    <div class="flex justify-end mt-4 pt-4 border-t border-white/5">
                        <button wire:click="closeVersionsModal" class="px-4 py-2.5 text-sm font-medium text-slate-300 bg-white/5 border border-white/10 rounded-xl hover:bg-white/10 transition-colors">
                            @lang('Close')
                        </button>
                    </div>
                </div>
            </div>
        </div>
    @endif

    {{-- Duplicate Menu Modal --}}
    @if($showDuplicateModal)
        <div class="fixed inset-0 z-50 overflow-y-auto" aria-modal="true">
            <div class="flex min-h-screen items-center justify-center p-4">
                <div class="fixed inset-0 bg-black/70 backdrop-blur-sm" wire:click="closeDuplicateModal"></div>

                <div class="relative w-full max-w-md bg-[#12121a] rounded-2xl shadow-2xl border border-white/10 p-6">
                    <div class="flex items-center gap-3 mb-5">
                        <div class="w-10 h-10 flex items-center justify-center rounded-xl bg-indigo-500/10">
                            <i class="ph-duotone ph-copy text-xl text-indigo-400"></i>
                        </div>
                        <div>
                            <h3 class="text-lg font-semibold text-white">@lang('Duplicate Menu')</h3>
                            <p class="text-xs text-slate-500">@lang('Create a copy of this menu')</p>
                        </div>
                    </div>

                    <form wire:submit="duplicateMenu" class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium text-slate-300 mb-2">@lang('New Menu Name')</label>
                            <input type="text" wire:model="duplicateName" class="w-full px-4 py-2.5 bg-white/5 border border-white/10 rounded-xl text-white placeholder-slate-500 focus:border-indigo-500/50 focus:ring-1 focus:ring-indigo-500/50 transition-colors" placeholder="@lang('Enter menu name')">
                            @error('duplicateName') <span class="text-xs text-red-400 mt-1">{{ $message }}</span> @enderror
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-slate-300 mb-2">@lang('Target Location')</label>
                            <select wire:model="duplicateLocation" class="w-full px-4 py-2.5 bg-white/5 border border-white/10 rounded-xl text-white focus:border-indigo-500/50 focus:ring-1 focus:ring-indigo-500/50 transition-colors">
                                @foreach($this->availableLocations as $value => $label)
                                    <option value="{{ $value }}" class="bg-[#12121a]">{{ $label }}</option>
                                @endforeach
                            </select>
                            @error('duplicateLocation') <span class="text-xs text-red-400 mt-1">{{ $message }}</span> @enderror
                        </div>

                        <div class="flex justify-end gap-3 pt-4 border-t border-white/5">
                            <button type="button" wire:click="closeDuplicateModal" class="px-4 py-2.5 text-sm font-medium text-slate-300 bg-white/5 border border-white/10 rounded-xl hover:bg-white/10 transition-colors">
                                @lang('Cancel')
                            </button>
                            <button type="submit" class="inline-flex items-center gap-2 px-4 py-2.5 text-sm font-medium text-white bg-indigo-600 rounded-xl hover:bg-indigo-700 transition-colors">
                                <span wire:loading.remove wire:target="duplicateMenu">
                                    <i class="ph ph-copy"></i>
                                    @lang('Duplicate')
                                </span>
                                <span wire:loading wire:target="duplicateMenu" class="flex items-center gap-2">
                                    <i class="ph ph-spinner animate-spin"></i>
                                    @lang('Duplicating...')
                                </span>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endif
</div>

@script
<script>
    Alpine.data('menuSortable', () => ({
        sortableInstance: null,

        initSortable() {
            const container = this.$el;
            if (!container || typeof Sortable === 'undefined') {
                console.warn('SortableJS not loaded or container not found');
                return;
            }

            this.sortableInstance = new Sortable(container, {
                group: 'nested', // Allow dragging between lists
                animation: 150,
                handle: '.cursor-grab',
                ghostClass: 'opacity-50',
                chosenClass: 'ring-2 ring-indigo-500/50',
                dragClass: 'shadow-lg',
                fallbackOnBody: true,
                swapThreshold: 0.65,
                emptyInsertThreshold: 5, // Allow dropping into empty lists
                onEnd: (evt) => {
                    // When item is dropped in a container, update THAT container's order
                    const targetContainer = evt.to;
                    const parentId = targetContainer.dataset.parentId ? parseInt(targetContainer.dataset.parentId) : null;
                    const orderedItems = this.getOrderedItems(targetContainer);
                    
                    $wire.updateOrder(orderedItems, parentId);
                }
            });
        },

        getOrderedItems(container) {
            const items = [];
            // Only get direct children of this container
            const wrappers = Array.from(container.children).filter(child => child.classList.contains('menu-item-wrapper'));

            wrappers.forEach((wrapper, index) => {
                const id = parseInt(wrapper.dataset.id);
                if (id) {
                    items.push({
                        id: id,
                        children: []
                    });
                }
            });

            return items;
        },

        destroy() {
            if (this.sortableInstance) {
                this.sortableInstance.destroy();
            }
        }
    }));

    // Keyboard shortcuts for menu builder
    document.addEventListener('keydown', function(e) {
        // Escape - Close any open modal
        if (e.key === 'Escape') {
            $wire.set('showDeleteModal', false);
            $wire.set('showResetModal', false);
            $wire.set('showImportModal', false);
            $wire.set('showVersionsModal', false);
            $wire.set('showDuplicateModal', false);
        }

        // Ctrl/Cmd + E - Export menu
        if ((e.metaKey || e.ctrlKey) && e.key === 'e') {
            e.preventDefault();
            $wire.exportMenu();
        }

        // Ctrl/Cmd + I - Open import modal
        if ((e.metaKey || e.ctrlKey) && e.key === 'i') {
            e.preventDefault();
            $wire.openImportModal();
        }

        // Ctrl/Cmd + D - Open duplicate modal
        if ((e.metaKey || e.ctrlKey) && e.key === 'd') {
            e.preventDefault();
            $wire.openDuplicateModal();
        }

        // Ctrl/Cmd + H - Open version history
        if ((e.metaKey || e.ctrlKey) && e.key === 'h') {
            e.preventDefault();
            $wire.openVersionsModal();
        }
    });
</script>
@endscript

