<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Menu Manager')" :subtitle="__('Manage navigation menus for client area and frontend sections.')">
        <x-slot:actions>
            <button wire:click="createDefaultMenus" class="inline-flex items-center gap-2 px-4 py-2.5 text-sm font-medium text-slate-300 bg-white/5 border border-white/10 rounded-xl hover:bg-white/10 transition-colors">
                <i class="ph-duotone ph-magic-wand text-lg"></i>
                @lang('Create Defaults')
            </button>
            <a href="{{ route('admin.menus.social-links') }}" wire:navigate class="inline-flex items-center gap-2 px-4 py-2.5 text-sm font-medium text-slate-300 bg-white/5 border border-white/10 rounded-xl hover:bg-white/10 transition-colors">
                <i class="ph-duotone ph-share-network text-lg"></i>
                @lang('Social Links')
            </a>
            <x-admin.button wire:click="openCreateModal" icon="ph-plus">
                @lang('Create Menu')
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    {{-- Statistics Cards --}}
    <div class="mt-4 sm:mt-6 -mx-4 sm:mx-0 px-4 sm:px-0 overflow-x-auto pb-2 sm:pb-0">
        <div class="flex sm:grid sm:grid-cols-2 lg:grid-cols-4 gap-3 sm:gap-4 min-w-max sm:min-w-0">
            <x-admin.stat-card
                icon="ph-list"
                iconColor="primary"
                :label="__('Total Menus')"
                :value="$allMenus->count()"
                class="min-w-[140px] sm:min-w-0"
            />
            <x-admin.stat-card
                icon="ph-check-circle"
                iconColor="success"
                :label="__('Active Menus')"
                :value="$allMenus->where('is_active', true)->count()"
                class="min-w-[140px] sm:min-w-0"
            />
            <x-admin.stat-card
                icon="ph-rows"
                iconColor="info"
                :label="__('Total Items')"
                :value="$allMenus->sum('items_count')"
                class="min-w-[140px] sm:min-w-0"
            />
            <x-admin.stat-card
                icon="ph-map-pin"
                iconColor="warning"
                :label="__('Locations')"
                :value="count($allLocations)"
                class="min-w-[140px] sm:min-w-0"
            />
        </div>
    </div>

    {{-- Search and Filters --}}
    <div class="mt-4 sm:mt-6">
        <x-admin.card class="!p-4">
            <div class="flex flex-col lg:flex-row gap-4">
                {{-- Search --}}
                <div class="flex-1">
                    <div class="relative">
                        <i class="ph ph-magnifying-glass absolute left-3 top-1/2 -translate-y-1/2 text-slate-500"></i>
                        <input
                            type="text"
                            wire:model.live.debounce.300ms="search"
                            placeholder="{{ __('Search menus...') }}"
                            class="w-full pl-10 pr-4 py-2.5 rounded-xl border border-white/10 bg-white/5 text-sm text-white placeholder-slate-500 focus:border-indigo-500/50 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                        />
                        @if($search)
                            <button wire:click="$set('search', '')" class="absolute right-3 top-1/2 -translate-y-1/2 text-slate-500 hover:text-white">
                                <i class="ph ph-x text-sm"></i>
                            </button>
                        @endif
                    </div>
                </div>

                {{-- Filters --}}
                <div class="flex flex-wrap gap-3">
                    {{-- Area Filter --}}
                    <select wire:model.live="filterArea" class="rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white focus:border-indigo-500/50 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                        <option value="" class="bg-[#1a1a24]">@lang('All Areas')</option>
                        <option value="client" class="bg-[#1a1a24]">@lang('Client Area')</option>
                        <option value="frontend" class="bg-[#1a1a24]">@lang('Frontend')</option>
                    </select>

                    {{-- Status Filter --}}
                    <select wire:model.live="filterStatus" class="rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white focus:border-indigo-500/50 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                        <option value="" class="bg-[#1a1a24]">@lang('All Status')</option>
                        <option value="active" class="bg-[#1a1a24]">@lang('Active')</option>
                        <option value="inactive" class="bg-[#1a1a24]">@lang('Inactive')</option>
                    </select>

                    {{-- Location Filter --}}
                    <select wire:model.live="filterLocation" class="rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white focus:border-indigo-500/50 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                        <option value="" class="bg-[#1a1a24]">@lang('All Locations')</option>
                        @foreach($locationsGrouped as $area => $locations)
                            <optgroup label="{{ $area === 'client' ? __('Client Area') : __('Frontend') }}" class="bg-[#1a1a24]">
                                @foreach($locations as $loc)
                                    <option value="{{ $loc->value }}" class="bg-[#1a1a24]">{{ $loc->label() }}</option>
                                @endforeach
                            </optgroup>
                        @endforeach
                    </select>

                    @if($hasFilters)
                        <button wire:click="clearFilters" class="px-4 py-2.5 text-sm text-slate-400 hover:text-white transition-colors">
                            <i class="ph ph-x mr-1"></i> @lang('Clear')
                        </button>
                    @endif
                </div>
            </div>
        </x-admin.card>
    </div>

    {{-- Bulk Actions Bar --}}
    @if(count($selected) > 0)
        <div class="mt-4 sm:mt-6">
            <x-admin.card class="!p-4 bg-indigo-500/10 border-indigo-500/20">
                <div class="flex flex-col sm:flex-row items-start sm:items-center justify-between gap-4">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 flex items-center justify-center rounded-xl bg-indigo-500/20 text-indigo-400">
                            <i class="ph-duotone ph-check-square text-xl"></i>
                        </div>
                        <div>
                            <span class="text-sm font-medium text-white">{{ count($selected) }} @lang('menus selected')</span>
                            <p class="text-xs text-slate-400">@lang('Choose an action to apply')</p>
                        </div>
                    </div>

                    <div class="flex flex-wrap gap-2">
                        <button wire:click="bulkActivate" class="inline-flex items-center gap-2 px-3 py-2 text-xs font-medium text-emerald-400 bg-emerald-500/10 border border-emerald-500/20 rounded-lg hover:bg-emerald-500/20 transition-colors">
                            <i class="ph ph-check-circle"></i> @lang('Activate')
                        </button>
                        <button wire:click="bulkDeactivate" class="inline-flex items-center gap-2 px-3 py-2 text-xs font-medium text-amber-400 bg-amber-500/10 border border-amber-500/20 rounded-lg hover:bg-amber-500/20 transition-colors">
                            <i class="ph ph-pause-circle"></i> @lang('Deactivate')
                        </button>
                        <button wire:click="bulkResetToDefault" class="inline-flex items-center gap-2 px-3 py-2 text-xs font-medium text-cyan-400 bg-cyan-500/10 border border-cyan-500/20 rounded-lg hover:bg-cyan-500/20 transition-colors">
                            <i class="ph ph-arrow-counter-clockwise"></i> @lang('Reset')
                        </button>
                        <button wire:click="bulkExport" class="inline-flex items-center gap-2 px-3 py-2 text-xs font-medium text-blue-400 bg-blue-500/10 border border-blue-500/20 rounded-lg hover:bg-blue-500/20 transition-colors">
                            <i class="ph ph-export"></i> @lang('Export')
                        </button>
                        <button wire:click="confirmBulkDelete" class="inline-flex items-center gap-2 px-3 py-2 text-xs font-medium text-rose-400 bg-rose-500/10 border border-rose-500/20 rounded-lg hover:bg-rose-500/20 transition-colors">
                            <i class="ph ph-trash"></i> @lang('Delete')
                        </button>
                        <button wire:click="$set('selected', [])" class="inline-flex items-center gap-2 px-3 py-2 text-xs font-medium text-slate-400 bg-white/5 border border-white/10 rounded-lg hover:bg-white/10 transition-colors">
                            <i class="ph ph-x"></i> @lang('Cancel')
                        </button>
                    </div>
                </div>
            </x-admin.card>
        </div>
    @endif

    {{-- Menus by Area --}}
    <div class="mt-4 sm:mt-6 space-y-6">
        @foreach($locationsGrouped as $area => $locations)
            @php
                $areaLabels = ['client' => __('Client Area Menus'), 'frontend' => __('Frontend Menus')];
                $areaIcons = ['client' => 'ph-user-circle', 'frontend' => 'ph-globe'];
                $areaColors = ['client' => 'from-indigo-500/20 to-purple-500/20', 'frontend' => 'from-emerald-500/20 to-cyan-500/20'];
            @endphp

            <div>
                <div class="flex items-center gap-3 mb-4">
                    <div class="flex h-10 w-10 shrink-0 items-center justify-center rounded-xl bg-gradient-to-br {{ $areaColors[$area] ?? 'from-slate-500/20 to-slate-600/20' }}">
                        <i class="ph-duotone {{ $areaIcons[$area] ?? 'ph-folder' }} text-xl {{ $area === 'client' ? 'text-indigo-400' : 'text-emerald-400' }}"></i>
                    </div>
                    <div>
                        <h2 class="text-lg font-semibold text-white">{{ $areaLabels[$area] ?? ucfirst($area) }}</h2>
                        <p class="text-sm text-slate-500">{{ count($locations) }} @lang('locations available')</p>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    @foreach($locations as $location)
                        @php
                            $locationValue = $location->value;
                            $menusForLocation = $menus->flatten()->filter(function($menu) use ($locationValue) {
                                $menuLocation = $menu->location->value ?? $menu->location;
                                return $menuLocation === $locationValue;
                            });
                        @endphp

                        <x-admin.card class="!p-0 overflow-hidden">
                            {{-- Location Header with Position Diagram --}}
                            <div class="p-4 border-b border-white/5 bg-white/[0.02]">
                                <div class="flex items-center gap-3">
                                    <div class="flex h-9 w-9 shrink-0 items-center justify-center rounded-lg bg-white/5">
                                        <i class="ph-duotone {{ $location->icon() }} text-lg text-slate-400"></i>
                                    </div>
                                    <div class="flex-1 min-w-0">
                                        <h3 class="font-medium text-white text-sm">{{ $location->label() }}</h3>
                                        <p class="text-xs text-slate-500 truncate">{{ $location->description() }}</p>
                                    </div>
                                    <span class="px-2 py-0.5 text-xs font-medium {{ $menusForLocation->count() > 0 ? 'text-emerald-400 bg-emerald-500/10' : 'text-slate-500 bg-white/5' }} rounded-full">
                                        {{ $menusForLocation->count() }}
                                    </span>
                                </div>

                                {{-- Position Diagram --}}
                                @php $diagram = $location->positionDiagram(); @endphp
                                <div class="mt-3 flex items-center gap-2">
                                    <div class="w-16 h-10 rounded border border-white/10 bg-white/[0.02] relative overflow-hidden">
                                        @switch($diagram['position'])
                                            @case('left')
                                                <div class="absolute left-0 top-0 bottom-0 w-1.5 bg-indigo-500/50"></div>
                                                @break
                                            @case('top')
                                                <div class="absolute left-0 right-0 top-0 h-1.5 bg-indigo-500/50"></div>
                                                @break
                                            @case('top-right')
                                                <div class="absolute right-1 top-1 w-2 h-2 rounded-sm bg-indigo-500/50"></div>
                                                @break
                                            @case('bottom')
                                                <div class="absolute left-0 right-0 bottom-0 h-1.5 bg-indigo-500/50"></div>
                                                @break
                                            @case('bottom-fixed')
                                                <div class="absolute left-0 right-0 bottom-0 h-2 bg-indigo-500/50"></div>
                                                @break
                                            @case('bottom-center')
                                                <div class="absolute left-1/2 -translate-x-1/2 bottom-1 w-6 h-1 bg-indigo-500/50 rounded-sm"></div>
                                                @break
                                            @case('bottom-left')
                                                <div class="absolute left-1 bottom-1 w-3 h-4 bg-indigo-500/50 rounded-sm"></div>
                                                @break
                                            @case('bottom-right')
                                                <div class="absolute right-1 bottom-1 w-3 h-4 bg-indigo-500/50 rounded-sm"></div>
                                                @break
                                            @default
                                                <div class="absolute inset-1 rounded bg-indigo-500/20"></div>
                                        @endswitch
                                    </div>
                                    <span class="text-[10px] text-slate-500">{{ $diagram['description'] }}</span>
                                </div>
                            </div>

                            {{-- Menus List --}}
                            <div class="p-3">
                                @if($menusForLocation->count() > 0)
                                    <div class="space-y-2">
                                        @foreach($menusForLocation as $menu)
                                            <div class="flex items-center justify-between p-3 bg-white/[0.02] rounded-xl border {{ in_array($menu->id, $selected) ? 'border-indigo-500/50 bg-indigo-500/5' : 'border-white/5' }} hover:border-white/10 transition-colors group">
                                                <div class="flex items-center gap-3 min-w-0">
                                                    {{-- Selection Checkbox --}}
                                                    <label class="relative flex items-center cursor-pointer">
                                                        <input
                                                            type="checkbox"
                                                            wire:model.live="selected"
                                                            value="{{ $menu->id }}"
                                                            class="sr-only peer"
                                                        />
                                                        <div class="w-5 h-5 rounded-md border border-white/20 bg-white/5 peer-checked:bg-indigo-500 peer-checked:border-indigo-500 transition-colors flex items-center justify-center">
                                                            <i class="ph ph-check text-xs text-white opacity-0 peer-checked:opacity-100"></i>
                                                        </div>
                                                    </label>

                                                    <div class="w-8 h-8 flex items-center justify-center rounded-lg {{ $menu->is_active ? 'bg-emerald-500/10 text-emerald-400' : 'bg-white/5 text-slate-500' }}">
                                                        <i class="ph-duotone ph-list text-base"></i>
                                                    </div>
                                                    <div class="min-w-0">
                                                        <h4 class="font-medium text-white text-sm truncate">{{ $menu->name }}</h4>
                                                        <p class="text-xs text-slate-500">{{ $menu->items_count ?? $menu->items()->count() }} @lang('items')</p>
                                                    </div>
                                                </div>

                                                <div class="flex items-center gap-1 opacity-0 group-hover:opacity-100 transition-opacity">
                                                    <a href="{{ route('admin.menus.builder', $menu) }}" wire:navigate class="p-1.5 rounded-lg bg-indigo-500/10 text-indigo-400 hover:bg-indigo-500/20 transition-colors" title="@lang('Edit Items')">
                                                        <i class="ph ph-tree-structure text-sm"></i>
                                                    </a>
                                                    <button wire:click="edit({{ $menu->id }})" class="p-1.5 rounded-lg bg-white/5 text-slate-400 hover:bg-white/10 transition-colors" title="@lang('Settings')">
                                                        <i class="ph ph-gear text-sm"></i>
                                                    </button>
                                                    <button wire:click="resetToDefault({{ $menu->id }})" class="p-1.5 rounded-lg bg-white/5 text-slate-400 hover:bg-white/10 transition-colors" title="@lang('Reset to Default')">
                                                        <i class="ph ph-arrow-counter-clockwise text-sm"></i>
                                                    </button>
                                                    <button wire:click="confirmDelete({{ $menu->id }})" class="p-1.5 rounded-lg bg-rose-500/10 text-rose-400 hover:bg-rose-500/20 transition-colors" title="@lang('Delete')">
                                                        <i class="ph ph-trash text-sm"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                @else
                                    <div class="text-center py-6">
                                        <p class="text-sm text-slate-500 mb-2">@lang('No menu for this location')</p>
                                        <button wire:click="openCreateModal" class="text-xs text-indigo-400 hover:text-indigo-300 transition-colors">
                                            <i class="ph ph-plus mr-1"></i> @lang('Create Menu')
                                        </button>
                                    </div>
                                @endif
                            </div>
                        </x-admin.card>
                    @endforeach
                </div>
            </div>
        @endforeach
    </div>

    {{-- Create/Edit Modal --}}
    @if($showCreateModal)
        <div class="fixed inset-0 z-50 overflow-y-auto" aria-modal="true">
            <div class="flex min-h-screen items-center justify-center p-4">
                <div class="fixed inset-0 bg-black/70 backdrop-blur-sm" wire:click="closeModal"></div>

                <div class="relative w-full max-w-lg bg-[#12121a] rounded-2xl shadow-2xl border border-white/10">
                    <div class="flex items-center justify-between px-6 py-4 border-b border-white/5">
                        <h3 class="text-lg font-semibold text-white">{{ $editingId ? __('Edit Menu') : __('Create Menu') }}</h3>
                        <button wire:click="closeModal" class="p-2 text-slate-400 hover:text-white rounded-xl hover:bg-white/5 transition-colors">
                            <i class="ph ph-x text-lg"></i>
                        </button>
                    </div>

                    <form wire:submit="save" class="p-6 space-y-5">
                        <div>
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-1.5 sm:mb-2">@lang('Menu Name')</label>
                            <input type="text" wire:model="name" class="w-full rounded-xl border border-white/10 bg-white/5 px-3 sm:px-4 py-2.5 text-base sm:text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" placeholder="{{ __('e.g. Main Navigation') }}">
                            @error('name') <span class="mt-1 text-xs text-rose-400 block">{{ $message }}</span> @enderror
                        </div>

                        <div>
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-1.5 sm:mb-2">@lang('Location')</label>
                            <select wire:model="location" class="w-full rounded-xl border border-white/10 bg-white/5 px-3 sm:px-4 py-2.5 text-base sm:text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20">
                                <option value="" class="bg-[#1a1a24]">@lang('Select location...')</option>
                                @foreach($locationsGrouped as $area => $locations)
                                    <optgroup label="{{ $area === 'client' ? __('Client Area') : __('Frontend') }}" class="bg-[#1a1a24]">
                                        @foreach($locations as $loc)
                                            <option value="{{ $loc->value }}" class="bg-[#1a1a24]">{{ $loc->label() }}</option>
                                        @endforeach
                                    </optgroup>
                                @endforeach
                            </select>
                            @error('location') <span class="mt-1 text-xs text-rose-400 block">{{ $message }}</span> @enderror
                        </div>

                        <div>
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-1.5 sm:mb-2">@lang('Description') (@lang('Optional'))</label>
                            <textarea wire:model="description" rows="2" class="w-full rounded-xl border border-white/10 bg-white/5 px-3 sm:px-4 py-2.5 text-base sm:text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20 resize-none" placeholder="{{ __('Brief description of this menu') }}"></textarea>
                        </div>

                        <div class="flex items-center gap-3">
                            <div class="relative">
                                <input type="checkbox" wire:model.live="is_active" class="sr-only peer" id="menu-active-toggle" />
                                <label for="menu-active-toggle" class="block h-6 w-11 rounded-full bg-slate-700 peer-checked:bg-indigo-500 transition-colors cursor-pointer"></label>
                                <div class="absolute left-0.5 top-0.5 h-5 w-5 rounded-full bg-white shadow-sm transition-transform peer-checked:translate-x-5 pointer-events-none"></div>
                            </div>
                            <span class="text-sm text-slate-300">@lang('Active')</span>
                        </div>

                        <div class="flex justify-end gap-3 pt-4 border-t border-white/5">
                            <button type="button" wire:click="closeModal" class="px-4 py-2.5 text-sm font-medium text-slate-300 bg-white/5 border border-white/10 rounded-xl hover:bg-white/10 transition-colors">@lang('Cancel')</button>
                            <x-admin.button type="submit">
                                {{ $editingId ? __('Update Menu') : __('Create Menu') }}
                            </x-admin.button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endif

    {{-- Delete Confirmation Modal --}}
    @if($showDeleteModal)
        <div class="fixed inset-0 z-50 overflow-y-auto" aria-modal="true">
            <div class="flex min-h-screen items-center justify-center p-4">
                <div class="fixed inset-0 bg-black/70 backdrop-blur-sm" wire:click="closeModal"></div>

                <div class="relative w-full max-w-sm bg-[#12121a] rounded-2xl shadow-2xl border border-white/10 p-6 text-center">
                    <div class="w-14 h-14 mx-auto mb-4 flex items-center justify-center rounded-full bg-rose-500/10">
                        <i class="ph-duotone ph-trash text-2xl text-rose-400"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-white mb-2">@lang('Delete Menu?')</h3>
                    <p class="text-sm text-slate-400 mb-6">@lang('This will permanently delete the menu and all its items. This action cannot be undone.')</p>

                    <div class="flex justify-center gap-3">
                        <button wire:click="closeModal" class="px-4 py-2.5 text-sm font-medium text-slate-300 bg-white/5 border border-white/10 rounded-xl hover:bg-white/10 transition-colors">@lang('Cancel')</button>
                        <button wire:click="delete" class="px-4 py-2.5 text-sm font-medium text-white bg-rose-600 rounded-xl hover:bg-rose-700 transition-colors">@lang('Delete')</button>
                    </div>
                </div>
            </div>
        </div>
    @endif

    {{-- Bulk Delete Confirmation Modal --}}
    @if($showBulkDeleteModal)
        <div class="fixed inset-0 z-50 overflow-y-auto" aria-modal="true">
            <div class="flex min-h-screen items-center justify-center p-4">
                <div class="fixed inset-0 bg-black/70 backdrop-blur-sm" wire:click="$set('showBulkDeleteModal', false)"></div>

                <div class="relative w-full max-w-sm bg-[#12121a] rounded-2xl shadow-2xl border border-white/10 p-6 text-center">
                    <div class="w-14 h-14 mx-auto mb-4 flex items-center justify-center rounded-full bg-rose-500/10">
                        <i class="ph-duotone ph-trash text-2xl text-rose-400"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-white mb-2">@lang('Delete :count Menus?', ['count' => count($selected)])</h3>
                    <p class="text-sm text-slate-400 mb-6">@lang('This will permanently delete the selected menus and all their items. This action cannot be undone.')</p>

                    <div class="flex justify-center gap-3">
                        <button wire:click="$set('showBulkDeleteModal', false)" class="px-4 py-2.5 text-sm font-medium text-slate-300 bg-white/5 border border-white/10 rounded-xl hover:bg-white/10 transition-colors">@lang('Cancel')</button>
                        <button wire:click="bulkDelete" class="px-4 py-2.5 text-sm font-medium text-white bg-rose-600 rounded-xl hover:bg-rose-700 transition-colors">@lang('Delete All')</button>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>

