<div>
    {{-- Page Header --}}
    <x-admin.page-header title="{{ __('Social Links') }}" subtitle="{{ __('Manage social media links displayed in the footer.') }}">
        <x-slot:actions>
            <x-admin.button wire:click="openModal" icon="ph-plus">
                @lang('Add Social Link')
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    {{-- Stats --}}
    <div class="mt-4 sm:mt-6 grid grid-cols-2 sm:grid-cols-3 gap-3 sm:gap-4">
        <x-admin.stat-card
            icon="ph-duotone ph-share-network"
            iconBg="bg-indigo-500/10"
            iconColor="text-indigo-400"
            :value="$links->count()"
            label="{{ __('Total Links') }}"
        />
        <x-admin.stat-card
            icon="ph-duotone ph-check-circle"
            iconBg="bg-emerald-500/10"
            iconColor="text-emerald-400"
            :value="$links->where('is_active', true)->count()"
            label="{{ __('Active') }}"
        />
        <x-admin.stat-card
            icon="ph-duotone ph-eye-slash"
            iconBg="bg-slate-500/10"
            iconColor="text-slate-400"
            :value="$links->where('is_active', false)->count()"
            label="{{ __('Inactive') }}"
        />
    </div>

    {{-- Social Links Grid --}}
    <div class="mt-4 sm:mt-6">
        <x-admin.card>
            <div class="flex items-center gap-3 pb-3 sm:pb-4 mb-4 border-b border-white/5">
                <div class="flex h-9 w-9 sm:h-10 sm:w-10 shrink-0 items-center justify-center rounded-xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20">
                    <i class="ph-duotone ph-share-network text-lg sm:text-xl text-indigo-400"></i>
                </div>
                <div class="min-w-0 flex-1">
                    <h3 class="font-semibold text-white text-sm sm:text-base">@lang('Social Platforms')</h3>
                    <p class="text-xs text-slate-500">@lang('Click to edit or toggle visibility.')</p>
                </div>
            </div>

            @if($links->count() > 0)
                <div class="grid gap-3 sm:grid-cols-2 lg:grid-cols-3">
                    @foreach($links as $link)
                        <div class="group flex items-center justify-between p-4 rounded-xl border transition-all {{ $link->is_active ? 'bg-white/[0.02] border-white/5 hover:border-white/10' : 'bg-white/[0.01] border-white/5 opacity-60' }}">
                            <div class="flex items-center gap-3 min-w-0">
                                <div class="w-10 h-10 flex items-center justify-center rounded-xl shrink-0" style="background-color: {{ $link->display_color }}15; color: {{ $link->display_color }}">
                                    <i class="{{ $link->display_icon }} text-lg"></i>
                                </div>
                                <div class="min-w-0">
                                    <h3 class="font-medium text-white text-sm truncate">{{ $link->display_name }}</h3>
                                    <p class="text-xs text-slate-500 truncate max-w-[140px]">{{ $link->url }}</p>
                                </div>
                            </div>

                            <div class="flex items-center gap-1 opacity-0 group-hover:opacity-100 transition-opacity">
                                <button wire:click="toggleActive({{ $link->id }})" class="p-1.5 rounded-lg transition-colors {{ $link->is_active ? 'text-emerald-400 hover:bg-emerald-500/10' : 'text-slate-400 hover:bg-white/5' }}" title="{{ $link->is_active ? __('Disable') : __('Enable') }}">
                                    <i class="ph ph-{{ $link->is_active ? 'eye' : 'eye-slash' }} text-sm"></i>
                                </button>
                                <button wire:click="edit({{ $link->id }})" class="p-1.5 rounded-lg text-slate-400 hover:text-white hover:bg-white/5 transition-colors" title="@lang('Edit')">
                                    <i class="ph ph-pencil-simple text-sm"></i>
                                </button>
                                <button wire:click="confirmDelete({{ $link->id }})" class="p-1.5 rounded-lg text-slate-400 hover:text-rose-400 hover:bg-rose-500/10 transition-colors" title="@lang('Delete')">
                                    <i class="ph ph-trash text-sm"></i>
                                </button>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <div class="text-center py-12">
                    <div class="w-16 h-16 mx-auto mb-4 flex items-center justify-center rounded-2xl bg-white/5 text-slate-500">
                        <i class="ph-duotone ph-share-network text-3xl"></i>
                    </div>
                    <h3 class="text-base font-medium text-white mb-1">@lang('No social links yet')</h3>
                    <p class="text-sm text-slate-500 mb-4">@lang('Add your social media profiles to display in the footer.')</p>
                    <x-admin.button wire:click="openModal" icon="ph-plus">
                        @lang('Add First Link')
                    </x-admin.button>
                </div>
            @endif
        </x-admin.card>
    </div>

    {{-- Add/Edit Modal --}}
    @if($showModal)
        <div class="fixed inset-0 z-50 overflow-y-auto" aria-modal="true">
            <div class="flex min-h-screen items-center justify-center p-4">
                <div class="fixed inset-0 bg-black/70 backdrop-blur-sm" wire:click="closeModal"></div>

                <div class="relative w-full max-w-lg bg-[#12121a] rounded-2xl shadow-2xl border border-white/10 max-h-[90vh] overflow-y-auto">
                    <div class="sticky top-0 flex items-center justify-between px-6 py-4 border-b border-white/5 bg-[#12121a] z-10">
                        <h3 class="text-lg font-semibold text-white">{{ $editingId ? __('Edit Social Link') : __('Add Social Link') }}</h3>
                        <button wire:click="closeModal" class="p-2 text-slate-400 hover:text-white rounded-lg hover:bg-white/5 transition-colors">
                            <i class="ph ph-x text-lg"></i>
                        </button>
                    </div>

                    <form wire:submit="save" class="p-6 space-y-5">
                        {{-- Platform Selection --}}
                        <div>
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-3">@lang('Platform')</label>
                            <div class="grid grid-cols-4 gap-2 max-h-48 overflow-y-auto p-1">
                                @foreach($platforms as $key => $info)
                                    <button type="button" wire:click="selectPlatform('{{ $key }}')"
                                        class="flex flex-col items-center gap-1 p-3 rounded-xl border transition-all {{ $platform === $key ? 'border-indigo-500/50 bg-indigo-500/10' : 'border-white/10 bg-white/5 hover:border-white/20' }}">
                                        <i class="{{ $info['icon'] }} text-lg" style="color: {{ $info['color'] }}"></i>
                                        <span class="text-xs text-slate-300 truncate w-full text-center">{{ ucfirst($key) }}</span>
                                    </button>
                                @endforeach
                            </div>
                            @error('platform') <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                        </div>

                        {{-- URL --}}
                        <div>
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-1.5">@lang('Profile URL')</label>
                            <input type="url" wire:model="url" class="w-full rounded-xl border border-white/10 bg-white/5 px-3 py-2.5 text-sm text-white placeholder-slate-500 focus:border-indigo-500/50 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" placeholder="https://...">
                            @error('url') <span class="mt-1 text-xs text-rose-400">{{ $message }}</span> @enderror
                        </div>

                        {{-- Custom Name (Optional) --}}
                        <div>
                            <label class="block text-xs font-semibold uppercase tracking-wider text-slate-500 mb-1.5">@lang('Custom Name') <span class="text-slate-600">(@lang('optional'))</span></label>
                            <input type="text" wire:model="name" class="w-full rounded-xl border border-white/10 bg-white/5 px-3 py-2.5 text-sm text-white placeholder-slate-500 focus:border-indigo-500/50 focus:outline-none focus:ring-2 focus:ring-indigo-500/20" placeholder="@lang('Leave empty to use platform name')">
                        </div>

                        {{-- Active Toggle --}}
                        <div class="flex items-center gap-3">
                            <button type="button" wire:click="$toggle('is_active')" class="relative inline-flex h-6 w-11 items-center rounded-full transition-colors {{ $is_active ? 'bg-indigo-600' : 'bg-slate-600' }}">
                                <span class="inline-block h-4 w-4 transform rounded-full bg-white transition-transform {{ $is_active ? 'translate-x-6' : 'translate-x-1' }}"></span>
                            </button>
                            <span class="text-sm text-slate-300">@lang('Active')</span>
                        </div>

                        {{-- Actions --}}
                        <div class="flex justify-end gap-3 pt-4 border-t border-white/5">
                            <button type="button" wire:click="closeModal" class="px-4 py-2.5 text-sm font-medium text-slate-300 bg-white/5 border border-white/10 rounded-xl hover:bg-white/10 transition-colors">@lang('Cancel')</button>
                            <x-admin.button type="submit">
                                {{ $editingId ? __('Update Link') : __('Add Link') }}
                            </x-admin.button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endif

    {{-- Delete Confirmation Modal --}}
    @if($showDeleteModal)
        <div class="fixed inset-0 z-50 overflow-y-auto" aria-modal="true">
            <div class="flex min-h-screen items-center justify-center p-4">
                <div class="fixed inset-0 bg-black/70 backdrop-blur-sm" wire:click="closeModal"></div>

                <div class="relative w-full max-w-sm bg-[#12121a] rounded-2xl shadow-2xl border border-white/10 p-6 text-center">
                    <div class="w-14 h-14 mx-auto mb-4 flex items-center justify-center rounded-full bg-rose-500/10">
                        <i class="ph-duotone ph-trash text-2xl text-rose-400"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-white mb-2">@lang('Delete Social Link?')</h3>
                    <p class="text-sm text-slate-400 mb-6">@lang('This action cannot be undone.')</p>

                    <div class="flex justify-center gap-3">
                        <button wire:click="closeModal" class="px-4 py-2.5 text-sm font-medium text-slate-300 bg-white/5 border border-white/10 rounded-xl hover:bg-white/10 transition-colors">@lang('Cancel')</button>
                        <button wire:click="delete" class="px-4 py-2.5 text-sm font-medium text-white bg-rose-600 rounded-xl hover:bg-rose-700 transition-colors">@lang('Delete')</button>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>

