<div class="relative" x-data="{ open: @entangle('isOpen'), isMobile: window.innerWidth < 640 }" x-init="window.addEventListener('resize', () => isMobile = window.innerWidth < 640)">
    {{-- Notification Bell Button --}}
    <button
        @click="open = !open"
        class="relative flex h-10 w-10 items-center justify-center rounded-xl text-slate-400 transition-all hover:bg-white/5 hover:text-white active:scale-95"
    >
        <i class="ph-duotone ph-bell text-xl"></i>
        @if($this->unreadCount > 0)
            <span class="absolute right-1.5 top-1.5 flex h-2.5 w-2.5">
                <span class="absolute inline-flex h-full w-full animate-ping rounded-full bg-rose-400 opacity-75"></span>
                <span class="relative inline-flex h-2.5 w-2.5 rounded-full border-2 border-[#0a0a0f] bg-rose-500"></span>
            </span>
        @endif
    </button>

    {{-- Mobile: Full-screen overlay --}}
    <template x-if="isMobile">
        <div
            x-show="open"
            x-transition:enter="transition ease-out duration-300"
            x-transition:enter-start="opacity-0"
            x-transition:enter-end="opacity-100"
            x-transition:leave="transition ease-in duration-200"
            x-transition:leave-start="opacity-100"
            x-transition:leave-end="opacity-0"
            @keydown.escape.window="open = false"
            class="fixed inset-0 z-50 bg-[#0a0a0f]/95 backdrop-blur-xl"
            x-cloak
        >
            <div class="flex flex-col h-full pt-safe">
                {{-- Header --}}
                <div class="flex items-center justify-between border-b border-white/5 px-4 py-4 shrink-0">
                    <div class="flex items-center gap-3">
                        <p class="text-base font-semibold text-white">@lang('Notifications')</p>
                        @if($this->unreadCount > 0)
                            <span class="rounded-full bg-rose-500/15 px-2.5 py-1 text-xs font-semibold text-rose-400">
                                {{ $this->unreadCount }} @lang('new')
                            </span>
                        @endif
                    </div>
                    <button
                        @click="open = false"
                        class="flex h-10 w-10 items-center justify-center rounded-xl text-slate-400 hover:bg-white/5 hover:text-white active:scale-95"
                    >
                        <i class="ph-bold ph-x text-xl"></i>
                    </button>
                </div>

                {{-- Mark all as read button --}}
                @if($this->unreadCount > 0)
                    <div class="px-4 py-3 border-b border-white/5 shrink-0">
                        <button
                            wire:click="markAllAsRead"
                            class="w-full rounded-xl bg-white/5 py-3 text-sm font-medium text-slate-300 hover:bg-white/10 active:scale-[0.98] transition-all"
                        >
                            <i class="ph-bold ph-checks mr-2"></i>
                            @lang('Mark all as read')
                        </button>
                    </div>
                @endif

                {{-- Notifications List --}}
                <div class="flex-1 overflow-y-auto overscroll-contain divide-y divide-white/5">
                    @forelse($this->notifications as $notification)
                        <a
                            href="{{ $notification->click_url ?? '#' }}"
                            wire:click="markAsRead({{ $notification->id }})"
                            @click="open = false"
                            class="flex items-start gap-4 px-4 py-4 transition-all hover:bg-white/[0.02] active:bg-white/[0.04] {{ !$notification->is_read ? 'bg-white/[0.02]' : '' }}"
                        >
                            <div class="flex h-12 w-12 shrink-0 items-center justify-center rounded-xl {{ $this->getNotificationColor($notification->type ?? 'system') }}">
                                <i class="ph-duotone {{ $this->getNotificationIcon($notification->type ?? 'system') }} text-xl"></i>
                            </div>
                            <div class="flex-1 min-w-0">
                                <p class="text-sm font-medium text-white {{ !$notification->is_read ? 'font-semibold' : '' }}">
                                    {{ $notification->title }}
                                </p>
                                @if($notification->user)
                                    <p class="text-xs text-slate-400 truncate mt-0.5">{{ $notification->user->fullname ?? $notification->user->email }}</p>
                                @endif
                                <p class="mt-1.5 text-xs text-slate-500">{{ $notification->created_at->diffForHumans() }}</p>
                            </div>
                            @if(!$notification->is_read)
                                <span class="mt-2 h-2.5 w-2.5 shrink-0 rounded-full bg-indigo-500"></span>
                            @endif
                        </a>
                    @empty
                        <div class="px-5 py-16 text-center">
                            <div class="mx-auto mb-4 flex h-16 w-16 items-center justify-center rounded-2xl bg-slate-800">
                                <i class="ph-duotone ph-bell-slash text-2xl text-slate-500"></i>
                            </div>
                            <p class="text-base font-medium text-slate-400">@lang('No notifications')</p>
                            <p class="mt-1 text-sm text-slate-500">@lang("You're all caught up!")</p>
                        </div>
                    @endforelse
                </div>

                {{-- Footer --}}
                @if($this->notifications->count() > 0)
                    <div class="border-t border-white/5 px-4 py-4 pb-safe shrink-0">
                        <a
                            href="{{ route('admin.notifications') }}"
                            @click="open = false"
                            class="flex items-center justify-center gap-2 w-full rounded-xl bg-indigo-500/10 py-3.5 text-sm font-medium text-indigo-400 hover:bg-indigo-500/20 active:scale-[0.98] transition-all"
                        >
                            @lang('View all notifications')
                            <i class="ph-bold ph-arrow-right text-sm"></i>
                        </a>
                    </div>
                @endif
            </div>
        </div>
    </template>

    {{-- Desktop: Dropdown --}}
    <template x-if="!isMobile">
        <div
            x-show="open"
            x-transition:enter="transition ease-out duration-150"
            x-transition:enter-start="opacity-0 translate-y-2"
            x-transition:enter-end="opacity-100 translate-y-0"
            x-transition:leave="transition ease-in duration-100"
            x-transition:leave-start="opacity-100 translate-y-0"
            x-transition:leave-end="opacity-0 translate-y-2"
            @click.away="open = false"
            class="absolute right-0 top-full mt-3 w-96 overflow-hidden rounded-2xl border border-white/10 bg-[#1a1a24] shadow-2xl shadow-black/40"
            x-cloak
        >
            {{-- Header --}}
            <div class="flex items-center justify-between border-b border-white/5 px-5 py-4">
                <p class="text-sm font-semibold text-white">@lang('Notifications')</p>
                @if($this->unreadCount > 0)
                    <span class="rounded-full bg-rose-500/15 px-2.5 py-1 text-[11px] font-semibold text-rose-400">
                        {{ $this->unreadCount }} @lang('new')
                    </span>
                @endif
            </div>

            {{-- Notifications List --}}
            <div class="max-h-[400px] divide-y divide-white/5 overflow-y-auto">
                @forelse($this->notifications as $notification)
                    <a
                        href="{{ $notification->click_url ?? '#' }}"
                        wire:click="markAsRead({{ $notification->id }})"
                        class="flex items-start gap-4 px-5 py-4 transition-all hover:bg-white/[0.02] {{ !$notification->is_read ? 'bg-white/[0.02]' : '' }}"
                    >
                        <div class="flex h-10 w-10 shrink-0 items-center justify-center rounded-xl {{ $this->getNotificationColor($notification->type ?? 'system') }}">
                            <i class="ph-duotone {{ $this->getNotificationIcon($notification->type ?? 'system') }} text-lg"></i>
                        </div>
                        <div class="flex-1 min-w-0">
                            <p class="text-sm font-medium text-white truncate {{ !$notification->is_read ? 'font-semibold' : '' }}">
                                {{ $notification->title }}
                            </p>
                            @if($notification->user)
                                <p class="text-xs text-slate-400 truncate">{{ $notification->user->fullname ?? $notification->user->email }}</p>
                            @endif
                            <p class="mt-1 text-[11px] text-slate-500">{{ $notification->created_at->diffForHumans() }}</p>
                        </div>
                        @if(!$notification->is_read)
                            <span class="mt-2 h-2 w-2 shrink-0 rounded-full bg-indigo-500"></span>
                        @endif
                    </a>
                @empty
                    <div class="px-5 py-12 text-center">
                        <div class="mx-auto mb-3 flex h-12 w-12 items-center justify-center rounded-xl bg-slate-800">
                            <i class="ph-duotone ph-bell-slash text-xl text-slate-500"></i>
                        </div>
                        <p class="text-sm font-medium text-slate-400">@lang('No notifications')</p>
                        <p class="mt-1 text-xs text-slate-500">@lang("You're all caught up!")</p>
                    </div>
                @endforelse
            </div>

            {{-- Footer --}}
            @if($this->notifications->count() > 0)
                <div class="flex items-center justify-between border-t border-white/5 px-5 py-3">
                    @if($this->unreadCount > 0)
                        <button
                            wire:click="markAllAsRead"
                            class="text-xs font-medium text-slate-400 transition-colors hover:text-white"
                        >
                            @lang('Mark all as read')
                        </button>
                    @else
                        <span></span>
                    @endif
                    <a
                        href="{{ route('admin.notifications') }}"
                        class="flex items-center gap-1.5 text-xs font-medium text-indigo-400 transition-colors hover:text-indigo-300"
                    >
                        @lang('View all')
                        <i class="ph-bold ph-arrow-right text-xs"></i>
                    </a>
                </div>
            @endif
        </div>
    </template>
</div>

