<div>
    <x-admin.page-header title="Notifications" description="Manage your admin notifications.">
        <div class="flex items-center gap-3">
            @if($unreadCount > 0)
                <x-admin.button wire:click="markAllAsRead" variant="secondary" size="sm">
                    <x-admin.icon name="checks" class="w-4 h-4 mr-1" />
                    Mark All Read
                </x-admin.button>
            @endif
            <x-admin.button wire:click="deleteAllRead" variant="ghost" size="sm" class="text-red-600 hover:text-red-700">
                <x-admin.icon name="trash" class="w-4 h-4 mr-1" />
                Clear Read
            </x-admin.button>
        </div>
    </x-admin.page-header>

    @if (session('success'))
        <x-admin.alert type="success" class="mb-6">{{ session('success') }}</x-admin.alert>
    @endif

    <!-- Filter Tabs -->
    <div class="flex items-center gap-4 mb-6">
        <button wire:click="$set('filter', 'all')" class="px-4 py-2 text-sm font-medium rounded-lg transition-colors {{ $filter === 'all' ? 'bg-primary-100 text-primary-700 dark:bg-primary-900/30 dark:text-primary-400' : 'text-slate-600 hover:bg-slate-100 dark:text-slate-400 dark:hover:bg-slate-800' }}">
            All ({{ $totalCount }})
        </button>
        <button wire:click="$set('filter', 'unread')" class="px-4 py-2 text-sm font-medium rounded-lg transition-colors {{ $filter === 'unread' ? 'bg-primary-100 text-primary-700 dark:bg-primary-900/30 dark:text-primary-400' : 'text-slate-600 hover:bg-slate-100 dark:text-slate-400 dark:hover:bg-slate-800' }}">
            Unread ({{ $unreadCount }})
        </button>
        <button wire:click="$set('filter', 'read')" class="px-4 py-2 text-sm font-medium rounded-lg transition-colors {{ $filter === 'read' ? 'bg-primary-100 text-primary-700 dark:bg-primary-900/30 dark:text-primary-400' : 'text-slate-600 hover:bg-slate-100 dark:text-slate-400 dark:hover:bg-slate-800' }}">
            Read ({{ $totalCount - $unreadCount }})
        </button>
    </div>

    <!-- Bulk Actions -->
    @if(count($selected) > 0)
        <div class="flex items-center gap-4 p-4 mb-6 bg-primary-50 dark:bg-primary-900/20 rounded-xl border border-primary-200 dark:border-primary-800">
            <span class="text-sm font-medium text-primary-700 dark:text-primary-300">{{ count($selected) }} selected</span>
            <x-admin.button wire:click="markSelectedAsRead" variant="secondary" size="sm">Mark as Read</x-admin.button>
            <x-admin.button wire:click="deleteSelected" variant="danger" size="sm">Delete</x-admin.button>
        </div>
    @endif

    <!-- Notifications List -->
    <x-admin.card>
        <div class="divide-y divide-slate-100 dark:divide-slate-700">
            @forelse($notifications as $notification)
                <div class="flex items-start gap-4 p-4 {{ !$notification->is_read ? 'bg-primary-50/50 dark:bg-primary-900/10' : '' }} hover:bg-slate-50 dark:hover:bg-slate-800/50 transition-colors">
                    <div class="pt-1">
                        <input type="checkbox" wire:model.live="selected" value="{{ $notification->id }}" class="rounded border-slate-300 text-primary-600 focus:ring-primary-500" />
                    </div>
                    <div class="shrink-0 w-10 h-10 rounded-full flex items-center justify-center {{ $this->getNotificationColor($notification->type) }}">
                        <x-admin.icon :name="$this->getNotificationIcon($notification->type)" class="w-5 h-5" />
                    </div>
                    <div class="flex-1 min-w-0">
                        <div class="flex items-start justify-between gap-4">
                            <div>
                                <p class="font-medium text-slate-900 dark:text-white {{ !$notification->is_read ? 'font-semibold' : '' }}">
                                    {{ $notification->title }}
                                </p>
                                <p class="text-sm text-slate-600 dark:text-slate-400 mt-1">{{ $notification->message }}</p>
                                <p class="text-xs text-slate-400 dark:text-slate-500 mt-2">{{ $notification->created_at->diffForHumans() }}</p>
                            </div>
                            <div class="flex items-center gap-2 shrink-0">
                                @if(!$notification->is_read)
                                    <span class="w-2 h-2 rounded-full bg-primary-500"></span>
                                @endif
                                <x-admin.action-menu>
                                    @if($notification->click_url)
                                        <x-admin.action-menu-item href="{{ $notification->click_url }}" icon="arrow-square-out">View</x-admin.action-menu-item>
                                    @endif
                                    @if($notification->is_read)
                                        <x-admin.action-menu-item wire:click="markAsUnread({{ $notification->id }})" icon="eye-slash">Mark Unread</x-admin.action-menu-item>
                                    @else
                                        <x-admin.action-menu-item wire:click="markAsRead({{ $notification->id }})" icon="eye">Mark Read</x-admin.action-menu-item>
                                    @endif
                                    <x-admin.action-menu-item wire:click="delete({{ $notification->id }})" icon="trash" class="text-red-600">Delete</x-admin.action-menu-item>
                                </x-admin.action-menu>
                            </div>
                        </div>
                    </div>
                </div>
            @empty
                <div class="p-12 text-center">
                    <div class="w-16 h-16 mx-auto bg-slate-100 dark:bg-slate-800 rounded-full flex items-center justify-center mb-4">
                        <x-admin.icon name="bell-slash" class="w-8 h-8 text-slate-400" />
                    </div>
                    <p class="text-slate-500 dark:text-slate-400">No notifications found.</p>
                </div>
            @endforelse
        </div>
    </x-admin.card>

    <!-- Pagination -->
    <div class="mt-6">
        {{ $notifications->links() }}
    </div>
</div>

