<div>
    {{-- Desktop Actions (Header level) --}}
    @teleport('#order-header-actions')
        <div class="hidden sm:flex flex-wrap items-center gap-2">
            @if($order->status !== \App\Models\Order::STATUS_PENDING)
                <button wire:click="$set('showPendingModal', true)" class="inline-flex items-center gap-2 rounded-xl border border-amber-500/30 bg-amber-500/10 px-4 py-2 text-sm font-medium text-amber-400 transition-all hover:bg-amber-500/20 cursor-pointer">
                    <i class="ph ph-hourglass"></i>
                    @lang('Mark as Pending')
                </button>
            @endif

            @if($order->invoice)
                <a href="{{ route('admin.invoices.details', $order->invoice_id) }}" class="inline-flex items-center gap-2 rounded-xl border border-white/10 bg-white/5 px-4 py-2 text-sm font-medium text-white transition-all hover:bg-white/10">
                    <i class="ph ph-file-text"></i>
                    @lang('View Invoice')
                </a>
            @endif

            <button wire:click="$set('showNotesModal', true)" class="inline-flex items-center gap-2 rounded-xl border border-white/10 bg-white/5 px-4 py-2 text-sm font-medium text-white transition-all hover:bg-white/10 cursor-pointer">
                <i class="ph ph-note-pencil"></i>
                @lang('Admin Notes')
            </button>
        </div>
    @endteleport

    {{-- Mobile Actions (Header level) --}}
    @teleport('#order-mobile-actions')
        <div class="flex sm:hidden -mx-4 px-4 overflow-x-auto pb-2 mt-3">
            <div class="flex items-center gap-2 min-w-max">
                @if($order->status !== \App\Models\Order::STATUS_PENDING)
                    <button wire:click="$set('showPendingModal', true)" class="inline-flex items-center gap-1.5 rounded-xl border border-amber-500/30 bg-amber-500/10 px-3 py-2 text-xs font-medium text-amber-400 transition-all active:scale-[0.98] cursor-pointer min-h-9">
                        <i class="ph ph-hourglass"></i>
                        @lang('Pending')
                    </button>
                @endif

                @if($order->invoice)
                    <a href="{{ route('admin.invoices.details', $order->invoice_id) }}" class="inline-flex items-center gap-1.5 rounded-xl border border-white/10 bg-white/5 px-3 py-2 text-xs font-medium text-white transition-all active:scale-[0.98] min-h-9">
                        <i class="ph ph-file-text"></i>
                        @lang('Invoice')
                    </a>
                @endif

                <button wire:click="$set('showNotesModal', true)" class="inline-flex items-center gap-1.5 rounded-xl border border-white/10 bg-white/5 px-3 py-2 text-xs font-medium text-white transition-all active:scale-[0.98] cursor-pointer min-h-9">
                    <i class="ph ph-note-pencil"></i>
                    @lang('Notes')
                </button>
            </div>
        </div>
    @endteleport

    {{-- Bottom Provisions Actions for Pending Orders --}}
    @if($order->status === \App\Models\Order::STATUS_PENDING)
        {{-- Desktop Actions --}}
        <div class="hidden sm:flex mt-6 justify-end gap-3">
            <button wire:click="$set('showCancelModal', true)" class="inline-flex items-center gap-2 rounded-xl border border-red-500/30 bg-red-500/10 px-5 py-2.5 text-sm font-medium text-red-400 transition-all hover:bg-red-500/20 cursor-pointer">
                <i class="ph ph-link-break"></i>
                @lang('Cancel Order')
            </button>
            <button wire:click="$set('showAcceptModal', true)" class="inline-flex items-center gap-2 rounded-xl bg-gradient-to-r from-primary-500 to-primary-600 px-5 py-2.5 text-sm font-medium text-white shadow-lg shadow-primary-500/25 transition-all hover:shadow-primary-500/40 cursor-pointer">
                <i class="ph ph-check-circle"></i>
                @lang('Accept Order')
            </button>
        </div>
        {{-- Mobile Actions --}}
        <div class="flex sm:hidden mt-4 flex-col gap-2">
            <button wire:click="$set('showAcceptModal', true)" class="w-full inline-flex items-center justify-center gap-2 rounded-xl bg-gradient-to-r from-primary-500 to-primary-600 px-4 py-3 text-sm font-medium text-white shadow-lg shadow-primary-500/25 transition-all active:scale-[0.98] cursor-pointer min-h-11">
                <i class="ph ph-check-circle"></i>
                @lang('Accept Order')
            </button>
            <button wire:click="$set('showCancelModal', true)" class="w-full inline-flex items-center justify-center gap-2 rounded-xl border border-red-500/30 bg-red-500/10 px-4 py-3 text-sm font-medium text-red-400 transition-all active:scale-[0.98] cursor-pointer min-h-11">
                <i class="ph ph-link-break"></i>
                @lang('Cancel Order')
            </button>
        </div>
    @endif

    {{-- Admin Notes Modal --}}
    <x-admin.modal wire:model="showNotesModal" :title="__('Admin Notes')" maxWidth="lg">
        <div class="space-y-3 sm:space-y-4">
            <p class="text-xs sm:text-sm text-slate-400">@lang('Add internal notes for this order. These notes are only visible to administrators.')</p>
            <textarea
                wire:model="adminNotes"
                rows="5"
                class="w-full rounded-xl border border-white/10 bg-white/5 px-3 sm:px-4 py-2.5 sm:py-3 text-base sm:text-sm text-white placeholder-slate-500 transition-all focus:border-primary-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-primary-500/20"
                placeholder="{{ __('Enter admin notes...') }}"
            ></textarea>
        </div>
        <x-slot name="footer">
            <div class="flex flex-col-reverse sm:flex-row gap-2 sm:gap-3 w-full sm:w-auto sm:justify-end">
                <button wire:click="$set('showNotesModal', false)" class="w-full sm:w-auto rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 sm:py-2 text-sm font-medium text-white transition-all hover:bg-white/10 active:scale-[0.98] cursor-pointer min-h-11 sm:min-h-0">
                    @lang('Cancel')
                </button>
                <button wire:click="saveNotes" wire:loading.attr="disabled" wire:loading.class="opacity-50" class="w-full sm:w-auto rounded-xl bg-gradient-to-r from-primary-500 to-primary-600 px-4 py-2.5 sm:py-2 text-sm font-medium text-white shadow-lg shadow-primary-500/25 transition-all hover:shadow-primary-500/40 active:scale-[0.98] cursor-pointer min-h-11 sm:min-h-0">
                    <span wire:loading.remove wire:target="saveNotes">@lang('Save Notes')</span>
                    <span wire:loading wire:target="saveNotes">@lang('Saving...')</span>
                </button>
            </div>
        </x-slot>
    </x-admin.modal>

    {{-- Accept Order Modal --}}
    <x-admin.modal wire:model="showAcceptModal" :title="__('Accept Order')" maxWidth="md">
        <div class="text-center">
            <div class="mx-auto flex h-12 w-12 sm:h-16 sm:w-16 items-center justify-center rounded-xl sm:rounded-2xl bg-emerald-500/10">
                <i class="ph ph-check-circle text-2xl sm:text-3xl text-emerald-400"></i>
            </div>
            <h3 class="mt-3 sm:mt-4 text-base sm:text-lg font-semibold text-white">@lang('Accept this order?')</h3>
            <p class="mt-1.5 sm:mt-2 text-xs sm:text-sm text-slate-400">@lang('This will activate all services and domains associated with this order.')</p>
        </div>
        <x-slot name="footer">
            <div class="flex flex-col-reverse sm:flex-row gap-2 sm:gap-3 w-full sm:w-auto sm:justify-end">
                <button wire:click="$set('showAcceptModal', false)" class="w-full sm:w-auto rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 sm:py-2 text-sm font-medium text-white transition-all hover:bg-white/10 active:scale-[0.98] cursor-pointer min-h-11 sm:min-h-0">
                    @lang('No, Cancel')
                </button>
                <button wire:click="acceptOrder" wire:loading.attr="disabled" wire:loading.class="opacity-50" class="w-full sm:w-auto rounded-xl bg-gradient-to-r from-emerald-500 to-emerald-600 px-4 py-2.5 sm:py-2 text-sm font-medium text-white shadow-lg shadow-emerald-500/25 transition-all hover:shadow-emerald-500/40 active:scale-[0.98] cursor-pointer min-h-11 sm:min-h-0">
                    <span wire:loading.remove wire:target="acceptOrder">@lang('Yes, Accept Order')</span>
                    <span wire:loading wire:target="acceptOrder">@lang('Processing...')</span>
                </button>
            </div>
        </x-slot>
    </x-admin.modal>

    {{-- Cancel Order Modal --}}
    <x-admin.modal wire:model="showCancelModal" :title="__('Cancel Order')" maxWidth="md">
        <div class="text-center">
            <div class="mx-auto flex h-12 w-12 sm:h-16 sm:w-16 items-center justify-center rounded-xl sm:rounded-2xl bg-red-500/10">
                <i class="ph ph-link-break text-2xl sm:text-3xl text-red-400"></i>
            </div>
            <h3 class="mt-3 sm:mt-4 text-base sm:text-lg font-semibold text-white">@lang('Cancel this order?')</h3>
            <p class="mt-1.5 sm:mt-2 text-xs sm:text-sm text-slate-400">@lang('This will cancel all services and domains associated with this order. This action cannot be undone.')</p>
        </div>
        <x-slot name="footer">
            <div class="flex flex-col-reverse sm:flex-row gap-2 sm:gap-3 w-full sm:w-auto sm:justify-end">
                <button wire:click="$set('showCancelModal', false)" class="w-full sm:w-auto rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 sm:py-2 text-sm font-medium text-white transition-all hover:bg-white/10 active:scale-[0.98] cursor-pointer min-h-11 sm:min-h-0">
                    @lang('No, Keep Order')
                </button>
                <button wire:click="cancelOrder" wire:loading.attr="disabled" wire:loading.class="opacity-50" class="w-full sm:w-auto rounded-xl bg-gradient-to-r from-red-500 to-red-600 px-4 py-2.5 sm:py-2 text-sm font-medium text-white shadow-lg shadow-red-500/25 transition-all hover:shadow-red-500/40 active:scale-[0.98] cursor-pointer min-h-11 sm:min-h-0">
                    <span wire:loading.remove wire:target="cancelOrder">@lang('Yes, Cancel Order')</span>
                    <span wire:loading wire:target="cancelOrder">@lang('Cancelling...')</span>
                </button>
            </div>
        </x-slot>
    </x-admin.modal>

    {{-- Mark as Pending Modal --}}
    <x-admin.modal wire:model="showPendingModal" :title="__('Mark as Pending')" maxWidth="md">
        <div class="text-center">
            <div class="mx-auto flex h-12 w-12 sm:h-16 sm:w-16 items-center justify-center rounded-xl sm:rounded-2xl bg-amber-500/10">
                <i class="ph ph-hourglass text-2xl sm:text-3xl text-amber-400"></i>
            </div>
            <h3 class="mt-3 sm:mt-4 text-base sm:text-lg font-semibold text-white">@lang('Set order back to pending?')</h3>
            <p class="mt-1.5 sm:mt-2 text-xs sm:text-sm text-slate-400">@lang('This will set all services and domains back to pending status.')</p>
        </div>
        <x-slot name="footer">
            <div class="flex flex-col-reverse sm:flex-row gap-2 sm:gap-3 w-full sm:w-auto sm:justify-end">
                <button wire:click="$set('showPendingModal', false)" class="w-full sm:w-auto rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 sm:py-2 text-sm font-medium text-white transition-all hover:bg-white/10 active:scale-[0.98] cursor-pointer min-h-11 sm:min-h-0">
                    @lang('No, Cancel')
                </button>
                <button wire:click="markPending" wire:loading.attr="disabled" wire:loading.class="opacity-50" class="w-full sm:w-auto rounded-xl bg-gradient-to-r from-amber-500 to-amber-600 px-4 py-2.5 sm:py-2 text-sm font-medium text-white shadow-lg shadow-amber-500/25 transition-all hover:shadow-amber-500/40 active:scale-[0.98] cursor-pointer min-h-11 sm:min-h-0">
                    <span wire:loading.remove wire:target="markPending">@lang('Yes, Mark as Pending')</span>
                    <span wire:loading wire:target="markPending">@lang('Processing...')</span>
                </button>
            </div>
        </x-slot>
    </x-admin.modal>
</div>
