<div class="mt-4 sm:mt-6">
    <x-admin.card :padding="false">
        <div class="border-b border-white/5 px-4 sm:px-6 py-3 sm:py-4">
            <h3 class="text-base sm:text-lg font-semibold text-white">@lang('Order Items')</h3>
        </div>
        
        {{-- Desktop Table --}}
        <div class="hidden md:block overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-white/5 bg-white/[0.02]">
                        <th class="px-6 py-4 text-left">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Service')</span>
                        </th>
                        <th class="px-6 py-4 text-left">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Description')</span>
                        </th>
                        <th class="px-6 py-4 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Billing Cycle')</span>
                        </th>
                        <th class="px-6 py-4 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Amount')</span>
                        </th>
                        <th class="px-6 py-4 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Payment')</span>
                        </th>
                        <th class="px-6 py-4 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Status')</span>
                        </th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    {{-- Hostings --}}
                    @foreach($order->hostings as $hosting)
                        @php $product = $hosting->product; @endphp
                        <tr class="transition-all hover:bg-white/[0.02]">
                            <td class="px-6 py-4">
                                <a href="{{ route('admin.order.hosting.details', $hosting->id) }}" class="font-semibold text-primary-400 hover:underline">
                                    {{ $product?->item ?? __('Hosting') }}
                                </a>
                            </td>
                            <td class="px-6 py-4">
                                <span class="text-sm text-slate-400">{{ $product?->serviceCategory?->name ?? __('N/A') }}</span>
                                <span class="text-sm text-white"> - {{ $product?->name ?? __('Unknown Product') }}</span>
                            </td>
                            <td class="px-6 py-4 text-center">
                                @php
                                    $billingCycles = [
                                        0 => __('One Time'),
                                        1 => __('Monthly'),
                                        2 => __('Quarterly'),
                                        3 => __('Semi-Annually'),
                                        4 => __('Annually'),
                                        5 => __('Biennially'),
                                        6 => __('Triennially'),
                                    ];
                                @endphp
                                <span class="text-sm text-slate-400">{{ $billingCycles[$hosting->billing_cycle] ?? __('N/A') }}</span>
                            </td>
                            <td class="px-6 py-4 text-center">
                                <span class="text-sm font-semibold text-white">${{ number_format($hosting->recurring_amount, 2) }}</span>
                            </td>
                            <td class="px-6 py-4 text-center">
                                @if($order->invoice)
                                    @php
                                        $invoiceStatusColors = [
                                            \App\Models\Invoice::STATUS_UNPAID => 'bg-amber-500/10 text-amber-400',
                                            \App\Models\Invoice::STATUS_PAID => 'bg-emerald-500/10 text-emerald-400',
                                            \App\Models\Invoice::STATUS_CANCELLED => 'bg-slate-500/10 text-slate-400',
                                            \App\Models\Invoice::STATUS_REFUNDED => 'bg-purple-500/10 text-purple-400',
                                        ];
                                    @endphp
                                    <span class="inline-flex items-center gap-1 rounded-full px-2 py-0.5 text-xs font-medium {{ $invoiceStatusColors[$order->invoice->status] ?? 'bg-slate-500/10 text-slate-400' }}">
                                        {{ __($order->invoice->status_label) }}
                                    </span>
                                @else
                                    <span class="text-sm text-slate-500">—</span>
                                @endif
                            </td>
                            <td class="px-6 py-4 text-center">
                                @php
                                    $hostingStatusColors = [
                                        \App\Models\Hosting::STATUS_ACTIVE => 'bg-emerald-500/10 text-emerald-400',
                                        \App\Models\Hosting::STATUS_PENDING => 'bg-amber-500/10 text-amber-400',
                                        \App\Models\Hosting::STATUS_SUSPENDED => 'bg-orange-500/10 text-orange-400',
                                        \App\Models\Hosting::STATUS_TERMINATED => 'bg-red-500/10 text-red-400',
                                        \App\Models\Hosting::STATUS_CANCELLED => 'bg-slate-500/10 text-slate-400',
                                    ];
                                @endphp
                                <span class="inline-flex items-center gap-1.5 rounded-full px-3 py-1 text-xs font-medium {{ $hostingStatusColors[$hosting->status] ?? 'bg-slate-500/10 text-slate-400' }}">
                                    <span class="h-1.5 w-1.5 rounded-full bg-current"></span>
                                    {{ __($hosting->status_label) }}
                                </span>
                            </td>
                        </tr>
                    @endforeach

                    {{-- Domains --}}
                    @foreach($order->domains as $domain)
                        @php
                            $invoiceStatusColors = [
                                \App\Models\Invoice::STATUS_UNPAID => 'bg-amber-500/10 text-amber-400',
                                \App\Models\Invoice::STATUS_PAID => 'bg-emerald-500/10 text-emerald-400',
                                \App\Models\Invoice::STATUS_CANCELLED => 'bg-slate-500/10 text-slate-400',
                                \App\Models\Invoice::STATUS_REFUNDED => 'bg-purple-500/10 text-purple-400',
                            ];
                        @endphp
                        <tr class="transition-all hover:bg-white/[0.02]">
                            <td class="px-6 py-4">
                                <a href="{{ route('admin.order.domain.details', $domain->id) }}" class="font-semibold text-primary-400 hover:underline">
                                    @lang('Domain')
                                </a>
                            </td>
                            <td class="px-6 py-4">
                                <span class="text-sm text-white">@lang('Registration') - {{ $domain->domain }}</span>
                                @if($domain->id_protection)
                                    <span class="ml-2 inline-flex items-center rounded-full bg-emerald-500/10 px-2 py-0.5 text-xs font-medium text-emerald-400">
                                        <i class="ph-fill ph-shield-check text-xs mr-1"></i>
                                        @lang('ID Protection')
                                    </span>
                                @endif
                            </td>
                            <td class="px-6 py-4 text-center">
                                <span class="text-sm text-slate-400">{{ $domain->reg_period }} @lang('Year(s)')</span>
                            </td>
                            <td class="px-6 py-4 text-center">
                                <span class="text-sm font-semibold text-white">${{ number_format($domain->recurring_amount ?? 0, 2) }}</span>
                            </td>
                            <td class="px-6 py-4 text-center">
                                @if($order->invoice)
                                    <span class="inline-flex items-center gap-1 rounded-full px-2 py-0.5 text-xs font-medium {{ $invoiceStatusColors[$order->invoice->status] ?? 'bg-slate-500/10 text-slate-400' }}">
                                        {{ __($order->invoice->status_label) }}
                                    </span>
                                @else
                                    <span class="text-sm text-slate-500">—</span>
                                @endif
                            </td>
                            <td class="px-6 py-4 text-center">
                                @php
                                    $domainStatusColors = [
                                        \App\Models\Domain::STATUS_ACTIVE => 'bg-emerald-500/10 text-emerald-400',
                                        \App\Models\Domain::STATUS_PENDING => 'bg-amber-500/10 text-amber-400',
                                        \App\Models\Domain::STATUS_SUSPENDED => 'bg-orange-500/10 text-orange-400',
                                        \App\Models\Domain::STATUS_TERMINATED => 'bg-red-500/10 text-red-400',
                                        \App\Models\Domain::STATUS_CANCELLED => 'bg-slate-500/10 text-slate-400',
                                    ];
                                @endphp
                                <span class="inline-flex items-center gap-1.5 rounded-full px-3 py-1 text-xs font-medium {{ $domainStatusColors[$domain->status] ?? 'bg-slate-500/10 text-slate-400' }}">
                                    <span class="h-1.5 w-1.5 rounded-full bg-current"></span>
                                    {{ __($domain->status_label) }}
                                </span>
                            </td>
                        </tr>
                    @endforeach

                    @if($order->hostings->isEmpty() && $order->domains->isEmpty())
                        <tr>
                            <td colspan="6" class="px-6 py-12 text-center">
                                <div class="flex flex-col items-center">
                                    <i class="ph-duotone ph-package text-3xl text-slate-500"></i>
                                    <p class="mt-2 text-sm text-slate-500">@lang('No items in this order.')</p>
                                </div>
                            </td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>

        {{-- Mobile Card View --}}
        <div class="md:hidden divide-y divide-white/5">
            {{-- Hostings --}}
            @foreach($order->hostings as $hosting)
                @php
                    $product = $hosting->product;
                    $billingCycles = [
                        0 => __('One Time'),
                        1 => __('Monthly'),
                        2 => __('Quarterly'),
                        3 => __('Semi-Annually'),
                        4 => __('Annually'),
                        5 => __('Biennially'),
                        6 => __('Triennially'),
                    ];
                    $hostingStatusColors = [
                        \App\Models\Hosting::STATUS_ACTIVE => 'bg-emerald-500/10 text-emerald-400',
                        \App\Models\Hosting::STATUS_PENDING => 'bg-amber-500/10 text-amber-400',
                        \App\Models\Hosting::STATUS_SUSPENDED => 'bg-orange-500/10 text-orange-400',
                        \App\Models\Hosting::STATUS_TERMINATED => 'bg-red-500/10 text-red-400',
                        \App\Models\Hosting::STATUS_CANCELLED => 'bg-slate-500/10 text-slate-400',
                    ];
                @endphp
                <a href="{{ route('admin.order.hosting.details', $hosting->id) }}" class="block p-4 active:bg-white/5 transition-colors">
                    <div class="flex items-start justify-between gap-3">
                        <div class="min-w-0 flex-1">
                            <p class="text-sm font-semibold text-primary-400 truncate">{{ $product?->item ?? __('Hosting') }}</p>
                            <p class="text-xs text-slate-400 mt-0.5 truncate">{{ $product?->serviceCategory?->name ?? __('N/A') }} - {{ $product?->name ?? __('Unknown') }}</p>
                        </div>
                        <span class="inline-flex items-center gap-1 rounded-full px-2 py-0.5 text-[10px] font-medium {{ $hostingStatusColors[$hosting->status] ?? 'bg-slate-500/10 text-slate-400' }}">
                            <span class="h-1 w-1 rounded-full bg-current"></span>
                            {{ __($hosting->status_label) }}
                        </span>
                    </div>
                    <div class="flex items-center justify-between mt-2 text-xs">
                        <span class="text-slate-500">{{ $billingCycles[$hosting->billing_cycle] ?? __('N/A') }}</span>
                        <span class="font-semibold text-white">${{ number_format($hosting->recurring_amount, 2) }}</span>
                    </div>
                </a>
            @endforeach

            {{-- Domains --}}
            @foreach($order->domains as $domain)
                @php
                    $domainStatusColors = [
                        \App\Models\Domain::STATUS_ACTIVE => 'bg-emerald-500/10 text-emerald-400',
                        \App\Models\Domain::STATUS_PENDING => 'bg-amber-500/10 text-amber-400',
                        \App\Models\Domain::STATUS_SUSPENDED => 'bg-orange-500/10 text-orange-400',
                        \App\Models\Domain::STATUS_TERMINATED => 'bg-red-500/10 text-red-400',
                        \App\Models\Domain::STATUS_CANCELLED => 'bg-slate-500/10 text-slate-400',
                    ];
                @endphp
                <a href="{{ route('admin.order.domain.details', $domain->id) }}" class="block p-4 active:bg-white/5 transition-colors">
                    <div class="flex items-start justify-between gap-3">
                        <div class="min-w-0 flex-1">
                            <p class="text-sm font-semibold text-primary-400 truncate">@lang('Domain')</p>
                            <p class="text-xs text-slate-400 mt-0.5 truncate">{{ $domain->domain }}</p>
                        </div>
                        <span class="inline-flex items-center gap-1 rounded-full px-2 py-0.5 text-[10px] font-medium {{ $domainStatusColors[$domain->status] ?? 'bg-slate-500/10 text-slate-400' }}">
                            <span class="h-1 w-1 rounded-full bg-current"></span>
                            {{ __($domain->status_label) }}
                        </span>
                    </div>
                    <div class="flex items-center justify-between mt-2 text-xs">
                        <span class="text-slate-500">{{ $domain->reg_period }} @lang('Year(s)')</span>
                        <span class="font-semibold text-white">${{ number_format($domain->recurring_amount ?? 0, 2) }}</span>
                    </div>
                </a>
            @endforeach

            @if($order->hostings->isEmpty() && $order->domains->isEmpty())
                <div class="p-8 text-center">
                    <i class="ph-duotone ph-package text-2xl text-slate-500"></i>
                    <p class="mt-2 text-xs text-slate-500">@lang('No items in this order.')</p>
                </div>
            @endif
        </div>
    </x-admin.card>
</div>
