<div>
    {{-- Page Header with Actions --}}
    @php $pageTitle = __('Order') . ' #' . $order->id; @endphp
    <div class="flex flex-col gap-3 sm:gap-4 sm:flex-row sm:items-center sm:justify-between">
        <x-admin.page-header :title="$pageTitle" :subtitle="__('View and manage order details.')" />

        {{-- Desktop Actions Target --}}
        <div id="order-header-actions"></div>
    </div>

    {{-- Mobile Actions Target --}}
    <div id="order-mobile-actions"></div>

    {{-- Order Info Cards --}}
    <div class="mt-4 sm:mt-6 grid grid-cols-1 gap-4 sm:gap-6 lg:grid-cols-2">
        {{-- Order Status Card --}}
        <x-admin.card>
            <h3 class="mb-3 sm:mb-4 text-base sm:text-lg font-semibold text-white">@lang('Order Information')</h3>
            <div class="space-y-2.5 sm:space-y-3">
                <div class="flex items-center justify-between border-b border-white/5 pb-2.5 sm:pb-3">
                    <span class="text-xs sm:text-sm text-slate-400">@lang('Order Status')</span>
                    @php
                        $statusColors = [
                            \App\Models\Order::STATUS_ACTIVE => 'bg-emerald-500/10 text-emerald-400',
                            \App\Models\Order::STATUS_PENDING => 'bg-amber-500/10 text-amber-400',
                            \App\Models\Order::STATUS_CANCELLED => 'bg-red-500/10 text-red-400',
                        ];
                    @endphp
                    <span class="inline-flex items-center gap-1 sm:gap-1.5 rounded-full px-2 sm:px-3 py-0.5 sm:py-1 text-[10px] sm:text-xs font-medium {{ $statusColors[$order->status] ?? 'bg-slate-500/10 text-slate-400' }}">
                        <span class="h-1 w-1 sm:h-1.5 sm:w-1.5 rounded-full bg-current"></span>
                        {{ __($order->status_label) }}
                    </span>
                </div>
                <div class="flex items-center justify-between border-b border-white/5 pb-2.5 sm:pb-3">
                    <span class="text-xs sm:text-sm text-slate-400">@lang('Order Date')</span>
                    <span class="text-xs sm:text-sm text-white">{{ $order->created_at->format('d/m/Y H:i') }}</span>
                </div>
                <div class="flex items-center justify-between border-b border-white/5 pb-2.5 sm:pb-3">
                    <span class="text-xs sm:text-sm text-slate-400">@lang('Order #')</span>
                    <span class="font-mono text-xs sm:text-sm font-semibold text-white">#{{ $order->id }}</span>
                </div>
                <div class="flex items-center justify-between border-b border-white/5 pb-2.5 sm:pb-3">
                    <span class="text-xs sm:text-sm text-slate-400">@lang('Client')</span>
                    @if($order->user)
                        <a href="{{ route('admin.users.detail', $order->user->username) }}" class="text-xs sm:text-sm text-primary-400 hover:underline truncate max-w-[120px] sm:max-w-none">
                            {{ $order->user->fullname }}
                        </a>
                    @else
                        <span class="text-xs sm:text-sm text-slate-500">@lang('Unknown')</span>
                    @endif
                </div>
                <div class="flex items-center justify-between">
                    <span class="text-xs sm:text-sm text-slate-400">@lang('IP Address')</span>
                    @php
                        $cleanIp = strip_tags($order->ip_address ?? '');
                    @endphp
                    <a href="https://extreme-ip-lookup.com/{{ $cleanIp }}" target="_blank" class="text-xs sm:text-sm text-primary-400 hover:underline">
                        {{ $order->ip_address ?? __('N/A') }}
                    </a>
                </div>
            </div>
        </x-admin.card>

        {{-- Payment Info Card --}}
        <x-admin.card>
            <h3 class="mb-3 sm:mb-4 text-base sm:text-lg font-semibold text-white">@lang('Payment Information')</h3>
            <div class="space-y-2.5 sm:space-y-3">
                <div class="flex items-center justify-between border-b border-white/5 pb-2.5 sm:pb-3">
                    <span class="text-xs sm:text-sm text-slate-400">@lang('Amount')</span>
                    <span class="text-xs sm:text-sm font-semibold text-white">${{ number_format($order->amount, 2) }}</span>
                </div>
                <div class="flex items-center justify-between border-b border-white/5 pb-2.5 sm:pb-3">
                    <span class="text-xs sm:text-sm text-slate-400">@lang('Discount')</span>
                    <span class="text-xs sm:text-sm text-emerald-400">-${{ number_format($order->discount ?? 0, 2) }}</span>
                </div>
                <div class="flex items-center justify-between border-b border-white/5 pb-2.5 sm:pb-3">
                    <span class="text-xs sm:text-sm text-slate-400">@lang('After Discount')</span>
                    <span class="text-xs sm:text-sm font-bold text-white">${{ number_format($order->after_discount ?? $order->amount, 2) }}</span>
                </div>
                <div class="flex items-center justify-between border-b border-white/5 pb-2.5 sm:pb-3">
                    <span class="text-xs sm:text-sm text-slate-400">@lang('Invoice')</span>
                    @if($order->invoice)
                        <a href="{{ route('admin.invoices.details', $order->invoice_id) }}" class="text-xs sm:text-sm text-primary-400 hover:underline">
                            #{{ $order->invoice->invoice_number ?? $order->invoice_id }}
                        </a>
                    @else
                        <span class="text-xs sm:text-sm text-slate-500">@lang('N/A')</span>
                    @endif
                </div>
                <div class="flex items-center justify-between">
                    <span class="text-xs sm:text-sm text-slate-400">@lang('Coupon Code')</span>
                    <span class="text-xs sm:text-sm text-white">{{ $order->coupon?->code ?? __('N/A') }}</span>
                </div>
            </div>
        </x-admin.card>
    </div>

    {{-- Order Items Component --}}
    @livewire('admin.orders.details.order-items', ['order' => $order], key('items-' . $order->id))

    {{-- Order Actions Component --}}
    @livewire('admin.orders.details.order-actions', ['order' => $order], key('actions-' . $order->id))
</div>
