<div>
    {{-- Page Header --}}
    @php $pageTitle = __('Deposit') . ' #' . $deposit->trx; @endphp
    <div class="flex flex-col gap-3 sm:gap-4 sm:flex-row sm:items-center sm:justify-between">
        <x-admin.page-header :title="$pageTitle" :subtitle="__('View and manage deposit details.')" />
        {{-- Desktop Back Button --}}
        <a href="{{ route('admin.deposit.list') }}" class="hidden sm:inline-flex items-center gap-2 rounded-xl border border-white/10 bg-white/5 px-4 py-2 text-sm font-medium text-white transition-all hover:bg-white/10">
            <i class="ph-duotone ph-arrow-left"></i>
            @lang('Back to Deposits')
        </a>
    </div>

    {{-- Mobile Back Button --}}
    <div class="flex sm:hidden mt-3">
        <a href="{{ route('admin.deposit.list') }}" class="inline-flex items-center gap-1.5 rounded-xl border border-white/10 bg-white/5 px-3 py-2 text-xs font-medium text-white transition-all active:scale-[0.98] min-h-9">
            <i class="ph-duotone ph-arrow-left"></i>
            @lang('Back')
        </a>
    </div>

    <div class="mt-4 sm:mt-6 grid grid-cols-1 gap-4 sm:gap-6 lg:grid-cols-3">
        {{-- Left Column: Deposit Info --}}
        <div class="lg:col-span-2 space-y-4 sm:space-y-6 order-2 lg:order-1">
            {{-- Deposit Details Card --}}
            <x-admin.card>
                <div class="flex flex-col sm:flex-row sm:items-center justify-between gap-3 border-b border-white/5 pb-3 sm:pb-4">
                    <div class="flex items-center gap-2.5 sm:gap-3">
                        <div class="flex h-10 w-10 sm:h-12 sm:w-12 shrink-0 items-center justify-center rounded-xl bg-purple-500/10">
                            <i class="ph-duotone ph-wallet text-xl sm:text-2xl text-purple-400"></i>
                        </div>
                        <div class="min-w-0">
                            <h3 class="text-sm sm:text-lg font-semibold text-white">@lang('Deposit Information')</h3>
                            <p class="text-xs sm:text-sm text-slate-400 truncate">@lang('Transaction details and payment info')</p>
                        </div>
                    </div>
                    {{-- Status Badge --}}
                    @switch($deposit->status)
                        @case(0)
                            <span class="inline-flex items-center gap-1 sm:gap-1.5 rounded-lg sm:rounded-xl border border-blue-500/20 bg-blue-500/10 px-2.5 sm:px-4 py-1.5 sm:py-2 text-xs sm:text-sm font-medium text-blue-400 self-start sm:self-auto">
                                <i class="ph-duotone ph-hourglass"></i>
                                @lang('Initiated')
                            </span>
                            @break
                        @case(1)
                            <span class="inline-flex items-center gap-1 sm:gap-1.5 rounded-lg sm:rounded-xl border border-emerald-500/20 bg-emerald-500/10 px-2.5 sm:px-4 py-1.5 sm:py-2 text-xs sm:text-sm font-medium text-emerald-400 self-start sm:self-auto">
                                <i class="ph-duotone ph-check-circle"></i>
                                @lang('Complete')
                            </span>
                            @break
                        @case(2)
                            <span class="inline-flex items-center gap-1 sm:gap-1.5 rounded-lg sm:rounded-xl border border-amber-500/20 bg-amber-500/10 px-2.5 sm:px-4 py-1.5 sm:py-2 text-xs sm:text-sm font-medium text-amber-400 self-start sm:self-auto">
                                <i class="ph-duotone ph-clock"></i>
                                @lang('Pending')
                            </span>
                            @break
                        @case(3)
                            <span class="inline-flex items-center gap-1 sm:gap-1.5 rounded-lg sm:rounded-xl border border-rose-500/20 bg-rose-500/10 px-2.5 sm:px-4 py-1.5 sm:py-2 text-xs sm:text-sm font-medium text-rose-400 self-start sm:self-auto">
                                <i class="ph-duotone ph-x-circle"></i>
                                @lang('Cancelled')
                            </span>
                            @break
                    @endswitch
                </div>

                <div class="mt-4 sm:mt-6 grid grid-cols-1 sm:grid-cols-2 gap-3 sm:gap-6">
                    {{-- Transaction ID --}}
                    <div class="rounded-xl border border-white/5 bg-white/5 p-3 sm:p-4">
                        <p class="text-[10px] sm:text-xs font-medium uppercase tracking-wider text-slate-400">@lang('Transaction ID')</p>
                        <p class="mt-0.5 sm:mt-1 font-mono text-sm sm:text-lg text-white truncate">{{ $deposit->trx }}</p>
                    </div>

                    {{-- Gateway --}}
                    <div class="rounded-xl border border-white/5 bg-white/5 p-3 sm:p-4">
                        <p class="text-[10px] sm:text-xs font-medium uppercase tracking-wider text-slate-400">@lang('Payment Gateway')</p>
                        <p class="mt-0.5 sm:mt-1 text-sm sm:text-lg text-white truncate">{{ $deposit->gateway->name ?? __('Unknown') }}</p>
                    </div>

                    {{-- Amount --}}
                    <div class="rounded-xl border border-white/5 bg-white/5 p-3 sm:p-4">
                        <p class="text-[10px] sm:text-xs font-medium uppercase tracking-wider text-slate-400">@lang('Amount')</p>
                        <p class="mt-0.5 sm:mt-1 text-xl sm:text-2xl font-bold text-emerald-400">{{ gs('cur_sym') ?? '$' }}{{ number_format($deposit->amount, 2) }}</p>
                    </div>

                    {{-- Charge --}}
                    <div class="rounded-xl border border-white/5 bg-white/5 p-3 sm:p-4">
                        <p class="text-[10px] sm:text-xs font-medium uppercase tracking-wider text-slate-400">@lang('Charge')</p>
                        <p class="mt-0.5 sm:mt-1 text-sm sm:text-lg text-rose-400">{{ gs('cur_sym') ?? '$' }}{{ number_format($deposit->charge, 2) }}</p>
                    </div>

                    {{-- Final Amount --}}
                    <div class="rounded-xl border border-white/5 bg-white/5 p-3 sm:p-4">
                        <p class="text-[10px] sm:text-xs font-medium uppercase tracking-wider text-slate-400">@lang('Final Amount (Gateway Currency)')</p>
                        <p class="mt-0.5 sm:mt-1 text-sm sm:text-lg text-white">{{ number_format($deposit->final_amount, 2) }} {{ $deposit->method_currency }}</p>
                    </div>

                    {{-- Exchange Rate --}}
                    <div class="rounded-xl border border-white/5 bg-white/5 p-3 sm:p-4">
                        <p class="text-[10px] sm:text-xs font-medium uppercase tracking-wider text-slate-400">@lang('Exchange Rate')</p>
                        <p class="mt-0.5 sm:mt-1 text-sm sm:text-lg text-white">1 {{ gs('cur_text') ?? 'USD' }} = {{ number_format($deposit->rate, 4) }} {{ $deposit->method_currency }}</p>
                    </div>

                    {{-- Date --}}
                    <div class="rounded-xl border border-white/5 bg-white/5 p-3 sm:p-4">
                        <p class="text-[10px] sm:text-xs font-medium uppercase tracking-wider text-slate-400">@lang('Created At')</p>
                        <p class="mt-0.5 sm:mt-1 text-sm sm:text-lg text-white">{{ $deposit->created_at->format('M d, Y h:i A') }}</p>
                    </div>

                    {{-- Updated --}}
                    <div class="rounded-xl border border-white/5 bg-white/5 p-3 sm:p-4">
                        <p class="text-[10px] sm:text-xs font-medium uppercase tracking-wider text-slate-400">@lang('Last Updated')</p>
                        <p class="mt-0.5 sm:mt-1 text-sm sm:text-lg text-white">{{ $deposit->updated_at->format('M d, Y h:i A') }}</p>
                    </div>

                    {{-- External ID (Gateway Reference) --}}
                    @if($deposit->btc_wallet)
                        <div class="sm:col-span-2 rounded-xl border border-white/5 bg-white/5 p-3 sm:p-4">
                            <div class="flex flex-col sm:flex-row sm:items-center justify-between gap-3">
                                <div>
                                    <p class="text-[10px] sm:text-xs font-medium uppercase tracking-wider text-slate-400">@lang('External Gateway ID')</p>
                                    <p class="mt-0.5 sm:mt-1 font-mono text-sm text-white truncate max-w-[200px] sm:max-w-md">{{ $deposit->btc_wallet }}</p>
                                </div>
                                @if(strtolower($deposit->gateway->alias ?? '') == 'stripe')
                                    <a href="https://dashboard.stripe.com/{{ $deposit->gateway->code < 1000 && str_contains($deposit->btc_wallet, '_test_') ? 'test/' : '' }}checkout-sessions/{{ $deposit->btc_wallet }}" 
                                       target="_blank" 
                                       class="inline-flex items-center justify-center gap-1.5 rounded-lg border border-purple-500/30 bg-purple-500/10 px-3 py-1.5 text-xs font-medium text-purple-400 transition-all hover:bg-purple-500/20 active:scale-[0.98]">
                                        <i class="ph-duotone ph-arrow-square-out text-base"></i>
                                        @lang('View in Stripe')
                                    </a>
                                @endif
                            </div>
                        </div>
                    @endif
                </div>

                {{-- Invoice Link --}}
                @if($deposit->invoice_id)
                    <div class="mt-4 sm:mt-6 rounded-xl border border-indigo-500/20 bg-indigo-500/5 p-3 sm:p-4">
                        <div class="flex flex-col sm:flex-row sm:items-center justify-between gap-3">
                            <div class="flex items-center gap-2.5 sm:gap-3">
                                <i class="ph-duotone ph-file-text text-xl sm:text-2xl text-indigo-400"></i>
                                <div class="min-w-0">
                                    <p class="text-xs sm:text-sm font-medium text-white">@lang('Linked Invoice')</p>
                                    <p class="text-[10px] sm:text-xs text-slate-400 truncate">{{ __('This deposit is for invoice #:id', ['id' => $deposit->invoice_id]) }}</p>
                                </div>
                            </div>
                            <a href="{{ route('admin.invoices.details', $deposit->invoice_id) }}" class="inline-flex items-center justify-center gap-1.5 sm:gap-2 rounded-xl border border-indigo-500/30 bg-indigo-500/10 px-3 sm:px-4 py-2 text-xs sm:text-sm font-medium text-indigo-400 transition-all hover:bg-indigo-500/20 active:scale-[0.98] min-h-9 sm:min-h-0">
                                <i class="ph-duotone ph-arrow-right"></i>
                                @lang('View Invoice')
                            </a>
                        </div>
                    </div>
                @endif

                {{-- Admin Feedback (if rejected) --}}
                @if($deposit->status === 3 && $deposit->admin_feedback)
                    <div class="mt-4 sm:mt-6 rounded-xl border border-rose-500/20 bg-rose-500/5 p-3 sm:p-4">
                        <div class="flex items-start gap-2.5 sm:gap-3">
                            <i class="ph-duotone ph-warning text-xl sm:text-2xl text-rose-400 shrink-0"></i>
                            <div class="min-w-0">
                                <p class="text-xs sm:text-sm font-medium text-rose-400">@lang('Rejection Reason')</p>
                                <p class="mt-0.5 sm:mt-1 text-xs sm:text-sm text-slate-300">{{ $deposit->admin_feedback }}</p>
                            </div>
                        </div>
                    </div>
                @endif

                {{-- Payment Details (if any) --}}
                @if($deposit->detail && is_object($deposit->detail) && count((array)$deposit->detail) > 0)
                    <div class="mt-4 sm:mt-6">
                        <h4 class="mb-2 sm:mb-3 text-xs sm:text-sm font-medium text-white">@lang('Payment Details')</h4>
                        <div class="rounded-xl border border-white/5 bg-white/5 p-3 sm:p-4">
                            <dl class="space-y-2 sm:space-y-3">
                                @foreach((array)$deposit->detail as $key => $value)
                                    <div class="flex items-start justify-between gap-3 sm:gap-4">
                                        <dt class="text-xs sm:text-sm text-slate-400">{{ ucfirst(str_replace('_', ' ', $key)) }}</dt>
                                        <dd class="text-xs sm:text-sm text-white text-right min-w-0 truncate">
                                            @if(is_array($value) || is_object($value))
                                                <pre class="text-[10px] sm:text-xs overflow-x-auto">{{ json_encode($value, JSON_PRETTY_PRINT) }}</pre>
                                            @else
                                                {{ $value }}
                                            @endif
                                        </dd>
                                    </div>
                                @endforeach
                            </dl>
                        </div>
                    </div>
                @endif
            </x-admin.card>

            {{-- Actions Card (for pending deposits) --}}
            @if($deposit->status === 2)
                <x-admin.card>
                    <div class="flex items-center gap-2.5 sm:gap-3 border-b border-white/5 pb-3 sm:pb-4">
                        <div class="flex h-8 w-8 sm:h-10 sm:w-10 shrink-0 items-center justify-center rounded-xl bg-amber-500/10">
                            <i class="ph-duotone ph-gear text-lg sm:text-xl text-amber-400"></i>
                        </div>
                        <div>
                            <h3 class="text-xs sm:text-sm font-semibold text-white">@lang('Pending Actions')</h3>
                            <p class="text-[10px] sm:text-xs text-slate-400">@lang('Approve or reject this deposit')</p>
                        </div>
                    </div>

                    <div class="mt-4 sm:mt-6 flex flex-col gap-2 sm:gap-4 sm:flex-row">
                        <button wire:click="approve" wire:confirm="{{ __('Are you sure you want to approve this deposit? The user\'s balance will be credited.') }}" wire:loading.attr="disabled" wire:loading.class="opacity-50" class="flex-1 inline-flex items-center justify-center gap-2 rounded-xl bg-gradient-to-r from-emerald-500 to-emerald-600 px-4 sm:px-6 py-2.5 sm:py-3 text-xs sm:text-sm font-medium text-white shadow-lg shadow-emerald-500/25 transition-all hover:shadow-emerald-500/40 active:scale-[0.98] cursor-pointer min-h-11 sm:min-h-0">
                            <i class="ph-duotone ph-check-circle text-base sm:text-lg"></i>
                            @lang('Approve Deposit')
                        </button>
                        <button wire:click="openRejectModal" wire:loading.attr="disabled" wire:loading.class="opacity-50" class="flex-1 inline-flex items-center justify-center gap-2 rounded-xl bg-gradient-to-r from-rose-500 to-rose-600 px-4 sm:px-6 py-2.5 sm:py-3 text-xs sm:text-sm font-medium text-white shadow-lg shadow-rose-500/25 transition-all hover:shadow-rose-500/40 active:scale-[0.98] cursor-pointer min-h-11 sm:min-h-0">
                            <i class="ph-duotone ph-x-circle text-base sm:text-lg"></i>
                            @lang('Reject Deposit')
                        </button>
                    </div>
                </x-admin.card>
            @endif
        </div>

        {{-- Right Column: User Info --}}
        <div class="space-y-4 sm:space-y-6 order-1 lg:order-2">
            {{-- User Card --}}
            <x-admin.card>
                <div class="flex items-center gap-2.5 sm:gap-3 border-b border-white/5 pb-3 sm:pb-4">
                    <div class="flex h-8 w-8 sm:h-10 sm:w-10 shrink-0 items-center justify-center rounded-xl bg-indigo-500/10">
                        <i class="ph-duotone ph-user text-lg sm:text-xl text-indigo-400"></i>
                    </div>
                    <h3 class="text-xs sm:text-sm font-semibold text-white">@lang('User Information')</h3>
                </div>

                @if($deposit->user)
                    <div class="mt-3 sm:mt-4 flex flex-col items-center text-center">
                        <div class="flex h-14 w-14 sm:h-20 sm:w-20 items-center justify-center rounded-xl sm:rounded-2xl bg-gradient-to-br from-purple-500 to-indigo-600 text-lg sm:text-2xl font-bold text-white">
                            {{ strtoupper(substr($deposit->user->username ?? 'U', 0, 2)) }}
                        </div>
                        <h4 class="mt-2 sm:mt-3 text-sm sm:text-lg font-semibold text-white">{{ $deposit->user->firstname }} {{ $deposit->user->lastname }}</h4>
                        <p class="text-xs sm:text-sm text-slate-400">{{ '@' . $deposit->user->username }}</p>
                        <p class="mt-0.5 sm:mt-1 text-[10px] sm:text-xs text-slate-500 truncate max-w-full">{{ $deposit->user->email }}</p>
                    </div>

                    <div class="mt-4 sm:mt-6 space-y-2 sm:space-y-3">
                        <div class="flex items-center justify-between rounded-xl border border-white/5 bg-white/5 p-2.5 sm:p-3">
                            <span class="text-xs sm:text-sm text-slate-400">@lang('Balance')</span>
                            <span class="text-xs sm:text-sm font-semibold text-emerald-400">{{ gs('cur_sym') ?? '$' }}{{ number_format($deposit->user->balance, 2) }}</span>
                        </div>
                        <div class="flex items-center justify-between rounded-xl border border-white/5 bg-white/5 p-2.5 sm:p-3">
                            <span class="text-xs sm:text-sm text-slate-400">@lang('Status')</span>
                            @if($deposit->user->status)
                                <span class="inline-flex items-center gap-1 text-xs sm:text-sm text-emerald-400">
                                    <i class="ph-duotone ph-check-circle"></i> @lang('Active')
                                </span>
                            @else
                                <span class="inline-flex items-center gap-1 text-xs sm:text-sm text-rose-400">
                                    <i class="ph-duotone ph-x-circle"></i> @lang('Inactive')
                                </span>
                            @endif
                        </div>
                        <div class="flex items-center justify-between rounded-xl border border-white/5 bg-white/5 p-2.5 sm:p-3">
                            <span class="text-xs sm:text-sm text-slate-400">@lang('Joined')</span>
                            <span class="text-xs sm:text-sm text-white">{{ $deposit->user->created_at->format('M d, Y') }}</span>
                        </div>
                    </div>

                    <div class="mt-3 sm:mt-4">
                        <a href="{{ route('admin.users.detail', $deposit->user->id) }}" class="w-full rounded-xl border border-white/10 bg-white/5 px-3 sm:px-4 py-2 sm:py-2.5 text-xs sm:text-sm font-medium text-white transition-all hover:bg-white/10 active:scale-[0.98] min-h-9 sm:min-h-0 flex items-center justify-center">
                            <i class="ph-duotone ph-arrow-right mr-1"></i>
                            @lang('View User Profile')
                        </a>
                    </div>
                @else
                    <div class="mt-3 sm:mt-4 py-6 sm:py-8 text-center">
                        <i class="ph-duotone ph-user-circle text-3xl sm:text-4xl text-slate-600"></i>
                        <p class="mt-1.5 sm:mt-2 text-xs sm:text-sm text-slate-400">@lang('User not found')</p>
                    </div>
                @endif
            </x-admin.card>

            {{-- Gateway Info --}}
            @if($deposit->gateway)
                <x-admin.card>
                    <div class="flex items-center gap-2.5 sm:gap-3 border-b border-white/5 pb-3 sm:pb-4">
                        <div class="flex h-8 w-8 sm:h-10 sm:w-10 shrink-0 items-center justify-center rounded-xl bg-purple-500/10">
                            <i class="ph-duotone ph-credit-card text-lg sm:text-xl text-purple-400"></i>
                        </div>
                        <h3 class="text-xs sm:text-sm font-semibold text-white">@lang('Gateway Details')</h3>
                    </div>

                    <div class="mt-3 sm:mt-4 space-y-2 sm:space-y-3">
                        <div class="flex items-center justify-between">
                            <span class="text-xs sm:text-sm text-slate-400">@lang('Name')</span>
                            <span class="text-xs sm:text-sm text-white">{{ $deposit->gateway->name }}</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-xs sm:text-sm text-slate-400">@lang('Code')</span>
                            <span class="font-mono text-xs sm:text-sm text-white">{{ $deposit->gateway->code }}</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-xs sm:text-sm text-slate-400">@lang('Type')</span>
                            @if($deposit->gateway->code < 1000)
                                <span class="inline-flex items-center gap-1 rounded-lg bg-emerald-500/10 px-1.5 sm:px-2 py-0.5 text-[10px] sm:text-xs font-medium text-emerald-400">
                                    <i class="ph-duotone ph-lightning"></i> @lang('Automatic')
                                </span>
                            @else
                                <span class="inline-flex items-center gap-1 rounded-lg bg-amber-500/10 px-1.5 sm:px-2 py-0.5 text-[10px] sm:text-xs font-medium text-amber-400">
                                    <i class="ph-duotone ph-hand-coins"></i> @lang('Manual')
                                </span>
                            @endif
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-xs sm:text-sm text-slate-400">@lang('Status')</span>
                            @if($deposit->gateway->status)
                                <span class="inline-flex items-center gap-1 text-xs sm:text-sm text-emerald-400">
                                    <i class="ph-duotone ph-check-circle"></i> @lang('Active')
                                </span>
                            @else
                                <span class="inline-flex items-center gap-1 text-xs sm:text-sm text-rose-400">
                                    <i class="ph-duotone ph-x-circle"></i> @lang('Inactive')
                                </span>
                            @endif
                        </div>
                    </div>
                </x-admin.card>
            @endif
        </div>
    </div>

    {{-- Reject Modal --}}
    <x-admin.modal wire:model="showRejectModal" :title="__('Reject Deposit')" maxWidth="md">
        <div class="p-4 sm:p-6">
            <div class="mb-3 sm:mb-4 flex items-center gap-2.5 sm:gap-3 rounded-xl border border-rose-500/20 bg-rose-500/5 p-3 sm:p-4">
                <i class="ph-duotone ph-warning text-xl sm:text-2xl text-rose-400 shrink-0"></i>
                <div class="min-w-0">
                    <p class="text-xs sm:text-sm font-medium text-rose-400">@lang('Confirm Rejection')</p>
                    <p class="text-[10px] sm:text-xs text-slate-400">@lang('This action cannot be undone. The user will be notified.')</p>
                </div>
            </div>

            <div>
                <label class="mb-1 sm:mb-1.5 block text-[10px] sm:text-xs font-medium text-slate-300">@lang('Rejection Reason') <span class="text-rose-400">*</span></label>
                <textarea
                    wire:model="rejectReason"
                    rows="4"
                    class="w-full rounded-xl border border-white/10 bg-white/5 px-3 sm:px-4 py-2.5 sm:py-3 text-base sm:text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-rose-500/50 focus:ring-2 focus:ring-rose-500/20"
                    placeholder="{{ __('Enter the reason for rejecting this deposit...') }}"
                ></textarea>
                @error('rejectReason') <span class="mt-1 text-[10px] sm:text-xs text-rose-400">{{ $message }}</span> @enderror
            </div>
        </div>
        <div class="flex flex-col-reverse sm:flex-row justify-end gap-2 sm:gap-3 border-t border-white/10 p-3 sm:p-4">
            <button wire:click="$set('showRejectModal', false)" class="w-full sm:w-auto rounded-xl border border-white/10 bg-white/5 px-4 py-2 text-xs sm:text-sm font-medium text-white transition-all hover:bg-white/10 active:scale-[0.98] cursor-pointer min-h-11 sm:min-h-0">
                @lang('Cancel')
            </button>
            <button wire:click="reject" wire:loading.attr="disabled" wire:loading.class="opacity-50" class="w-full sm:w-auto inline-flex items-center justify-center gap-2 rounded-xl bg-gradient-to-r from-rose-500 to-rose-600 px-4 py-2 text-xs sm:text-sm font-medium text-white shadow-lg shadow-rose-500/25 transition-all hover:shadow-rose-500/40 active:scale-[0.98] cursor-pointer min-h-11 sm:min-h-0">
                <i class="ph-duotone ph-x-circle"></i>
                @lang('Reject Deposit')
            </button>
        </div>
    </x-admin.modal>
</div>

