<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Deposits')" :subtitle="__('Manage and track all payment deposits.')" />

    {{-- Stats Cards --}}
    <div class="mt-6 grid grid-cols-2 gap-4 sm:grid-cols-3 lg:grid-cols-6">
        <button wire:click="setStatus('')" class="group relative overflow-hidden rounded-2xl border {{ $status === '' ? 'border-purple-500/50 bg-purple-500/10' : 'border-white/10 bg-gradient-to-br from-[#12121a] to-[#0f0f15]' }} p-4 text-left transition-all hover:border-purple-500/30 cursor-pointer">
            <div class="flex items-center gap-3">
                <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-purple-500/10">
                    <i class="ph-duotone ph-wallet text-xl text-purple-400"></i>
                </div>
                <div>
                    <p class="text-2xl font-bold text-white">{{ number_format($this->totalCount) }}</p>
                    <p class="text-xs text-slate-400">@lang('All Deposits')</p>
                </div>
            </div>
        </button>

        <button wire:click="setStatus('2')" class="group relative overflow-hidden rounded-2xl border {{ $status === '2' ? 'border-amber-500/50 bg-amber-500/10' : 'border-white/10 bg-gradient-to-br from-[#12121a] to-[#0f0f15]' }} p-4 text-left transition-all hover:border-amber-500/30 cursor-pointer">
            <div class="flex items-center gap-3">
                <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-amber-500/10">
                    <i class="ph-duotone ph-clock text-xl text-amber-400"></i>
                </div>
                <div>
                    <p class="text-2xl font-bold text-white">{{ number_format($this->pendingCount) }}</p>
                    <p class="text-xs text-slate-400">@lang('Pending')</p>
                </div>
            </div>
        </button>

        <button wire:click="setStatus('1')" class="group relative overflow-hidden rounded-2xl border {{ $status === '1' ? 'border-emerald-500/50 bg-emerald-500/10' : 'border-white/10 bg-gradient-to-br from-[#12121a] to-[#0f0f15]' }} p-4 text-left transition-all hover:border-emerald-500/30 cursor-pointer">
            <div class="flex items-center gap-3">
                <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-emerald-500/10">
                    <i class="ph-duotone ph-check-circle text-xl text-emerald-400"></i>
                </div>
                <div>
                    <p class="text-2xl font-bold text-white">{{ number_format($this->completeCount) }}</p>
                    <p class="text-xs text-slate-400">@lang('Complete')</p>
                </div>
            </div>
        </button>

        <button wire:click="setStatus('0')" class="group relative overflow-hidden rounded-2xl border {{ $status === '0' ? 'border-blue-500/50 bg-blue-500/10' : 'border-white/10 bg-gradient-to-br from-[#12121a] to-[#0f0f15]' }} p-4 text-left transition-all hover:border-blue-500/30 cursor-pointer">
            <div class="flex items-center gap-3">
                <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-blue-500/10">
                    <i class="ph-duotone ph-hourglass text-xl text-blue-400"></i>
                </div>
                <div>
                    <p class="text-2xl font-bold text-white">{{ number_format($this->initiatedCount) }}</p>
                    <p class="text-xs text-slate-400">@lang('Initiated')</p>
                </div>
            </div>
        </button>

        <button wire:click="setStatus('3')" class="group relative overflow-hidden rounded-2xl border {{ $status === '3' ? 'border-rose-500/50 bg-rose-500/10' : 'border-white/10 bg-gradient-to-br from-[#12121a] to-[#0f0f15]' }} p-4 text-left transition-all hover:border-rose-500/30 cursor-pointer">
            <div class="flex items-center gap-3">
                <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-rose-500/10">
                    <i class="ph-duotone ph-x-circle text-xl text-rose-400"></i>
                </div>
                <div>
                    <p class="text-2xl font-bold text-white">{{ number_format($this->cancelledCount) }}</p>
                    <p class="text-xs text-slate-400">@lang('Cancelled')</p>
                </div>
            </div>
        </button>

        <div class="rounded-2xl border border-white/10 bg-gradient-to-br from-[#12121a] to-[#0f0f15] p-4">
            <div class="flex items-center gap-3">
                <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-indigo-500/10">
                    <i class="ph-duotone ph-currency-circle-dollar text-xl text-indigo-400"></i>
                </div>
                <div>
                    <p class="text-2xl font-bold text-white">{{ gs('cur_sym') ?? '$' }}{{ number_format($this->totalAmount, 2) }}</p>
                    <p class="text-xs text-slate-400">@lang('Total Received')</p>
                </div>
            </div>
        </div>
    </div>

    {{-- Filters --}}
    <x-admin.card class="mt-6">
        <div class="flex flex-col gap-4 lg:flex-row lg:items-center lg:justify-between">
            <div class="flex flex-1 flex-col gap-4 sm:flex-row">
                {{-- Search --}}
                <div class="relative flex-1">
                    <i class="ph-duotone ph-magnifying-glass absolute left-4 top-1/2 -translate-y-1/2 text-slate-400"></i>
                    <input
                        type="text"
                        wire:model.live.debounce.300ms="search"
                        placeholder="{{ __('Search by TRX, username, email...') }}"
                        class="w-full rounded-xl border border-white/10 bg-white/5 py-2.5 pl-11 pr-4 text-sm text-white placeholder-slate-400 outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20"
                    />
                </div>

                {{-- Gateway Filter --}}
                <select wire:model.live="gateway" class="rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20">
                    <option value="" class="bg-[#12121a]">@lang('All Gateways')</option>
                    @foreach($gateways as $gw)
                        <option value="{{ $gw->code }}" class="bg-[#12121a]">{{ $gw->name }}</option>
                    @endforeach
                </select>

                {{-- Date From --}}
                <input
                    type="date"
                    wire:model.live="dateFrom"
                    class="rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20"
                />

                {{-- Date To --}}
                <input
                    type="date"
                    wire:model.live="dateTo"
                    class="rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white outline-none transition-all focus:border-purple-500/50 focus:ring-2 focus:ring-purple-500/20"
                />
            </div>

            @if($search || $status !== '' || $gateway || $dateFrom || $dateTo)
                <button wire:click="clearFilters" class="inline-flex items-center gap-2 rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm font-medium text-white transition-all hover:bg-white/10 cursor-pointer">
                    <i class="ph-duotone ph-x"></i>
                    @lang('Clear Filters')
                </button>
            @endif
        </div>
    </x-admin.card>

    {{-- Deposits Table --}}
    <x-admin.card class="mt-6">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-white/5 text-left">
                        <th class="px-4 py-3 text-xs font-medium uppercase tracking-wider text-slate-400">@lang('Transaction')</th>
                        <th class="px-4 py-3 text-xs font-medium uppercase tracking-wider text-slate-400">@lang('User')</th>
                        <th class="px-4 py-3 text-xs font-medium uppercase tracking-wider text-slate-400">@lang('Gateway')</th>
                        <th class="px-4 py-3 text-xs font-medium uppercase tracking-wider text-slate-400">@lang('Amount')</th>
                        <th class="px-4 py-3 text-xs font-medium uppercase tracking-wider text-slate-400">@lang('Charge')</th>
                        <th class="px-4 py-3 text-xs font-medium uppercase tracking-wider text-slate-400">@lang('Status')</th>
                        <th class="px-4 py-3 text-xs font-medium uppercase tracking-wider text-slate-400">@lang('Date')</th>
                        <th class="px-4 py-3 text-xs font-medium uppercase tracking-wider text-slate-400 text-right">@lang('Actions')</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    @forelse($deposits as $deposit)
                        <tr class="transition-colors hover:bg-white/[0.02]">
                            <td class="whitespace-nowrap px-4 py-3">
                                <div class="flex items-center gap-3">
                                    <div class="flex h-9 w-9 items-center justify-center rounded-xl bg-purple-500/10">
                                        <i class="ph-duotone ph-hash text-lg text-purple-400"></i>
                                    </div>
                                    <div>
                                        <p class="font-mono text-sm text-white">{{ $deposit->trx }}</p>
                                        @if($deposit->invoice_id)
                                            <p class="text-xs text-slate-400">@lang('Invoice') #{{ $deposit->invoice_id }}</p>
                                        @endif
                                    </div>
                                </div>
                            </td>
                            <td class="whitespace-nowrap px-4 py-3">
                                @if($deposit->user)
                                    <div class="flex items-center gap-2">
                                        <div class="flex h-8 w-8 items-center justify-center rounded-full bg-gradient-to-br from-purple-500 to-indigo-600 text-xs font-bold text-white">
                                            {{ strtoupper(substr($deposit->user->username ?? 'U', 0, 1)) }}
                                        </div>
                                        <div>
                                            <p class="text-sm font-medium text-white">{{ $deposit->user->username }}</p>
                                            <p class="text-xs text-slate-400">{{ $deposit->user->email }}</p>
                                        </div>
                                    </div>
                                @else
                                    <span class="text-sm text-slate-400">@lang('N/A')</span>
                                @endif
                            </td>
                            <td class="whitespace-nowrap px-4 py-3">
                                @if($deposit->gateway)
                                    <span class="inline-flex items-center gap-1.5 rounded-lg border border-white/10 bg-white/5 px-2.5 py-1 text-xs font-medium text-white">
                                        <i class="ph-duotone ph-credit-card text-purple-400"></i>
                                        {{ $deposit->gateway->name }}
                                    </span>
                                @else
                                    <span class="text-sm text-slate-400">@lang('Unknown')</span>
                                @endif
                            </td>
                            <td class="whitespace-nowrap px-4 py-3">
                                <p class="text-sm font-semibold text-white">{{ gs('cur_sym') ?? '$' }}{{ number_format($deposit->amount, 2) }}</p>
                                @if($deposit->method_currency && $deposit->method_currency !== (gs('cur_text') ?? 'USD'))
                                    <p class="text-xs text-slate-400">{{ number_format($deposit->final_amount, 2) }} {{ $deposit->method_currency }}</p>
                                @endif
                            </td>
                            <td class="whitespace-nowrap px-4 py-3">
                                <p class="text-sm text-slate-300">{{ gs('cur_sym') ?? '$' }}{{ number_format($deposit->charge, 2) }}</p>
                            </td>
                            <td class="whitespace-nowrap px-4 py-3">
                                @switch($deposit->status)
                                    @case(0)
                                        <span class="inline-flex items-center gap-1.5 rounded-lg border border-blue-500/20 bg-blue-500/10 px-2.5 py-1 text-xs font-medium text-blue-400">
                                            <i class="ph-duotone ph-hourglass"></i>
                                            @lang('Initiated')
                                        </span>
                                        @break
                                    @case(1)
                                        <span class="inline-flex items-center gap-1.5 rounded-lg border border-emerald-500/20 bg-emerald-500/10 px-2.5 py-1 text-xs font-medium text-emerald-400">
                                            <i class="ph-duotone ph-check-circle"></i>
                                            @lang('Complete')
                                        </span>
                                        @break
                                    @case(2)
                                        <span class="inline-flex items-center gap-1.5 rounded-lg border border-amber-500/20 bg-amber-500/10 px-2.5 py-1 text-xs font-medium text-amber-400">
                                            <i class="ph-duotone ph-clock"></i>
                                            @lang('Pending')
                                        </span>
                                        @break
                                    @case(3)
                                        <span class="inline-flex items-center gap-1.5 rounded-lg border border-rose-500/20 bg-rose-500/10 px-2.5 py-1 text-xs font-medium text-rose-400">
                                            <i class="ph-duotone ph-x-circle"></i>
                                            @lang('Cancelled')
                                        </span>
                                        @break
                                @endswitch
                            </td>
                            <td class="whitespace-nowrap px-4 py-3">
                                <p class="text-sm text-slate-300">{{ $deposit->created_at->format('M d, Y') }}</p>
                                <p class="text-xs text-slate-500">{{ $deposit->created_at->format('h:i A') }}</p>
                            </td>
                            <td class="whitespace-nowrap px-4 py-3 text-right">
                                <a href="{{ route('admin.deposit.details', $deposit->id) }}" class="inline-flex items-center gap-1.5 rounded-lg border border-white/10 bg-white/5 px-3 py-1.5 text-xs font-medium text-white transition-all hover:bg-white/10">
                                    <i class="ph-duotone ph-eye"></i>
                                    @lang('View')
                                </a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="px-4 py-12 text-center">
                                <div class="flex flex-col items-center">
                                    <div class="flex h-16 w-16 items-center justify-center rounded-2xl bg-slate-800/50">
                                        <i class="ph-duotone ph-wallet text-3xl text-slate-500"></i>
                                    </div>
                                    <p class="mt-4 text-sm font-medium text-white">@lang('No deposits found')</p>
                                    <p class="mt-1 text-xs text-slate-400">
                                        @if($search || $status !== '' || $gateway || $dateFrom || $dateTo)
                                            @lang('Try adjusting your filters')
                                        @else
                                            @lang('Deposits will appear here when users make payments')
                                        @endif
                                    </p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        {{-- Pagination --}}
        @if($deposits->hasPages())
            <div class="mt-6 border-t border-white/5 pt-4">
                {{ $deposits->links() }}
            </div>
        @endif
    </x-admin.card>
</div>

