<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Features for :category', ['category' => $category->name])" :subtitle="__('Define master features for comparison table alignment.')">
        <x-slot:actions>
            <x-admin.button :href="route('admin.products.categories')" variant="secondary" icon="ph-arrow-left">
                @lang('Back to Categories')
            </x-admin.button>
            <x-admin.button wire:click="openModal" icon="ph-plus">
                @lang('Add Feature')
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    {{-- Features List --}}
    <x-admin.card class="mt-6" :padding="false">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-white/5 bg-white/[0.02]">
                        <th class="w-10 px-6 py-4"></th>
                        <th class="px-6 py-4 text-left">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Feature Name')</span>
                        </th>
                        <th class="px-6 py-4 text-left">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Group')</span>
                        </th>
                        <th class="px-6 py-4 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Products Using')</span>
                        </th>
                        <th class="px-6 py-4 text-right">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Actions')</span>
                        </th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5" wire:sortable="updateSortOrder">
                    @forelse($features as $feature)
                        <tr class="group transition-all hover:bg-white/[0.02]" wire:key="feature-{{ $feature->id }}" wire:sortable.item="{{ $feature->id }}">
                            <td class="px-6 py-4">
                                <button wire:sortable.handle class="cursor-grab text-slate-600 hover:text-white active:cursor-grabbing">
                                    <i class="ph-bold ph-dots-six-vertical"></i>
                                </button>
                            </td>
                            <td class="px-6 py-4">
                                <div class="flex items-center gap-3">
                                    @if($feature->icon)
                                        <div class="flex h-8 w-8 items-center justify-center rounded-lg bg-white/5 text-indigo-400">
                                            <i class="{{ $feature->icon }}"></i>
                                        </div>
                                    @endif
                                    <div>
                                        <p class="font-medium text-white">{{ $feature->name }}</p>
                                        @if($feature->tooltip_text)
                                            <p class="text-xs text-slate-500">{{ Str::limit($feature->tooltip_text, 50) }}</p>
                                        @endif
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4">
                                <span class="rounded-lg bg-indigo-500/10 px-2.5 py-1 text-xs font-medium text-indigo-400">
                                    {{ $comparisonGroups[$feature->comparison_group] ?? ucfirst($feature->comparison_group ?: 'other') }}
                                </span>
                            </td>
                            <td class="px-6 py-4 text-center">
                                <span class="inline-flex items-center justify-center rounded-full bg-white/5 px-2.5 py-0.5 text-xs font-medium text-white">
                                    {{ $feature->product_features_count ?? $feature->productFeatures()->count() }}
                                </span>
                            </td>
                            <td class="px-6 py-4 text-right">
                                <div class="flex justify-end gap-2">
                                    <x-admin.button variant="secondary" size="sm" wire:click="openModal({{ $feature->id }})" icon="ph-pencil" />
                                    <x-admin.button variant="danger" size="sm" wire:click="deleteFeature({{ $feature->id }})" icon="ph-trash" wire:confirm="{{ __('Are you sure?') }}" />
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="px-6 py-16 text-center">
                                <div class="flex flex-col items-center">
                                    <div class="flex h-16 w-16 items-center justify-center rounded-2xl bg-white/5">
                                        <i class="ph-duotone ph-list-checks text-3xl text-slate-500"></i>
                                    </div>
                                    <h3 class="mt-4 text-lg font-medium text-white">@lang('No features defined')</h3>
                                    <p class="mt-1 text-sm text-slate-500">@lang('Define master features to ensure correct alignment in comparison tables.')</p>
                                    <x-admin.button wire:click="openModal" icon="ph-plus" class="mt-4">
                                        @lang('Add First Feature')
                                    </x-admin.button>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </x-admin.card>

    {{-- Add/Edit Modal --}}
    <x-admin.modal wire:model="showModal" :title="$editingId ? __('Edit Feature') : __('Add Feature')">
        <form wire:submit="save">
            <div class="space-y-4">
                <x-admin.input
                    :label="__('Feature Name')"
                    wire:model="name"
                    placeholder="{{ __('e.g. Storage, Bandwidth, SSL') }}"
                    required
                />
                
                <div class="grid grid-cols-2 gap-4">
                    <x-admin.input
                        :label="__('Icon Class')"
                        wire:model="icon"
                        placeholder="{{ __('e.g. ph-hard-drive') }}"
                    />
                    <div>
                        <label class="mb-2 block text-sm font-medium text-slate-400">@lang('Comparison Group')</label>
                        <select wire:model="comparisonGroup" class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white focus:border-indigo-500/50 focus:outline-none">
                            <option value="">@lang('Select Group')</option>
                            @foreach($comparisonGroups as $value => $label)
                                <option value="{{ $value }}">{{ $label }}</option>
                            @endforeach
                            <option value="other">@lang('Other')</option>
                        </select>
                    </div>
                </div>

                <x-admin.textarea
                    :label="__('Tooltip Text')"
                    wire:model="tooltipText"
                    placeholder="{{ __('Explain what this feature is...') }}"
                    rows="3"
                />

                <x-admin.input
                    type="number"
                    :label="__('Sort Order')"
                    wire:model="sortOrder"
                />
            </div>
            
            <div class="mt-6 flex justify-end gap-3">
                <x-admin.button type="button" variant="secondary" wire:click="$set('showModal', false)">@lang('Cancel')</x-admin.button>
                <x-admin.button type="submit">@if($editingId) @lang('Update') @else @lang('Create') @endif @lang('Feature')</x-admin.button>
            </div>
        </form>
    </x-admin.modal>
</div>
