<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Configurable Groups')" :subtitle="__('Manage product configurable options.')">
        <x-slot:actions>
            <x-admin.button wire:click="openModal" icon="ph-plus">
                @lang('Add Group')
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    @if (session('success'))
        <x-admin.alert type="success" class="mt-6">{{ session('success') }}</x-admin.alert>
    @endif
    @if (session('error'))
        <x-admin.alert type="danger" class="mt-6">{{ session('error') }}</x-admin.alert>
    @endif

    {{-- Filters Card --}}
    <x-admin.card class="mt-6">
        <div class="relative w-full sm:w-80">
            <i class="ph-duotone ph-magnifying-glass absolute left-3 top-1/2 -translate-y-1/2 text-slate-500"></i>
            <input
                type="text"
                wire:model.live.debounce.300ms="search"
                placeholder="{{ __('Search groups...') }}"
                class="w-full rounded-xl border border-white/10 bg-white/5 py-2.5 pl-10 pr-4 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
            />
            @if($search)
                <button wire:click="$set('search', '')" class="absolute right-3 top-1/2 -translate-y-1/2 text-slate-500 transition-colors hover:text-white">
                    <i class="ph-bold ph-x text-sm"></i>
                </button>
            @endif
        </div>
    </x-admin.card>

    {{-- Groups Table --}}
    <x-admin.card class="mt-6" :padding="false">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-white/5 bg-white/[0.02]">
                        <th class="px-6 py-4 text-left">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Group Name')</span>
                        </th>
                        <th class="px-6 py-4 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Options')</span>
                        </th>
                        <th class="px-6 py-4 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Products')</span>
                        </th>
                        <th class="px-6 py-4 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Status')</span>
                        </th>
                        <th class="px-6 py-4 text-right">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Actions')</span>
                        </th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    @forelse($groups as $group)
                        <tr class="group transition-all hover:bg-white/[0.02]" wire:key="group-{{ $group->id }}">
                            {{-- Group Info --}}
                            <td class="px-6 py-4">
                                <div class="flex items-center gap-3">
                                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-amber-500/20 to-orange-500/20 text-amber-400">
                                        <i class="ph-duotone ph-list-checks text-lg"></i>
                                    </div>
                                    <div>
                                        <p class="font-medium text-white">{{ $group->name }}</p>
                                        @if($group->description)
                                            <p class="text-sm text-slate-500">{{ Str::limit($group->description, 50) }}</p>
                                        @endif
                                    </div>
                                </div>
                            </td>

                            {{-- Options Count --}}
                            <td class="px-6 py-4 text-center">
                                <a href="{{ route('admin.products.configurable-options', $group->id) }}" class="inline-flex items-center justify-center rounded-lg bg-white/5 px-3 py-1 text-sm font-medium text-white transition-colors hover:bg-white/10">
                                    {{ $group->options_count }}
                                </a>
                            </td>

                            {{-- Products Count --}}
                            <td class="px-6 py-4 text-center">
                                <span class="inline-flex items-center justify-center rounded-lg bg-white/5 px-3 py-1 text-sm font-medium text-white">
                                    {{ $group->products_count }}
                                </span>
                            </td>

                            {{-- Status --}}
                            <td class="px-6 py-4 text-center">
                                <x-admin.toggle wire:click="toggleStatus({{ $group->id }})" :checked="$group->status" />
                            </td>

                            {{-- Actions --}}
                            <td class="px-6 py-4 text-right">
                                <x-admin.action-menu>
                                    <x-admin.action-menu-item wire:click="openModal({{ $group->id }})" icon="ph-pencil">
                                        @lang('Edit Group')
                                    </x-admin.action-menu-item>
                                    <x-admin.action-menu-item href="{{ route('admin.products.configurable-options', $group->id) }}" icon="ph-list">
                                        @lang('Manage Options')
                                    </x-admin.action-menu-item>
                                    <x-admin.action-menu-item :divider="true" />
                                    <x-admin.action-menu-item wire:click="deleteGroup({{ $group->id }})" wire:confirm="{{ __('Are you sure you want to delete this group?') }}" icon="ph-trash" :danger="true">
                                        @lang('Delete Group')
                                    </x-admin.action-menu-item>
                                </x-admin.action-menu>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="px-6 py-16 text-center">
                                <div class="flex flex-col items-center">
                                    <div class="flex h-16 w-16 items-center justify-center rounded-2xl bg-white/5">
                                        <i class="ph-duotone ph-list-checks text-3xl text-slate-500"></i>
                                    </div>
                                    <h3 class="mt-4 text-lg font-medium text-white">@lang('No groups found')</h3>
                                    <p class="mt-1 text-sm text-slate-500">
                                        @if($search)
                                            @lang('No groups match your search.')
                                        @else
                                            @lang('Get started by adding your first configurable group.')
                                        @endif
                                    </p>
                                    @if(!$search)
                                        <x-admin.button wire:click="openModal" icon="ph-plus" class="mt-4">
                                            @lang('Add Group')
                                        </x-admin.button>
                                    @endif
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        {{-- Pagination --}}
        @if($groups->hasPages())
            <div class="border-t border-white/5 px-6 py-4">
                {{ $groups->links() }}
            </div>
        @endif
    </x-admin.card>

    {{-- Add/Edit Modal --}}
    <x-admin.modal wire:model="showModal" :title="$editingId ? __('Edit Group') : __('Add Group')">
        <form wire:submit="save">
            <div class="space-y-4">
                <x-admin.input
                    :label="__('Group Name')"
                    wire:model="name"
                    placeholder="{{ __('Enter group name') }}"
                    required
                />
                <x-admin.textarea
                    :label="__('Description')"
                    wire:model="description"
                    placeholder="{{ __('Brief description of the group') }}"
                    rows="2"
                />
                <div class="flex items-center justify-between rounded-xl bg-white/5 p-4">
                    <div>
                        <p class="text-sm font-medium text-white">@lang('Active Status')</p>
                        <p class="text-xs text-slate-500">@lang('Enable this configurable group')</p>
                    </div>
                    <x-admin.toggle wire:model.live="status" />
                </div>
            </div>
            <div class="mt-6 flex justify-end gap-3">
                <x-admin.button type="button" variant="secondary" wire:click="$set('showModal', false)">@lang('Cancel')</x-admin.button>
                <x-admin.button type="submit">{{ $editingId ? __('Update') : __('Create') }} @lang('Group')</x-admin.button>
            </div>
        </form>
    </x-admin.modal>
</div>

