<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="$group->name" :subtitle="__('Manage options for this configurable group.')">
        <x-slot:actions>
            <x-admin.button href="{{ route('admin.products.configurable-groups') }}" variant="secondary" icon="ph-arrow-left">
                @lang('Back to Groups')
            </x-admin.button>
            <x-admin.button wire:click="openModal" icon="ph-plus">
                @lang('Add Option')
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    @if (session('success'))
        <x-admin.alert type="success" class="mt-6">{{ session('success') }}</x-admin.alert>
    @endif
    @if (session('error'))
        <x-admin.alert type="danger" class="mt-6">{{ session('error') }}</x-admin.alert>
    @endif

    {{-- Options Table --}}
    <x-admin.card class="mt-6" :padding="false">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-white/5 bg-white/[0.02]">
                        <th class="px-6 py-4 text-left">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Order')</span>
                        </th>
                        <th class="px-6 py-4 text-left">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Option Name')</span>
                        </th>
                        <th class="px-6 py-4 text-left">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Type')</span>
                        </th>
                        <th class="px-6 py-4 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Sub-Options')</span>
                        </th>
                        <th class="px-6 py-4 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Status')</span>
                        </th>
                        <th class="px-6 py-4 text-right">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Actions')</span>
                        </th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    @forelse($options as $option)
                        <tr class="group transition-all hover:bg-white/[0.02]" wire:key="option-{{ $option->id }}">
                            {{-- Order --}}
                            <td class="px-6 py-4">
                                <span class="inline-flex h-8 w-8 items-center justify-center rounded-lg bg-white/5 text-sm font-medium text-slate-400">
                                    {{ $option->order }}
                                </span>
                            </td>

                            {{-- Option Info --}}
                            <td class="px-6 py-4">
                                <p class="font-medium text-white">{{ $option->name }}</p>
                            </td>

                            {{-- Type --}}
                            <td class="px-6 py-4">
                                @php
                                    $typeLabels = [
                                        1 => ['label' => __('Dropdown'), 'color' => 'primary'],
                                        2 => ['label' => __('Radio'), 'color' => 'info'],
                                        3 => ['label' => __('Checkbox'), 'color' => 'warning'],
                                        4 => ['label' => __('Quantity'), 'color' => 'success'],
                                    ];
                                    $type = $typeLabels[$option->option_type] ?? ['label' => __('Unknown'), 'color' => 'secondary'];
                                @endphp
                                <x-admin.badge :type="$type['color']" size="sm">{{ $type['label'] }}</x-admin.badge>
                            </td>

                            {{-- Sub-Options Count --}}
                            <td class="px-6 py-4 text-center">
                                <span class="inline-flex items-center justify-center rounded-lg bg-white/5 px-3 py-1 text-sm font-medium text-white">
                                    {{ $option->sub_options_count }}
                                </span>
                            </td>

                            {{-- Status --}}
                            <td class="px-6 py-4 text-center">
                                <x-admin.toggle wire:click="toggleStatus({{ $option->id }})" :checked="$option->status" />
                            </td>

                            {{-- Actions --}}
                            <td class="px-6 py-4 text-right">
                                <x-admin.action-menu>
                                    <x-admin.action-menu-item wire:click="openModal({{ $option->id }})" icon="ph-pencil">
                                        @lang('Edit Option')
                                    </x-admin.action-menu-item>
                                    <x-admin.action-menu-item :divider="true" />
                                    <x-admin.action-menu-item wire:click="deleteOption({{ $option->id }})" wire:confirm="{{ __('Are you sure you want to delete this option?') }}" icon="ph-trash" :danger="true">
                                        @lang('Delete Option')
                                    </x-admin.action-menu-item>
                                </x-admin.action-menu>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="px-6 py-16 text-center">
                                <div class="flex flex-col items-center">
                                    <div class="flex h-16 w-16 items-center justify-center rounded-2xl bg-white/5">
                                        <i class="ph-duotone ph-list-checks text-3xl text-slate-500"></i>
                                    </div>
                                    <h3 class="mt-4 text-lg font-medium text-white">@lang('No options found')</h3>
                                    <p class="mt-1 text-sm text-slate-500">@lang('Add options to this configurable group.')</p>
                                    <x-admin.button wire:click="openModal" icon="ph-plus" class="mt-4">
                                        @lang('Add Option')
                                    </x-admin.button>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </x-admin.card>

    {{-- Add/Edit Modal --}}
    <x-admin.modal wire:model="showModal" :title="$editingId ? __('Edit Option') : __('Add Option')">
        <form wire:submit="save">
            <div class="space-y-4">
                <x-admin.input
                    :label="__('Option Name')"
                    wire:model="name"
                    placeholder="{{ __('Enter option name') }}"
                    required
                />
                <x-admin.select :label="__('Option Type')" wire:model="option_type">
                    <option value="1">@lang('Dropdown')</option>
                    <option value="2">@lang('Radio Buttons')</option>
                    <option value="3">@lang('Checkbox')</option>
                    <option value="4">@lang('Quantity')</option>
                </x-admin.select>
                <x-admin.input
                    type="number"
                    :label="__('Display Order')"
                    wire:model="order"
                    min="0"
                />
                <div class="flex items-center justify-between rounded-xl bg-white/5 p-4">
                    <div>
                        <p class="text-sm font-medium text-white">@lang('Active Status')</p>
                        <p class="text-xs text-slate-500">@lang('Enable this option')</p>
                    </div>
                    <x-admin.toggle wire:model.live="status" />
                </div>
            </div>
            <div class="mt-6 flex justify-end gap-3">
                <x-admin.button type="button" variant="secondary" wire:click="$set('showModal', false)">@lang('Cancel')</x-admin.button>
                <x-admin.button type="submit">{{ $editingId ? __('Update') : __('Create') }} @lang('Option')</x-admin.button>
            </div>
        </form>
    </x-admin.modal>
</div>

