<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Product Features')" :subtitle="$product ? __('Manage features for: :product', ['product' => $product->name]) : __('Select a product to manage its features')">
        <x-slot:actions>
            @if($product)
                <x-admin.button type="button" wire:click="openCopyModal" variant="secondary" icon="ph-copy">
                    @lang('Copy From')
                </x-admin.button>
                <x-admin.button type="button" wire:click="openAddModal" icon="ph-plus">
                    @lang('Add Feature')
                </x-admin.button>
            @endif
        </x-slot:actions>
    </x-admin.page-header>

    {{-- Product Selector --}}
    <x-admin.card class="mt-6">
        <div class="flex flex-col md:flex-row gap-4 items-start md:items-center">
            <div class="flex-1">
                <label class="block text-sm font-medium text-slate-400 mb-2">@lang('Select Product')</label>
                <select wire:model.live="productId" wire:change="selectProduct($event.target.value)"
                    class="w-full bg-slate-800/50 border border-slate-700 rounded-xl px-4 py-3 text-white focus:outline-none focus:ring-2 focus:ring-primary-500 focus:border-transparent">
                    <option value="">@lang('-- Select a Product --')</option>
                    @foreach($this->products as $prod)
                        <option value="{{ $prod->id }}">
                            {{ $prod->name }}
                            @if($prod->category) ({{ $prod->category->name }}) @endif
                        </option>
                    @endforeach
                </select>
            </div>
            @if($product)
                <div class="flex gap-6 text-sm">
                    <div class="text-center">
                        <div class="text-2xl font-bold text-white">{{ $features->count() }}</div>
                        <div class="text-slate-500">@lang('Total Features')</div>
                    </div>
                    <div class="text-center">
                        <div class="text-2xl font-bold text-primary-400">{{ $features->where('display_in_pricing', true)->count() }}</div>
                        <div class="text-slate-500">@lang('In Pricing')</div>
                    </div>
                    <div class="text-center">
                        <div class="text-2xl font-bold text-emerald-400">{{ $features->where('badge_text', '!=', null)->count() }}</div>
                        <div class="text-slate-500">@lang('With Badges')</div>
                    </div>
                </div>
            @endif
        </div>
    </x-admin.card>

    @if($product)
        {{-- Bulk Actions Bar --}}
        @if(count($selectedFeatures) > 0)
            <div class="mt-4 bg-primary-500/10 border border-primary-500/30 rounded-xl px-4 py-3 flex items-center justify-between">
                <span class="text-sm text-primary-400">
                    <i class="ph-bold ph-check-square mr-2"></i>
                    {{ count($selectedFeatures) }} @lang('features selected')
                </span>
                <div class="flex gap-2">
                    <x-admin.button type="button" wire:click="deleteSelected" wire:confirm="{{ __('Delete all selected features?') }}" variant="danger" size="sm" icon="ph-trash">
                        @lang('Delete Selected')
                    </x-admin.button>
                </div>
            </div>
        @endif

        {{-- Features List --}}
        <x-admin.card class="mt-4" :padding="false">
            <x-admin.table>
                <x-slot:header>
                    <x-admin.table.th class="w-10">
                        <input type="checkbox" wire:model.live="selectAll" class="rounded bg-slate-700 border-slate-600 text-primary-500 focus:ring-primary-500">
                    </x-admin.table.th>
                    <x-admin.table.th class="w-12">#</x-admin.table.th>
                    <x-admin.table.th>@lang('Feature')</x-admin.table.th>
                    <x-admin.table.th>@lang('Type')</x-admin.table.th>
                    <x-admin.table.th>@lang('Group')</x-admin.table.th>
                    <x-admin.table.th class="text-center">@lang('Pricing')</x-admin.table.th>
                    <x-admin.table.th class="text-right">@lang('Actions')</x-admin.table.th>
                </x-slot:header>
                <x-slot:body>
                    @forelse($features as $index => $feature)
                        <x-admin.table.tr wire:key="feature-{{ $feature->id }}">
                            <x-admin.table.td>
                                <input type="checkbox" wire:model.live="selectedFeatures" value="{{ $feature->id }}" class="rounded bg-slate-700 border-slate-600 text-primary-500 focus:ring-primary-500">
                            </x-admin.table.td>
                            <x-admin.table.td>
                                <div class="flex flex-col gap-1">
                                    <button wire:click="moveUp({{ $feature->id }})" class="p-1 text-slate-500 hover:text-white transition {{ $loop->first ? 'opacity-30 cursor-not-allowed' : '' }}" @if($loop->first) disabled @endif>
                                        <i class="ph-bold ph-caret-up text-xs"></i>
                                    </button>
                                    <button wire:click="moveDown({{ $feature->id }})" class="p-1 text-slate-500 hover:text-white transition {{ $loop->last ? 'opacity-30 cursor-not-allowed' : '' }}" @if($loop->last) disabled @endif>
                                        <i class="ph-bold ph-caret-down text-xs"></i>
                                    </button>
                                </div>
                            </x-admin.table.td>
                            <x-admin.table.td>
                                <div class="flex items-center gap-3">
                                    @if($feature->categoryFeature?->icon)
                                        <div class="w-8 h-8 rounded-lg bg-primary-500/10 flex items-center justify-center">
                                            <i class="ph-bold {{ $feature->categoryFeature->icon }} text-primary-400"></i>
                                        </div>
                                    @endif
                                    <div>
                                        <div class="font-medium text-white flex items-center gap-2">
                                            <span class="text-slate-400">{{ $feature->categoryFeature?->name }}:</span>
                                            {{ $feature->name }}
                                            @if($feature->badge_text)
                                                <span class="px-1.5 py-0.5 text-xs rounded bg-{{ $feature->badge_color ?? 'blue' }}-500/20 text-{{ $feature->badge_color ?? 'blue' }}-400">
                                                    {{ $feature->badge_text }}
                                                </span>
                                            @endif
                                        </div>
                                        @if($feature->categoryFeature?->tooltip_text)
                                            <div class="text-xs text-slate-500 mt-1">{{ Str::limit($feature->categoryFeature->tooltip_text, 50) }}</div>
                                        @endif
                                    </div>
                                </div>
                            </x-admin.table.td>
                            <x-admin.table.td>
                                @php
                                    $typeColors = [
                                        'included' => 'success',
                                        'unlimited' => 'info',
                                        'limited' => 'warning',
                                        'custom' => 'primary',
                                        'excluded' => 'danger',
                                    ];
                                @endphp
                                <x-admin.badge :variant="$typeColors[$feature->type] ?? 'secondary'">
                                    {{ $featureTypes[$feature->type] ?? $feature->type }}
                                </x-admin.badge>
                            </x-admin.table.td>
                            <x-admin.table.td>
                                @if($feature->categoryFeature?->comparison_group)
                                    <span class="text-xs px-2 py-1 rounded-lg bg-slate-700 text-slate-300">
                                        {{ $feature->categoryFeature->comparison_group }}
                                    </span>
                                @else
                                    <span class="text-slate-600">—</span>
                                @endif
                            </x-admin.table.td>
                            <x-admin.table.td class="text-center">
                                <button wire:click="togglePricingDisplay({{ $feature->id }})" class="inline-flex">
                                    @if($feature->display_in_pricing)
                                        <i class="ph-fill ph-check-circle text-emerald-400"></i>
                                    @else
                                        <i class="ph-bold ph-x-circle text-slate-600 hover:text-slate-400 transition"></i>
                                    @endif
                                </button>
                            </x-admin.table.td>
                            <x-admin.table.td class="text-right">
                                <div class="flex items-center justify-end gap-2">
                                    <button wire:click="editFeature({{ $feature->id }})" class="p-2 text-slate-400 hover:text-primary-400 transition" title="@lang('Edit')">
                                        <i class="ph-bold ph-pencil-simple"></i>
                                    </button>
                                    <button wire:click="deleteFeature({{ $feature->id }})" wire:confirm="{{ __('Are you sure you want to delete this feature?') }}" class="p-2 text-slate-400 hover:text-red-400 transition" title="@lang('Delete')">
                                        <i class="ph-bold ph-trash"></i>
                                    </button>
                                </div>
                            </x-admin.table.td>
                        </x-admin.table.tr>
                    @empty
                        <x-admin.table.tr>
                            <x-admin.table.td colspan="7" class="text-center py-12">
                                <div class="text-slate-500">
                                    <i class="ph-bold ph-list-checks text-4xl mb-3 block opacity-50"></i>
                                    <p class="mb-4">@lang('No features added yet.')</p>
                                    <div class="flex justify-center gap-3">
                                        <x-admin.button type="button" wire:click="openAddModal" size="sm" icon="ph-plus">
                                            @lang('Add Manually')
                                        </x-admin.button>
                                    </div>
                                </div>
                            </x-admin.table.td>
                        </x-admin.table.tr>
                    @endforelse
                </x-slot:body>
            </x-admin.table>
        </x-admin.card>
    @else
        {{-- No Product Selected State --}}
        <x-admin.card class="mt-6">
            <div class="text-center py-12">
                <div class="w-16 h-16 mx-auto mb-4 rounded-2xl bg-slate-800 flex items-center justify-center">
                    <i class="ph-bold ph-package text-3xl text-slate-500"></i>
                </div>
                <h3 class="text-lg font-semibold text-white mb-2">@lang('Select a Product')</h3>
                <p class="text-slate-500 max-w-md mx-auto">
                    @lang('Choose a product from the dropdown above to start managing its features. Features are displayed on pricing tables and comparison pages.')
                </p>
            </div>
        </x-admin.card>
    @endif

    {{-- Add/Edit Modal --}}
    <x-admin.modal wire:model="showModal" maxWidth="2xl">
        <x-slot:title>
            {{ $editingId ? __('Edit Feature') : __('Add Feature') }}
        </x-slot:title>

        <form wire:submit="save" class="space-y-6">
            {{-- Feature Definition Selection --}}
            <x-admin.form-group :label="__('Feature Definition')" for="categoryFeatureId" required :error="$errors->first('categoryFeatureId')">
                <x-admin.select id="categoryFeatureId" wire:model="categoryFeatureId">
                    <option value="">@lang('-- Select Feature Type --')</option>
                    @foreach($this->categoryFeatures as $cf)
                        <option value="{{ $cf->id }}">{{ $cf->name }} ({{ $cf->comparison_group }})</option>
                    @endforeach
                </x-admin.select>
                <p class="text-xs text-slate-500 mt-1">
                    @lang('Icons and grouping are managed at the category level.')
                    <a href="{{ route('admin.products.categories.features', $product->category_id ?? 0) }}" class="text-primary-400 hover:underline">@lang('Manage definitions')</a>
                </p>
            </x-admin.form-group>

            <div class="grid grid-cols-2 gap-4">
                <x-admin.form-group :label="__('Specific Value')" for="name" required :error="$errors->first('name')">
                    <x-admin.input type="text" id="name" wire:model="name" placeholder="{{ __('e.g., 10 GB') }}" />
                </x-admin.form-group>

                <x-admin.form-group :label="__('Type')" for="type" :error="$errors->first('type')">
                    <x-admin.select id="type" wire:model="type">
                        @foreach($featureTypes as $key => $label)
                            <option value="{{ $key }}">{{ $label }}</option>
                        @endforeach
                    </x-admin.select>
                </x-admin.form-group>
            </div>

            {{-- Badge Settings --}}
            <div class="grid grid-cols-3 gap-4">
                <x-admin.form-group :label="__('Badge Text')" for="badgeText" :error="$errors->first('badgeText')">
                    <x-admin.input type="text" id="badgeText" wire:model="badgeText" placeholder="{{ __('NEW') }}" />
                </x-admin.form-group>

                <x-admin.form-group :label="__('Badge Color')" for="badgeColor" :error="$errors->first('badgeColor')">
                    <x-admin.select id="badgeColor" wire:model="badgeColor">
                        <option value="">@lang('Default')</option>
                        <option value="blue">@lang('Blue')</option>
                        <option value="green">@lang('Green')</option>
                        <option value="yellow">@lang('Yellow')</option>
                        <option value="red">@lang('Red')</option>
                        <option value="purple">@lang('Purple')</option>
                    </x-admin.select>
                </x-admin.form-group>

                <x-admin.form-group :label="__('Sort Order')" for="sortOrder" :error="$errors->first('sortOrder')">
                    <x-admin.input type="number" id="sortOrder" wire:model="sortOrder" min="0" />
                </x-admin.form-group>
            </div>

            {{-- Display Toggle --}}
            <div class="pt-4 border-t border-slate-700">
                <label class="flex items-center gap-3 cursor-pointer">
                    <x-admin.toggle wire:model="displayInPricing" />
                    <span class="text-sm text-slate-300">@lang('Show in Pricing Cards')</span>
                </label>
                <p class="text-xs text-slate-500 mt-2">@lang('Features are always shown in comparison tables. Use badges to highlight special features.')</p>
            </div>
        </form>

        <x-slot:footer>
            <x-admin.button type="button" wire:click="closeModal" variant="secondary">@lang('Cancel')</x-admin.button>
            <x-admin.button type="submit" wire:click="save" icon="ph-floppy-disk">
                <span wire:loading.remove wire:target="save">{{ $editingId ? __('Update') : __('Add') }}</span>
                <span wire:loading wire:target="save">@lang('Saving...')</span>
            </x-admin.button>
        </x-slot:footer>
    </x-admin.modal>

    {{-- Copy Features Modal --}}
    <x-admin.modal wire:model="showCopyModal" maxWidth="md">
        <x-slot:title>@lang('Copy Features from Another Product')</x-slot:title>

        <div class="space-y-4">
            <p class="text-slate-400 text-sm">
                @lang('Select a product to copy all its features to the current product. Existing features will not be affected.')
            </p>

            <x-admin.form-group :label="__('Copy From Product')" for="copyFromProductId">
                <x-admin.select id="copyFromProductId" wire:model="copyFromProductId">
                    <option value="">@lang('-- Select Product --')</option>
                    @foreach($this->products as $prod)
                        @if($prod->id !== $productId)
                            <option value="{{ $prod->id }}">
                                {{ $prod->name }} ({{ $prod->features->count() }} features)
                            </option>
                        @endif
                    @endforeach
                </x-admin.select>
            </x-admin.form-group>
        </div>

        <x-slot:footer>
            <x-admin.button type="button" wire:click="closeCopyModal" variant="secondary">@lang('Cancel')</x-admin.button>
            <x-admin.button type="button" wire:click="copyFeatures" icon="ph-copy" :disabled="!$copyFromProductId">
                @lang('Copy Features')
            </x-admin.button>
        </x-slot:footer>
    </x-admin.modal>

</div>

