<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="$isEdit ? __('Edit Product') : __('Add Product')" :subtitle="$isEdit ? __('Update product details and pricing.') : __('Create a new hosting product.')">
        <x-slot:actions>
            <x-admin.button href="{{ route('admin.products.all') }}" variant="secondary" icon="ph-arrow-left"
                class="hidden sm:inline-flex">
                @lang('Back to Products')
            </x-admin.button>
            <x-admin.button href="{{ route('admin.products.all') }}" variant="secondary" icon="ph-arrow-left"
                class="sm:hidden">
                @lang('Back')
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    <form wire:submit="save" class="mt-4 sm:mt-6">
        <div class="grid grid-cols-1 gap-4 sm:gap-6 xl:grid-cols-3">
            {{-- Main Content --}}
            <div class="space-y-4 sm:space-y-6 xl:col-span-2 order-2 xl:order-1">
                {{-- Basic Information --}}
                <x-admin.card :title="__('Basic Information')" :subtitle="__('Product name and description.')">
                    <div class="space-y-4">
                        <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                            <x-admin.input :label="__('Product Name')" wire:model.live="name"
                                placeholder="{{ __('Enter product name') }}" required />
                            <x-admin.input :label="__('Slug')" wire:model="slug" placeholder="{{ __('product-slug') }}"
                                required />
                        </div>
                        <x-admin.select :label="__('Category')" wire:model="category_id" required>
                            <option value="">@lang('Select Category')</option>
                            @foreach($this->categories as $category)
                                <option value="{{ $category->id }}">{{ $category->name }}</option>
                            @endforeach
                        </x-admin.select>
                        <x-admin.textarea :label="__('Description')" wire:model="description"
                            placeholder="{{ __('Product description...') }}" rows="3" />
                    </div>
                </x-admin.card>

                {{-- Product Type --}}
                <x-admin.card :title="__('Product Type')" :subtitle="__('Define the type and payment model.')">
                    <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                        <x-admin.select :label="__('Product Type')" wire:model="product_type">
                            <option value="1">@lang('Shared Hosting')</option>
                            <option value="2">@lang('Reseller Hosting')</option>
                            <option value="3">@lang('VPS / Server')</option>
                            <option value="4">@lang('Other')</option>
                        </x-admin.select>
                        <x-admin.select :label="__('Payment Type')" wire:model="payment_type">
                            <option value="2">@lang('Recurring')</option>
                            <option value="1">@lang('One-Time')</option>
                        </x-admin.select>
                    </div>
                </x-admin.card>

                {{-- Module Settings --}}
                <x-admin.card :title="__('Module Settings')" :subtitle="__('Automation and server configuration.')">
                    <div class="space-y-4 relative">
                        {{-- Loading Overlay --}}
                        @if($loadingPackages)
                            <div class="absolute inset-0 bg-white/80 dark:bg-slate-800/80 backdrop-blur-sm z-10 flex items-center justify-center rounded-lg">
                                <div class="flex flex-col items-center gap-3">
                                    <div class="flex items-center gap-2">
                                        <i class="ph-duotone ph-spinner animate-spin text-2xl text-primary-600"></i>
                                        <span class="text-sm font-medium text-slate-600 dark:text-slate-300">@lang('Fetching packages from server...')</span>
                                    </div>
                                    <div class="flex gap-1">
                                        <span class="w-2 h-2 bg-primary-600 rounded-full animate-bounce" style="animation-delay: 0ms"></span>
                                        <span class="w-2 h-2 bg-primary-600 rounded-full animate-bounce" style="animation-delay: 150ms"></span>
                                        <span class="w-2 h-2 bg-primary-600 rounded-full animate-bounce" style="animation-delay: 300ms"></span>
                                    </div>
                                </div>
                            </div>
                        @endif

                        <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                            <x-admin.select :label="__('Module')" wire:model.live="module_type">
                                <option value="0">@lang('None')</option>
                                <option value="1">cPanel</option>
                                <option value="2">DirectAdmin</option>
                                <option value="3">Plesk</option>
                            </x-admin.select>
                            <x-admin.select :label="__('Auto Setup')" wire:model="module_option">
                                <option value="1">@lang('On Payment')</option>
                                <option value="2">@lang('On Order Accept')</option>
                                <option value="3">@lang('Manual')</option>
                            </x-admin.select>
                        </div>
                        @if($module_type > 0)
                            <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                                <x-admin.select :label="__('Server Group')" wire:model.live="server_group_id">
                                    <option value="">@lang('Select Server Group')</option>
                                    @foreach($this->serverGroups as $group)
                                        <option value="{{ $group->id }}">{{ $group->name }}</option>
                                    @endforeach
                                </x-admin.select>
                                <x-admin.select :label="__('Server')" wire:model.live="server_id">
                                    <option value="">@lang('Auto Select (All from Group)')</option>
                                    @foreach($this->servers as $server)
                                        <option value="{{ $server->id }}">{{ $server->name }}</option>
                                    @endforeach
                                </x-admin.select>
                            </div>
                            {{-- Package Selection with Dynamic Loading --}}
                            <div class="relative">
                                <x-admin.select :label="__('Package Name')" wire:model.live="package_name" :disabled="$loadingPackages">
                                    <option value="">
                                        {{ $loadingPackages ? __('Loading packages...') : __('Select Package') }}</option>
                                    @foreach($availablePackages as $package)
                                        <option value="{{ $package['name'] }}">{{ $package['name'] }}
                                            ({{ $package['server_name'] }})</option>
                                    @endforeach
                                </x-admin.select>
                                @if($loadingPackages)
                                    <div class="absolute right-3 top-9">
                                        <i class="ph-duotone ph-spinner animate-spin text-primary-600"></i>
                                    </div>
                                @endif
                                @if($server_group_id && empty($availablePackages) && !$loadingPackages)
                                    <p class="mt-1 text-xs text-amber-500 flex items-center gap-1">
                                        <i class="ph-duotone ph-warning"></i>
                                        @lang('No packages found. Enter manually:')
                                    </p>
                                    <x-admin.input wire:model="package_name" placeholder="{{ __('e.g., starter_plan') }}"
                                        class="mt-2" />
                                @elseif(!empty($availablePackages) && !$loadingPackages)
                                    <p class="mt-1 text-xs text-green-500 flex items-center gap-1">
                                        <i class="ph-duotone ph-check-circle"></i>
                                        @lang(':count packages loaded successfully', ['count' => count($availablePackages)])
                                    </p>
                                @endif
                            </div>
                        @endif
                    </div>
                </x-admin.card>


                {{-- Pricing with Per-Cycle Setup Fees and Enable/Disable --}}
                <x-admin.card :title="__('Pricing')" :subtitle="__('Set billing cycle prices and setup fees.')">
                    <div class="space-y-4">
                        @php
                            $cycles = [
                                'monthly' => ['label' => __('Monthly'), 'icon' => 'ph-calendar'],
                                'quarterly' => ['label' => __('Quarterly'), 'icon' => 'ph-calendar-blank'],
                                'semi_annually' => ['label' => __('Semi-Annually'), 'icon' => 'ph-calendar-check'],
                                'annually' => ['label' => __('Annually'), 'icon' => 'ph-calendar-star'],
                                'biennially' => ['label' => __('Biennially'), 'icon' => 'ph-calendar-plus'],
                                'triennially' => ['label' => __('Triennially'), 'icon' => 'ph-calendar-x'],
                            ];
                        @endphp

                        <div class="grid grid-cols-1 gap-3 sm:gap-4 sm:grid-cols-2">
                            @foreach($cycles as $key => $cycle)
                                <div
                                    class="rounded-xl border border-white/10 bg-white/5 p-3 sm:p-4 transition-all duration-200 {{ $pricing[$key]['enabled'] ? '' : 'opacity-50' }}">
                                    <div class="mb-2 sm:mb-3 flex items-center justify-between">
                                        <div class="flex items-center gap-2">
                                            <i
                                                class="ph-duotone {{ $cycle['icon'] }} text-base sm:text-lg text-primary-400"></i>
                                            <span
                                                class="text-xs sm:text-sm font-medium text-white">{{ $cycle['label'] }}</span>
                                        </div>
                                        <x-admin.toggle wire:model.live="pricing.{{ $key }}.enabled" />
                                    </div>
                                    <div class="grid grid-cols-2 gap-2 sm:gap-3">
                                        <div>
                                            <label class="mb-1 block text-xs text-slate-400">@lang('Price')</label>
                                            <input type="number" step="0.01" min="0" wire:model="pricing.{{ $key }}.price"
                                                class="w-full rounded-lg border border-white/10 bg-white/5 px-2 sm:px-3 py-2 text-base sm:text-sm text-white placeholder-slate-500 focus:border-primary-500 focus:outline-none focus:ring-1 focus:ring-primary-500 {{ $errors->has("pricing.$key.price") ? 'border-rose-500/50' : '' }}"
                                                placeholder="0.00" {{ !$pricing[$key]['enabled'] ? 'disabled' : '' }}>
                                            @error("pricing.$key.price")
                                                <p class="mt-1 text-[10px] text-rose-400">{{ $message }}</p>
                                            @enderror
                                        </div>
                                        <div>
                                            <label class="mb-1 block text-xs text-slate-400">@lang('Setup Fee')</label>
                                            <input type="number" step="0.01" min="0"
                                                wire:model="pricing.{{ $key }}.setup_fee"
                                                class="w-full rounded-lg border border-white/10 bg-white/5 px-2 sm:px-3 py-2 text-base sm:text-sm text-white placeholder-slate-500 focus:border-primary-500 focus:outline-none focus:ring-1 focus:ring-primary-500 {{ $errors->has("pricing.$key.setup_fee") ? 'border-rose-500/50' : '' }}"
                                                placeholder="0.00" {{ !$pricing[$key]['enabled'] ? 'disabled' : '' }}>
                                            @error("pricing.$key.setup_fee")
                                                <p class="mt-1 text-[10px] text-rose-400">{{ $message }}</p>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </x-admin.card>

                {{-- Discount Settings --}}
                <x-admin.card :title="__('Discount Settings')" :subtitle="__('Configure promotional discounts for this product.')">
                    <div class="space-y-4">
                        {{-- Enable Discount Toggle --}}
                        <div class="flex items-center justify-between rounded-xl bg-white/5 p-4">
                            <div>
                                <p class="text-sm font-medium text-white">@lang('Enable Discount')</p>
                                <p class="text-xs text-slate-500">@lang('Apply promotional pricing')</p>
                            </div>
                            <x-admin.toggle wire:model.live="discountEnabled" />
                        </div>

                        @if($discountEnabled)
                            <div class="grid grid-cols-1 gap-4 sm:grid-cols-3">
                                <x-admin.select :label="__('Discount Type')" wire:model="discountType">
                                    <option value="1">@lang('Percentage (%)')</option>
                                    <option value="2">@lang('Fixed Amount')</option>
                                </x-admin.select>
                                <x-admin.input type="number" step="0.01" min="0" :label="__('Discount Value')"
                                    wire:model="discountValue" placeholder="{{ $discountType == 1 ? '10' : '5.00' }}" />
                                <x-admin.select :label="__('Badge Color')" wire:model="promoBadgeColor">
                                    <option value="red">@lang('Red')</option>
                                    <option value="green">@lang('Green')</option>
                                    <option value="blue">@lang('Blue')</option>
                                    <option value="yellow">@lang('Yellow')</option>
                                    <option value="purple">@lang('Purple')</option>
                                </x-admin.select>
                            </div>

                            <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                                <x-admin.input type="datetime-local" :label="__('Start Date')"
                                    wire:model="discountStartDate" />
                                <x-admin.input type="datetime-local" :label="__('End Date')" wire:model="discountEndDate" />
                            </div>

                            <x-admin.input :label="__('Promo Badge Text')" wire:model="promoBadgeText"
                                placeholder="{{ __('e.g., SALE, 20% OFF, LIMITED') }}" />

                            {{-- Per-Cycle Discount Overrides --}}
                            <div class="mt-4 border-t border-white/10 pt-4">
                                <p class="mb-3 text-sm font-medium text-white">@lang('Per-Cycle Discount Overrides') <span
                                        class="text-xs text-slate-500">(@lang('optional'))</span></p>
                                <div class="grid grid-cols-2 gap-3 md:grid-cols-3">
                                    @foreach(['monthly' => 'Monthly', 'quarterly' => 'Quarterly', 'semi_annually' => 'Semi-Annual', 'annually' => 'Annual', 'biennially' => 'Biennial', 'triennially' => 'Triennial'] as $key => $label)
                                        <div>
                                            <label class="mb-1 block text-xs text-slate-400">{{ __($label) }}</label>
                                            <input type="number" step="0.01" min="0" wire:model="cycleDiscounts.{{ $key }}"
                                                class="w-full rounded-lg border border-white/10 bg-white/5 px-3 py-2 text-sm text-white placeholder-slate-500 focus:border-primary-500 focus:outline-none focus:ring-1 focus:ring-primary-500"
                                                placeholder="{{ $discountType == 1 ? '%' : '$' }}">
                                        </div>
                                    @endforeach
                                </div>
                                <p class="mt-2 text-xs text-slate-500">
                                    @lang('Leave empty to use the global discount value above.')</p>
                            </div>
                        @endif
                    </div>
                </x-admin.card>

                {{-- Plan Enhancement Settings --}}
                <x-admin.card :title="__('Plan Enhancement')" :subtitle="__('Customize how this plan appears in pricing tables.')">
                    <div class="space-y-4">
                        {{-- Badges & Highlights --}}
                        <div class="grid grid-cols-1 gap-4 sm:grid-cols-3">
                            <div class="flex items-center justify-between rounded-xl bg-white/5 p-4">
                                <div>
                                    <p class="text-sm font-medium text-white">@lang('Featured')</p>
                                </div>
                                <x-admin.toggle wire:model.live="is_featured" />
                            </div>
                            <div class="flex items-center justify-between rounded-xl bg-white/5 p-4">
                                <div>
                                    <p class="text-sm font-medium text-white">@lang('Popular')</p>
                                </div>
                                <x-admin.toggle wire:model.live="is_popular" />
                            </div>
                            <div class="flex items-center justify-between rounded-xl bg-white/5 p-4">
                                <div>
                                    <p class="text-sm font-medium text-white">@lang('Recommended')</p>
                                </div>
                                <x-admin.toggle wire:model.live="is_recommended" />
                            </div>
                        </div>

                        {{-- Ribbon Settings --}}
                        <div class="grid grid-cols-1 gap-4 sm:grid-cols-3">
                            <x-admin.input :label="__('Ribbon Text')" wire:model="ribbon_text"
                                placeholder="{{ __('e.g., BEST VALUE') }}" />
                            <x-admin.select :label="__('Ribbon Color')" wire:model="ribbon_color">
                                <option value="">@lang('None')</option>
                                <option value="primary">@lang('Primary')</option>
                                <option value="green">@lang('Green')</option>
                                <option value="red">@lang('Red')</option>
                                <option value="yellow">@lang('Yellow')</option>
                                <option value="purple">@lang('Purple')</option>
                            </x-admin.select>
                            <x-admin.select :label="__('Ribbon Position')" wire:model="ribbon_position">
                                <option value="top-right">@lang('Top Right')</option>
                                <option value="top-left">@lang('Top Left')</option>
                            </x-admin.select>
                        </div>

                        {{-- Badge & Tagline --}}
                        <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                            <x-admin.input :label="__('Badge Text')" wire:model="badge_text"
                                placeholder="{{ __('e.g., NEW, HOT') }}" />
                            <x-admin.select :label="__('Badge Color')" wire:model="badge_color">
                                <option value="">@lang('Default')</option>
                                <option value="blue">@lang('Blue')</option>
                                <option value="green">@lang('Green')</option>
                                <option value="red">@lang('Red')</option>
                                <option value="yellow">@lang('Yellow')</option>
                                <option value="purple">@lang('Purple')</option>
                            </x-admin.select>
                        </div>

                        <x-admin.input :label="__('Tagline')" wire:model="tagline"
                            placeholder="{{ __('e.g., Perfect for small businesses') }}" />

                        {{-- Highlight Colors --}}
                        <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                            <x-admin.input type="color" :label="__('Highlight Color')" wire:model="highlight_color" />
                            <x-admin.input type="color" :label="__('Border Color')"
                                wire:model="highlight_border_color" />
                        </div>

                        {{-- CTA Customization --}}
                        <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                            <x-admin.input :label="__('CTA Button Text')" wire:model="cta_text"
                                placeholder="{{ __('e.g., Get Started, Order Now') }}" />
                            <x-admin.select :label="__('CTA Color')" wire:model="cta_color">
                                <option value="">@lang('Default')</option>
                                <option value="primary">@lang('Primary')</option>
                                <option value="green">@lang('Green')</option>
                                <option value="blue">@lang('Blue')</option>
                            </x-admin.select>
                        </div>

                        {{-- Comparison Settings --}}
                        <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                            <x-admin.input type="number" :label="__('Comparison Order')" wire:model="comparison_order"
                                min="0" />
                            <div class="flex items-center justify-between rounded-xl bg-white/5 p-4">
                                <div>
                                    <p class="text-sm font-medium text-white">@lang('Show in Comparison')</p>
                                </div>
                                <x-admin.toggle wire:model.live="show_in_comparison" />
                            </div>
                        </div>
                    </div>
                </x-admin.card>

                {{-- Assigned Configurable Groups --}}
                <x-admin.card :title="__('Configurable Options')" :subtitle="__('Assign configurable option groups to this product.')">
                    <div class="space-y-3">
                        @forelse($this->configurableGroups as $group)
                            <label
                                class="flex cursor-pointer items-center gap-3 rounded-xl border border-white/10 bg-white/5 p-4 transition-all duration-200 hover:border-primary-500/50 hover:bg-white/10">
                                <input type="checkbox" wire:model="assigned_config_groups" value="{{ $group->id }}"
                                    class="h-4 w-4 rounded border-white/20 bg-white/5 text-primary-500 focus:ring-primary-500 focus:ring-offset-0">
                                <div class="flex-1">
                                    <p class="text-sm font-medium text-white">{{ $group->name }}</p>
                                    @if($group->description)
                                        <p class="text-xs text-slate-400">{{ Str::limit($group->description, 60) }}</p>
                                    @endif
                                </div>
                                <span class="rounded-full bg-primary-500/20 px-2 py-0.5 text-xs text-primary-400">
                                    {{ $group->options_count ?? $group->options()->count() }} @lang('options')
                                </span>
                            </label>
                        @empty
                            <div class="rounded-xl border border-dashed border-white/10 p-6 text-center">
                                <i class="ph-duotone ph-sliders-horizontal mb-2 text-3xl text-slate-500"></i>
                                <p class="text-sm text-slate-400">@lang('No configurable groups available.')</p>
                                <a href="{{ route('admin.products.configurable-groups') }}"
                                    class="mt-2 inline-block text-xs text-primary-400 hover:underline">
                                    @lang('Create Configurable Group') →
                                </a>
                            </div>
                        @endforelse
                    </div>
                </x-admin.card>
            </div>

            {{-- Sidebar --}}
            <div class="space-y-4 sm:space-y-6 order-1 xl:order-2">
                {{-- Status --}}
                <x-admin.card :title="__('Status')">
                    <div class="flex items-center justify-between rounded-xl bg-white/5 p-4">
                        <div>
                            <p class="text-sm font-medium text-white">@lang('Active')</p>
                            <p class="text-xs text-slate-500">@lang('Show product on frontend')</p>
                        </div>
                        <x-admin.toggle wire:model.live="status" />
                    </div>
                </x-admin.card>

                {{-- Options --}}
                <x-admin.card :title="__('Options')">
                    <div class="space-y-4">
                        <div class="flex items-center justify-between rounded-xl bg-white/5 p-4">
                            <div>
                                <p class="text-sm font-medium text-white">@lang('Domain Registration')</p>
                                <p class="text-xs text-slate-500">@lang('Require domain on order')</p>
                            </div>
                            <x-admin.toggle wire:model.live="domain_register" />
                        </div>
                        <div class="flex items-center justify-between rounded-xl bg-white/5 p-4">
                            <div>
                                <p class="text-sm font-medium text-white">@lang('Stock Control')</p>
                                <p class="text-xs text-slate-500">@lang('Limit available quantity')</p>
                            </div>
                            <x-admin.toggle wire:model.live="stock_control" />
                        </div>
                        @if($stock_control)
                            <x-admin.input type="number" :label="__('Stock Quantity')" wire:model="stock_quantity"
                                min="0" />
                        @endif
                    </div>
                </x-admin.card>

                {{-- Upgrade/Downgrade Settings --}}
                <x-admin.card :title="__('Upgrade/Downgrade')">
                    <div class="space-y-4">
                        <div class="flex items-center justify-between rounded-xl bg-white/5 p-4">
                            <div>
                                <p class="text-sm font-medium text-white">@lang('Allow Upgrades')</p>
                                <p class="text-xs text-slate-500">@lang('Enable upgrade/downgrade')</p>
                            </div>
                            <x-admin.toggle wire:model.live="allow_upgrade" />
                        </div>
                        @if($allow_upgrade)
                            <div class="mt-4">
                                <label class="mb-2 block text-sm font-medium text-slate-300">@lang('Link to Upgrade Products')</label>
                                <div class="max-h-72 overflow-y-auto space-y-2 pr-2 custom-scrollbar">
                                    @forelse($this->allProducts as $p)
                                        <label class="flex items-center gap-3 p-3 rounded-lg bg-white/5 border border-white/10 hover:border-primary-500/50 cursor-pointer transition-all">
                                            <input type="checkbox" wire:model="assigned_upgrade_products" value="{{ $p->id }}"
                                                class="h-4 w-4 rounded border-white/20 bg-white/5 text-primary-500 focus:ring-primary-500">
                                            <div class="flex-1">
                                                <div class="flex items-center justify-between">
                                                    <p class="text-sm font-medium text-white">{{ $p->name }}</p>
                                                    @if($p->upgrade_group_id)
                                                        <span class="text-[10px] uppercase tracking-wider px-2 py-0.5 rounded-full bg-slate-500/20 text-slate-400">
                                                            @lang('Group') #{{ $p->upgrade_group_id }}
                                                        </span>
                                                    @endif
                                                </div>
                                                <p class="text-xs text-slate-500">{{ $p->serviceCategory?->name }}</p>
                                            </div>
                                        </label>
                                    @empty
                                        <div class="text-center py-6 border border-dashed border-white/10 rounded-xl">
                                            <p class="text-sm text-slate-500">@lang('No other products available.')</p>
                                        </div>
                                    @endforelse
                                </div>
                                <p class="mt-3 text-xs text-slate-500 leading-relaxed">
                                    @lang('Selected products will be linked in the same upgrade group. Clients will be able to upgrade or downgrade between any products that share a group.')
                                </p>
                            </div>
                        @endif
                    </div>
                </x-admin.card>

                {{-- Welcome Email --}}
                <x-admin.card :title="__('Welcome Email')">
                    <x-admin.select :label="__('Email Template')" wire:model="welcome_email">
                        <option value="">@lang('Use System Default')</option>
                        @foreach(welcomeEmail() as $id => $template)
                            <option value="{{ $id }}">{{ __($template['name']) }}</option>
                        @endforeach
                    </x-admin.select>
                    <p class="mt-2 text-xs text-slate-500">@lang('Selected template will be sent to the client upon activation.')</p>
                </x-admin.card>

                {{-- Actions --}}
                <x-admin.card>
                    <div class="flex flex-col gap-3">
                        <x-admin.button type="submit" class="w-full" icon="ph-check">
                            {{ $isEdit ? __('Update Product') : __('Create Product') }}
                        </x-admin.button>
                        <x-admin.button type="button" variant="secondary" href="{{ route('admin.products.all') }}"
                            class="w-full">
                            @lang('Cancel')
                        </x-admin.button>
                    </div>
                </x-admin.card>
            </div>
        </div>
    </form>
</div>