<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Products')" :subtitle="__('Manage hosting products and services.')">
        <x-slot:actions>
            <x-admin.button href="{{ route('admin.products.create') }}" icon="ph-plus">
                @lang('Add Product')
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    @if (session('success'))
        <x-admin.alert type="success" class="mt-6">{{ session('success') }}</x-admin.alert>
    @endif

    {{-- Statistics Cards --}}
    <div class="mt-6 grid grid-cols-1 gap-4 sm:grid-cols-3">
        <x-admin.stat-card icon="ph-package" iconColor="primary" :label="__('Total Products')" :value="$totalProducts" />
        <x-admin.stat-card icon="ph-check-circle" iconColor="success" :label="__('Active Products')" :value="$activeProducts" />
        <x-admin.stat-card icon="ph-x-circle" iconColor="danger" :label="__('Inactive Products')" :value="$inactiveProducts" />
    </div>

    {{-- Filters Card --}}
    <x-admin.card class="mt-6">
        <div class="flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between">
            {{-- Search --}}
            <div class="relative w-full sm:w-80">
                <i class="ph-duotone ph-magnifying-glass absolute left-3 top-1/2 -translate-y-1/2 text-slate-500"></i>
                <input
                    type="text"
                    wire:model.live.debounce.300ms="search"
                    placeholder="{{ __('Search products...') }}"
                    class="w-full rounded-xl border border-white/10 bg-white/5 py-2.5 pl-10 pr-4 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                />
                @if($search)
                    <button wire:click="$set('search', '')" class="absolute right-3 top-1/2 -translate-y-1/2 text-slate-500 transition-colors hover:text-white">
                        <i class="ph-bold ph-x text-sm"></i>
                    </button>
                @endif
            </div>

            {{-- Filters --}}
            <div class="flex flex-wrap gap-2">
                <select
                    wire:model.live="category"
                    class="rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                >
                    <option value="" class="bg-[#1a1a24]">@lang('All Categories')</option>
                    @foreach($categories as $cat)
                        <option value="{{ $cat->id }}" class="bg-[#1a1a24]">{{ $cat->name }}</option>
                    @endforeach
                </select>
                <select
                    wire:model.live="status"
                    class="rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                >
                    <option value="" class="bg-[#1a1a24]">@lang('All Status')</option>
                    <option value="active" class="bg-[#1a1a24]">@lang('Active')</option>
                    <option value="inactive" class="bg-[#1a1a24]">@lang('Inactive')</option>
                </select>
            </div>
        </div>
    </x-admin.card>

    {{-- Products Table --}}
    <x-admin.card class="mt-6" :padding="false">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-white/5 bg-white/[0.02]">
                        <th class="px-6 py-4 text-left">
                            <button wire:click="sortBy('name')" class="flex items-center gap-2 text-xs font-semibold uppercase tracking-wider text-slate-500 transition-colors hover:text-white">
                                @lang('Product')
                                @if($sortField === 'name')
                                    <i class="ph-bold {{ $sortDirection === 'asc' ? 'ph-caret-up' : 'ph-caret-down' }} text-indigo-400"></i>
                                @endif
                            </button>
                        </th>
                        <th class="px-6 py-4 text-left">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Category')</span>
                        </th>
                        <th class="px-6 py-4 text-left">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Type')</span>
                        </th>
                        <th class="px-6 py-4 text-left">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Pricing')</span>
                        </th>
                        <th class="px-6 py-4 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Status')</span>
                        </th>
                        <th class="px-6 py-4 text-right">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Actions')</span>
                        </th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    @forelse($products as $product)
                        <tr class="group transition-all hover:bg-white/[0.02]" wire:key="product-{{ $product->id }}">
                            {{-- Product Info --}}
                            <td class="px-6 py-4">
                                <div class="flex items-center gap-3">
                                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20 text-indigo-400">
                                        <i class="ph-duotone ph-package text-lg"></i>
                                    </div>
                                    <div>
                                        <p class="font-medium text-white">{{ $product->name }}</p>
                                        <p class="text-sm text-slate-500">{{ $product->slug }}</p>
                                    </div>
                                </div>
                            </td>

                            {{-- Category --}}
                            <td class="px-6 py-4">
                                <span class="text-sm text-slate-300">{{ $product->category?->name ?? __('Uncategorized') }}</span>
                            </td>

                            {{-- Type --}}
                            <td class="px-6 py-4">
                                @php
                                    $typeLabels = [
                                        1 => ['label' => __('Shared Hosting'), 'color' => 'primary'],
                                        2 => ['label' => __('Reseller Hosting'), 'color' => 'info'],
                                        3 => ['label' => __('VPS/Server'), 'color' => 'warning'],
                                        4 => ['label' => __('Other'), 'color' => 'secondary'],
                                    ];
                                    $type = $typeLabels[$product->product_type] ?? ['label' => __('Unknown'), 'color' => 'secondary'];
                                @endphp
                                <x-admin.badge :type="$type['color']" size="sm">{{ $type['label'] }}</x-admin.badge>
                            </td>

                            {{-- Pricing --}}
                            <td class="px-6 py-4">
                                @if($product->pricing)
                                    <span class="text-sm font-medium text-white">
                                        {{ showAmount($product->pricing->monthly ?? 0) }}/@lang('mo')
                                    </span>
                                @else
                                    <span class="text-sm text-slate-500">@lang('Not set')</span>
                                @endif
                            </td>

                            {{-- Status --}}
                            <td class="px-6 py-4 text-center">
                                <x-admin.toggle wire:click="toggleStatus({{ $product->id }})" :checked="$product->status" />
                            </td>

                            {{-- Actions --}}
                            <td class="px-6 py-4 text-right">
                                <x-admin.action-menu>
                                    <x-admin.action-menu-item href="{{ route('admin.products.edit', $product->id) }}" icon="ph-pencil">
                                        @lang('Edit Product')
                                    </x-admin.action-menu-item>
                                    <x-admin.action-menu-item href="{{ route('admin.products.pricing', $product->id) }}" icon="ph-currency-dollar">
                                        @lang('Manage Pricing')
                                    </x-admin.action-menu-item>
                                    <x-admin.action-menu-item href="{{ route('admin.products.features', $product->id) }}" icon="ph-list-checks">
                                        @lang('Manage Features')
                                    </x-admin.action-menu-item>
                                    <x-admin.action-menu-item :divider="true" />
                                    <x-admin.action-menu-item wire:click="deleteProduct({{ $product->id }})" wire:confirm="{{ __('Are you sure you want to delete this product?') }}" icon="ph-trash" :danger="true">
                                        @lang('Delete Product')
                                    </x-admin.action-menu-item>
                                </x-admin.action-menu>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="px-6 py-16 text-center">
                                <div class="flex flex-col items-center">
                                    <div class="flex h-16 w-16 items-center justify-center rounded-2xl bg-white/5">
                                        <i class="ph-duotone ph-package text-3xl text-slate-500"></i>
                                    </div>
                                    <h3 class="mt-4 text-lg font-medium text-white">@lang('No products found')</h3>
                                    <p class="mt-1 text-sm text-slate-500">
                                        @if($search || $category || $status)
                                            @lang('No products match your search criteria.')
                                        @else
                                            @lang('Get started by adding your first product.')
                                        @endif
                                    </p>
                                    @if(!$search && !$category && !$status)
                                        <x-admin.button href="{{ route('admin.products.create') }}" icon="ph-plus" class="mt-4">
                                            @lang('Add Product')
                                        </x-admin.button>
                                    @endif
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        {{-- Pagination --}}
        @if($products->hasPages())
            <div class="border-t border-white/5 px-6 py-4">
                {{ $products->links() }}
            </div>
        @endif
    </x-admin.card>
</div>

