<div>
    <x-admin.page-header :title="__('Profile Settings')" :description="__('Manage your account settings and security.')" />

    @if (session('success'))
        <x-admin.alert type="success" class="mb-4 sm:mb-6">{{ session('success') }}</x-admin.alert>
    @endif

    <!-- Tabs - Horizontal Scroll on Mobile -->
    <div class="border-b border-white/10 mb-4 sm:mb-6 -mx-4 sm:mx-0 px-4 sm:px-0 overflow-x-auto">
        <nav class="flex gap-4 sm:gap-8 min-w-max sm:min-w-0">
            <button
                wire:click="$set('activeTab', 'profile')"
                class="py-3 sm:py-4 px-1 border-b-2 font-medium text-xs sm:text-sm transition-colors whitespace-nowrap {{ $activeTab === 'profile' ? 'border-primary-500 text-primary-400' : 'border-transparent text-slate-500 hover:text-slate-300' }}"
            >
                @lang('Profile Information')
            </button>
            <button
                wire:click="$set('activeTab', 'password')"
                class="py-3 sm:py-4 px-1 border-b-2 font-medium text-xs sm:text-sm transition-colors whitespace-nowrap {{ $activeTab === 'password' ? 'border-primary-500 text-primary-400' : 'border-transparent text-slate-500 hover:text-slate-300' }}"
            >
                @lang('Change Password')
            </button>
            <button
                wire:click="$set('activeTab', '2fa')"
                class="py-3 sm:py-4 px-1 border-b-2 font-medium text-xs sm:text-sm transition-colors whitespace-nowrap {{ $activeTab === '2fa' ? 'border-primary-500 text-primary-400' : 'border-transparent text-slate-500 hover:text-slate-300' }}"
            >
                @lang('Two-Factor Auth')
            </button>
        </nav>
    </div>

    <!-- Profile Tab -->
    @if($activeTab === 'profile')
        <x-admin.card>
            <x-admin.card-header :title="__('Profile Information')" :description="__('Update your account\'s profile information.')" />
            <form wire:submit="updateProfile" class="p-4 sm:p-6 space-y-4 sm:space-y-6">
                <div class="flex flex-col sm:flex-row items-center gap-4 sm:gap-6">
                    <div class="shrink-0">
                        @if($image)
                            <img src="{{ $image->temporaryUrl() }}" class="h-16 w-16 sm:h-20 sm:w-20 rounded-full object-cover" />
                        @else
                            <x-admin.avatar :name="$name" size="xl" />
                        @endif
                    </div>
                    <div class="text-center sm:text-left">
                        <x-admin.button type="button" variant="secondary" size="sm" x-on:click="$refs.imageInput.click()">
                            @lang('Change Photo')
                        </x-admin.button>
                        <input type="file" wire:model="image" x-ref="imageInput" class="hidden" accept="image/*" />
                        <p class="text-[10px] sm:text-xs text-slate-500 mt-1">@lang('JPG, PNG. Max 2MB.')</p>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 sm:gap-6">
                    <x-admin.input wire:model="name" :label="__('Full Name')" required />
                    <x-admin.input wire:model="email" type="email" :label="__('Email Address')" required />
                </div>

                <div class="flex justify-end">
                    <x-admin.button type="submit" class="w-full sm:w-auto min-h-11 sm:min-h-0">@lang('Save Changes')</x-admin.button>
                </div>
            </form>
        </x-admin.card>
    @endif

    <!-- Password Tab -->
    @if($activeTab === 'password')
        <x-admin.card>
            <x-admin.card-header :title="__('Change Password')" :description="__('Ensure your account is using a long, random password.')" />
            <form wire:submit="updatePassword" class="p-4 sm:p-6 space-y-4 sm:space-y-6">
                <x-admin.input wire:model="current_password" type="password" :label="__('Current Password')" required />
                <x-admin.input wire:model="password" type="password" :label="__('New Password')" required />
                <x-admin.input wire:model="password_confirmation" type="password" :label="__('Confirm Password')" required />

                <div class="flex justify-end">
                    <x-admin.button type="submit" class="w-full sm:w-auto min-h-11 sm:min-h-0">@lang('Update Password')</x-admin.button>
                </div>
            </form>
        </x-admin.card>
    @endif

    <!-- 2FA Tab -->
    @if($activeTab === '2fa')
        <x-admin.card>
            <x-admin.card-header :title="__('Two-Factor Authentication')" :description="__('Add an extra layer of security to your account.')" />
            <div class="p-4 sm:p-6">
                @if($twoFactorEnabled)
                    <div class="flex items-start sm:items-center gap-3 sm:gap-4 p-3 sm:p-4 bg-emerald-900/20 rounded-xl border border-emerald-800 mb-4 sm:mb-6">
                        <div class="shrink-0 w-8 h-8 sm:w-10 sm:h-10 bg-emerald-900/50 rounded-full flex items-center justify-center">
                            <svg class="w-4 h-4 sm:w-5 sm:h-5 text-emerald-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                            </svg>
                        </div>
                        <div class="min-w-0">
                            <div class="text-xs sm:text-sm font-medium text-emerald-200">@lang('Two-factor authentication is enabled')</div>
                            <div class="text-[10px] sm:text-sm text-emerald-400">@lang('Your account is protected with 2FA.')</div>
                        </div>
                    </div>
                    <form wire:submit="disableTwoFactor" class="space-y-3 sm:space-y-4">
                        <x-admin.input wire:model="twoFactorCode" :label="__('Enter 2FA Code to Disable')" placeholder="000000" maxlength="6" />
                        <x-admin.button type="submit" variant="danger" class="w-full sm:w-auto min-h-11 sm:min-h-0">@lang('Disable 2FA')</x-admin.button>
                    </form>
                @else
                    @if($twoFactorSecret)
                        <div class="text-center mb-4 sm:mb-6">
                            <p class="text-xs sm:text-sm text-slate-400 mb-3 sm:mb-4">@lang('Scan this QR code with your authenticator app:')</p>
                            <div class="inline-flex p-3 sm:p-4 bg-white rounded-xl shadow-sm border">
                                {!! $twoFactorQrSvg !!}
                            </div>
                            <div class="mt-3 sm:mt-4 flex flex-col sm:flex-row items-center justify-center gap-2">
                                <span class="text-[10px] sm:text-sm text-slate-500">@lang('Or enter this code manually:')</span>
                                <div class="flex items-center gap-1.5">
                                    <code class="bg-slate-800 px-2 sm:px-3 py-1 sm:py-1.5 rounded font-mono text-[10px] sm:text-sm tracking-wider text-white">{{ $twoFactorSecret }}</code>
                                    <button type="button" onclick="navigator.clipboard.writeText('{{ $twoFactorSecret }}')" class="p-1.5 text-slate-400 hover:text-slate-200 transition-colors min-h-8 min-w-8 flex items-center justify-center">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z" />
                                        </svg>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <form wire:submit="enableTwoFactor" class="space-y-3 sm:space-y-4 max-w-sm mx-auto">
                            <x-admin.input wire:model="twoFactorCode" :label="__('Verification Code')" placeholder="000000" maxlength="6" inputmode="numeric" />
                            <x-admin.button type="submit" class="w-full min-h-11 sm:min-h-0">@lang('Enable 2FA')</x-admin.button>
                        </form>
                    @else
                        <div class="text-center">
                            <div class="w-12 h-12 sm:w-16 sm:h-16 mx-auto bg-slate-800 rounded-full flex items-center justify-center mb-3 sm:mb-4">
                                <svg class="w-6 h-6 sm:w-8 sm:h-8 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                                </svg>
                            </div>
                            <p class="text-xs sm:text-sm text-slate-400 mb-3 sm:mb-4">@lang('Two-factor authentication is not enabled.')</p>
                            <x-admin.button wire:click="generateTwoFactorSecret" class="min-h-11 sm:min-h-0">@lang('Setup 2FA')</x-admin.button>
                        </div>
                    @endif
                @endif
            </div>
        </x-admin.card>
    @endif
</div>

