<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Email Details')" :subtitle="__('View the full content of this email notification.')">
        <x-slot:actions>
            <x-admin.button href="{{ route('admin.report.notification.history') }}" variant="secondary" icon="ph-arrow-left">
                @lang('Back to History')
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    {{-- Email Info Card --}}
    <x-admin.card class="mt-6">
        <div class="grid grid-cols-1 gap-6 md:grid-cols-2 lg:grid-cols-4">
            {{-- Type --}}
            <div>
                <label class="text-xs font-medium uppercase tracking-wider text-slate-500">@lang('Type')</label>
                <div class="mt-2">
                    @switch($email->notification_type)
                        @case('email')
                            <span class="inline-flex items-center gap-1.5 rounded-lg bg-sky-500/10 px-3 py-1.5 text-sm font-medium text-sky-400">
                                <i class="ph-duotone ph-envelope text-base"></i>
                                @lang('Email')
                            </span>
                            @break
                        @case('sms')
                            <span class="inline-flex items-center gap-1.5 rounded-lg bg-emerald-500/10 px-3 py-1.5 text-sm font-medium text-emerald-400">
                                <i class="ph-duotone ph-device-mobile text-base"></i>
                                @lang('SMS')
                            </span>
                            @break
                        @case('push')
                            <span class="inline-flex items-center gap-1.5 rounded-lg bg-amber-500/10 px-3 py-1.5 text-sm font-medium text-amber-400">
                                <i class="ph-duotone ph-bell-ringing text-base"></i>
                                @lang('Push Notification')
                            </span>
                            @break
                    @endswitch
                </div>
            </div>

            {{-- Sent At --}}
            <div>
                <label class="text-xs font-medium uppercase tracking-wider text-slate-500">@lang('Sent At')</label>
                <p class="mt-2 text-sm text-slate-300">{{ $email->created_at->format('M d, Y H:i:s') }}</p>
                <p class="text-xs text-slate-500">{{ $email->created_at->diffForHumans() }}</p>
            </div>

            {{-- Sent To --}}
            <div>
                <label class="text-xs font-medium uppercase tracking-wider text-slate-500">@lang('Sent To')</label>
                <p class="mt-2 text-sm text-slate-300">{{ $email->sent_to ?? __('N/A') }}</p>
            </div>

            {{-- Sender --}}
            <div>
                <label class="text-xs font-medium uppercase tracking-wider text-slate-500">@lang('Sender')</label>
                <p class="mt-2 text-sm text-slate-300">{{ $email->sent_from ?? $email->sender ?? __('System') }}</p>
            </div>
        </div>

        {{-- User Info --}}
        @if($email->user)
            <div class="mt-6 border-t border-white/5 pt-6">
                <label class="text-xs font-medium uppercase tracking-wider text-slate-500">@lang('Recipient User')</label>
                <div class="mt-2 flex items-center gap-3">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20 font-semibold text-indigo-400">
                        {{ strtoupper(substr($email->user->firstname ?? $email->user->username, 0, 1)) }}
                    </div>
                    <div>
                        <a href="{{ route('admin.users.detail', $email->user->username) }}" class="font-medium text-white transition-colors hover:text-indigo-400">
                            {{ $email->user->fullname }}
                        </a>
                        <p class="text-sm text-slate-500">{{ '@' . $email->user->username }} • {{ $email->user->email }}</p>
                    </div>
                </div>
            </div>
        @endif

        {{-- Subject --}}
        <div class="mt-6 border-t border-white/5 pt-6">
            <label class="text-xs font-medium uppercase tracking-wider text-slate-500">@lang('Subject')</label>
            <p class="mt-2 text-lg font-medium text-white">{{ $email->subject ?? __('No Subject') }}</p>
        </div>
    </x-admin.card>

    {{-- Email Content Card --}}
    <x-admin.card class="mt-6" :title="__('Message Content')">
        @if($email->notification_type === 'email')
            <div class="overflow-hidden rounded-xl border border-white/10">
                <iframe srcdoc="{{ $email->message }}" class="min-h-[500px] w-full bg-white"></iframe>
            </div>
        @else
            <div class="rounded-xl border border-white/10 bg-white/5 p-6">
                <div class="prose prose-invert max-w-none text-slate-300">
                    {!! nl2br(e($email->message)) !!}
                </div>
            </div>
        @endif
    </x-admin.card>
</div>

