<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Login History')" :subtitle="__('Track user login activities and session information.')">
        <x-slot:actions>
            @if($search || $ip || $dateFrom || $dateTo)
                <x-admin.button wire:click="clearFilters" variant="secondary" icon="ph-funnel-x">
                    @lang('Clear Filters')
                </x-admin.button>
            @endif
        </x-slot:actions>
    </x-admin.page-header>

    {{-- Statistics Cards --}}
    <div class="mt-6 grid grid-cols-1 gap-4 sm:grid-cols-2 lg:grid-cols-4">
        <x-admin.stat-card
            icon="ph-sign-in"
            iconColor="primary"
            :label="__('Total Logins')"
            :value="number_format($stats['total'])"
        />
        <x-admin.stat-card
            icon="ph-calendar-check"
            iconColor="success"
            :label="__('Today\'s Logins')"
            :value="number_format($stats['today'])"
        />
        <x-admin.stat-card
            icon="ph-globe"
            iconColor="info"
            :label="__('Unique IPs')"
            :value="number_format($stats['uniqueIps'])"
        />
        <x-admin.stat-card
            icon="ph-chart-line-up"
            iconColor="warning"
            :label="__('This Week')"
            :value="number_format($stats['thisWeek'])"
        />
    </div>

    {{-- Filters Card --}}
    <x-admin.card class="mt-6">
        <div class="flex flex-col gap-4 lg:flex-row lg:items-end lg:justify-between">
            <div class="grid flex-1 grid-cols-1 gap-4 sm:grid-cols-2 lg:grid-cols-4">
                {{-- Search --}}
                <div class="relative">
                    <i class="ph-duotone ph-magnifying-glass absolute left-3 top-1/2 -translate-y-1/2 text-slate-500"></i>
                    <input
                        type="text"
                        wire:model.live.debounce.300ms="search"
                        placeholder="{{ __('Search by username...') }}"
                        class="w-full rounded-xl border border-white/10 bg-white/5 py-2.5 pl-10 pr-4 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                    />
                    @if($search)
                        <button wire:click="$set('search', '')" class="absolute right-3 top-1/2 -translate-y-1/2 text-slate-500 transition-colors hover:text-white">
                            <i class="ph-bold ph-x text-sm"></i>
                        </button>
                    @endif
                </div>

                {{-- IP Filter --}}
                <div class="relative">
                    <i class="ph-duotone ph-globe absolute left-3 top-1/2 -translate-y-1/2 text-slate-500"></i>
                    <input
                        type="text"
                        wire:model.live.debounce.300ms="ip"
                        placeholder="{{ __('Filter by IP address...') }}"
                        class="w-full rounded-xl border border-white/10 bg-white/5 py-2.5 pl-10 pr-4 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                    />
                    @if($ip)
                        <button wire:click="$set('ip', '')" class="absolute right-3 top-1/2 -translate-y-1/2 text-slate-500 transition-colors hover:text-white">
                            <i class="ph-bold ph-x text-sm"></i>
                        </button>
                    @endif
                </div>

                {{-- Date Range --}}
                <input
                    type="date"
                    wire:model.live="dateFrom"
                    class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                    placeholder="{{ __('From') }}"
                />
                <input
                    type="date"
                    wire:model.live="dateTo"
                    class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                    placeholder="{{ __('To') }}"
                />
            </div>
        </div>
    </x-admin.card>

    {{-- Login Logs Table --}}
    <x-admin.card class="mt-6" :padding="false">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-white/5 bg-white/[0.02]">
                        <th class="px-6 py-4 text-left">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('User')</span>
                        </th>
                        <th class="px-6 py-4 text-left">
                            <button wire:click="sortBy('created_at')" class="flex items-center gap-2 text-xs font-semibold uppercase tracking-wider text-slate-500 transition-colors hover:text-white">
                                @lang('Login At')
                                @if($sortField === 'created_at')
                                    <i class="ph-bold {{ $sortDirection === 'asc' ? 'ph-caret-up' : 'ph-caret-down' }} text-indigo-400"></i>
                                @endif
                            </button>
                        </th>
                        <th class="px-6 py-4 text-left">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('IP Address')</span>
                        </th>
                        <th class="px-6 py-4 text-left">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Location')</span>
                        </th>
                        <th class="px-6 py-4 text-left">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Browser / OS')</span>
                        </th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    @forelse($loginLogs as $log)
                        <tr class="group transition-all hover:bg-white/[0.02]" wire:key="login-{{ $log->id }}">
                            {{-- User --}}
                            <td class="px-6 py-4">
                                @if($log->user)
                                    <div class="flex items-center gap-3">
                                        <div class="flex h-9 w-9 items-center justify-center rounded-lg bg-gradient-to-br from-indigo-500/20 to-purple-500/20 text-sm font-semibold text-indigo-400">
                                            {{ strtoupper(substr($log->user->firstname ?? $log->user->username, 0, 1)) }}
                                        </div>
                                        <div>
                                            <a href="{{ route('admin.users.detail', $log->user->username) }}" class="font-medium text-white transition-colors hover:text-indigo-400">
                                                {{ $log->user->fullname }}
                                            </a>
                                            <p class="text-xs text-slate-500">{{ '@' . $log->user->username }}</p>
                                        </div>
                                    </div>
                                @else
                                    <span class="text-slate-500">@lang('Unknown User')</span>
                                @endif
                            </td>

                            {{-- Login At --}}
                            <td class="px-6 py-4">
                                <div class="flex flex-col">
                                    <span class="text-sm text-slate-300">{{ $log->created_at->format('M d, Y H:i') }}</span>
                                    <span class="text-xs text-slate-500">{{ $log->created_at->diffForHumans() }}</span>
                                </div>
                            </td>

                            {{-- IP Address --}}
                            <td class="px-6 py-4">
                                <button
                                    wire:click="filterByIp('{{ $log->user_ip }}')"
                                    class="inline-flex items-center gap-1.5 rounded-lg bg-white/5 px-2.5 py-1 font-mono text-sm text-slate-300 transition-colors hover:bg-indigo-500/20 hover:text-indigo-400"
                                    title="{{ __('Filter by this IP') }}"
                                >
                                    <i class="ph-duotone ph-globe text-sm"></i>
                                    {{ $log->user_ip ?? __('N/A') }}
                                </button>
                            </td>

                            {{-- Location --}}
                            <td class="px-6 py-4">
                                @if($log->city || $log->country)
                                    <div class="flex items-center gap-2">
                                        @if($log->country_code)
                                            <span class="text-lg">{{ strtoupper($log->country_code) == 'US' ? '🇺🇸' : '🌍' }}</span>
                                        @endif
                                        <div class="flex flex-col">
                                            <span class="text-sm text-slate-300">{{ $log->city ?? __('Unknown City') }}</span>
                                            <span class="text-xs text-slate-500">{{ $log->country ?? __('Unknown Country') }}</span>
                                        </div>
                                    </div>
                                @else
                                    <span class="text-slate-500">@lang('Unknown')</span>
                                @endif
                            </td>

                            {{-- Browser / OS --}}
                            <td class="px-6 py-4">
                                <div class="flex flex-col gap-1">
                                    @if($log->browser)
                                        <div class="flex items-center gap-1.5">
                                            <i class="ph-duotone ph-browser text-slate-400"></i>
                                            <span class="text-sm text-slate-300">{{ $log->browser }}</span>
                                        </div>
                                    @endif
                                    @if($log->os)
                                        <div class="flex items-center gap-1.5">
                                            <i class="ph-duotone ph-desktop text-slate-400"></i>
                                            <span class="text-xs text-slate-500">{{ $log->os }}</span>
                                        </div>
                                    @endif
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="px-6 py-16 text-center">
                                <div class="flex flex-col items-center">
                                    <div class="flex h-16 w-16 items-center justify-center rounded-2xl bg-white/5">
                                        <i class="ph-duotone ph-sign-in text-3xl text-slate-500"></i>
                                    </div>
                                    <h3 class="mt-4 text-lg font-medium text-white">@lang('No login records found')</h3>
                                    <p class="mt-1 text-sm text-slate-500">
                                        @if($search || $ip || $dateFrom || $dateTo)
                                            @lang('No logins match your filter criteria.')
                                        @else
                                            @lang('No login activity has been recorded yet.')
                                        @endif
                                    </p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        {{-- Pagination --}}
        @if($loginLogs->hasPages())
            <div class="border-t border-white/5 px-6 py-4">
                {{ $loginLogs->links() }}
            </div>
        @endif
    </x-admin.card>
</div>

