<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Notification History')" :subtitle="__('Track all email, SMS, and push notifications sent to users.')">
        <x-slot:actions>
            @if($search || $type || $dateFrom || $dateTo)
                <x-admin.button wire:click="clearFilters" variant="secondary" icon="ph-funnel-x">
                    @lang('Clear Filters')
                </x-admin.button>
            @endif
        </x-slot:actions>
    </x-admin.page-header>

    {{-- Statistics Cards --}}
    <div class="mt-6 grid grid-cols-1 gap-4 sm:grid-cols-2 lg:grid-cols-4">
        <x-admin.stat-card
            icon="ph-bell"
            iconColor="primary"
            :label="__('Total Notifications')"
            :value="number_format($stats['total'])"
        />
        <x-admin.stat-card
            icon="ph-envelope"
            iconColor="info"
            :label="__('Email Notifications')"
            :value="number_format($stats['email'])"
        />
        <x-admin.stat-card
            icon="ph-device-mobile"
            iconColor="success"
            :label="__('SMS Notifications')"
            :value="number_format($stats['sms'])"
        />
        <x-admin.stat-card
            icon="ph-bell-ringing"
            iconColor="warning"
            :label="__('Push Notifications')"
            :value="number_format($stats['push'])"
        />
    </div>

    {{-- Filters Card --}}
    <x-admin.card class="mt-6">
        <div class="flex flex-col gap-4 lg:flex-row lg:items-end lg:justify-between">
            <div class="grid flex-1 grid-cols-1 gap-4 sm:grid-cols-2 lg:grid-cols-4">
                {{-- Search --}}
                <div class="relative">
                    <i class="ph-duotone ph-magnifying-glass absolute left-3 top-1/2 -translate-y-1/2 text-slate-500"></i>
                    <input
                        type="text"
                        wire:model.live.debounce.300ms="search"
                        placeholder="{{ __('Search by subject or recipient...') }}"
                        class="w-full rounded-xl border border-white/10 bg-white/5 py-2.5 pl-10 pr-4 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                    />
                    @if($search)
                        <button wire:click="$set('search', '')" class="absolute right-3 top-1/2 -translate-y-1/2 text-slate-500 transition-colors hover:text-white">
                            <i class="ph-bold ph-x text-sm"></i>
                        </button>
                    @endif
                </div>

                {{-- Type Filter --}}
                <select
                    wire:model.live="type"
                    class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                >
                    <option value="" class="bg-[#1a1a24]">@lang('All Types')</option>
                    <option value="email" class="bg-[#1a1a24]">@lang('Email')</option>
                    <option value="sms" class="bg-[#1a1a24]">@lang('SMS')</option>
                    <option value="push" class="bg-[#1a1a24]">@lang('Push')</option>
                </select>

                {{-- Date Range --}}
                <input
                    type="date"
                    wire:model.live="dateFrom"
                    class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                    placeholder="{{ __('From') }}"
                />
                <input
                    type="date"
                    wire:model.live="dateTo"
                    class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                    placeholder="{{ __('To') }}"
                />
            </div>
        </div>
    </x-admin.card>

    {{-- Notification Logs Table --}}
    <x-admin.card class="mt-6" :padding="false">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-white/5 bg-white/[0.02]">
                        <th class="px-6 py-4 text-left">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('User')</span>
                        </th>
                        <th class="px-6 py-4 text-left">
                            <button wire:click="sortBy('created_at')" class="flex items-center gap-2 text-xs font-semibold uppercase tracking-wider text-slate-500 transition-colors hover:text-white">
                                @lang('Sent At')
                                @if($sortField === 'created_at')
                                    <i class="ph-bold {{ $sortDirection === 'asc' ? 'ph-caret-up' : 'ph-caret-down' }} text-indigo-400"></i>
                                @endif
                            </button>
                        </th>
                        <th class="px-6 py-4 text-center">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Type')</span>
                        </th>
                        <th class="px-6 py-4 text-left">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Sent To')</span>
                        </th>
                        <th class="px-6 py-4 text-left">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Subject')</span>
                        </th>
                        <th class="px-6 py-4 text-right">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Action')</span>
                        </th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    @forelse($logs as $log)
                        <tr class="group transition-all hover:bg-white/[0.02]" wire:key="log-{{ $log->id }}">
                            {{-- User --}}
                            <td class="px-6 py-4">
                                @if($log->user)
                                    <div class="flex items-center gap-3">
                                        <div class="flex h-9 w-9 items-center justify-center rounded-lg bg-gradient-to-br from-indigo-500/20 to-purple-500/20 text-sm font-semibold text-indigo-400">
                                            {{ strtoupper(substr($log->user->firstname ?? $log->user->username, 0, 1)) }}
                                        </div>
                                        <div>
                                            <a href="{{ route('admin.users.detail', $log->user->username) }}" class="font-medium text-white transition-colors hover:text-indigo-400">
                                                {{ $log->user->fullname }}
                                            </a>
                                            <p class="text-xs text-slate-500">{{ '@' . $log->user->username }}</p>
                                        </div>
                                    </div>
                                @else
                                    <span class="font-medium text-slate-300">@lang('System')</span>
                                @endif
                            </td>

                            {{-- Sent At --}}
                            <td class="px-6 py-4">
                                <div class="flex flex-col">
                                    <span class="text-sm text-slate-300">{{ $log->created_at->format('M d, Y H:i') }}</span>
                                    <span class="text-xs text-slate-500">{{ $log->created_at->diffForHumans() }}</span>
                                </div>
                            </td>

                            {{-- Type --}}
                            <td class="px-6 py-4 text-center">
                                @switch($log->notification_type)
                                    @case('email')
                                        <span class="inline-flex items-center gap-1.5 rounded-lg bg-sky-500/10 px-2.5 py-1 text-xs font-medium text-sky-400">
                                            <i class="ph-duotone ph-envelope"></i>
                                            @lang('Email')
                                        </span>
                                        @break
                                    @case('sms')
                                        <span class="inline-flex items-center gap-1.5 rounded-lg bg-emerald-500/10 px-2.5 py-1 text-xs font-medium text-emerald-400">
                                            <i class="ph-duotone ph-device-mobile"></i>
                                            @lang('SMS')
                                        </span>
                                        @break
                                    @case('push')
                                        <span class="inline-flex items-center gap-1.5 rounded-lg bg-amber-500/10 px-2.5 py-1 text-xs font-medium text-amber-400">
                                            <i class="ph-duotone ph-bell-ringing"></i>
                                            @lang('Push')
                                        </span>
                                        @break
                                    @default
                                        <span class="inline-flex items-center gap-1.5 rounded-lg bg-slate-500/10 px-2.5 py-1 text-xs font-medium text-slate-400">
                                            <i class="ph-duotone ph-question"></i>
                                            @lang('Unknown')
                                        </span>
                                @endswitch
                            </td>

                            {{-- Sent To --}}
                            <td class="px-6 py-4">
                                <span class="text-sm text-slate-300">{{ $log->sent_to ?? __('N/A') }}</span>
                            </td>

                            {{-- Subject --}}
                            <td class="px-6 py-4">
                                <p class="max-w-xs truncate text-sm text-slate-300" title="{{ $log->subject }}">
                                    {{ $log->subject ?? __('No Subject') }}
                                </p>
                            </td>

                            {{-- Action --}}
                            <td class="px-6 py-4 text-right">
                                <x-admin.button
                                    wire:click="viewDetail({{ $log->id }})"
                                    variant="ghost"
                                    size="sm"
                                    icon="ph-eye"
                                >
                                    @lang('View')
                                </x-admin.button>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="px-6 py-16 text-center">
                                <div class="flex flex-col items-center">
                                    <div class="flex h-16 w-16 items-center justify-center rounded-2xl bg-white/5">
                                        <i class="ph-duotone ph-bell text-3xl text-slate-500"></i>
                                    </div>
                                    <h3 class="mt-4 text-lg font-medium text-white">@lang('No notifications found')</h3>
                                    <p class="mt-1 text-sm text-slate-500">
                                        @if($search || $type || $dateFrom || $dateTo)
                                            @lang('No notifications match your filter criteria.')
                                        @else
                                            @lang('No notifications have been sent yet.')
                                        @endif
                                    </p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        {{-- Pagination --}}
        @if($logs->hasPages())
            <div class="border-t border-white/5 px-6 py-4">
                {{ $logs->links() }}
            </div>
        @endif
    </x-admin.card>

    {{-- Notification Detail Modal --}}
    <x-admin.modal wire:model="showDetailModal" :title="__('Notification Details')" maxWidth="2xl">
        @if($selectedLog)
            <div class="space-y-4">
                {{-- Header Info --}}
                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <label class="text-xs font-medium uppercase tracking-wider text-slate-500">@lang('Type')</label>
                        <div class="mt-1">
                            @switch($selectedLog->notification_type)
                                @case('email')
                                    <span class="inline-flex items-center gap-1.5 rounded-lg bg-sky-500/10 px-2.5 py-1 text-sm font-medium text-sky-400">
                                        <i class="ph-duotone ph-envelope"></i>
                                        @lang('Email')
                                    </span>
                                    @break
                                @case('sms')
                                    <span class="inline-flex items-center gap-1.5 rounded-lg bg-emerald-500/10 px-2.5 py-1 text-sm font-medium text-emerald-400">
                                        <i class="ph-duotone ph-device-mobile"></i>
                                        @lang('SMS')
                                    </span>
                                    @break
                                @case('push')
                                    <span class="inline-flex items-center gap-1.5 rounded-lg bg-amber-500/10 px-2.5 py-1 text-sm font-medium text-amber-400">
                                        <i class="ph-duotone ph-bell-ringing"></i>
                                        @lang('Push')
                                    </span>
                                    @break
                            @endswitch
                        </div>
                    </div>
                    <div>
                        <label class="text-xs font-medium uppercase tracking-wider text-slate-500">@lang('Sent At')</label>
                        <p class="mt-1 text-sm text-slate-300">{{ $selectedLog->created_at->format('M d, Y H:i:s') }}</p>
                    </div>
                </div>

                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <label class="text-xs font-medium uppercase tracking-wider text-slate-500">@lang('Sent To')</label>
                        <p class="mt-1 text-sm text-slate-300">{{ $selectedLog->sent_to ?? __('N/A') }}</p>
                    </div>
                    <div>
                        <label class="text-xs font-medium uppercase tracking-wider text-slate-500">@lang('Sender')</label>
                        <p class="mt-1 text-sm text-slate-300">{{ $selectedLog->sent_from ?? $selectedLog->sender ?? __('System') }}</p>
                    </div>
                </div>

                @if($selectedLog->user)
                    <div>
                        <label class="text-xs font-medium uppercase tracking-wider text-slate-500">@lang('User')</label>
                        <div class="mt-1 flex items-center gap-2">
                            <a href="{{ route('admin.users.detail', $selectedLog->user->username) }}" class="text-sm text-indigo-400 hover:text-indigo-300">
                                {{ $selectedLog->user->fullname }} ({{ '@' . $selectedLog->user->username }})
                            </a>
                        </div>
                    </div>
                @endif

                <div>
                    <label class="text-xs font-medium uppercase tracking-wider text-slate-500">@lang('Subject')</label>
                    <p class="mt-1 text-sm font-medium text-white">{{ $selectedLog->subject ?? __('No Subject') }}</p>
                </div>

                <div>
                    <label class="text-xs font-medium uppercase tracking-wider text-slate-500">@lang('Message Content')</label>
                    <div class="mt-2 max-h-80 overflow-y-auto rounded-xl border border-white/10 bg-white/5 p-4">
                        @if($selectedLog->notification_type === 'email')
                            <iframe srcdoc="{{ $selectedLog->message }}" class="h-64 w-full rounded-lg bg-white"></iframe>
                        @else
                            <div class="prose prose-invert prose-sm max-w-none text-slate-300">
                                {!! nl2br(e($selectedLog->message)) !!}
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            <x-slot:footer>
                <x-admin.button wire:click="closeDetailModal" variant="secondary">
                    @lang('Close')
                </x-admin.button>
            </x-slot:footer>
        @endif
    </x-admin.modal>
</div>

