<div>
    {{-- Page Header --}}
    <x-admin.page-header :title="__('Transaction Report')" :subtitle="__('View and analyze all financial transactions across the platform.')">
        <x-slot:actions>
            @if($search || $trxType || $remark || $dateFrom || $dateTo)
                <x-admin.button wire:click="clearFilters" variant="secondary" icon="ph-funnel-x">
                    @lang('Clear Filters')
                </x-admin.button>
            @endif
        </x-slot:actions>
    </x-admin.page-header>

    {{-- Statistics Cards --}}
    <div class="mt-6 grid grid-cols-1 gap-4 sm:grid-cols-2 lg:grid-cols-4">
        <x-admin.stat-card
            icon="ph-receipt"
            iconColor="primary"
            :label="__('Total Transactions')"
            :value="number_format($stats['total'])"
        />
        <x-admin.stat-card
            icon="ph-arrow-circle-up"
            iconColor="success"
            :label="__('Credit Transactions')"
            :value="number_format($stats['credit'])"
        />
        <x-admin.stat-card
            icon="ph-arrow-circle-down"
            iconColor="danger"
            :label="__('Debit Transactions')"
            :value="number_format($stats['debit'])"
        />
        <x-admin.stat-card
            icon="ph-calendar-check"
            iconColor="info"
            :label="__('Today\'s Transactions')"
            :value="number_format($stats['today'])"
        />
    </div>

    {{-- Filters Card --}}
    <x-admin.card class="mt-6">
        <div class="flex flex-col gap-4 lg:flex-row lg:items-end lg:justify-between">
            {{-- Search & Filters --}}
            <div class="grid flex-1 grid-cols-1 gap-4 sm:grid-cols-2 lg:grid-cols-4">
                {{-- Search --}}
                <div class="relative">
                    <i class="ph-duotone ph-magnifying-glass absolute left-3 top-1/2 -translate-y-1/2 text-slate-500"></i>
                    <input
                        type="text"
                        wire:model.live.debounce.300ms="search"
                        placeholder="{{ __('Search by TRX or username...') }}"
                        class="w-full rounded-xl border border-white/10 bg-white/5 py-2.5 pl-10 pr-4 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                    />
                    @if($search)
                        <button wire:click="$set('search', '')" class="absolute right-3 top-1/2 -translate-y-1/2 text-slate-500 transition-colors hover:text-white">
                            <i class="ph-bold ph-x text-sm"></i>
                        </button>
                    @endif
                </div>

                {{-- Type Filter --}}
                <select
                    wire:model.live="trxType"
                    class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                >
                    <option value="" class="bg-[#1a1a24]">@lang('All Types')</option>
                    <option value="+" class="bg-[#1a1a24]">@lang('Credit') (+)</option>
                    <option value="-" class="bg-[#1a1a24]">@lang('Debit') (-)</option>
                </select>

                {{-- Remark Filter --}}
                <select
                    wire:model.live="remark"
                    class="w-full rounded-xl border border-white/10 bg-white/5 px-4 py-2.5 text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                >
                    <option value="" class="bg-[#1a1a24]">@lang('All Remarks')</option>
                    @foreach($remarks as $remarkOption)
                        <option value="{{ $remarkOption }}" class="bg-[#1a1a24]">{{ ucwords(str_replace('_', ' ', $remarkOption)) }}</option>
                    @endforeach
                </select>

                {{-- Date Range --}}
                <div class="flex gap-2">
                    <input
                        type="date"
                        wire:model.live="dateFrom"
                        class="w-full rounded-xl border border-white/10 bg-white/5 px-3 py-2.5 text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                        placeholder="{{ __('From') }}"
                    />
                    <input
                        type="date"
                        wire:model.live="dateTo"
                        class="w-full rounded-xl border border-white/10 bg-white/5 px-3 py-2.5 text-sm text-white transition-all focus:border-indigo-500/50 focus:bg-white/10 focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
                        placeholder="{{ __('To') }}"
                    />
                </div>
            </div>
        </div>
    </x-admin.card>

    {{-- Transactions Table --}}
    <x-admin.card class="mt-6" :padding="false">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-white/5 bg-white/[0.02]">
                        <th class="px-6 py-4 text-left">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('User')</span>
                        </th>
                        <th class="px-6 py-4 text-left">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('TRX')</span>
                        </th>
                        <th class="px-6 py-4 text-left">
                            <button wire:click="sortBy('created_at')" class="flex items-center gap-2 text-xs font-semibold uppercase tracking-wider text-slate-500 transition-colors hover:text-white">
                                @lang('Transacted')
                                @if($sortField === 'created_at')
                                    <i class="ph-bold {{ $sortDirection === 'asc' ? 'ph-caret-up' : 'ph-caret-down' }} text-indigo-400"></i>
                                @endif
                            </button>
                        </th>
                        <th class="px-6 py-4 text-right">
                            <button wire:click="sortBy('amount')" class="flex items-center justify-end gap-2 text-xs font-semibold uppercase tracking-wider text-slate-500 transition-colors hover:text-white">
                                @lang('Amount')
                                @if($sortField === 'amount')
                                    <i class="ph-bold {{ $sortDirection === 'asc' ? 'ph-caret-up' : 'ph-caret-down' }} text-indigo-400"></i>
                                @endif
                            </button>
                        </th>
                        <th class="px-6 py-4 text-right">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Post Balance')</span>
                        </th>
                        <th class="px-6 py-4 text-left">
                            <span class="text-xs font-semibold uppercase tracking-wider text-slate-500">@lang('Details')</span>
                        </th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    @forelse($transactions as $trx)
                        <tr class="group transition-all hover:bg-white/[0.02]" wire:key="trx-{{ $trx->id }}">
                            {{-- User --}}
                            <td class="px-6 py-4">
                                @if($trx->user)
                                    <div class="flex items-center gap-3">
                                        <div class="flex h-9 w-9 items-center justify-center rounded-lg bg-gradient-to-br from-indigo-500/20 to-purple-500/20 text-sm font-semibold text-indigo-400">
                                            {{ strtoupper(substr($trx->user->firstname ?? $trx->user->username, 0, 1)) }}
                                        </div>
                                        <div>
                                            <a href="{{ route('admin.users.detail', $trx->user->username) }}" class="font-medium text-white transition-colors hover:text-indigo-400">
                                                {{ $trx->user->fullname }}
                                            </a>
                                            <p class="text-xs text-slate-500">{{ '@' . $trx->user->username }}</p>
                                        </div>
                                    </div>
                                @else
                                    <span class="text-slate-500">@lang('System')</span>
                                @endif
                            </td>

                            {{-- TRX Code --}}
                            <td class="px-6 py-4">
                                <span class="inline-flex items-center rounded-lg bg-white/5 px-2.5 py-1 font-mono text-sm text-white">
                                    {{ $trx->trx }}
                                </span>
                            </td>

                            {{-- Transacted --}}
                            <td class="px-6 py-4">
                                <div class="flex flex-col">
                                    <span class="text-sm text-slate-300">{{ $trx->created_at->format('M d, Y') }}</span>
                                    <span class="text-xs text-slate-500">{{ $trx->created_at->diffForHumans() }}</span>
                                </div>
                            </td>

                            {{-- Amount --}}
                            <td class="px-6 py-4 text-right">
                                <span class="font-semibold {{ $trx->isCredit() ? 'text-emerald-400' : 'text-rose-400' }}">
                                    {{ $trx->trx_type }}{{ showAmount($trx->amount) }}
                                </span>
                            </td>

                            {{-- Post Balance --}}
                            <td class="px-6 py-4 text-right">
                                <span class="text-sm text-slate-300">{{ showAmount($trx->post_balance) }}</span>
                            </td>

                            {{-- Details --}}
                            <td class="px-6 py-4">
                                <div class="max-w-xs">
                                    <p class="truncate text-sm text-slate-400" title="{{ $trx->details }}">{{ $trx->details }}</p>
                                    @if($trx->remark)
                                        <span class="mt-1 inline-flex items-center rounded-md bg-indigo-500/10 px-2 py-0.5 text-xs text-indigo-400">
                                            {{ ucwords(str_replace('_', ' ', $trx->remark)) }}
                                        </span>
                                    @endif
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="px-6 py-16 text-center">
                                <div class="flex flex-col items-center">
                                    <div class="flex h-16 w-16 items-center justify-center rounded-2xl bg-white/5">
                                        <i class="ph-duotone ph-receipt text-3xl text-slate-500"></i>
                                    </div>
                                    <h3 class="mt-4 text-lg font-medium text-white">@lang('No transactions found')</h3>
                                    <p class="mt-1 text-sm text-slate-500">
                                        @if($search || $trxType || $remark || $dateFrom || $dateTo)
                                            @lang('No transactions match your filter criteria.')
                                        @else
                                            @lang('No transactions have been recorded yet.')
                                        @endif
                                    </p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        {{-- Pagination --}}
        @if($transactions->hasPages())
            <div class="border-t border-white/5 px-6 py-4">
                {{ $transactions->links() }}
            </div>
        @endif
    </x-admin.card>
</div>

