<div>
    <x-admin.page-header :title="$role ? __('Edit Role') : __('Create Role')" :subtitle="__('Configure role permissions')">
        <x-slot:actions>
            <x-admin.button href="{{ route('admin.roles.index') }}" variant="secondary" icon="ph-arrow-left">
                @lang('Back to Roles')
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    <form wire:submit="save">
        <!-- Role Name -->
        <div class="mb-6 overflow-hidden rounded-2xl border border-white/5 bg-[#12121a]">
            <div class="border-b border-white/5 px-6 py-4">
                <h3 class="text-base font-semibold text-white">@lang('Role Details')</h3>
            </div>
            <div class="p-6">
                <x-admin.input
                    wire:model="name"
                    :label="__('Role Name')"
                    :placeholder="__('Enter role name')"
                    required
                />
                @error('name')
                    <p class="mt-2 text-sm text-rose-400">{{ $message }}</p>
                @enderror
            </div>
        </div>

        <!-- Permissions -->
        <div class="mb-6 overflow-hidden rounded-2xl border border-white/5 bg-[#12121a]">
            <div class="border-b border-white/5 px-6 py-4">
                <h3 class="text-base font-semibold text-white">@lang('Permissions')</h3>
                <p class="mt-1 text-sm text-slate-400">@lang('Select permissions for this role')</p>
            </div>
            <div class="p-6 space-y-4">
                @forelse($permissionGroups as $group => $permissions)
                    <div x-data="{ open: false }" class="border border-white/10 rounded-xl overflow-hidden">
                        <button
                            type="button"
                            @click="open = !open"
                            class="w-full flex items-center justify-between px-4 py-3 bg-white/[0.02] hover:bg-white/[0.04] transition-colors"
                        >
                            <div class="flex items-center gap-3">
                                <input
                                    type="checkbox"
                                    wire:click="toggleGroup('{{ $group }}')"
                                    @checked($this->isGroupSelected($group))
                                    class="h-4 w-4 rounded border-white/20 bg-white/5 text-indigo-600 focus:ring-indigo-500/50"
                                    @click.stop
                                >
                                <span class="font-medium text-white">{{ ucwords(str_replace('_', ' ', $group)) }}</span>
                                <x-admin.badge variant="neutral" size="sm">{{ count($permissions) }}</x-admin.badge>
                            </div>
                            <svg class="w-5 h-5 text-slate-400 transition-transform" :class="{ 'rotate-180': open }" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                            </svg>
                        </button>
                        <div x-show="open" x-collapse class="px-4 py-4 bg-white/[0.01] border-t border-white/5">
                            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-3">
                                @foreach($permissions as $permission)
                                    <label class="flex items-center gap-2 cursor-pointer group">
                                        <input
                                            type="checkbox"
                                            wire:model="selectedPermissions"
                                            value="{{ $permission['id'] }}"
                                            class="h-4 w-4 rounded border-white/20 bg-white/5 text-indigo-600 focus:ring-indigo-500/50"
                                        >
                                        <span class="text-sm text-slate-400 group-hover:text-white transition-colors">{{ $permission['name'] }}</span>
                                    </label>
                                @endforeach
                            </div>
                        </div>
                    </div>
                @empty
                    <div class="text-center py-8">
                        <div class="mb-4 flex h-16 w-16 mx-auto items-center justify-center rounded-2xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20">
                            <i class="ph-duotone ph-shield-warning text-3xl text-indigo-400"></i>
                        </div>
                        <h3 class="mb-1 text-sm font-medium text-white">@lang('No permissions found')</h3>
                        <p class="text-sm text-slate-500">@lang('Please run the permission seeders first.')</p>
                    </div>
                @endforelse
            </div>
        </div>

        <!-- Actions -->
        <div class="flex justify-end gap-3">
            <x-admin.button href="{{ route('admin.roles.index') }}" variant="secondary">
                @lang('Cancel')
            </x-admin.button>
            <x-admin.button type="submit" icon="ph-check">
                {{ $role ? __('Update Role') : __('Create Role') }}
            </x-admin.button>
        </div>
    </form>
</div>

