<div>
    <x-admin.page-header :title="__('Roles Management')" :subtitle="__('Manage admin roles and permissions')">
        <x-slot:actions>
            <x-admin.button href="{{ route('admin.roles.create') }}" icon="ph-plus">
                @lang('Add New Role')
            </x-admin.button>
        </x-slot:actions>
    </x-admin.page-header>

    <!-- Filters -->
    <div class="mb-6">
        <div class="relative">
            <i class="ph-duotone ph-magnifying-glass absolute left-4 top-1/2 -translate-y-1/2 text-slate-500"></i>
            <input
                type="text"
                wire:model.live.debounce.300ms="search"
                placeholder="{{ __('Search roles...') }}"
                class="w-full rounded-xl border border-white/10 bg-white/5 py-3 pl-11 pr-4 text-sm text-white placeholder-slate-500 transition-all focus:border-indigo-500/50 focus:bg-white/[0.07] focus:outline-none focus:ring-2 focus:ring-indigo-500/20"
            />
        </div>
    </div>

    <!-- Roles Table -->
    <div class="overflow-hidden rounded-2xl border border-white/5 bg-[#12121a]">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-white/5 bg-white/[0.02]">
                        <x-admin.table-header>@lang('Role Name')</x-admin.table-header>
                        <x-admin.table-header>@lang('Permissions')</x-admin.table-header>
                        <x-admin.table-header>@lang('Staff Members')</x-admin.table-header>
                        <x-admin.table-header>@lang('Created')</x-admin.table-header>
                        <x-admin.table-header class="text-right">@lang('Actions')</x-admin.table-header>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    @forelse($roles as $role)
                        <tr class="transition-colors hover:bg-white/[0.02]">
                            <td class="px-5 py-4">
                                <div class="font-medium text-white">{{ $role->name }}</div>
                            </td>
                            <td class="px-5 py-4">
                                <x-admin.badge variant="primary">{{ $role->permissions_count }} @lang('permissions')</x-admin.badge>
                            </td>
                            <td class="px-5 py-4">
                                <x-admin.badge variant="neutral">{{ $role->admins_count }} @lang('staff')</x-admin.badge>
                            </td>
                            <td class="px-5 py-4 text-sm text-slate-400">
                                {{ $role->created_at->format('M d, Y') }}
                            </td>
                            <td class="px-5 py-4 text-right">
                                <x-admin.action-menu>
                                    <x-admin.action-menu-item href="{{ route('admin.roles.edit', $role) }}" icon="pencil">
                                        @lang('Edit')
                                    </x-admin.action-menu-item>
                                    <x-admin.action-menu-item wire:click="confirmDelete({{ $role->id }})" icon="trash" variant="danger">
                                        @lang('Delete')
                                    </x-admin.action-menu-item>
                                </x-admin.action-menu>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="px-5 py-16 text-center">
                                <div class="flex flex-col items-center">
                                    <div class="mb-4 flex h-16 w-16 items-center justify-center rounded-2xl bg-gradient-to-br from-indigo-500/20 to-purple-500/20">
                                        <i class="ph-duotone ph-shield-check text-3xl text-indigo-400"></i>
                                    </div>
                                    <h3 class="mb-1 text-sm font-medium text-white">@lang('No roles found')</h3>
                                    <p class="mb-4 text-sm text-slate-500">@lang('Get started by creating a new role.')</p>
                                    <x-admin.button href="{{ route('admin.roles.create') }}" icon="plus" size="sm">
                                        @lang('Add Role')
                                    </x-admin.button>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        @if($roles->hasPages())
            <div class="border-t border-white/5 px-5 py-4">
                {{ $roles->links() }}
            </div>
        @endif
    </div>

    <!-- Delete Confirmation Modal -->
    <x-admin.modal name="confirm-delete" :title="__('Delete Role')">
        <p class="text-slate-400">@lang('Are you sure you want to delete this role? This action cannot be undone.')</p>
        <div class="mt-6 flex justify-end gap-3">
            <x-admin.button variant="secondary" x-on:click="$dispatch('close-modal', 'confirm-delete')">@lang('Cancel')</x-admin.button>
            <x-admin.button variant="danger" wire:click="delete">@lang('Delete Role')</x-admin.button>
        </div>
    </x-admin.modal>
</div>

